<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$grp_add = new grp_add();

// Run the page
$grp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$grp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fgrpadd = currentForm = new ew.Form("fgrpadd", "add");

// Validate form
fgrpadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($grp_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $grp->grp->caption(), $grp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($grp_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $grp->type->caption(), $grp->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($grp_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $grp->status->caption(), $grp->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($grp_add->publish->Required) { ?>
			elm = this.getElements("x" + infix + "_publish");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $grp->publish->caption(), $grp->publish->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($grp_add->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $grp->image->caption(), $grp->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($grp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $grp->operator->caption(), $grp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($grp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $grp->datetime->caption(), $grp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fgrpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgrpadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgrpadd.lists["x_type"] = <?php echo $grp_add->type->Lookup->toClientList() ?>;
fgrpadd.lists["x_type"].options = <?php echo JsonEncode($grp_add->type->options(FALSE, TRUE)) ?>;
fgrpadd.lists["x_status"] = <?php echo $grp_add->status->Lookup->toClientList() ?>;
fgrpadd.lists["x_status"].options = <?php echo JsonEncode($grp_add->status->options(FALSE, TRUE)) ?>;
fgrpadd.lists["x_publish"] = <?php echo $grp_add->publish->Lookup->toClientList() ?>;
fgrpadd.lists["x_publish"].options = <?php echo JsonEncode($grp_add->publish->options(FALSE, TRUE)) ?>;
fgrpadd.lists["x_operator"] = <?php echo $grp_add->operator->Lookup->toClientList() ?>;
fgrpadd.lists["x_operator"].options = <?php echo JsonEncode($grp_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $grp_add->showPageHeader(); ?>
<?php
$grp_add->showMessage();
?>
<form name="fgrpadd" id="fgrpadd" class="<?php echo $grp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($grp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $grp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="grp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$grp_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($grp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_grp_grp" for="x_grp" class="<?php echo $grp_add->LeftColumnClass ?>"><?php echo $grp->grp->caption() ?><?php echo ($grp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $grp_add->RightColumnClass ?>"><div<?php echo $grp->grp->cellAttributes() ?>>
<span id="el_grp_grp">
<input type="text" data-table="grp" data-field="x_grp" name="x_grp" id="x_grp" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($grp->grp->getPlaceHolder()) ?>" value="<?php echo $grp->grp->EditValue ?>"<?php echo $grp->grp->editAttributes() ?>>
</span>
<?php echo $grp->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($grp->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_grp_type" for="x_type" class="<?php echo $grp_add->LeftColumnClass ?>"><?php echo $grp->type->caption() ?><?php echo ($grp->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $grp_add->RightColumnClass ?>"><div<?php echo $grp->type->cellAttributes() ?>>
<span id="el_grp_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="grp" data-field="x_type" data-value-separator="<?php echo $grp->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $grp->type->editAttributes() ?>>
		<?php echo $grp->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $grp->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($grp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_grp_status" for="x_status" class="<?php echo $grp_add->LeftColumnClass ?>"><?php echo $grp->status->caption() ?><?php echo ($grp->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $grp_add->RightColumnClass ?>"><div<?php echo $grp->status->cellAttributes() ?>>
<span id="el_grp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="grp" data-field="x_status" data-value-separator="<?php echo $grp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $grp->status->editAttributes() ?>>
		<?php echo $grp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $grp->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($grp->publish->Visible) { // publish ?>
	<div id="r_publish" class="form-group row">
		<label id="elh_grp_publish" for="x_publish" class="<?php echo $grp_add->LeftColumnClass ?>"><?php echo $grp->publish->caption() ?><?php echo ($grp->publish->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $grp_add->RightColumnClass ?>"><div<?php echo $grp->publish->cellAttributes() ?>>
<span id="el_grp_publish">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="grp" data-field="x_publish" data-value-separator="<?php echo $grp->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $grp->publish->editAttributes() ?>>
		<?php echo $grp->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
</span>
<?php echo $grp->publish->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($grp->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_grp_image" class="<?php echo $grp_add->LeftColumnClass ?>"><?php echo $grp->image->caption() ?><?php echo ($grp->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $grp_add->RightColumnClass ?>"><div<?php echo $grp->image->cellAttributes() ?>>
<span id="el_grp_image">
<div id="fd_x_image">
<span title="<?php echo $grp->image->title() ? $grp->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($grp->image->ReadOnly || $grp->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="grp" data-field="x_image" name="x_image" id="x_image"<?php echo $grp->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $grp->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="250">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $grp->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $grp->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $grp->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$grp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $grp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $grp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$grp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$grp_add->terminate();
?>