<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$grp_list = new grp_list();

// Run the page
$grp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$grp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$grp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgrplist = currentForm = new ew.Form("fgrplist", "list");
fgrplist.formKeyCountName = '<?php echo $grp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgrplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgrplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgrplist.lists["x_type"] = <?php echo $grp_list->type->Lookup->toClientList() ?>;
fgrplist.lists["x_type"].options = <?php echo JsonEncode($grp_list->type->options(FALSE, TRUE)) ?>;
fgrplist.lists["x_status"] = <?php echo $grp_list->status->Lookup->toClientList() ?>;
fgrplist.lists["x_status"].options = <?php echo JsonEncode($grp_list->status->options(FALSE, TRUE)) ?>;
fgrplist.lists["x_publish"] = <?php echo $grp_list->publish->Lookup->toClientList() ?>;
fgrplist.lists["x_publish"].options = <?php echo JsonEncode($grp_list->publish->options(FALSE, TRUE)) ?>;
fgrplist.lists["x_operator"] = <?php echo $grp_list->operator->Lookup->toClientList() ?>;
fgrplist.lists["x_operator"].options = <?php echo JsonEncode($grp_list->operator->lookupOptions()) ?>;

// Form object for search
var fgrplistsrch = currentSearchForm = new ew.Form("fgrplistsrch");

// Filters
fgrplistsrch.filterList = <?php echo $grp_list->getFilterList() ?>;

// Init search panel as collapsed
fgrplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$grp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($grp_list->TotalRecs > 0 && $grp_list->ExportOptions->visible()) { ?>
<?php $grp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($grp_list->ImportOptions->visible()) { ?>
<?php $grp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($grp_list->SearchOptions->visible()) { ?>
<?php $grp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($grp_list->FilterOptions->visible()) { ?>
<?php $grp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$grp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$grp->isExport() && !$grp->CurrentAction) { ?>
<form name="fgrplistsrch" id="fgrplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($grp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgrplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="grp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($grp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($grp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $grp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($grp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($grp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($grp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($grp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $grp_list->showPageHeader(); ?>
<?php
$grp_list->showMessage();
?>
<?php if ($grp_list->TotalRecs > 0 || $grp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($grp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> grp">
<?php if (!$grp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$grp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($grp_list->Pager)) $grp_list->Pager = new PrevNextPager($grp_list->StartRec, $grp_list->DisplayRecs, $grp_list->TotalRecs, $grp_list->AutoHidePager) ?>
<?php if ($grp_list->Pager->RecordCount > 0 && $grp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($grp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($grp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $grp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($grp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($grp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $grp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($grp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $grp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $grp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $grp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($grp_list->TotalRecs > 0 && (!$grp_list->AutoHidePageSizeSelector || $grp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="grp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($grp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($grp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($grp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($grp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($grp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($grp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $grp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgrplist" id="fgrplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($grp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $grp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="grp">
<div id="gmp_grp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($grp_list->TotalRecs > 0 || $grp->isGridEdit()) { ?>
<table id="tbl_grplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$grp_list->RowType = ROWTYPE_HEADER;

// Render list options
$grp_list->renderListOptions();

// Render list options (header, left)
$grp_list->ListOptions->render("header", "left");
?>
<?php if ($grp->id->Visible) { // id ?>
	<?php if ($grp->sortUrl($grp->id) == "") { ?>
		<th data-name="id" class="<?php echo $grp->id->headerCellClass() ?>"><div id="elh_grp_id" class="grp_id"><div class="ew-table-header-caption"><?php echo $grp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $grp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->id) ?>',2);"><div id="elh_grp_id" class="grp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($grp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($grp->grp->Visible) { // grp ?>
	<?php if ($grp->sortUrl($grp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $grp->grp->headerCellClass() ?>"><div id="elh_grp_grp" class="grp_grp"><div class="ew-table-header-caption"><?php echo $grp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $grp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->grp) ?>',2);"><div id="elh_grp_grp" class="grp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->grp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($grp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($grp->type->Visible) { // type ?>
	<?php if ($grp->sortUrl($grp->type) == "") { ?>
		<th data-name="type" class="<?php echo $grp->type->headerCellClass() ?>"><div id="elh_grp_type" class="grp_type"><div class="ew-table-header-caption"><?php echo $grp->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $grp->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->type) ?>',2);"><div id="elh_grp_type" class="grp_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($grp->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($grp->status->Visible) { // status ?>
	<?php if ($grp->sortUrl($grp->status) == "") { ?>
		<th data-name="status" class="<?php echo $grp->status->headerCellClass() ?>"><div id="elh_grp_status" class="grp_status"><div class="ew-table-header-caption"><?php echo $grp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $grp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->status) ?>',2);"><div id="elh_grp_status" class="grp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($grp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($grp->publish->Visible) { // publish ?>
	<?php if ($grp->sortUrl($grp->publish) == "") { ?>
		<th data-name="publish" class="<?php echo $grp->publish->headerCellClass() ?>"><div id="elh_grp_publish" class="grp_publish"><div class="ew-table-header-caption"><?php echo $grp->publish->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="publish" class="<?php echo $grp->publish->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->publish) ?>',2);"><div id="elh_grp_publish" class="grp_publish">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->publish->caption() ?></span><span class="ew-table-header-sort"><?php if ($grp->publish->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->publish->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($grp->image->Visible) { // image ?>
	<?php if ($grp->sortUrl($grp->image) == "") { ?>
		<th data-name="image" class="<?php echo $grp->image->headerCellClass() ?>"><div id="elh_grp_image" class="grp_image"><div class="ew-table-header-caption"><?php echo $grp->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $grp->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->image) ?>',2);"><div id="elh_grp_image" class="grp_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($grp->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($grp->operator->Visible) { // operator ?>
	<?php if ($grp->sortUrl($grp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $grp->operator->headerCellClass() ?>"><div id="elh_grp_operator" class="grp_operator"><div class="ew-table-header-caption"><?php echo $grp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $grp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->operator) ?>',2);"><div id="elh_grp_operator" class="grp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($grp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($grp->datetime->Visible) { // datetime ?>
	<?php if ($grp->sortUrl($grp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $grp->datetime->headerCellClass() ?>"><div id="elh_grp_datetime" class="grp_datetime"><div class="ew-table-header-caption"><?php echo $grp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $grp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $grp->SortUrl($grp->datetime) ?>',2);"><div id="elh_grp_datetime" class="grp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $grp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($grp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($grp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$grp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($grp->ExportAll && $grp->isExport()) {
	$grp_list->StopRec = $grp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($grp_list->TotalRecs > $grp_list->StartRec + $grp_list->DisplayRecs - 1)
		$grp_list->StopRec = $grp_list->StartRec + $grp_list->DisplayRecs - 1;
	else
		$grp_list->StopRec = $grp_list->TotalRecs;
}
$grp_list->RecCnt = $grp_list->StartRec - 1;
if ($grp_list->Recordset && !$grp_list->Recordset->EOF) {
	$grp_list->Recordset->moveFirst();
	$selectLimit = $grp_list->UseSelectLimit;
	if (!$selectLimit && $grp_list->StartRec > 1)
		$grp_list->Recordset->move($grp_list->StartRec - 1);
} elseif (!$grp->AllowAddDeleteRow && $grp_list->StopRec == 0) {
	$grp_list->StopRec = $grp->GridAddRowCount;
}

// Initialize aggregate
$grp->RowType = ROWTYPE_AGGREGATEINIT;
$grp->resetAttributes();
$grp_list->renderRow();
while ($grp_list->RecCnt < $grp_list->StopRec) {
	$grp_list->RecCnt++;
	if ($grp_list->RecCnt >= $grp_list->StartRec) {
		$grp_list->RowCnt++;

		// Set up key count
		$grp_list->KeyCount = $grp_list->RowIndex;

		// Init row class and style
		$grp->resetAttributes();
		$grp->CssClass = "";
		if ($grp->isGridAdd()) {
		} else {
			$grp_list->loadRowValues($grp_list->Recordset); // Load row values
		}
		$grp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$grp->RowAttrs = array_merge($grp->RowAttrs, array('data-rowindex'=>$grp_list->RowCnt, 'id'=>'r' . $grp_list->RowCnt . '_grp', 'data-rowtype'=>$grp->RowType));

		// Render row
		$grp_list->renderRow();

		// Render list options
		$grp_list->renderListOptions();
?>
	<tr<?php echo $grp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$grp_list->ListOptions->render("body", "left", $grp_list->RowCnt);
?>
	<?php if ($grp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $grp->id->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_id" class="grp_id">
<span<?php echo $grp->id->viewAttributes() ?>>
<?php echo $grp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($grp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $grp->grp->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_grp" class="grp_grp">
<span<?php echo $grp->grp->viewAttributes() ?>>
<?php echo $grp->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($grp->type->Visible) { // type ?>
		<td data-name="type"<?php echo $grp->type->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_type" class="grp_type">
<span<?php echo $grp->type->viewAttributes() ?>>
<?php echo $grp->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($grp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $grp->status->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_status" class="grp_status">
<span<?php echo $grp->status->viewAttributes() ?>>
<?php echo $grp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($grp->publish->Visible) { // publish ?>
		<td data-name="publish"<?php echo $grp->publish->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_publish" class="grp_publish">
<span<?php echo $grp->publish->viewAttributes() ?>>
<?php echo $grp->publish->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($grp->image->Visible) { // image ?>
		<td data-name="image"<?php echo $grp->image->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_image" class="grp_image">
<span<?php echo $grp->image->viewAttributes() ?>>
<?php echo GetFileViewTag($grp->image, $grp->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($grp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $grp->operator->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_operator" class="grp_operator">
<span<?php echo $grp->operator->viewAttributes() ?>>
<?php echo $grp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($grp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $grp->datetime->cellAttributes() ?>>
<span id="el<?php echo $grp_list->RowCnt ?>_grp_datetime" class="grp_datetime">
<span<?php echo $grp->datetime->viewAttributes() ?>>
<?php echo $grp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$grp_list->ListOptions->render("body", "right", $grp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$grp->isGridAdd())
		$grp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$grp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($grp_list->Recordset)
	$grp_list->Recordset->Close();
?>
<?php if (!$grp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$grp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($grp_list->Pager)) $grp_list->Pager = new PrevNextPager($grp_list->StartRec, $grp_list->DisplayRecs, $grp_list->TotalRecs, $grp_list->AutoHidePager) ?>
<?php if ($grp_list->Pager->RecordCount > 0 && $grp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($grp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($grp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $grp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($grp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($grp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $grp_list->pageUrl() ?>start=<?php echo $grp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $grp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($grp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $grp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $grp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $grp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($grp_list->TotalRecs > 0 && (!$grp_list->AutoHidePageSizeSelector || $grp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="grp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($grp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($grp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($grp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($grp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($grp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($grp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $grp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($grp_list->TotalRecs == 0 && !$grp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $grp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$grp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$grp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$grp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_grp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$grp_list->terminate();
?>