<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$grp_search = new grp_search();

// Run the page
$grp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$grp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($grp_search->IsModal) { ?>
var fgrpsearch = currentAdvancedSearchForm = new ew.Form("fgrpsearch", "search");
<?php } else { ?>
var fgrpsearch = currentForm = new ew.Form("fgrpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fgrpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgrpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgrpsearch.lists["x_type"] = <?php echo $grp_search->type->Lookup->toClientList() ?>;
fgrpsearch.lists["x_type"].options = <?php echo JsonEncode($grp_search->type->options(FALSE, TRUE)) ?>;
fgrpsearch.lists["x_status"] = <?php echo $grp_search->status->Lookup->toClientList() ?>;
fgrpsearch.lists["x_status"].options = <?php echo JsonEncode($grp_search->status->options(FALSE, TRUE)) ?>;
fgrpsearch.lists["x_publish"] = <?php echo $grp_search->publish->Lookup->toClientList() ?>;
fgrpsearch.lists["x_publish"].options = <?php echo JsonEncode($grp_search->publish->options(FALSE, TRUE)) ?>;
fgrpsearch.lists["x_operator"] = <?php echo $grp_search->operator->Lookup->toClientList() ?>;
fgrpsearch.lists["x_operator"].options = <?php echo JsonEncode($grp_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fgrpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($grp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($grp->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $grp_search->showPageHeader(); ?>
<?php
$grp_search->showMessage();
?>
<form name="fgrpsearch" id="fgrpsearch" class="<?php echo $grp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($grp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $grp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="grp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$grp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($grp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_id"><?php echo $grp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->id->cellAttributes() ?>>
			<span id="el_grp_id">
<input type="text" data-table="grp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($grp->id->getPlaceHolder()) ?>" value="<?php echo $grp->id->EditValue ?>"<?php echo $grp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($grp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_grp"><?php echo $grp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_grp" id="z_grp" value="LIKE"></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->grp->cellAttributes() ?>>
			<span id="el_grp_grp">
<input type="text" data-table="grp" data-field="x_grp" name="x_grp" id="x_grp" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($grp->grp->getPlaceHolder()) ?>" value="<?php echo $grp->grp->EditValue ?>"<?php echo $grp->grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($grp->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_type"><?php echo $grp->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->type->cellAttributes() ?>>
			<span id="el_grp_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="grp" data-field="x_type" data-value-separator="<?php echo $grp->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $grp->type->editAttributes() ?>>
		<?php echo $grp->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($grp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_status"><?php echo $grp->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->status->cellAttributes() ?>>
			<span id="el_grp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="grp" data-field="x_status" data-value-separator="<?php echo $grp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $grp->status->editAttributes() ?>>
		<?php echo $grp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($grp->publish->Visible) { // publish ?>
	<div id="r_publish" class="form-group row">
		<label for="x_publish" class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_publish"><?php echo $grp->publish->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_publish" id="z_publish" value="="></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->publish->cellAttributes() ?>>
			<span id="el_grp_publish">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="grp" data-field="x_publish" data-value-separator="<?php echo $grp->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $grp->publish->editAttributes() ?>>
		<?php echo $grp->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($grp->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_image"><?php echo $grp->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->image->cellAttributes() ?>>
			<span id="el_grp_image">
<input type="text" data-table="grp" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($grp->image->getPlaceHolder()) ?>" value="<?php echo $grp->image->EditValue ?>"<?php echo $grp->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($grp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_operator"><?php echo $grp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->operator->cellAttributes() ?>>
			<span id="el_grp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="grp" data-field="x_operator" data-value-separator="<?php echo $grp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $grp->operator->editAttributes() ?>>
		<?php echo $grp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $grp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($grp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $grp_search->LeftColumnClass ?>"><span id="elh_grp_datetime"><?php echo $grp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $grp_search->RightColumnClass ?>"><div<?php echo $grp->datetime->cellAttributes() ?>>
			<span id="el_grp_datetime">
<input type="text" data-table="grp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($grp->datetime->getPlaceHolder()) ?>" value="<?php echo $grp->datetime->EditValue ?>"<?php echo $grp->datetime->editAttributes() ?>>
<?php if (!$grp->datetime->ReadOnly && !$grp->datetime->Disabled && !isset($grp->datetime->EditAttrs["readonly"]) && !isset($grp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgrpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$grp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $grp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$grp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$grp_search->terminate();
?>