<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$grp_view = new grp_view();

// Run the page
$grp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$grp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$grp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fgrpview = currentForm = new ew.Form("fgrpview", "view");

// Form_CustomValidate event
fgrpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgrpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgrpview.lists["x_type"] = <?php echo $grp_view->type->Lookup->toClientList() ?>;
fgrpview.lists["x_type"].options = <?php echo JsonEncode($grp_view->type->options(FALSE, TRUE)) ?>;
fgrpview.lists["x_status"] = <?php echo $grp_view->status->Lookup->toClientList() ?>;
fgrpview.lists["x_status"].options = <?php echo JsonEncode($grp_view->status->options(FALSE, TRUE)) ?>;
fgrpview.lists["x_publish"] = <?php echo $grp_view->publish->Lookup->toClientList() ?>;
fgrpview.lists["x_publish"].options = <?php echo JsonEncode($grp_view->publish->options(FALSE, TRUE)) ?>;
fgrpview.lists["x_operator"] = <?php echo $grp_view->operator->Lookup->toClientList() ?>;
fgrpview.lists["x_operator"].options = <?php echo JsonEncode($grp_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$grp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $grp_view->ExportOptions->render("body") ?>
<?php $grp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $grp_view->showPageHeader(); ?>
<?php
$grp_view->showMessage();
?>
<form name="fgrpview" id="fgrpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($grp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $grp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="grp">
<input type="hidden" name="modal" value="<?php echo (int)$grp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($grp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_id"><?php echo $grp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $grp->id->cellAttributes() ?>>
<span id="el_grp_id">
<span<?php echo $grp->id->viewAttributes() ?>>
<?php echo $grp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($grp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_grp"><?php echo $grp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $grp->grp->cellAttributes() ?>>
<span id="el_grp_grp">
<span<?php echo $grp->grp->viewAttributes() ?>>
<?php echo $grp->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($grp->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_type"><?php echo $grp->type->caption() ?></span></td>
		<td data-name="type"<?php echo $grp->type->cellAttributes() ?>>
<span id="el_grp_type">
<span<?php echo $grp->type->viewAttributes() ?>>
<?php echo $grp->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($grp->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_status"><?php echo $grp->status->caption() ?></span></td>
		<td data-name="status"<?php echo $grp->status->cellAttributes() ?>>
<span id="el_grp_status">
<span<?php echo $grp->status->viewAttributes() ?>>
<?php echo $grp->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($grp->publish->Visible) { // publish ?>
	<tr id="r_publish">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_publish"><?php echo $grp->publish->caption() ?></span></td>
		<td data-name="publish"<?php echo $grp->publish->cellAttributes() ?>>
<span id="el_grp_publish">
<span<?php echo $grp->publish->viewAttributes() ?>>
<?php echo $grp->publish->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($grp->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_image"><?php echo $grp->image->caption() ?></span></td>
		<td data-name="image"<?php echo $grp->image->cellAttributes() ?>>
<span id="el_grp_image">
<span<?php echo $grp->image->viewAttributes() ?>>
<?php echo GetFileViewTag($grp->image, $grp->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($grp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_operator"><?php echo $grp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $grp->operator->cellAttributes() ?>>
<span id="el_grp_operator">
<span<?php echo $grp->operator->viewAttributes() ?>>
<?php echo $grp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($grp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $grp_view->TableLeftColumnClass ?>"><span id="elh_grp_datetime"><?php echo $grp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $grp->datetime->cellAttributes() ?>>
<span id="el_grp_datetime">
<span<?php echo $grp->datetime->viewAttributes() ?>>
<?php echo $grp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$grp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$grp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$grp_view->terminate();
?>