<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$help_edit = new help_edit();

// Run the page
$help_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$help_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fhelpedit = currentForm = new ew.Form("fhelpedit", "edit");

// Validate form
fhelpedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($help_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->id->caption(), $help->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->level->Required) { ?>
			elm = this.getElements("x" + infix + "_level");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->level->caption(), $help->level->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->field_name->Required) { ?>
			elm = this.getElements("x" + infix + "_field_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->field_name->caption(), $help->field_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->field_caption->Required) { ?>
			elm = this.getElements("x" + infix + "_field_caption");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->field_caption->caption(), $help->field_caption->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->field_description->Required) { ?>
			elm = this.getElements("x" + infix + "_field_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->field_description->caption(), $help->field_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->table_name->Required) { ?>
			elm = this.getElements("x" + infix + "_table_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->table_name->caption(), $help->table_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->table_caption->Required) { ?>
			elm = this.getElements("x" + infix + "_table_caption");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->table_caption->caption(), $help->table_caption->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->table_description->Required) { ?>
			elm = this.getElements("x" + infix + "_table_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->table_description->caption(), $help->table_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->menu_group->Required) { ?>
			elm = this.getElements("x" + infix + "_menu_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->menu_group->caption(), $help->menu_group->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->menu_description->Required) { ?>
			elm = this.getElements("x" + infix + "_menu_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->menu_description->caption(), $help->menu_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->portal_notes->Required) { ?>
			elm = this.getElements("x" + infix + "_portal_notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->portal_notes->caption(), $help->portal_notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->visible->Required) { ?>
			elm = this.getElements("x" + infix + "_visible");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->visible->caption(), $help->visible->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->operator->caption(), $help->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->datetime->caption(), $help->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fhelpedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhelpedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhelpedit.lists["x_level"] = <?php echo $help_edit->level->Lookup->toClientList() ?>;
fhelpedit.lists["x_level"].options = <?php echo JsonEncode($help_edit->level->options(FALSE, TRUE)) ?>;
fhelpedit.lists["x_visible"] = <?php echo $help_edit->visible->Lookup->toClientList() ?>;
fhelpedit.lists["x_visible"].options = <?php echo JsonEncode($help_edit->visible->options(FALSE, TRUE)) ?>;
fhelpedit.lists["x_operator"] = <?php echo $help_edit->operator->Lookup->toClientList() ?>;
fhelpedit.lists["x_operator"].options = <?php echo JsonEncode($help_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $help_edit->showPageHeader(); ?>
<?php
$help_edit->showMessage();
?>
<form name="fhelpedit" id="fhelpedit" class="<?php echo $help_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($help_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $help_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="help">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$help_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($help->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_help_id" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->id->caption() ?><?php echo ($help->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->id->cellAttributes() ?>>
<span id="el_help_id">
<span<?php echo $help->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($help->id->CurrentValue) ?>">
<?php echo $help->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->level->Visible) { // level ?>
	<div id="r_level" class="form-group row">
		<label id="elh_help_level" for="x_level" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->level->caption() ?><?php echo ($help->level->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->level->cellAttributes() ?>>
<span id="el_help_level">
<span<?php echo $help->level->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->level->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_level" name="x_level" id="x_level" value="<?php echo HtmlEncode($help->level->CurrentValue) ?>">
<?php echo $help->level->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->field_name->Visible) { // field_name ?>
	<div id="r_field_name" class="form-group row">
		<label id="elh_help_field_name" for="x_field_name" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->field_name->caption() ?><?php echo ($help->field_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->field_name->cellAttributes() ?>>
<span id="el_help_field_name">
<span<?php echo $help->field_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->field_name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_field_name" name="x_field_name" id="x_field_name" value="<?php echo HtmlEncode($help->field_name->CurrentValue) ?>">
<?php echo $help->field_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->field_caption->Visible) { // field_caption ?>
	<div id="r_field_caption" class="form-group row">
		<label id="elh_help_field_caption" for="x_field_caption" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->field_caption->caption() ?><?php echo ($help->field_caption->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->field_caption->cellAttributes() ?>>
<span id="el_help_field_caption">
<span<?php echo $help->field_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->field_caption->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_field_caption" name="x_field_caption" id="x_field_caption" value="<?php echo HtmlEncode($help->field_caption->CurrentValue) ?>">
<?php echo $help->field_caption->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->field_description->Visible) { // field_description ?>
	<div id="r_field_description" class="form-group row">
		<label id="elh_help_field_description" for="x_field_description" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->field_description->caption() ?><?php echo ($help->field_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->field_description->cellAttributes() ?>>
<span id="el_help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x_field_description" id="x_field_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->field_description->getPlaceHolder()) ?>"<?php echo $help->field_description->editAttributes() ?>><?php echo $help->field_description->EditValue ?></textarea>
</span>
<?php echo $help->field_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->table_name->Visible) { // table_name ?>
	<div id="r_table_name" class="form-group row">
		<label id="elh_help_table_name" for="x_table_name" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->table_name->caption() ?><?php echo ($help->table_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->table_name->cellAttributes() ?>>
<span id="el_help_table_name">
<span<?php echo $help->table_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->table_name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_table_name" name="x_table_name" id="x_table_name" value="<?php echo HtmlEncode($help->table_name->CurrentValue) ?>">
<?php echo $help->table_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->table_caption->Visible) { // table_caption ?>
	<div id="r_table_caption" class="form-group row">
		<label id="elh_help_table_caption" for="x_table_caption" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->table_caption->caption() ?><?php echo ($help->table_caption->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->table_caption->cellAttributes() ?>>
<span id="el_help_table_caption">
<span<?php echo $help->table_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->table_caption->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_table_caption" name="x_table_caption" id="x_table_caption" value="<?php echo HtmlEncode($help->table_caption->CurrentValue) ?>">
<?php echo $help->table_caption->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->table_description->Visible) { // table_description ?>
	<div id="r_table_description" class="form-group row">
		<label id="elh_help_table_description" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->table_description->caption() ?><?php echo ($help->table_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->table_description->cellAttributes() ?>>
<span id="el_help_table_description">
<?php AppendClass($help->table_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_table_description" name="x_table_description" id="x_table_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->table_description->getPlaceHolder()) ?>"<?php echo $help->table_description->editAttributes() ?>><?php echo $help->table_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelpedit", "x_table_description", 35, 4, <?php echo ($help->table_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $help->table_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->menu_group->Visible) { // menu_group ?>
	<div id="r_menu_group" class="form-group row">
		<label id="elh_help_menu_group" for="x_menu_group" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->menu_group->caption() ?><?php echo ($help->menu_group->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->menu_group->cellAttributes() ?>>
<span id="el_help_menu_group">
<input type="text" data-table="help" data-field="x_menu_group" name="x_menu_group" id="x_menu_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_group->getPlaceHolder()) ?>" value="<?php echo $help->menu_group->EditValue ?>"<?php echo $help->menu_group->editAttributes() ?>>
</span>
<?php echo $help->menu_group->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->menu_description->Visible) { // menu_description ?>
	<div id="r_menu_description" class="form-group row">
		<label id="elh_help_menu_description" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->menu_description->caption() ?><?php echo ($help->menu_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->menu_description->cellAttributes() ?>>
<span id="el_help_menu_description">
<?php AppendClass($help->menu_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_menu_description" name="x_menu_description" id="x_menu_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->menu_description->getPlaceHolder()) ?>"<?php echo $help->menu_description->editAttributes() ?>><?php echo $help->menu_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelpedit", "x_menu_description", 0, 0, <?php echo ($help->menu_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $help->menu_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->portal_notes->Visible) { // portal_notes ?>
	<div id="r_portal_notes" class="form-group row">
		<label id="elh_help_portal_notes" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->portal_notes->caption() ?><?php echo ($help->portal_notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->portal_notes->cellAttributes() ?>>
<span id="el_help_portal_notes">
<?php AppendClass($help->portal_notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_portal_notes" name="x_portal_notes" id="x_portal_notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->portal_notes->getPlaceHolder()) ?>"<?php echo $help->portal_notes->editAttributes() ?>><?php echo $help->portal_notes->EditValue ?></textarea>
<script>
ew.createEditor("fhelpedit", "x_portal_notes", 35, 4, <?php echo ($help->portal_notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $help->portal_notes->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->visible->Visible) { // visible ?>
	<div id="r_visible" class="form-group row">
		<label id="elh_help_visible" for="x_visible" class="<?php echo $help_edit->LeftColumnClass ?>"><?php echo $help->visible->caption() ?><?php echo ($help->visible->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $help_edit->RightColumnClass ?>"><div<?php echo $help->visible->cellAttributes() ?>>
<span id="el_help_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_visible" data-value-separator="<?php echo $help->visible->displayValueSeparatorAttribute() ?>" id="x_visible" name="x_visible"<?php echo $help->visible->editAttributes() ?>>
		<?php echo $help->visible->selectOptionListHtml("x_visible") ?>
	</select>
</div>
</span>
<?php echo $help->visible->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$help_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $help_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $help_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$help_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

var level = $("#x_level").val();
		if (level == 3)
		{
			$("#r_menu_group").hide();
			$("#r_menu_description").hide();
			$("#r_table_name").show();
			$("#r_table_caption").hide();
			$("#r_table_description").hide();
			$("#r_field_name").show();
			$("#r_field_caption").show();
			$("#r_field_description").show();		
			$("#r_system_notes").hide();
			$("#r_portal_notes").hide();
			$("#r_admin_notes").hide();
			$("#r_visible").show();		
		}
		else if (level == 2)
		{
			$("#r_menu_group").show();
			$("#r_menu_description").show();
			$("#r_table_name").show();
			$("#r_table_caption").show();
			$("#r_table_description").show();		
			$("#r_field_name").hide();
			$("#r_field_caption").hide();
			$("#r_field_description").hide();		
			$("#r_system_notes").show();
			$("#r_portal_notes").hide();
			$("#r_admin_notes").hide();
			$("#r_visible").hide();		
		}
</script>
<?php include_once "footer.php" ?>
<?php
$help_edit->terminate();
?>