<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$help_list = new help_list();

// Run the page
$help_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$help_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$help->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fhelplist = currentForm = new ew.Form("fhelplist", "list");
fhelplist.formKeyCountName = '<?php echo $help_list->FormKeyCountName ?>';

// Validate form
fhelplist.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($help_list->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->id->caption(), $help->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->level->Required) { ?>
			elm = this.getElements("x" + infix + "_level");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->level->caption(), $help->level->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->field_name->Required) { ?>
			elm = this.getElements("x" + infix + "_field_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->field_name->caption(), $help->field_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->field_caption->Required) { ?>
			elm = this.getElements("x" + infix + "_field_caption");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->field_caption->caption(), $help->field_caption->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->field_description->Required) { ?>
			elm = this.getElements("x" + infix + "_field_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->field_description->caption(), $help->field_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->table_name->Required) { ?>
			elm = this.getElements("x" + infix + "_table_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->table_name->caption(), $help->table_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->table_caption->Required) { ?>
			elm = this.getElements("x" + infix + "_table_caption");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->table_caption->caption(), $help->table_caption->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->table_description->Required) { ?>
			elm = this.getElements("x" + infix + "_table_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->table_description->caption(), $help->table_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->menu_group->Required) { ?>
			elm = this.getElements("x" + infix + "_menu_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->menu_group->caption(), $help->menu_group->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->menu_description->Required) { ?>
			elm = this.getElements("x" + infix + "_menu_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->menu_description->caption(), $help->menu_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->visible->Required) { ?>
			elm = this.getElements("x" + infix + "_visible");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->visible->caption(), $help->visible->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->operator->caption(), $help->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($help_list->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->datetime->caption(), $help->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fhelplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhelplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhelplist.lists["x_level"] = <?php echo $help_list->level->Lookup->toClientList() ?>;
fhelplist.lists["x_level"].options = <?php echo JsonEncode($help_list->level->options(FALSE, TRUE)) ?>;
fhelplist.lists["x_visible"] = <?php echo $help_list->visible->Lookup->toClientList() ?>;
fhelplist.lists["x_visible"].options = <?php echo JsonEncode($help_list->visible->options(FALSE, TRUE)) ?>;
fhelplist.lists["x_operator"] = <?php echo $help_list->operator->Lookup->toClientList() ?>;
fhelplist.lists["x_operator"].options = <?php echo JsonEncode($help_list->operator->lookupOptions()) ?>;

// Form object for search
var fhelplistsrch = currentSearchForm = new ew.Form("fhelplistsrch");

// Validate function for search
fhelplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fhelplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhelplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhelplistsrch.lists["x_level"] = <?php echo $help_list->level->Lookup->toClientList() ?>;
fhelplistsrch.lists["x_level"].options = <?php echo JsonEncode($help_list->level->options(FALSE, TRUE)) ?>;

// Filters
fhelplistsrch.filterList = <?php echo $help_list->getFilterList() ?>;

// Init search panel as collapsed
fhelplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$help->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($help_list->TotalRecs > 0 && $help_list->ExportOptions->visible()) { ?>
<?php $help_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($help_list->ImportOptions->visible()) { ?>
<?php $help_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($help_list->SearchOptions->visible()) { ?>
<?php $help_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($help_list->FilterOptions->visible()) { ?>
<?php $help_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$help_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$help->isExport() && !$help->CurrentAction) { ?>
<form name="fhelplistsrch" id="fhelplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($help_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fhelplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="help">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$help_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$help->RowType = ROWTYPE_SEARCH;

// Render row
$help->resetAttributes();
$help_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($help->level->Visible) { // level ?>
	<div id="xsc_level" class="ew-cell form-group">
		<label for="x_level" class="ew-search-caption ew-label"><?php echo $help->level->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_level" id="z_level" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_level" data-value-separator="<?php echo $help->level->displayValueSeparatorAttribute() ?>" id="x_level" name="x_level"<?php echo $help->level->editAttributes() ?>>
		<?php echo $help->level->selectOptionListHtml("x_level") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($help->table_name->Visible) { // table_name ?>
	<div id="xsc_table_name" class="ew-cell form-group">
		<label for="x_table_name" class="ew-search-caption ew-label"><?php echo $help->table_name->caption() ?></label>
		<span class="ew-search-operator"><select name="z_table_name" id="z_table_name" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->table_name->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="help" data-field="x_table_name" name="x_table_name" id="x_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_name->getPlaceHolder()) ?>" value="<?php echo $help->table_name->EditValue ?>"<?php echo $help->table_name->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_table_name style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_table_name style="d-none"">
<input type="text" data-table="help" data-field="x_table_name" name="y_table_name" id="y_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_name->getPlaceHolder()) ?>" value="<?php echo $help->table_name->EditValue2 ?>"<?php echo $help->table_name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($help->table_caption->Visible) { // table_caption ?>
	<div id="xsc_table_caption" class="ew-cell form-group">
		<label for="x_table_caption" class="ew-search-caption ew-label"><?php echo $help->table_caption->caption() ?></label>
		<span class="ew-search-operator"><select name="z_table_caption" id="z_table_caption" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="help" data-field="x_table_caption" name="x_table_caption" id="x_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_caption->getPlaceHolder()) ?>" value="<?php echo $help->table_caption->EditValue ?>"<?php echo $help->table_caption->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_table_caption style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_table_caption style="d-none"">
<input type="text" data-table="help" data-field="x_table_caption" name="y_table_caption" id="y_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_caption->getPlaceHolder()) ?>" value="<?php echo $help->table_caption->EditValue2 ?>"<?php echo $help->table_caption->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($help_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($help_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $help_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($help_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($help_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($help_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($help_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $help_list->showPageHeader(); ?>
<?php
$help_list->showMessage();
?>
<?php if ($help_list->TotalRecs > 0 || $help->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($help_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> help">
<?php if (!$help->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$help->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($help_list->Pager)) $help_list->Pager = new PrevNextPager($help_list->StartRec, $help_list->DisplayRecs, $help_list->TotalRecs, $help_list->AutoHidePager) ?>
<?php if ($help_list->Pager->RecordCount > 0 && $help_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($help_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($help_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $help_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($help_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($help_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $help_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($help_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $help_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $help_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $help_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($help_list->TotalRecs > 0 && (!$help_list->AutoHidePageSizeSelector || $help_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="help">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($help_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($help_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($help_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($help_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($help_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($help->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $help_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fhelplist" id="fhelplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($help_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $help_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="help">
<div id="gmp_help" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($help_list->TotalRecs > 0 || $help->isGridEdit()) { ?>
<table id="tbl_helplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$help_list->RowType = ROWTYPE_HEADER;

// Render list options
$help_list->renderListOptions();

// Render list options (header, left)
$help_list->ListOptions->render("header", "left");
?>
<?php if ($help->id->Visible) { // id ?>
	<?php if ($help->sortUrl($help->id) == "") { ?>
		<th data-name="id" class="<?php echo $help->id->headerCellClass() ?>"><div id="elh_help_id" class="help_id"><div class="ew-table-header-caption"><?php echo $help->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $help->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->id) ?>',2);"><div id="elh_help_id" class="help_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->level->Visible) { // level ?>
	<?php if ($help->sortUrl($help->level) == "") { ?>
		<th data-name="level" class="<?php echo $help->level->headerCellClass() ?>"><div id="elh_help_level" class="help_level"><div class="ew-table-header-caption"><?php echo $help->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $help->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->level) ?>',2);"><div id="elh_help_level" class="help_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->field_name->Visible) { // field_name ?>
	<?php if ($help->sortUrl($help->field_name) == "") { ?>
		<th data-name="field_name" class="<?php echo $help->field_name->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_field_name" class="help_field_name"><div class="ew-table-header-caption"><?php echo $help->field_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="field_name" class="<?php echo $help->field_name->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->field_name) ?>',2);"><div id="elh_help_field_name" class="help_field_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->field_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->field_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->field_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->field_caption->Visible) { // field_caption ?>
	<?php if ($help->sortUrl($help->field_caption) == "") { ?>
		<th data-name="field_caption" class="<?php echo $help->field_caption->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_field_caption" class="help_field_caption"><div class="ew-table-header-caption"><?php echo $help->field_caption->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="field_caption" class="<?php echo $help->field_caption->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->field_caption) ?>',2);"><div id="elh_help_field_caption" class="help_field_caption">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->field_caption->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->field_caption->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->field_caption->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->field_description->Visible) { // field_description ?>
	<?php if ($help->sortUrl($help->field_description) == "") { ?>
		<th data-name="field_description" class="<?php echo $help->field_description->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_field_description" class="help_field_description"><div class="ew-table-header-caption"><?php echo $help->field_description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="field_description" class="<?php echo $help->field_description->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->field_description) ?>',2);"><div id="elh_help_field_description" class="help_field_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->field_description->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->field_description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->field_description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->table_name->Visible) { // table_name ?>
	<?php if ($help->sortUrl($help->table_name) == "") { ?>
		<th data-name="table_name" class="<?php echo $help->table_name->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_table_name" class="help_table_name"><div class="ew-table-header-caption"><?php echo $help->table_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="table_name" class="<?php echo $help->table_name->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->table_name) ?>',2);"><div id="elh_help_table_name" class="help_table_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->table_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->table_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->table_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->table_caption->Visible) { // table_caption ?>
	<?php if ($help->sortUrl($help->table_caption) == "") { ?>
		<th data-name="table_caption" class="<?php echo $help->table_caption->headerCellClass() ?>"><div id="elh_help_table_caption" class="help_table_caption"><div class="ew-table-header-caption"><?php echo $help->table_caption->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="table_caption" class="<?php echo $help->table_caption->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->table_caption) ?>',2);"><div id="elh_help_table_caption" class="help_table_caption">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->table_caption->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($help->table_caption->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->table_caption->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->table_description->Visible) { // table_description ?>
	<?php if ($help->sortUrl($help->table_description) == "") { ?>
		<th data-name="table_description" class="<?php echo $help->table_description->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_table_description" class="help_table_description"><div class="ew-table-header-caption"><?php echo $help->table_description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="table_description" class="<?php echo $help->table_description->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->table_description) ?>',2);"><div id="elh_help_table_description" class="help_table_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->table_description->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->table_description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->table_description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->menu_group->Visible) { // menu_group ?>
	<?php if ($help->sortUrl($help->menu_group) == "") { ?>
		<th data-name="menu_group" class="<?php echo $help->menu_group->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_menu_group" class="help_menu_group"><div class="ew-table-header-caption"><?php echo $help->menu_group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="menu_group" class="<?php echo $help->menu_group->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->menu_group) ?>',2);"><div id="elh_help_menu_group" class="help_menu_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->menu_group->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->menu_group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->menu_group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->menu_description->Visible) { // menu_description ?>
	<?php if ($help->sortUrl($help->menu_description) == "") { ?>
		<th data-name="menu_description" class="<?php echo $help->menu_description->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_menu_description" class="help_menu_description"><div class="ew-table-header-caption"><?php echo $help->menu_description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="menu_description" class="<?php echo $help->menu_description->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->menu_description) ?>',2);"><div id="elh_help_menu_description" class="help_menu_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->menu_description->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->menu_description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->menu_description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->visible->Visible) { // visible ?>
	<?php if ($help->sortUrl($help->visible) == "") { ?>
		<th data-name="visible" class="<?php echo $help->visible->headerCellClass() ?>"><div id="elh_help_visible" class="help_visible"><div class="ew-table-header-caption"><?php echo $help->visible->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="visible" class="<?php echo $help->visible->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->visible) ?>',2);"><div id="elh_help_visible" class="help_visible">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->visible->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->visible->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->visible->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->operator->Visible) { // operator ?>
	<?php if ($help->sortUrl($help->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $help->operator->headerCellClass() ?>"><div id="elh_help_operator" class="help_operator"><div class="ew-table-header-caption"><?php echo $help->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $help->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->operator) ?>',2);"><div id="elh_help_operator" class="help_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($help->datetime->Visible) { // datetime ?>
	<?php if ($help->sortUrl($help->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $help->datetime->headerCellClass() ?>"><div id="elh_help_datetime" class="help_datetime"><div class="ew-table-header-caption"><?php echo $help->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $help->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $help->SortUrl($help->datetime) ?>',2);"><div id="elh_help_datetime" class="help_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $help->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($help->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($help->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$help_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($help->ExportAll && $help->isExport()) {
	$help_list->StopRec = $help_list->TotalRecs;
} else {

	// Set the last record to display
	if ($help_list->TotalRecs > $help_list->StartRec + $help_list->DisplayRecs - 1)
		$help_list->StopRec = $help_list->StartRec + $help_list->DisplayRecs - 1;
	else
		$help_list->StopRec = $help_list->TotalRecs;
}

// Restore number of post back records
if ($CurrentForm && $help_list->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($help_list->FormKeyCountName) && ($help->isGridAdd() || $help->isGridEdit() || $help->isConfirm())) {
		$help_list->KeyCount = $CurrentForm->getValue($help_list->FormKeyCountName);
		$help_list->StopRec = $help_list->StartRec + $help_list->KeyCount - 1;
	}
}
$help_list->RecCnt = $help_list->StartRec - 1;
if ($help_list->Recordset && !$help_list->Recordset->EOF) {
	$help_list->Recordset->moveFirst();
	$selectLimit = $help_list->UseSelectLimit;
	if (!$selectLimit && $help_list->StartRec > 1)
		$help_list->Recordset->move($help_list->StartRec - 1);
} elseif (!$help->AllowAddDeleteRow && $help_list->StopRec == 0) {
	$help_list->StopRec = $help->GridAddRowCount;
}

// Initialize aggregate
$help->RowType = ROWTYPE_AGGREGATEINIT;
$help->resetAttributes();
$help_list->renderRow();
if ($help->isGridEdit())
	$help_list->RowIndex = 0;
while ($help_list->RecCnt < $help_list->StopRec) {
	$help_list->RecCnt++;
	if ($help_list->RecCnt >= $help_list->StartRec) {
		$help_list->RowCnt++;
		if ($help->isGridAdd() || $help->isGridEdit() || $help->isConfirm()) {
			$help_list->RowIndex++;
			$CurrentForm->Index = $help_list->RowIndex;
			if ($CurrentForm->hasValue($help_list->FormActionName) && $help_list->EventCancelled)
				$help_list->RowAction = strval($CurrentForm->getValue($help_list->FormActionName));
			elseif ($help->isGridAdd())
				$help_list->RowAction = "insert";
			else
				$help_list->RowAction = "";
		}

		// Set up key count
		$help_list->KeyCount = $help_list->RowIndex;

		// Init row class and style
		$help->resetAttributes();
		$help->CssClass = "";
		if ($help->isGridAdd()) {
			$help_list->loadRowValues(); // Load default values
		} else {
			$help_list->loadRowValues($help_list->Recordset); // Load row values
		}
		$help->RowType = ROWTYPE_VIEW; // Render view
		if ($help->isGridEdit()) { // Grid edit
			if ($help->EventCancelled)
				$help_list->restoreCurrentRowFormValues($help_list->RowIndex); // Restore form values
			if ($help_list->RowAction == "insert")
				$help->RowType = ROWTYPE_ADD; // Render add
			else
				$help->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($help->isGridEdit() && ($help->RowType == ROWTYPE_EDIT || $help->RowType == ROWTYPE_ADD) && $help->EventCancelled) // Update failed
			$help_list->restoreCurrentRowFormValues($help_list->RowIndex); // Restore form values
		if ($help->RowType == ROWTYPE_EDIT) // Edit row
			$help_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$help->RowAttrs = array_merge($help->RowAttrs, array('data-rowindex'=>$help_list->RowCnt, 'id'=>'r' . $help_list->RowCnt . '_help', 'data-rowtype'=>$help->RowType));

		// Render row
		$help_list->renderRow();

		// Render list options
		$help_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($help_list->RowAction <> "delete" && $help_list->RowAction <> "insertdelete" && !($help_list->RowAction == "insert" && $help->isConfirm() && $help_list->emptyRow())) {
?>
	<tr<?php echo $help->rowAttributes() ?>>
<?php

// Render list options (body, left)
$help_list->ListOptions->render("body", "left", $help_list->RowCnt);
?>
	<?php if ($help->id->Visible) { // id ?>
		<td data-name="id"<?php echo $help->id->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="help" data-field="x_id" name="o<?php echo $help_list->RowIndex ?>_id" id="o<?php echo $help_list->RowIndex ?>_id" value="<?php echo HtmlEncode($help->id->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_id" class="form-group help_id">
<span<?php echo $help->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_id" name="x<?php echo $help_list->RowIndex ?>_id" id="x<?php echo $help_list->RowIndex ?>_id" value="<?php echo HtmlEncode($help->id->CurrentValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_id" class="help_id">
<span<?php echo $help->id->viewAttributes() ?>>
<?php echo $help->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->level->Visible) { // level ?>
		<td data-name="level"<?php echo $help->level->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_level" class="form-group help_level">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_level" data-value-separator="<?php echo $help->level->displayValueSeparatorAttribute() ?>" id="x<?php echo $help_list->RowIndex ?>_level" name="x<?php echo $help_list->RowIndex ?>_level"<?php echo $help->level->editAttributes() ?>>
		<?php echo $help->level->selectOptionListHtml("x<?php echo $help_list->RowIndex ?>_level") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="help" data-field="x_level" name="o<?php echo $help_list->RowIndex ?>_level" id="o<?php echo $help_list->RowIndex ?>_level" value="<?php echo HtmlEncode($help->level->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_level" class="form-group help_level">
<span<?php echo $help->level->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->level->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_level" name="x<?php echo $help_list->RowIndex ?>_level" id="x<?php echo $help_list->RowIndex ?>_level" value="<?php echo HtmlEncode($help->level->CurrentValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_level" class="help_level">
<span<?php echo $help->level->viewAttributes() ?>>
<?php echo $help->level->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->field_name->Visible) { // field_name ?>
		<td data-name="field_name"<?php echo $help->field_name->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_name" class="form-group help_field_name">
<input type="text" data-table="help" data-field="x_field_name" name="x<?php echo $help_list->RowIndex ?>_field_name" id="x<?php echo $help_list->RowIndex ?>_field_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_name->getPlaceHolder()) ?>" value="<?php echo $help->field_name->EditValue ?>"<?php echo $help->field_name->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_field_name" name="o<?php echo $help_list->RowIndex ?>_field_name" id="o<?php echo $help_list->RowIndex ?>_field_name" value="<?php echo HtmlEncode($help->field_name->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_name" class="form-group help_field_name">
<span<?php echo $help->field_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->field_name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_field_name" name="x<?php echo $help_list->RowIndex ?>_field_name" id="x<?php echo $help_list->RowIndex ?>_field_name" value="<?php echo HtmlEncode($help->field_name->CurrentValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_name" class="help_field_name">
<span<?php echo $help->field_name->viewAttributes() ?>>
<?php echo $help->field_name->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->field_caption->Visible) { // field_caption ?>
		<td data-name="field_caption"<?php echo $help->field_caption->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_caption" class="form-group help_field_caption">
<input type="text" data-table="help" data-field="x_field_caption" name="x<?php echo $help_list->RowIndex ?>_field_caption" id="x<?php echo $help_list->RowIndex ?>_field_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_caption->getPlaceHolder()) ?>" value="<?php echo $help->field_caption->EditValue ?>"<?php echo $help->field_caption->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_field_caption" name="o<?php echo $help_list->RowIndex ?>_field_caption" id="o<?php echo $help_list->RowIndex ?>_field_caption" value="<?php echo HtmlEncode($help->field_caption->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_caption" class="form-group help_field_caption">
<span<?php echo $help->field_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->field_caption->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_field_caption" name="x<?php echo $help_list->RowIndex ?>_field_caption" id="x<?php echo $help_list->RowIndex ?>_field_caption" value="<?php echo HtmlEncode($help->field_caption->CurrentValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_caption" class="help_field_caption">
<span<?php echo $help->field_caption->viewAttributes() ?>>
<?php echo $help->field_caption->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->field_description->Visible) { // field_description ?>
		<td data-name="field_description"<?php echo $help->field_description->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_description" class="form-group help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x<?php echo $help_list->RowIndex ?>_field_description" id="x<?php echo $help_list->RowIndex ?>_field_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->field_description->getPlaceHolder()) ?>"<?php echo $help->field_description->editAttributes() ?>><?php echo $help->field_description->EditValue ?></textarea>
</span>
<input type="hidden" data-table="help" data-field="x_field_description" name="o<?php echo $help_list->RowIndex ?>_field_description" id="o<?php echo $help_list->RowIndex ?>_field_description" value="<?php echo HtmlEncode($help->field_description->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_description" class="form-group help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x<?php echo $help_list->RowIndex ?>_field_description" id="x<?php echo $help_list->RowIndex ?>_field_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->field_description->getPlaceHolder()) ?>"<?php echo $help->field_description->editAttributes() ?>><?php echo $help->field_description->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_field_description" class="help_field_description">
<span<?php echo $help->field_description->viewAttributes() ?>>
<?php echo $help->field_description->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->table_name->Visible) { // table_name ?>
		<td data-name="table_name"<?php echo $help->table_name->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_name" class="form-group help_table_name">
<input type="text" data-table="help" data-field="x_table_name" name="x<?php echo $help_list->RowIndex ?>_table_name" id="x<?php echo $help_list->RowIndex ?>_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_name->getPlaceHolder()) ?>" value="<?php echo $help->table_name->EditValue ?>"<?php echo $help->table_name->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_table_name" name="o<?php echo $help_list->RowIndex ?>_table_name" id="o<?php echo $help_list->RowIndex ?>_table_name" value="<?php echo HtmlEncode($help->table_name->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_name" class="form-group help_table_name">
<span<?php echo $help->table_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->table_name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_table_name" name="x<?php echo $help_list->RowIndex ?>_table_name" id="x<?php echo $help_list->RowIndex ?>_table_name" value="<?php echo HtmlEncode($help->table_name->CurrentValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_name" class="help_table_name">
<span<?php echo $help->table_name->viewAttributes() ?>>
<?php echo $help->table_name->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->table_caption->Visible) { // table_caption ?>
		<td data-name="table_caption"<?php echo $help->table_caption->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_caption" class="form-group help_table_caption">
<input type="text" data-table="help" data-field="x_table_caption" name="x<?php echo $help_list->RowIndex ?>_table_caption" id="x<?php echo $help_list->RowIndex ?>_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_caption->getPlaceHolder()) ?>" value="<?php echo $help->table_caption->EditValue ?>"<?php echo $help->table_caption->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_table_caption" name="o<?php echo $help_list->RowIndex ?>_table_caption" id="o<?php echo $help_list->RowIndex ?>_table_caption" value="<?php echo HtmlEncode($help->table_caption->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_caption" class="form-group help_table_caption">
<span<?php echo $help->table_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->table_caption->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_table_caption" name="x<?php echo $help_list->RowIndex ?>_table_caption" id="x<?php echo $help_list->RowIndex ?>_table_caption" value="<?php echo HtmlEncode($help->table_caption->CurrentValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_caption" class="help_table_caption">
<span<?php echo $help->table_caption->viewAttributes() ?>>
<?php echo $help->table_caption->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->table_description->Visible) { // table_description ?>
		<td data-name="table_description"<?php echo $help->table_description->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_description" class="form-group help_table_description">
<?php AppendClass($help->table_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_table_description" name="x<?php echo $help_list->RowIndex ?>_table_description" id="x<?php echo $help_list->RowIndex ?>_table_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->table_description->getPlaceHolder()) ?>"<?php echo $help->table_description->editAttributes() ?>><?php echo $help->table_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelplist", "x<?php echo $help_list->RowIndex ?>_table_description", 35, 4, <?php echo ($help->table_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<input type="hidden" data-table="help" data-field="x_table_description" name="o<?php echo $help_list->RowIndex ?>_table_description" id="o<?php echo $help_list->RowIndex ?>_table_description" value="<?php echo HtmlEncode($help->table_description->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_description" class="form-group help_table_description">
<?php AppendClass($help->table_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_table_description" name="x<?php echo $help_list->RowIndex ?>_table_description" id="x<?php echo $help_list->RowIndex ?>_table_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->table_description->getPlaceHolder()) ?>"<?php echo $help->table_description->editAttributes() ?>><?php echo $help->table_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelplist", "x<?php echo $help_list->RowIndex ?>_table_description", 35, 4, <?php echo ($help->table_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_table_description" class="help_table_description">
<span<?php echo $help->table_description->viewAttributes() ?>>
<?php echo $help->table_description->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->menu_group->Visible) { // menu_group ?>
		<td data-name="menu_group"<?php echo $help->menu_group->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_menu_group" class="form-group help_menu_group">
<input type="text" data-table="help" data-field="x_menu_group" name="x<?php echo $help_list->RowIndex ?>_menu_group" id="x<?php echo $help_list->RowIndex ?>_menu_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_group->getPlaceHolder()) ?>" value="<?php echo $help->menu_group->EditValue ?>"<?php echo $help->menu_group->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_menu_group" name="o<?php echo $help_list->RowIndex ?>_menu_group" id="o<?php echo $help_list->RowIndex ?>_menu_group" value="<?php echo HtmlEncode($help->menu_group->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_menu_group" class="form-group help_menu_group">
<input type="text" data-table="help" data-field="x_menu_group" name="x<?php echo $help_list->RowIndex ?>_menu_group" id="x<?php echo $help_list->RowIndex ?>_menu_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_group->getPlaceHolder()) ?>" value="<?php echo $help->menu_group->EditValue ?>"<?php echo $help->menu_group->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_menu_group" class="help_menu_group">
<span<?php echo $help->menu_group->viewAttributes() ?>>
<?php echo $help->menu_group->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->menu_description->Visible) { // menu_description ?>
		<td data-name="menu_description"<?php echo $help->menu_description->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_menu_description" class="form-group help_menu_description">
<?php AppendClass($help->menu_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_menu_description" name="x<?php echo $help_list->RowIndex ?>_menu_description" id="x<?php echo $help_list->RowIndex ?>_menu_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->menu_description->getPlaceHolder()) ?>"<?php echo $help->menu_description->editAttributes() ?>><?php echo $help->menu_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelplist", "x<?php echo $help_list->RowIndex ?>_menu_description", 0, 0, <?php echo ($help->menu_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<input type="hidden" data-table="help" data-field="x_menu_description" name="o<?php echo $help_list->RowIndex ?>_menu_description" id="o<?php echo $help_list->RowIndex ?>_menu_description" value="<?php echo HtmlEncode($help->menu_description->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_menu_description" class="form-group help_menu_description">
<?php AppendClass($help->menu_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_menu_description" name="x<?php echo $help_list->RowIndex ?>_menu_description" id="x<?php echo $help_list->RowIndex ?>_menu_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->menu_description->getPlaceHolder()) ?>"<?php echo $help->menu_description->editAttributes() ?>><?php echo $help->menu_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelplist", "x<?php echo $help_list->RowIndex ?>_menu_description", 0, 0, <?php echo ($help->menu_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_menu_description" class="help_menu_description">
<span<?php echo $help->menu_description->viewAttributes() ?>>
<?php echo $help->menu_description->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->visible->Visible) { // visible ?>
		<td data-name="visible"<?php echo $help->visible->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_visible" class="form-group help_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_visible" data-value-separator="<?php echo $help->visible->displayValueSeparatorAttribute() ?>" id="x<?php echo $help_list->RowIndex ?>_visible" name="x<?php echo $help_list->RowIndex ?>_visible"<?php echo $help->visible->editAttributes() ?>>
		<?php echo $help->visible->selectOptionListHtml("x<?php echo $help_list->RowIndex ?>_visible") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="help" data-field="x_visible" name="o<?php echo $help_list->RowIndex ?>_visible" id="o<?php echo $help_list->RowIndex ?>_visible" value="<?php echo HtmlEncode($help->visible->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_visible" class="form-group help_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_visible" data-value-separator="<?php echo $help->visible->displayValueSeparatorAttribute() ?>" id="x<?php echo $help_list->RowIndex ?>_visible" name="x<?php echo $help_list->RowIndex ?>_visible"<?php echo $help->visible->editAttributes() ?>>
		<?php echo $help->visible->selectOptionListHtml("x<?php echo $help_list->RowIndex ?>_visible") ?>
	</select>
</div>
</span>
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_visible" class="help_visible">
<span<?php echo $help->visible->viewAttributes() ?>>
<?php echo $help->visible->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $help->operator->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="help" data-field="x_operator" name="o<?php echo $help_list->RowIndex ?>_operator" id="o<?php echo $help_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($help->operator->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_operator" class="help_operator">
<span<?php echo $help->operator->viewAttributes() ?>>
<?php echo $help->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($help->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $help->datetime->cellAttributes() ?>>
<?php if ($help->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="help" data-field="x_datetime" name="o<?php echo $help_list->RowIndex ?>_datetime" id="o<?php echo $help_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($help->datetime->OldValue) ?>">
<?php } ?>
<?php if ($help->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($help->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $help_list->RowCnt ?>_help_datetime" class="help_datetime">
<span<?php echo $help->datetime->viewAttributes() ?>>
<?php echo $help->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$help_list->ListOptions->render("body", "right", $help_list->RowCnt);
?>
	</tr>
<?php if ($help->RowType == ROWTYPE_ADD || $help->RowType == ROWTYPE_EDIT) { ?>
<script>
fhelplist.updateLists(<?php echo $help_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$help->isGridAdd())
		if (!$help_list->Recordset->EOF)
			$help_list->Recordset->moveNext();
}
?>
<?php
	if ($help->isGridAdd() || $help->isGridEdit()) {
		$help_list->RowIndex = '$rowindex$';
		$help_list->loadRowValues();

		// Set row properties
		$help->resetAttributes();
		$help->RowAttrs = array_merge($help->RowAttrs, array('data-rowindex'=>$help_list->RowIndex, 'id'=>'r0_help', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($help->RowAttrs["class"], "ew-template");
		$help->RowType = ROWTYPE_ADD;

		// Render row
		$help_list->renderRow();

		// Render list options
		$help_list->renderListOptions();
		$help_list->StartRowCnt = 0;
?>
	<tr<?php echo $help->rowAttributes() ?>>
<?php

// Render list options (body, left)
$help_list->ListOptions->render("body", "left", $help_list->RowIndex);
?>
	<?php if ($help->id->Visible) { // id ?>
		<td data-name="id">
<input type="hidden" data-table="help" data-field="x_id" name="o<?php echo $help_list->RowIndex ?>_id" id="o<?php echo $help_list->RowIndex ?>_id" value="<?php echo HtmlEncode($help->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->level->Visible) { // level ?>
		<td data-name="level">
<span id="el$rowindex$_help_level" class="form-group help_level">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_level" data-value-separator="<?php echo $help->level->displayValueSeparatorAttribute() ?>" id="x<?php echo $help_list->RowIndex ?>_level" name="x<?php echo $help_list->RowIndex ?>_level"<?php echo $help->level->editAttributes() ?>>
		<?php echo $help->level->selectOptionListHtml("x<?php echo $help_list->RowIndex ?>_level") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="help" data-field="x_level" name="o<?php echo $help_list->RowIndex ?>_level" id="o<?php echo $help_list->RowIndex ?>_level" value="<?php echo HtmlEncode($help->level->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->field_name->Visible) { // field_name ?>
		<td data-name="field_name">
<span id="el$rowindex$_help_field_name" class="form-group help_field_name">
<input type="text" data-table="help" data-field="x_field_name" name="x<?php echo $help_list->RowIndex ?>_field_name" id="x<?php echo $help_list->RowIndex ?>_field_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_name->getPlaceHolder()) ?>" value="<?php echo $help->field_name->EditValue ?>"<?php echo $help->field_name->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_field_name" name="o<?php echo $help_list->RowIndex ?>_field_name" id="o<?php echo $help_list->RowIndex ?>_field_name" value="<?php echo HtmlEncode($help->field_name->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->field_caption->Visible) { // field_caption ?>
		<td data-name="field_caption">
<span id="el$rowindex$_help_field_caption" class="form-group help_field_caption">
<input type="text" data-table="help" data-field="x_field_caption" name="x<?php echo $help_list->RowIndex ?>_field_caption" id="x<?php echo $help_list->RowIndex ?>_field_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_caption->getPlaceHolder()) ?>" value="<?php echo $help->field_caption->EditValue ?>"<?php echo $help->field_caption->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_field_caption" name="o<?php echo $help_list->RowIndex ?>_field_caption" id="o<?php echo $help_list->RowIndex ?>_field_caption" value="<?php echo HtmlEncode($help->field_caption->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->field_description->Visible) { // field_description ?>
		<td data-name="field_description">
<span id="el$rowindex$_help_field_description" class="form-group help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x<?php echo $help_list->RowIndex ?>_field_description" id="x<?php echo $help_list->RowIndex ?>_field_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->field_description->getPlaceHolder()) ?>"<?php echo $help->field_description->editAttributes() ?>><?php echo $help->field_description->EditValue ?></textarea>
</span>
<input type="hidden" data-table="help" data-field="x_field_description" name="o<?php echo $help_list->RowIndex ?>_field_description" id="o<?php echo $help_list->RowIndex ?>_field_description" value="<?php echo HtmlEncode($help->field_description->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->table_name->Visible) { // table_name ?>
		<td data-name="table_name">
<span id="el$rowindex$_help_table_name" class="form-group help_table_name">
<input type="text" data-table="help" data-field="x_table_name" name="x<?php echo $help_list->RowIndex ?>_table_name" id="x<?php echo $help_list->RowIndex ?>_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_name->getPlaceHolder()) ?>" value="<?php echo $help->table_name->EditValue ?>"<?php echo $help->table_name->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_table_name" name="o<?php echo $help_list->RowIndex ?>_table_name" id="o<?php echo $help_list->RowIndex ?>_table_name" value="<?php echo HtmlEncode($help->table_name->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->table_caption->Visible) { // table_caption ?>
		<td data-name="table_caption">
<span id="el$rowindex$_help_table_caption" class="form-group help_table_caption">
<input type="text" data-table="help" data-field="x_table_caption" name="x<?php echo $help_list->RowIndex ?>_table_caption" id="x<?php echo $help_list->RowIndex ?>_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_caption->getPlaceHolder()) ?>" value="<?php echo $help->table_caption->EditValue ?>"<?php echo $help->table_caption->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_table_caption" name="o<?php echo $help_list->RowIndex ?>_table_caption" id="o<?php echo $help_list->RowIndex ?>_table_caption" value="<?php echo HtmlEncode($help->table_caption->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->table_description->Visible) { // table_description ?>
		<td data-name="table_description">
<span id="el$rowindex$_help_table_description" class="form-group help_table_description">
<?php AppendClass($help->table_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_table_description" name="x<?php echo $help_list->RowIndex ?>_table_description" id="x<?php echo $help_list->RowIndex ?>_table_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->table_description->getPlaceHolder()) ?>"<?php echo $help->table_description->editAttributes() ?>><?php echo $help->table_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelplist", "x<?php echo $help_list->RowIndex ?>_table_description", 35, 4, <?php echo ($help->table_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<input type="hidden" data-table="help" data-field="x_table_description" name="o<?php echo $help_list->RowIndex ?>_table_description" id="o<?php echo $help_list->RowIndex ?>_table_description" value="<?php echo HtmlEncode($help->table_description->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->menu_group->Visible) { // menu_group ?>
		<td data-name="menu_group">
<span id="el$rowindex$_help_menu_group" class="form-group help_menu_group">
<input type="text" data-table="help" data-field="x_menu_group" name="x<?php echo $help_list->RowIndex ?>_menu_group" id="x<?php echo $help_list->RowIndex ?>_menu_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_group->getPlaceHolder()) ?>" value="<?php echo $help->menu_group->EditValue ?>"<?php echo $help->menu_group->editAttributes() ?>>
</span>
<input type="hidden" data-table="help" data-field="x_menu_group" name="o<?php echo $help_list->RowIndex ?>_menu_group" id="o<?php echo $help_list->RowIndex ?>_menu_group" value="<?php echo HtmlEncode($help->menu_group->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->menu_description->Visible) { // menu_description ?>
		<td data-name="menu_description">
<span id="el$rowindex$_help_menu_description" class="form-group help_menu_description">
<?php AppendClass($help->menu_description->EditAttrs["class"], "editor"); ?>
<textarea data-table="help" data-field="x_menu_description" name="x<?php echo $help_list->RowIndex ?>_menu_description" id="x<?php echo $help_list->RowIndex ?>_menu_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->menu_description->getPlaceHolder()) ?>"<?php echo $help->menu_description->editAttributes() ?>><?php echo $help->menu_description->EditValue ?></textarea>
<script>
ew.createEditor("fhelplist", "x<?php echo $help_list->RowIndex ?>_menu_description", 0, 0, <?php echo ($help->menu_description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<input type="hidden" data-table="help" data-field="x_menu_description" name="o<?php echo $help_list->RowIndex ?>_menu_description" id="o<?php echo $help_list->RowIndex ?>_menu_description" value="<?php echo HtmlEncode($help->menu_description->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->visible->Visible) { // visible ?>
		<td data-name="visible">
<span id="el$rowindex$_help_visible" class="form-group help_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_visible" data-value-separator="<?php echo $help->visible->displayValueSeparatorAttribute() ?>" id="x<?php echo $help_list->RowIndex ?>_visible" name="x<?php echo $help_list->RowIndex ?>_visible"<?php echo $help->visible->editAttributes() ?>>
		<?php echo $help->visible->selectOptionListHtml("x<?php echo $help_list->RowIndex ?>_visible") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="help" data-field="x_visible" name="o<?php echo $help_list->RowIndex ?>_visible" id="o<?php echo $help_list->RowIndex ?>_visible" value="<?php echo HtmlEncode($help->visible->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->operator->Visible) { // operator ?>
		<td data-name="operator">
<input type="hidden" data-table="help" data-field="x_operator" name="o<?php echo $help_list->RowIndex ?>_operator" id="o<?php echo $help_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($help->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($help->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<input type="hidden" data-table="help" data-field="x_datetime" name="o<?php echo $help_list->RowIndex ?>_datetime" id="o<?php echo $help_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($help->datetime->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$help_list->ListOptions->render("body", "right", $help_list->RowIndex);
?>
<script>
fhelplist.updateLists(<?php echo $help_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($help->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $help_list->FormKeyCountName ?>" id="<?php echo $help_list->FormKeyCountName ?>" value="<?php echo $help_list->KeyCount ?>">
<?php echo $help_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$help->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($help_list->Recordset)
	$help_list->Recordset->Close();
?>
<?php if (!$help->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$help->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($help_list->Pager)) $help_list->Pager = new PrevNextPager($help_list->StartRec, $help_list->DisplayRecs, $help_list->TotalRecs, $help_list->AutoHidePager) ?>
<?php if ($help_list->Pager->RecordCount > 0 && $help_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($help_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($help_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $help_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($help_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($help_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $help_list->pageUrl() ?>start=<?php echo $help_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $help_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($help_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $help_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $help_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $help_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($help_list->TotalRecs > 0 && (!$help_list->AutoHidePageSizeSelector || $help_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="help">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($help_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($help_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($help_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($help_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($help_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($help->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $help_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($help_list->TotalRecs == 0 && !$help->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $help_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$help_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$help->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$help->isExport()) { ?>
<script>
ew.scrollableTable("gmp_help", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$help_list->terminate();
?>