<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$help_search = new help_search();

// Run the page
$help_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$help_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($help_search->IsModal) { ?>
var fhelpsearch = currentAdvancedSearchForm = new ew.Form("fhelpsearch", "search");
<?php } else { ?>
var fhelpsearch = currentForm = new ew.Form("fhelpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fhelpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhelpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhelpsearch.lists["x_level"] = <?php echo $help_search->level->Lookup->toClientList() ?>;
fhelpsearch.lists["x_level"].options = <?php echo JsonEncode($help_search->level->options(FALSE, TRUE)) ?>;
fhelpsearch.lists["x_visible"] = <?php echo $help_search->visible->Lookup->toClientList() ?>;
fhelpsearch.lists["x_visible"].options = <?php echo JsonEncode($help_search->visible->options(FALSE, TRUE)) ?>;
fhelpsearch.lists["x_operator"] = <?php echo $help_search->operator->Lookup->toClientList() ?>;
fhelpsearch.lists["x_operator"].options = <?php echo JsonEncode($help_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fhelpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($help->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($help->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $help_search->showPageHeader(); ?>
<?php
$help_search->showMessage();
?>
<form name="fhelpsearch" id="fhelpsearch" class="<?php echo $help_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($help_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $help_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="help">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$help_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($help->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_id"><?php echo $help->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->id->cellAttributes() ?>>
			<span id="el_help_id">
<input type="text" data-table="help" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($help->id->getPlaceHolder()) ?>" value="<?php echo $help->id->EditValue ?>"<?php echo $help->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->level->Visible) { // level ?>
	<div id="r_level" class="form-group row">
		<label for="x_level" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_level"><?php echo $help->level->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_level" id="z_level" value="="></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->level->cellAttributes() ?>>
			<span id="el_help_level">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_level" data-value-separator="<?php echo $help->level->displayValueSeparatorAttribute() ?>" id="x_level" name="x_level"<?php echo $help->level->editAttributes() ?>>
		<?php echo $help->level->selectOptionListHtml("x_level") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->field_name->Visible) { // field_name ?>
	<div id="r_field_name" class="form-group row">
		<label for="x_field_name" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_field_name"><?php echo $help->field_name->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->field_name->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_field_name" id="z_field_name" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->field_name->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->field_name->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_field_name">
<input type="text" data-table="help" data-field="x_field_name" name="x_field_name" id="x_field_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_name->getPlaceHolder()) ?>" value="<?php echo $help->field_name->EditValue ?>"<?php echo $help->field_name->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_field_name d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_field_name" class="btw1_field_name d-none">
<input type="text" data-table="help" data-field="x_field_name" name="y_field_name" id="y_field_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_name->getPlaceHolder()) ?>" value="<?php echo $help->field_name->EditValue2 ?>"<?php echo $help->field_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->field_caption->Visible) { // field_caption ?>
	<div id="r_field_caption" class="form-group row">
		<label for="x_field_caption" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_field_caption"><?php echo $help->field_caption->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->field_caption->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_field_caption" id="z_field_caption" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->field_caption->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_field_caption">
<input type="text" data-table="help" data-field="x_field_caption" name="x_field_caption" id="x_field_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_caption->getPlaceHolder()) ?>" value="<?php echo $help->field_caption->EditValue ?>"<?php echo $help->field_caption->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_field_caption d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_field_caption" class="btw1_field_caption d-none">
<input type="text" data-table="help" data-field="x_field_caption" name="y_field_caption" id="y_field_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->field_caption->getPlaceHolder()) ?>" value="<?php echo $help->field_caption->EditValue2 ?>"<?php echo $help->field_caption->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->field_description->Visible) { // field_description ?>
	<div id="r_field_description" class="form-group row">
		<label for="x_field_description" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_field_description"><?php echo $help->field_description->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->field_description->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_field_description" id="z_field_description" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->field_description->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->field_description->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_field_description">
<input type="text" data-table="help" data-field="x_field_description" name="x_field_description" id="x_field_description" size="35" placeholder="<?php echo HtmlEncode($help->field_description->getPlaceHolder()) ?>" value="<?php echo $help->field_description->EditValue ?>"<?php echo $help->field_description->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_field_description d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_field_description" class="btw1_field_description d-none">
<input type="text" data-table="help" data-field="x_field_description" name="y_field_description" id="y_field_description" size="35" placeholder="<?php echo HtmlEncode($help->field_description->getPlaceHolder()) ?>" value="<?php echo $help->field_description->EditValue2 ?>"<?php echo $help->field_description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->table_name->Visible) { // table_name ?>
	<div id="r_table_name" class="form-group row">
		<label for="x_table_name" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_table_name"><?php echo $help->table_name->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->table_name->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_table_name" id="z_table_name" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->table_name->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->table_name->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_table_name">
<input type="text" data-table="help" data-field="x_table_name" name="x_table_name" id="x_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_name->getPlaceHolder()) ?>" value="<?php echo $help->table_name->EditValue ?>"<?php echo $help->table_name->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_table_name d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_table_name" class="btw1_table_name d-none">
<input type="text" data-table="help" data-field="x_table_name" name="y_table_name" id="y_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_name->getPlaceHolder()) ?>" value="<?php echo $help->table_name->EditValue2 ?>"<?php echo $help->table_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->table_caption->Visible) { // table_caption ?>
	<div id="r_table_caption" class="form-group row">
		<label for="x_table_caption" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_table_caption"><?php echo $help->table_caption->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->table_caption->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_table_caption" id="z_table_caption" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->table_caption->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_table_caption">
<input type="text" data-table="help" data-field="x_table_caption" name="x_table_caption" id="x_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_caption->getPlaceHolder()) ?>" value="<?php echo $help->table_caption->EditValue ?>"<?php echo $help->table_caption->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_table_caption d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_table_caption" class="btw1_table_caption d-none">
<input type="text" data-table="help" data-field="x_table_caption" name="y_table_caption" id="y_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->table_caption->getPlaceHolder()) ?>" value="<?php echo $help->table_caption->EditValue2 ?>"<?php echo $help->table_caption->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->table_description->Visible) { // table_description ?>
	<div id="r_table_description" class="form-group row">
		<label class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_table_description"><?php echo $help->table_description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_table_description" id="z_table_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->table_description->cellAttributes() ?>>
			<span id="el_help_table_description">
<input type="text" data-table="help" data-field="x_table_description" name="x_table_description" id="x_table_description" size="35" placeholder="<?php echo HtmlEncode($help->table_description->getPlaceHolder()) ?>" value="<?php echo $help->table_description->EditValue ?>"<?php echo $help->table_description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->menu_group->Visible) { // menu_group ?>
	<div id="r_menu_group" class="form-group row">
		<label for="x_menu_group" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_menu_group"><?php echo $help->menu_group->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->menu_group->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_menu_group" id="z_menu_group" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->menu_group->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_menu_group">
<input type="text" data-table="help" data-field="x_menu_group" name="x_menu_group" id="x_menu_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_group->getPlaceHolder()) ?>" value="<?php echo $help->menu_group->EditValue ?>"<?php echo $help->menu_group->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_menu_group d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_menu_group" class="btw1_menu_group d-none">
<input type="text" data-table="help" data-field="x_menu_group" name="y_menu_group" id="y_menu_group" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_group->getPlaceHolder()) ?>" value="<?php echo $help->menu_group->EditValue2 ?>"<?php echo $help->menu_group->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->menu_description->Visible) { // menu_description ?>
	<div id="r_menu_description" class="form-group row">
		<label class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_menu_description"><?php echo $help->menu_description->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->menu_description->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_menu_description" id="z_menu_description" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->menu_description->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_menu_description">
<input type="text" data-table="help" data-field="x_menu_description" name="x_menu_description" id="x_menu_description" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_description->getPlaceHolder()) ?>" value="<?php echo $help->menu_description->EditValue ?>"<?php echo $help->menu_description->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_menu_description d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_menu_description" class="btw1_menu_description d-none">
<input type="text" data-table="help" data-field="x_menu_description" name="y_menu_description" id="y_menu_description" maxlength="96" placeholder="<?php echo HtmlEncode($help->menu_description->getPlaceHolder()) ?>" value="<?php echo $help->menu_description->EditValue2 ?>"<?php echo $help->menu_description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->portal_notes->Visible) { // portal_notes ?>
	<div id="r_portal_notes" class="form-group row">
		<label class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_portal_notes"><?php echo $help->portal_notes->caption() ?></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->portal_notes->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_portal_notes" id="z_portal_notes" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($help->portal_notes->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_help_portal_notes">
<input type="text" data-table="help" data-field="x_portal_notes" name="x_portal_notes" id="x_portal_notes" size="35" placeholder="<?php echo HtmlEncode($help->portal_notes->getPlaceHolder()) ?>" value="<?php echo $help->portal_notes->EditValue ?>"<?php echo $help->portal_notes->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_portal_notes d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_help_portal_notes" class="btw1_portal_notes d-none">
<input type="text" data-table="help" data-field="x_portal_notes" name="y_portal_notes" id="y_portal_notes" size="35" placeholder="<?php echo HtmlEncode($help->portal_notes->getPlaceHolder()) ?>" value="<?php echo $help->portal_notes->EditValue2 ?>"<?php echo $help->portal_notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->visible->Visible) { // visible ?>
	<div id="r_visible" class="form-group row">
		<label for="x_visible" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_visible"><?php echo $help->visible->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_visible" id="z_visible" value="="></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->visible->cellAttributes() ?>>
			<span id="el_help_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_visible" data-value-separator="<?php echo $help->visible->displayValueSeparatorAttribute() ?>" id="x_visible" name="x_visible"<?php echo $help->visible->editAttributes() ?>>
		<?php echo $help->visible->selectOptionListHtml("x_visible") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_operator"><?php echo $help->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->operator->cellAttributes() ?>>
			<span id="el_help_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_operator" data-value-separator="<?php echo $help->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $help->operator->editAttributes() ?>>
		<?php echo $help->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $help->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($help->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $help_search->LeftColumnClass ?>"><span id="elh_help_datetime"><?php echo $help->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $help_search->RightColumnClass ?>"><div<?php echo $help->datetime->cellAttributes() ?>>
			<span id="el_help_datetime">
<input type="text" data-table="help" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($help->datetime->getPlaceHolder()) ?>" value="<?php echo $help->datetime->EditValue ?>"<?php echo $help->datetime->editAttributes() ?>>
<?php if (!$help->datetime->ReadOnly && !$help->datetime->Disabled && !isset($help->datetime->EditAttrs["readonly"]) && !isset($help->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhelpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$help_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $help_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$help_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$help_search->terminate();
?>