<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$help_update = new help_update();

// Run the page
$help_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$help_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fhelpupdate = currentForm = new ew.Form("fhelpupdate", "update");

// Validate form
fhelpupdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($help_update->field_description->Required) { ?>
			elm = this.getElements("x" + infix + "_field_description");
			uelm = this.getElements("u" + infix + "_field_description");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->field_description->caption(), $help->field_description->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($help_update->visible->Required) { ?>
			elm = this.getElements("x" + infix + "_visible");
			uelm = this.getElements("u" + infix + "_visible");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $help->visible->caption(), $help->visible->RequiredErrorMessage)) ?>");
			}
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fhelpupdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhelpupdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhelpupdate.lists["x_visible"] = <?php echo $help_update->visible->Lookup->toClientList() ?>;
fhelpupdate.lists["x_visible"].options = <?php echo JsonEncode($help_update->visible->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $help_update->showPageHeader(); ?>
<?php
$help_update->showMessage();
?>
<form name="fhelpupdate" id="fhelpupdate" class="<?php echo $help_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($help_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $help_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="help">
<?php if ($help->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$help_update->IsModal ?>">
<?php foreach ($help_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_helpupdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $help_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($help->field_description->Visible) { // field_description ?>
	<div id="r_field_description" class="form-group row">
		<label for="x_field_description" class="<?php echo $help_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$help->isConfirm()) { ?>
<input type="checkbox" name="u_field_description" id="u_field_description" class="form-check-input ew-multi-select" value="1"<?php echo ($help->field_description->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_field_description" id="u_field_description" value="<?php echo $help->field_description->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($help->field_description->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_field_description"><?php echo $help->field_description->caption() ?></label></div></label>
		<div class="<?php echo $help_update->RightColumnClass ?>"><div<?php echo $help->field_description->cellAttributes() ?>>
<?php if (!$help->isConfirm()) { ?>
<span id="el_help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x_field_description" id="x_field_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($help->field_description->getPlaceHolder()) ?>"<?php echo $help->field_description->editAttributes() ?>><?php echo $help->field_description->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el_help_field_description">
<span<?php echo $help->field_description->viewAttributes() ?>>
<?php echo $help->field_description->ViewValue ?></span>
</span>
<input type="hidden" data-table="help" data-field="x_field_description" name="x_field_description" id="x_field_description" value="<?php echo HtmlEncode($help->field_description->FormValue) ?>">
<?php } ?>
<?php echo $help->field_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($help->visible->Visible) { // visible ?>
	<div id="r_visible" class="form-group row">
		<label for="x_visible" class="<?php echo $help_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$help->isConfirm()) { ?>
<input type="checkbox" name="u_visible" id="u_visible" class="form-check-input ew-multi-select" value="1"<?php echo ($help->visible->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_visible" id="u_visible" value="<?php echo $help->visible->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($help->visible->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_visible"><?php echo $help->visible->caption() ?></label></div></label>
		<div class="<?php echo $help_update->RightColumnClass ?>"><div<?php echo $help->visible->cellAttributes() ?>>
<?php if (!$help->isConfirm()) { ?>
<span id="el_help_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="help" data-field="x_visible" data-value-separator="<?php echo $help->visible->displayValueSeparatorAttribute() ?>" id="x_visible" name="x_visible"<?php echo $help->visible->editAttributes() ?>>
		<?php echo $help->visible->selectOptionListHtml("x_visible") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_help_visible">
<span<?php echo $help->visible->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($help->visible->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="help" data-field="x_visible" name="x_visible" id="x_visible" value="<?php echo HtmlEncode($help->visible->FormValue) ?>">
<?php } ?>
<?php echo $help->visible->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$help_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $help_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$help->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $help_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$help_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$help_update->terminate();
?>