<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$hs_count_stock_list = new hs_count_stock_list();

// Run the page
$hs_count_stock_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$hs_count_stock_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$hs_count_stock->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fhs_count_stocklist = currentForm = new ew.Form("fhs_count_stocklist", "list");
fhs_count_stocklist.formKeyCountName = '<?php echo $hs_count_stock_list->FormKeyCountName ?>';

// Form_CustomValidate event
fhs_count_stocklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhs_count_stocklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhs_count_stocklist.lists["x_jc_no"] = <?php echo $hs_count_stock_list->jc_no->Lookup->toClientList() ?>;
fhs_count_stocklist.lists["x_jc_no"].options = <?php echo JsonEncode($hs_count_stock_list->jc_no->lookupOptions()) ?>;
fhs_count_stocklist.lists["x_emp_id"] = <?php echo $hs_count_stock_list->emp_id->Lookup->toClientList() ?>;
fhs_count_stocklist.lists["x_emp_id"].options = <?php echo JsonEncode($hs_count_stock_list->emp_id->lookupOptions()) ?>;

// Form object for search
var fhs_count_stocklistsrch = currentSearchForm = new ew.Form("fhs_count_stocklistsrch");

// Filters
fhs_count_stocklistsrch.filterList = <?php echo $hs_count_stock_list->getFilterList() ?>;

// Init search panel as collapsed
fhs_count_stocklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$hs_count_stock->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($hs_count_stock_list->TotalRecs > 0 && $hs_count_stock_list->ExportOptions->visible()) { ?>
<?php $hs_count_stock_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($hs_count_stock_list->ImportOptions->visible()) { ?>
<?php $hs_count_stock_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($hs_count_stock_list->SearchOptions->visible()) { ?>
<?php $hs_count_stock_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($hs_count_stock_list->FilterOptions->visible()) { ?>
<?php $hs_count_stock_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$hs_count_stock_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$hs_count_stock->isExport() && !$hs_count_stock->CurrentAction) { ?>
<form name="fhs_count_stocklistsrch" id="fhs_count_stocklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($hs_count_stock_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fhs_count_stocklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="hs_count_stock">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($hs_count_stock_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($hs_count_stock_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $hs_count_stock_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($hs_count_stock_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($hs_count_stock_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($hs_count_stock_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($hs_count_stock_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $hs_count_stock_list->showPageHeader(); ?>
<?php
$hs_count_stock_list->showMessage();
?>
<?php if ($hs_count_stock_list->TotalRecs > 0 || $hs_count_stock->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($hs_count_stock_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> hs_count_stock">
<?php if (!$hs_count_stock->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$hs_count_stock->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($hs_count_stock_list->Pager)) $hs_count_stock_list->Pager = new PrevNextPager($hs_count_stock_list->StartRec, $hs_count_stock_list->DisplayRecs, $hs_count_stock_list->TotalRecs, $hs_count_stock_list->AutoHidePager) ?>
<?php if ($hs_count_stock_list->Pager->RecordCount > 0 && $hs_count_stock_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($hs_count_stock_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($hs_count_stock_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $hs_count_stock_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($hs_count_stock_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($hs_count_stock_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($hs_count_stock_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($hs_count_stock_list->TotalRecs > 0 && (!$hs_count_stock_list->AutoHidePageSizeSelector || $hs_count_stock_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="hs_count_stock">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($hs_count_stock_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($hs_count_stock_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($hs_count_stock_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($hs_count_stock_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($hs_count_stock_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($hs_count_stock->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $hs_count_stock_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fhs_count_stocklist" id="fhs_count_stocklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($hs_count_stock_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $hs_count_stock_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="hs_count_stock">
<div id="gmp_hs_count_stock" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($hs_count_stock_list->TotalRecs > 0 || $hs_count_stock->isGridEdit()) { ?>
<table id="tbl_hs_count_stocklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$hs_count_stock_list->RowType = ROWTYPE_HEADER;

// Render list options
$hs_count_stock_list->renderListOptions();

// Render list options (header, left)
$hs_count_stock_list->ListOptions->render("header", "left");
?>
<?php if ($hs_count_stock->jc_no->Visible) { // jc_no ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $hs_count_stock->jc_no->headerCellClass() ?>"><div id="elh_hs_count_stock_jc_no" class="hs_count_stock_jc_no"><div class="ew-table-header-caption"><?php echo $hs_count_stock->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $hs_count_stock->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->jc_no) ?>',2);"><div id="elh_hs_count_stock_jc_no" class="hs_count_stock_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->emp_id->Visible) { // emp_id ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $hs_count_stock->emp_id->headerCellClass() ?>"><div id="elh_hs_count_stock_emp_id" class="hs_count_stock_emp_id"><div class="ew-table-header-caption"><?php echo $hs_count_stock->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $hs_count_stock->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->emp_id) ?>',2);"><div id="elh_hs_count_stock_emp_id" class="hs_count_stock_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->product->Visible) { // product ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->product) == "") { ?>
		<th data-name="product" class="<?php echo $hs_count_stock->product->headerCellClass() ?>"><div id="elh_hs_count_stock_product" class="hs_count_stock_product"><div class="ew-table-header-caption"><?php echo $hs_count_stock->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $hs_count_stock->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->product) ?>',2);"><div id="elh_hs_count_stock_product" class="hs_count_stock_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->rid->Visible) { // rid ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $hs_count_stock->rid->headerCellClass() ?>"><div id="elh_hs_count_stock_rid" class="hs_count_stock_rid"><div class="ew-table-header-caption"><?php echo $hs_count_stock->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $hs_count_stock->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->rid) ?>',2);"><div id="elh_hs_count_stock_rid" class="hs_count_stock_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->OUT->Visible) { // OUT ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $hs_count_stock->OUT->headerCellClass() ?>"><div id="elh_hs_count_stock_OUT" class="hs_count_stock_OUT"><div class="ew-table-header-caption"><?php echo $hs_count_stock->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $hs_count_stock->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->OUT) ?>',2);"><div id="elh_hs_count_stock_OUT" class="hs_count_stock_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->item->Visible) { // item ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->item) == "") { ?>
		<th data-name="item" class="<?php echo $hs_count_stock->item->headerCellClass() ?>"><div id="elh_hs_count_stock_item" class="hs_count_stock_item"><div class="ew-table-header-caption"><?php echo $hs_count_stock->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $hs_count_stock->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->item) ?>',2);"><div id="elh_hs_count_stock_item" class="hs_count_stock_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->item_code->Visible) { // item_code ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->item_code) == "") { ?>
		<th data-name="item_code" class="<?php echo $hs_count_stock->item_code->headerCellClass() ?>"><div id="elh_hs_count_stock_item_code" class="hs_count_stock_item_code"><div class="ew-table-header-caption"><?php echo $hs_count_stock->item_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item_code" class="<?php echo $hs_count_stock->item_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->item_code) ?>',2);"><div id="elh_hs_count_stock_item_code" class="hs_count_stock_item_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->item_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->item_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->item_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->IN->Visible) { // IN ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $hs_count_stock->IN->headerCellClass() ?>"><div id="elh_hs_count_stock_IN" class="hs_count_stock_IN"><div class="ew-table-header-caption"><?php echo $hs_count_stock->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $hs_count_stock->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->IN) ?>',2);"><div id="elh_hs_count_stock_IN" class="hs_count_stock_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->Balance->Visible) { // Balance ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $hs_count_stock->Balance->headerCellClass() ?>"><div id="elh_hs_count_stock_Balance" class="hs_count_stock_Balance"><div class="ew-table-header-caption"><?php echo $hs_count_stock->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $hs_count_stock->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->Balance) ?>',2);"><div id="elh_hs_count_stock_Balance" class="hs_count_stock_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->Shortage->Visible) { // Shortage ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->Shortage) == "") { ?>
		<th data-name="Shortage" class="<?php echo $hs_count_stock->Shortage->headerCellClass() ?>"><div id="elh_hs_count_stock_Shortage" class="hs_count_stock_Shortage"><div class="ew-table-header-caption"><?php echo $hs_count_stock->Shortage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Shortage" class="<?php echo $hs_count_stock->Shortage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->Shortage) ?>',2);"><div id="elh_hs_count_stock_Shortage" class="hs_count_stock_Shortage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->Shortage->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->Shortage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->Shortage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->godown->Visible) { // godown ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $hs_count_stock->godown->headerCellClass() ?>"><div id="elh_hs_count_stock_godown" class="hs_count_stock_godown"><div class="ew-table-header-caption"><?php echo $hs_count_stock->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $hs_count_stock->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->godown) ?>',2);"><div id="elh_hs_count_stock_godown" class="hs_count_stock_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->outid->Visible) { // outid ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->outid) == "") { ?>
		<th data-name="outid" class="<?php echo $hs_count_stock->outid->headerCellClass() ?>"><div id="elh_hs_count_stock_outid" class="hs_count_stock_outid"><div class="ew-table-header-caption"><?php echo $hs_count_stock->outid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="outid" class="<?php echo $hs_count_stock->outid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->outid) ?>',2);"><div id="elh_hs_count_stock_outid" class="hs_count_stock_outid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->outid->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->outid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->outid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->emp_name->Visible) { // emp_name ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->emp_name) == "") { ?>
		<th data-name="emp_name" class="<?php echo $hs_count_stock->emp_name->headerCellClass() ?>"><div id="elh_hs_count_stock_emp_name" class="hs_count_stock_emp_name"><div class="ew-table-header-caption"><?php echo $hs_count_stock->emp_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_name" class="<?php echo $hs_count_stock->emp_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->emp_name) ?>',2);"><div id="elh_hs_count_stock_emp_name" class="hs_count_stock_emp_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->emp_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->emp_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->emp_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->count->Visible) { // count ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->count) == "") { ?>
		<th data-name="count" class="<?php echo $hs_count_stock->count->headerCellClass() ?>"><div id="elh_hs_count_stock_count" class="hs_count_stock_count"><div class="ew-table-header-caption"><?php echo $hs_count_stock->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $hs_count_stock->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->count) ?>',2);"><div id="elh_hs_count_stock_count" class="hs_count_stock_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->count->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->jc_quantity->Visible) { // jc_quantity ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->jc_quantity) == "") { ?>
		<th data-name="jc_quantity" class="<?php echo $hs_count_stock->jc_quantity->headerCellClass() ?>"><div id="elh_hs_count_stock_jc_quantity" class="hs_count_stock_jc_quantity"><div class="ew-table-header-caption"><?php echo $hs_count_stock->jc_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_quantity" class="<?php echo $hs_count_stock->jc_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->jc_quantity) ?>',2);"><div id="elh_hs_count_stock_jc_quantity" class="hs_count_stock_jc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->jc_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->jc_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->jc_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->jc_no_fp->Visible) { // jc_no_fp ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->jc_no_fp) == "") { ?>
		<th data-name="jc_no_fp" class="<?php echo $hs_count_stock->jc_no_fp->headerCellClass() ?>"><div id="elh_hs_count_stock_jc_no_fp" class="hs_count_stock_jc_no_fp"><div class="ew-table-header-caption"><?php echo $hs_count_stock->jc_no_fp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no_fp" class="<?php echo $hs_count_stock->jc_no_fp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->jc_no_fp) ?>',2);"><div id="elh_hs_count_stock_jc_no_fp" class="hs_count_stock_jc_no_fp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->jc_no_fp->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->jc_no_fp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->jc_no_fp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->count_received->Visible) { // count_received ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->count_received) == "") { ?>
		<th data-name="count_received" class="<?php echo $hs_count_stock->count_received->headerCellClass() ?>"><div id="elh_hs_count_stock_count_received" class="hs_count_stock_count_received"><div class="ew-table-header-caption"><?php echo $hs_count_stock->count_received->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count_received" class="<?php echo $hs_count_stock->count_received->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->count_received) ?>',2);"><div id="elh_hs_count_stock_count_received" class="hs_count_stock_count_received">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->count_received->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->count_received->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->count_received->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->status->Visible) { // status ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->status) == "") { ?>
		<th data-name="status" class="<?php echo $hs_count_stock->status->headerCellClass() ?>"><div id="elh_hs_count_stock_status" class="hs_count_stock_status"><div class="ew-table-header-caption"><?php echo $hs_count_stock->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $hs_count_stock->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->status) ?>',2);"><div id="elh_hs_count_stock_status" class="hs_count_stock_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_count_stock->countID->Visible) { // countID ?>
	<?php if ($hs_count_stock->sortUrl($hs_count_stock->countID) == "") { ?>
		<th data-name="countID" class="<?php echo $hs_count_stock->countID->headerCellClass() ?>"><div id="elh_hs_count_stock_countID" class="hs_count_stock_countID"><div class="ew-table-header-caption"><?php echo $hs_count_stock->countID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="countID" class="<?php echo $hs_count_stock->countID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_count_stock->SortUrl($hs_count_stock->countID) ?>',2);"><div id="elh_hs_count_stock_countID" class="hs_count_stock_countID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_count_stock->countID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_count_stock->countID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_count_stock->countID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$hs_count_stock_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($hs_count_stock->ExportAll && $hs_count_stock->isExport()) {
	$hs_count_stock_list->StopRec = $hs_count_stock_list->TotalRecs;
} else {

	// Set the last record to display
	if ($hs_count_stock_list->TotalRecs > $hs_count_stock_list->StartRec + $hs_count_stock_list->DisplayRecs - 1)
		$hs_count_stock_list->StopRec = $hs_count_stock_list->StartRec + $hs_count_stock_list->DisplayRecs - 1;
	else
		$hs_count_stock_list->StopRec = $hs_count_stock_list->TotalRecs;
}
$hs_count_stock_list->RecCnt = $hs_count_stock_list->StartRec - 1;
if ($hs_count_stock_list->Recordset && !$hs_count_stock_list->Recordset->EOF) {
	$hs_count_stock_list->Recordset->moveFirst();
	$selectLimit = $hs_count_stock_list->UseSelectLimit;
	if (!$selectLimit && $hs_count_stock_list->StartRec > 1)
		$hs_count_stock_list->Recordset->move($hs_count_stock_list->StartRec - 1);
} elseif (!$hs_count_stock->AllowAddDeleteRow && $hs_count_stock_list->StopRec == 0) {
	$hs_count_stock_list->StopRec = $hs_count_stock->GridAddRowCount;
}

// Initialize aggregate
$hs_count_stock->RowType = ROWTYPE_AGGREGATEINIT;
$hs_count_stock->resetAttributes();
$hs_count_stock_list->renderRow();
while ($hs_count_stock_list->RecCnt < $hs_count_stock_list->StopRec) {
	$hs_count_stock_list->RecCnt++;
	if ($hs_count_stock_list->RecCnt >= $hs_count_stock_list->StartRec) {
		$hs_count_stock_list->RowCnt++;

		// Set up key count
		$hs_count_stock_list->KeyCount = $hs_count_stock_list->RowIndex;

		// Init row class and style
		$hs_count_stock->resetAttributes();
		$hs_count_stock->CssClass = "";
		if ($hs_count_stock->isGridAdd()) {
		} else {
			$hs_count_stock_list->loadRowValues($hs_count_stock_list->Recordset); // Load row values
		}
		$hs_count_stock->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$hs_count_stock->RowAttrs = array_merge($hs_count_stock->RowAttrs, array('data-rowindex'=>$hs_count_stock_list->RowCnt, 'id'=>'r' . $hs_count_stock_list->RowCnt . '_hs_count_stock', 'data-rowtype'=>$hs_count_stock->RowType));

		// Render row
		$hs_count_stock_list->renderRow();

		// Render list options
		$hs_count_stock_list->renderListOptions();
?>
	<tr<?php echo $hs_count_stock->rowAttributes() ?>>
<?php

// Render list options (body, left)
$hs_count_stock_list->ListOptions->render("body", "left", $hs_count_stock_list->RowCnt);
?>
	<?php if ($hs_count_stock->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $hs_count_stock->jc_no->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_jc_no" class="hs_count_stock_jc_no">
<span<?php echo $hs_count_stock->jc_no->viewAttributes() ?>>
<?php echo $hs_count_stock->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $hs_count_stock->emp_id->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_emp_id" class="hs_count_stock_emp_id">
<span<?php echo $hs_count_stock->emp_id->viewAttributes() ?>>
<?php echo $hs_count_stock->emp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->product->Visible) { // product ?>
		<td data-name="product"<?php echo $hs_count_stock->product->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_product" class="hs_count_stock_product">
<span<?php echo $hs_count_stock->product->viewAttributes() ?>>
<?php echo $hs_count_stock->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $hs_count_stock->rid->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_rid" class="hs_count_stock_rid">
<span<?php echo $hs_count_stock->rid->viewAttributes() ?>>
<?php echo $hs_count_stock->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $hs_count_stock->OUT->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_OUT" class="hs_count_stock_OUT">
<span<?php echo $hs_count_stock->OUT->viewAttributes() ?>>
<?php echo $hs_count_stock->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->item->Visible) { // item ?>
		<td data-name="item"<?php echo $hs_count_stock->item->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_item" class="hs_count_stock_item">
<span<?php echo $hs_count_stock->item->viewAttributes() ?>>
<?php echo $hs_count_stock->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->item_code->Visible) { // item_code ?>
		<td data-name="item_code"<?php echo $hs_count_stock->item_code->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_item_code" class="hs_count_stock_item_code">
<span<?php echo $hs_count_stock->item_code->viewAttributes() ?>>
<?php echo $hs_count_stock->item_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $hs_count_stock->IN->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_IN" class="hs_count_stock_IN">
<span<?php echo $hs_count_stock->IN->viewAttributes() ?>>
<?php echo $hs_count_stock->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $hs_count_stock->Balance->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_Balance" class="hs_count_stock_Balance">
<span<?php echo $hs_count_stock->Balance->viewAttributes() ?>>
<?php echo $hs_count_stock->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->Shortage->Visible) { // Shortage ?>
		<td data-name="Shortage"<?php echo $hs_count_stock->Shortage->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_Shortage" class="hs_count_stock_Shortage">
<span<?php echo $hs_count_stock->Shortage->viewAttributes() ?>>
<?php echo $hs_count_stock->Shortage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $hs_count_stock->godown->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_godown" class="hs_count_stock_godown">
<span<?php echo $hs_count_stock->godown->viewAttributes() ?>>
<?php echo $hs_count_stock->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->outid->Visible) { // outid ?>
		<td data-name="outid"<?php echo $hs_count_stock->outid->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_outid" class="hs_count_stock_outid">
<span<?php echo $hs_count_stock->outid->viewAttributes() ?>>
<?php echo $hs_count_stock->outid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name"<?php echo $hs_count_stock->emp_name->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_emp_name" class="hs_count_stock_emp_name">
<span<?php echo $hs_count_stock->emp_name->viewAttributes() ?>>
<?php echo $hs_count_stock->emp_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->count->Visible) { // count ?>
		<td data-name="count"<?php echo $hs_count_stock->count->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_count" class="hs_count_stock_count">
<span<?php echo $hs_count_stock->count->viewAttributes() ?>>
<?php echo $hs_count_stock->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity"<?php echo $hs_count_stock->jc_quantity->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_jc_quantity" class="hs_count_stock_jc_quantity">
<span<?php echo $hs_count_stock->jc_quantity->viewAttributes() ?>>
<?php echo $hs_count_stock->jc_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->jc_no_fp->Visible) { // jc_no_fp ?>
		<td data-name="jc_no_fp"<?php echo $hs_count_stock->jc_no_fp->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_jc_no_fp" class="hs_count_stock_jc_no_fp">
<span<?php echo $hs_count_stock->jc_no_fp->viewAttributes() ?>>
<?php echo $hs_count_stock->jc_no_fp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->count_received->Visible) { // count_received ?>
		<td data-name="count_received"<?php echo $hs_count_stock->count_received->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_count_received" class="hs_count_stock_count_received">
<span<?php echo $hs_count_stock->count_received->viewAttributes() ?>>
<?php echo $hs_count_stock->count_received->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->status->Visible) { // status ?>
		<td data-name="status"<?php echo $hs_count_stock->status->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_status" class="hs_count_stock_status">
<span<?php echo $hs_count_stock->status->viewAttributes() ?>>
<?php echo $hs_count_stock->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_count_stock->countID->Visible) { // countID ?>
		<td data-name="countID"<?php echo $hs_count_stock->countID->cellAttributes() ?>>
<span id="el<?php echo $hs_count_stock_list->RowCnt ?>_hs_count_stock_countID" class="hs_count_stock_countID">
<span<?php echo $hs_count_stock->countID->viewAttributes() ?>>
<?php echo $hs_count_stock->countID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$hs_count_stock_list->ListOptions->render("body", "right", $hs_count_stock_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$hs_count_stock->isGridAdd())
		$hs_count_stock_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$hs_count_stock->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($hs_count_stock_list->Recordset)
	$hs_count_stock_list->Recordset->Close();
?>
<?php if (!$hs_count_stock->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$hs_count_stock->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($hs_count_stock_list->Pager)) $hs_count_stock_list->Pager = new PrevNextPager($hs_count_stock_list->StartRec, $hs_count_stock_list->DisplayRecs, $hs_count_stock_list->TotalRecs, $hs_count_stock_list->AutoHidePager) ?>
<?php if ($hs_count_stock_list->Pager->RecordCount > 0 && $hs_count_stock_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($hs_count_stock_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($hs_count_stock_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $hs_count_stock_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($hs_count_stock_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($hs_count_stock_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $hs_count_stock_list->pageUrl() ?>start=<?php echo $hs_count_stock_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($hs_count_stock_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hs_count_stock_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($hs_count_stock_list->TotalRecs > 0 && (!$hs_count_stock_list->AutoHidePageSizeSelector || $hs_count_stock_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="hs_count_stock">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($hs_count_stock_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($hs_count_stock_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($hs_count_stock_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($hs_count_stock_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($hs_count_stock_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($hs_count_stock->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $hs_count_stock_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($hs_count_stock_list->TotalRecs == 0 && !$hs_count_stock->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $hs_count_stock_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$hs_count_stock_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$hs_count_stock->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$hs_count_stock->isExport()) { ?>
<script>
ew.scrollableTable("gmp_hs_count_stock", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$hs_count_stock_list->terminate();
?>