<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$hs_stock_product_list = new hs_stock_product_list();

// Run the page
$hs_stock_product_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$hs_stock_product_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$hs_stock_product->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fhs_stock_productlist = currentForm = new ew.Form("fhs_stock_productlist", "list");
fhs_stock_productlist.formKeyCountName = '<?php echo $hs_stock_product_list->FormKeyCountName ?>';

// Form_CustomValidate event
fhs_stock_productlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhs_stock_productlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhs_stock_productlist.lists["x_grp"] = <?php echo $hs_stock_product_list->grp->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_grp"].options = <?php echo JsonEncode($hs_stock_product_list->grp->options(FALSE, TRUE)) ?>;
fhs_stock_productlist.lists["x_s_grp"] = <?php echo $hs_stock_product_list->s_grp->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_s_grp"].options = <?php echo JsonEncode($hs_stock_product_list->s_grp->lookupOptions()) ?>;
fhs_stock_productlist.lists["x_product"] = <?php echo $hs_stock_product_list->product->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_product"].options = <?php echo JsonEncode($hs_stock_product_list->product->lookupOptions()) ?>;
fhs_stock_productlist.lists["x_rid"] = <?php echo $hs_stock_product_list->rid->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_rid"].options = <?php echo JsonEncode($hs_stock_product_list->rid->lookupOptions()) ?>;
fhs_stock_productlist.lists["x_IN"] = <?php echo $hs_stock_product_list->IN->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_IN"].options = <?php echo JsonEncode($hs_stock_product_list->IN->lookupOptions()) ?>;
fhs_stock_productlist.lists["x_OUT"] = <?php echo $hs_stock_product_list->OUT->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_OUT"].options = <?php echo JsonEncode($hs_stock_product_list->OUT->lookupOptions()) ?>;
fhs_stock_productlist.lists["x_godown"] = <?php echo $hs_stock_product_list->godown->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_godown"].options = <?php echo JsonEncode($hs_stock_product_list->godown->lookupOptions()) ?>;
fhs_stock_productlist.lists["x_jc_no"] = <?php echo $hs_stock_product_list->jc_no->Lookup->toClientList() ?>;
fhs_stock_productlist.lists["x_jc_no"].options = <?php echo JsonEncode($hs_stock_product_list->jc_no->lookupOptions()) ?>;

// Form object for search
var fhs_stock_productlistsrch = currentSearchForm = new ew.Form("fhs_stock_productlistsrch");

// Filters
fhs_stock_productlistsrch.filterList = <?php echo $hs_stock_product_list->getFilterList() ?>;

// Init search panel as collapsed
fhs_stock_productlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$hs_stock_product->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($hs_stock_product_list->TotalRecs > 0 && $hs_stock_product_list->ExportOptions->visible()) { ?>
<?php $hs_stock_product_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($hs_stock_product_list->ImportOptions->visible()) { ?>
<?php $hs_stock_product_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($hs_stock_product_list->SearchOptions->visible()) { ?>
<?php $hs_stock_product_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($hs_stock_product_list->FilterOptions->visible()) { ?>
<?php $hs_stock_product_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$hs_stock_product_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$hs_stock_product->isExport() && !$hs_stock_product->CurrentAction) { ?>
<form name="fhs_stock_productlistsrch" id="fhs_stock_productlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($hs_stock_product_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fhs_stock_productlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="hs_stock_product">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($hs_stock_product_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($hs_stock_product_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $hs_stock_product_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($hs_stock_product_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($hs_stock_product_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($hs_stock_product_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($hs_stock_product_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $hs_stock_product_list->showPageHeader(); ?>
<?php
$hs_stock_product_list->showMessage();
?>
<?php if ($hs_stock_product_list->TotalRecs > 0 || $hs_stock_product->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($hs_stock_product_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> hs_stock_product">
<?php if (!$hs_stock_product->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$hs_stock_product->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($hs_stock_product_list->Pager)) $hs_stock_product_list->Pager = new PrevNextPager($hs_stock_product_list->StartRec, $hs_stock_product_list->DisplayRecs, $hs_stock_product_list->TotalRecs, $hs_stock_product_list->AutoHidePager) ?>
<?php if ($hs_stock_product_list->Pager->RecordCount > 0 && $hs_stock_product_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($hs_stock_product_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($hs_stock_product_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $hs_stock_product_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($hs_stock_product_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($hs_stock_product_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($hs_stock_product_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($hs_stock_product_list->TotalRecs > 0 && (!$hs_stock_product_list->AutoHidePageSizeSelector || $hs_stock_product_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="hs_stock_product">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($hs_stock_product_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($hs_stock_product_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($hs_stock_product_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($hs_stock_product_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($hs_stock_product_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($hs_stock_product->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $hs_stock_product_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fhs_stock_productlist" id="fhs_stock_productlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($hs_stock_product_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $hs_stock_product_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="hs_stock_product">
<div id="gmp_hs_stock_product" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($hs_stock_product_list->TotalRecs > 0 || $hs_stock_product->isGridEdit()) { ?>
<table id="tbl_hs_stock_productlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$hs_stock_product_list->RowType = ROWTYPE_HEADER;

// Render list options
$hs_stock_product_list->renderListOptions();

// Render list options (header, left)
$hs_stock_product_list->ListOptions->render("header", "left");
?>
<?php if ($hs_stock_product->grp->Visible) { // grp ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $hs_stock_product->grp->headerCellClass() ?>"><div id="elh_hs_stock_product_grp" class="hs_stock_product_grp"><div class="ew-table-header-caption"><?php echo $hs_stock_product->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $hs_stock_product->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->grp) ?>',2);"><div id="elh_hs_stock_product_grp" class="hs_stock_product_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->s_grp->Visible) { // s_grp ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $hs_stock_product->s_grp->headerCellClass() ?>"><div id="elh_hs_stock_product_s_grp" class="hs_stock_product_s_grp"><div class="ew-table-header-caption"><?php echo $hs_stock_product->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $hs_stock_product->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->s_grp) ?>',2);"><div id="elh_hs_stock_product_s_grp" class="hs_stock_product_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->product->Visible) { // product ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->product) == "") { ?>
		<th data-name="product" class="<?php echo $hs_stock_product->product->headerCellClass() ?>"><div id="elh_hs_stock_product_product" class="hs_stock_product_product"><div class="ew-table-header-caption"><?php echo $hs_stock_product->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $hs_stock_product->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->product) ?>',2);"><div id="elh_hs_stock_product_product" class="hs_stock_product_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->rid->Visible) { // rid ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $hs_stock_product->rid->headerCellClass() ?>"><div id="elh_hs_stock_product_rid" class="hs_stock_product_rid"><div class="ew-table-header-caption"><?php echo $hs_stock_product->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $hs_stock_product->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->rid) ?>',2);"><div id="elh_hs_stock_product_rid" class="hs_stock_product_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->IN->Visible) { // IN ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $hs_stock_product->IN->headerCellClass() ?>"><div id="elh_hs_stock_product_IN" class="hs_stock_product_IN"><div class="ew-table-header-caption"><?php echo $hs_stock_product->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $hs_stock_product->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->IN) ?>',2);"><div id="elh_hs_stock_product_IN" class="hs_stock_product_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->OUT->Visible) { // OUT ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $hs_stock_product->OUT->headerCellClass() ?>"><div id="elh_hs_stock_product_OUT" class="hs_stock_product_OUT"><div class="ew-table-header-caption"><?php echo $hs_stock_product->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $hs_stock_product->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->OUT) ?>',2);"><div id="elh_hs_stock_product_OUT" class="hs_stock_product_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->Balance->Visible) { // Balance ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $hs_stock_product->Balance->headerCellClass() ?>"><div id="elh_hs_stock_product_Balance" class="hs_stock_product_Balance"><div class="ew-table-header-caption"><?php echo $hs_stock_product->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $hs_stock_product->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->Balance) ?>',2);"><div id="elh_hs_stock_product_Balance" class="hs_stock_product_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->godown->Visible) { // godown ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $hs_stock_product->godown->headerCellClass() ?>"><div id="elh_hs_stock_product_godown" class="hs_stock_product_godown"><div class="ew-table-header-caption"><?php echo $hs_stock_product->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $hs_stock_product->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->godown) ?>',2);"><div id="elh_hs_stock_product_godown" class="hs_stock_product_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->jc_no->Visible) { // jc_no ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $hs_stock_product->jc_no->headerCellClass() ?>"><div id="elh_hs_stock_product_jc_no" class="hs_stock_product_jc_no"><div class="ew-table-header-caption"><?php echo $hs_stock_product->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $hs_stock_product->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->jc_no) ?>',2);"><div id="elh_hs_stock_product_jc_no" class="hs_stock_product_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->item_code->Visible) { // item_code ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->item_code) == "") { ?>
		<th data-name="item_code" class="<?php echo $hs_stock_product->item_code->headerCellClass() ?>"><div id="elh_hs_stock_product_item_code" class="hs_stock_product_item_code"><div class="ew-table-header-caption"><?php echo $hs_stock_product->item_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item_code" class="<?php echo $hs_stock_product->item_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->item_code) ?>',2);"><div id="elh_hs_stock_product_item_code" class="hs_stock_product_item_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->item_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->item_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->item_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hs_stock_product->jc_no_fp->Visible) { // jc_no_fp ?>
	<?php if ($hs_stock_product->sortUrl($hs_stock_product->jc_no_fp) == "") { ?>
		<th data-name="jc_no_fp" class="<?php echo $hs_stock_product->jc_no_fp->headerCellClass() ?>"><div id="elh_hs_stock_product_jc_no_fp" class="hs_stock_product_jc_no_fp"><div class="ew-table-header-caption"><?php echo $hs_stock_product->jc_no_fp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no_fp" class="<?php echo $hs_stock_product->jc_no_fp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hs_stock_product->SortUrl($hs_stock_product->jc_no_fp) ?>',2);"><div id="elh_hs_stock_product_jc_no_fp" class="hs_stock_product_jc_no_fp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hs_stock_product->jc_no_fp->caption() ?></span><span class="ew-table-header-sort"><?php if ($hs_stock_product->jc_no_fp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hs_stock_product->jc_no_fp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$hs_stock_product_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($hs_stock_product->ExportAll && $hs_stock_product->isExport()) {
	$hs_stock_product_list->StopRec = $hs_stock_product_list->TotalRecs;
} else {

	// Set the last record to display
	if ($hs_stock_product_list->TotalRecs > $hs_stock_product_list->StartRec + $hs_stock_product_list->DisplayRecs - 1)
		$hs_stock_product_list->StopRec = $hs_stock_product_list->StartRec + $hs_stock_product_list->DisplayRecs - 1;
	else
		$hs_stock_product_list->StopRec = $hs_stock_product_list->TotalRecs;
}
$hs_stock_product_list->RecCnt = $hs_stock_product_list->StartRec - 1;
if ($hs_stock_product_list->Recordset && !$hs_stock_product_list->Recordset->EOF) {
	$hs_stock_product_list->Recordset->moveFirst();
	$selectLimit = $hs_stock_product_list->UseSelectLimit;
	if (!$selectLimit && $hs_stock_product_list->StartRec > 1)
		$hs_stock_product_list->Recordset->move($hs_stock_product_list->StartRec - 1);
} elseif (!$hs_stock_product->AllowAddDeleteRow && $hs_stock_product_list->StopRec == 0) {
	$hs_stock_product_list->StopRec = $hs_stock_product->GridAddRowCount;
}

// Initialize aggregate
$hs_stock_product->RowType = ROWTYPE_AGGREGATEINIT;
$hs_stock_product->resetAttributes();
$hs_stock_product_list->renderRow();
while ($hs_stock_product_list->RecCnt < $hs_stock_product_list->StopRec) {
	$hs_stock_product_list->RecCnt++;
	if ($hs_stock_product_list->RecCnt >= $hs_stock_product_list->StartRec) {
		$hs_stock_product_list->RowCnt++;

		// Set up key count
		$hs_stock_product_list->KeyCount = $hs_stock_product_list->RowIndex;

		// Init row class and style
		$hs_stock_product->resetAttributes();
		$hs_stock_product->CssClass = "";
		if ($hs_stock_product->isGridAdd()) {
		} else {
			$hs_stock_product_list->loadRowValues($hs_stock_product_list->Recordset); // Load row values
		}
		$hs_stock_product->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$hs_stock_product->RowAttrs = array_merge($hs_stock_product->RowAttrs, array('data-rowindex'=>$hs_stock_product_list->RowCnt, 'id'=>'r' . $hs_stock_product_list->RowCnt . '_hs_stock_product', 'data-rowtype'=>$hs_stock_product->RowType));

		// Render row
		$hs_stock_product_list->renderRow();

		// Render list options
		$hs_stock_product_list->renderListOptions();
?>
	<tr<?php echo $hs_stock_product->rowAttributes() ?>>
<?php

// Render list options (body, left)
$hs_stock_product_list->ListOptions->render("body", "left", $hs_stock_product_list->RowCnt);
?>
	<?php if ($hs_stock_product->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $hs_stock_product->grp->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_grp" class="hs_stock_product_grp">
<span<?php echo $hs_stock_product->grp->viewAttributes() ?>>
<?php echo $hs_stock_product->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $hs_stock_product->s_grp->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_s_grp" class="hs_stock_product_s_grp">
<span<?php echo $hs_stock_product->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($hs_stock_product->s_grp->getViewValue())) && $hs_stock_product->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $hs_stock_product->s_grp->linkAttributes() ?>><?php echo $hs_stock_product->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $hs_stock_product->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->product->Visible) { // product ?>
		<td data-name="product"<?php echo $hs_stock_product->product->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_product" class="hs_stock_product_product">
<span<?php echo $hs_stock_product->product->viewAttributes() ?>>
<?php if ((!EmptyString($hs_stock_product->product->getViewValue())) && $hs_stock_product->product->linkAttributes() <> "") { ?>
<a<?php echo $hs_stock_product->product->linkAttributes() ?>><?php echo $hs_stock_product->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $hs_stock_product->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $hs_stock_product->rid->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_rid" class="hs_stock_product_rid">
<span<?php echo $hs_stock_product->rid->viewAttributes() ?>>
<?php echo $hs_stock_product->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $hs_stock_product->IN->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_IN" class="hs_stock_product_IN">
<span<?php echo $hs_stock_product->IN->viewAttributes() ?>>
<?php echo $hs_stock_product->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $hs_stock_product->OUT->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_OUT" class="hs_stock_product_OUT">
<span<?php echo $hs_stock_product->OUT->viewAttributes() ?>>
<?php echo $hs_stock_product->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $hs_stock_product->Balance->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_Balance" class="hs_stock_product_Balance">
<span<?php echo $hs_stock_product->Balance->viewAttributes() ?>>
<?php echo $hs_stock_product->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $hs_stock_product->godown->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_godown" class="hs_stock_product_godown">
<span<?php echo $hs_stock_product->godown->viewAttributes() ?>>
<?php if ((!EmptyString($hs_stock_product->godown->getViewValue())) && $hs_stock_product->godown->linkAttributes() <> "") { ?>
<a<?php echo $hs_stock_product->godown->linkAttributes() ?>><?php echo $hs_stock_product->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $hs_stock_product->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $hs_stock_product->jc_no->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_jc_no" class="hs_stock_product_jc_no">
<span<?php echo $hs_stock_product->jc_no->viewAttributes() ?>>
<?php if ((!EmptyString($hs_stock_product->jc_no->getViewValue())) && $hs_stock_product->jc_no->linkAttributes() <> "") { ?>
<a<?php echo $hs_stock_product->jc_no->linkAttributes() ?>><?php echo $hs_stock_product->jc_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $hs_stock_product->jc_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->item_code->Visible) { // item_code ?>
		<td data-name="item_code"<?php echo $hs_stock_product->item_code->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_item_code" class="hs_stock_product_item_code">
<span<?php echo $hs_stock_product->item_code->viewAttributes() ?>>
<?php echo $hs_stock_product->item_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hs_stock_product->jc_no_fp->Visible) { // jc_no_fp ?>
		<td data-name="jc_no_fp"<?php echo $hs_stock_product->jc_no_fp->cellAttributes() ?>>
<span id="el<?php echo $hs_stock_product_list->RowCnt ?>_hs_stock_product_jc_no_fp" class="hs_stock_product_jc_no_fp">
<span<?php echo $hs_stock_product->jc_no_fp->viewAttributes() ?>>
<?php echo $hs_stock_product->jc_no_fp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$hs_stock_product_list->ListOptions->render("body", "right", $hs_stock_product_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$hs_stock_product->isGridAdd())
		$hs_stock_product_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$hs_stock_product->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($hs_stock_product_list->Recordset)
	$hs_stock_product_list->Recordset->Close();
?>
<?php if (!$hs_stock_product->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$hs_stock_product->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($hs_stock_product_list->Pager)) $hs_stock_product_list->Pager = new PrevNextPager($hs_stock_product_list->StartRec, $hs_stock_product_list->DisplayRecs, $hs_stock_product_list->TotalRecs, $hs_stock_product_list->AutoHidePager) ?>
<?php if ($hs_stock_product_list->Pager->RecordCount > 0 && $hs_stock_product_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($hs_stock_product_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($hs_stock_product_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $hs_stock_product_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($hs_stock_product_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($hs_stock_product_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $hs_stock_product_list->pageUrl() ?>start=<?php echo $hs_stock_product_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($hs_stock_product_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hs_stock_product_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($hs_stock_product_list->TotalRecs > 0 && (!$hs_stock_product_list->AutoHidePageSizeSelector || $hs_stock_product_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="hs_stock_product">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($hs_stock_product_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($hs_stock_product_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($hs_stock_product_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($hs_stock_product_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($hs_stock_product_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($hs_stock_product->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $hs_stock_product_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($hs_stock_product_list->TotalRecs == 0 && !$hs_stock_product->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $hs_stock_product_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$hs_stock_product_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$hs_stock_product->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$hs_stock_product->isExport()) { ?>
<script>
ew.scrollableTable("gmp_hs_stock_product", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$hs_stock_product_list->terminate();
?>