<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$hs_stock_product_search = new hs_stock_product_search();

// Run the page
$hs_stock_product_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$hs_stock_product_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($hs_stock_product_search->IsModal) { ?>
var fhs_stock_productsearch = currentAdvancedSearchForm = new ew.Form("fhs_stock_productsearch", "search");
<?php } else { ?>
var fhs_stock_productsearch = currentForm = new ew.Form("fhs_stock_productsearch", "search");
<?php } ?>

// Form_CustomValidate event
fhs_stock_productsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhs_stock_productsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhs_stock_productsearch.lists["x_grp"] = <?php echo $hs_stock_product_search->grp->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_grp"].options = <?php echo JsonEncode($hs_stock_product_search->grp->options(FALSE, TRUE)) ?>;
fhs_stock_productsearch.lists["x_s_grp"] = <?php echo $hs_stock_product_search->s_grp->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_s_grp"].options = <?php echo JsonEncode($hs_stock_product_search->s_grp->lookupOptions()) ?>;
fhs_stock_productsearch.lists["x_product"] = <?php echo $hs_stock_product_search->product->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_product"].options = <?php echo JsonEncode($hs_stock_product_search->product->lookupOptions()) ?>;
fhs_stock_productsearch.lists["x_rid"] = <?php echo $hs_stock_product_search->rid->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_rid"].options = <?php echo JsonEncode($hs_stock_product_search->rid->lookupOptions()) ?>;
fhs_stock_productsearch.lists["x_IN"] = <?php echo $hs_stock_product_search->IN->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_IN"].options = <?php echo JsonEncode($hs_stock_product_search->IN->lookupOptions()) ?>;
fhs_stock_productsearch.lists["x_OUT"] = <?php echo $hs_stock_product_search->OUT->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_OUT"].options = <?php echo JsonEncode($hs_stock_product_search->OUT->lookupOptions()) ?>;
fhs_stock_productsearch.lists["x_godown"] = <?php echo $hs_stock_product_search->godown->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_godown"].options = <?php echo JsonEncode($hs_stock_product_search->godown->lookupOptions()) ?>;
fhs_stock_productsearch.lists["x_jc_no"] = <?php echo $hs_stock_product_search->jc_no->Lookup->toClientList() ?>;
fhs_stock_productsearch.lists["x_jc_no"].options = <?php echo JsonEncode($hs_stock_product_search->jc_no->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fhs_stock_productsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($hs_stock_product->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no_fp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($hs_stock_product->jc_no_fp->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $hs_stock_product_search->showPageHeader(); ?>
<?php
$hs_stock_product_search->showMessage();
?>
<form name="fhs_stock_productsearch" id="fhs_stock_productsearch" class="<?php echo $hs_stock_product_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($hs_stock_product_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $hs_stock_product_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="hs_stock_product">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$hs_stock_product_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($hs_stock_product->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_grp"><?php echo $hs_stock_product->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->grp->cellAttributes() ?>>
			<span id="el_hs_stock_product_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_grp" data-value-separator="<?php echo $hs_stock_product->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $hs_stock_product->grp->editAttributes() ?>>
		<?php echo $hs_stock_product->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_s_grp"><?php echo $hs_stock_product->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->s_grp->cellAttributes() ?>>
			<span id="el_hs_stock_product_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_s_grp" data-value-separator="<?php echo $hs_stock_product->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $hs_stock_product->s_grp->editAttributes() ?>>
		<?php echo $hs_stock_product->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $hs_stock_product->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_product"><?php echo $hs_stock_product->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->product->cellAttributes() ?>>
			<span id="el_hs_stock_product_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_product" data-value-separator="<?php echo $hs_stock_product->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $hs_stock_product->product->editAttributes() ?>>
		<?php echo $hs_stock_product->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $hs_stock_product->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_rid"><?php echo $hs_stock_product->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->rid->cellAttributes() ?>>
			<span id="el_hs_stock_product_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_rid" data-value-separator="<?php echo $hs_stock_product->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $hs_stock_product->rid->editAttributes() ?>>
		<?php echo $hs_stock_product->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $hs_stock_product->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_IN"><?php echo $hs_stock_product->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->IN->cellAttributes() ?>>
			<span id="el_hs_stock_product_IN">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_IN" data-value-separator="<?php echo $hs_stock_product->IN->displayValueSeparatorAttribute() ?>" id="x_IN" name="x_IN"<?php echo $hs_stock_product->IN->editAttributes() ?>>
		<?php echo $hs_stock_product->IN->selectOptionListHtml("x_IN") ?>
	</select>
</div>
<?php echo $hs_stock_product->IN->Lookup->getParamTag("p_x_IN") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_OUT"><?php echo $hs_stock_product->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->OUT->cellAttributes() ?>>
			<span id="el_hs_stock_product_OUT">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_OUT" data-value-separator="<?php echo $hs_stock_product->OUT->displayValueSeparatorAttribute() ?>" id="x_OUT" name="x_OUT"<?php echo $hs_stock_product->OUT->editAttributes() ?>>
		<?php echo $hs_stock_product->OUT->selectOptionListHtml("x_OUT") ?>
	</select>
</div>
<?php echo $hs_stock_product->OUT->Lookup->getParamTag("p_x_OUT") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_Balance"><?php echo $hs_stock_product->Balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Balance" id="z_Balance" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->Balance->cellAttributes() ?>>
			<span id="el_hs_stock_product_Balance">
<input type="text" data-table="hs_stock_product" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($hs_stock_product->Balance->getPlaceHolder()) ?>" value="<?php echo $hs_stock_product->Balance->EditValue ?>"<?php echo $hs_stock_product->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_godown"><?php echo $hs_stock_product->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->godown->cellAttributes() ?>>
			<span id="el_hs_stock_product_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_godown" data-value-separator="<?php echo $hs_stock_product->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $hs_stock_product->godown->editAttributes() ?>>
		<?php echo $hs_stock_product->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $hs_stock_product->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_jc_no"><?php echo $hs_stock_product->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->jc_no->cellAttributes() ?>>
			<span id="el_hs_stock_product_jc_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hs_stock_product" data-field="x_jc_no" data-value-separator="<?php echo $hs_stock_product->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $hs_stock_product->jc_no->editAttributes() ?>>
		<?php echo $hs_stock_product->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $hs_stock_product->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->item_code->Visible) { // item_code ?>
	<div id="r_item_code" class="form-group row">
		<label for="x_item_code" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_item_code"><?php echo $hs_stock_product->item_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item_code" id="z_item_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->item_code->cellAttributes() ?>>
			<span id="el_hs_stock_product_item_code">
<input type="text" data-table="hs_stock_product" data-field="x_item_code" name="x_item_code" id="x_item_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($hs_stock_product->item_code->getPlaceHolder()) ?>" value="<?php echo $hs_stock_product->item_code->EditValue ?>"<?php echo $hs_stock_product->item_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($hs_stock_product->jc_no_fp->Visible) { // jc_no_fp ?>
	<div id="r_jc_no_fp" class="form-group row">
		<label for="x_jc_no_fp" class="<?php echo $hs_stock_product_search->LeftColumnClass ?>"><span id="elh_hs_stock_product_jc_no_fp"><?php echo $hs_stock_product->jc_no_fp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no_fp" id="z_jc_no_fp" value="="></span>
		</label>
		<div class="<?php echo $hs_stock_product_search->RightColumnClass ?>"><div<?php echo $hs_stock_product->jc_no_fp->cellAttributes() ?>>
			<span id="el_hs_stock_product_jc_no_fp">
<input type="text" data-table="hs_stock_product" data-field="x_jc_no_fp" name="x_jc_no_fp" id="x_jc_no_fp" size="30" placeholder="<?php echo HtmlEncode($hs_stock_product->jc_no_fp->getPlaceHolder()) ?>" value="<?php echo $hs_stock_product->jc_no_fp->EditValue ?>"<?php echo $hs_stock_product->jc_no_fp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$hs_stock_product_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $hs_stock_product_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$hs_stock_product_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$hs_stock_product_search->terminate();
?>