<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$import_bcode_add = new import_bcode_add();

// Run the page
$import_bcode_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$import_bcode_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fimport_bcodeadd = currentForm = new ew.Form("fimport_bcodeadd", "add");

// Validate form
fimport_bcodeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($import_bcode_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $import_bcode->_barcode->caption(), $import_bcode->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($import_bcode_add->material_requirement->Required) { ?>
			elm = this.getElements("x" + infix + "_material_requirement");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $import_bcode->material_requirement->caption(), $import_bcode->material_requirement->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($import_bcode_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $import_bcode->operator->caption(), $import_bcode->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($import_bcode_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $import_bcode->datetime->caption(), $import_bcode->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fimport_bcodeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fimport_bcodeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fimport_bcodeadd.lists["x_material_requirement"] = <?php echo $import_bcode_add->material_requirement->Lookup->toClientList() ?>;
fimport_bcodeadd.lists["x_material_requirement"].options = <?php echo JsonEncode($import_bcode_add->material_requirement->options(FALSE, TRUE)) ?>;
fimport_bcodeadd.lists["x_operator"] = <?php echo $import_bcode_add->operator->Lookup->toClientList() ?>;
fimport_bcodeadd.lists["x_operator"].options = <?php echo JsonEncode($import_bcode_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $import_bcode_add->showPageHeader(); ?>
<?php
$import_bcode_add->showMessage();
?>
<form name="fimport_bcodeadd" id="fimport_bcodeadd" class="<?php echo $import_bcode_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($import_bcode_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $import_bcode_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="import_bcode">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$import_bcode_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($import_bcode->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_import_bcode__barcode" for="x__barcode" class="<?php echo $import_bcode_add->LeftColumnClass ?>"><?php echo $import_bcode->_barcode->caption() ?><?php echo ($import_bcode->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $import_bcode_add->RightColumnClass ?>"><div<?php echo $import_bcode->_barcode->cellAttributes() ?>>
<span id="el_import_bcode__barcode">
<textarea data-table="import_bcode" data-field="x__barcode" name="x__barcode" id="x__barcode" cols="35" rows="4" placeholder="<?php echo HtmlEncode($import_bcode->_barcode->getPlaceHolder()) ?>"<?php echo $import_bcode->_barcode->editAttributes() ?>><?php echo $import_bcode->_barcode->EditValue ?></textarea>
</span>
<?php echo $import_bcode->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($import_bcode->material_requirement->Visible) { // material_requirement ?>
	<div id="r_material_requirement" class="form-group row">
		<label id="elh_import_bcode_material_requirement" for="x_material_requirement" class="<?php echo $import_bcode_add->LeftColumnClass ?>"><?php echo $import_bcode->material_requirement->caption() ?><?php echo ($import_bcode->material_requirement->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $import_bcode_add->RightColumnClass ?>"><div<?php echo $import_bcode->material_requirement->cellAttributes() ?>>
<span id="el_import_bcode_material_requirement">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="import_bcode" data-field="x_material_requirement" data-value-separator="<?php echo $import_bcode->material_requirement->displayValueSeparatorAttribute() ?>" id="x_material_requirement" name="x_material_requirement"<?php echo $import_bcode->material_requirement->editAttributes() ?>>
		<?php echo $import_bcode->material_requirement->selectOptionListHtml("x_material_requirement") ?>
	</select>
</div>
</span>
<?php echo $import_bcode->material_requirement->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$import_bcode_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $import_bcode_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $import_bcode_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$import_bcode_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$import_bcode_add->terminate();
?>