<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$import_bcode_list = new import_bcode_list();

// Run the page
$import_bcode_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$import_bcode_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$import_bcode->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fimport_bcodelist = currentForm = new ew.Form("fimport_bcodelist", "list");
fimport_bcodelist.formKeyCountName = '<?php echo $import_bcode_list->FormKeyCountName ?>';

// Form_CustomValidate event
fimport_bcodelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fimport_bcodelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fimport_bcodelist.lists["x_material_requirement"] = <?php echo $import_bcode_list->material_requirement->Lookup->toClientList() ?>;
fimport_bcodelist.lists["x_material_requirement"].options = <?php echo JsonEncode($import_bcode_list->material_requirement->options(FALSE, TRUE)) ?>;
fimport_bcodelist.lists["x_operator"] = <?php echo $import_bcode_list->operator->Lookup->toClientList() ?>;
fimport_bcodelist.lists["x_operator"].options = <?php echo JsonEncode($import_bcode_list->operator->lookupOptions()) ?>;

// Form object for search
var fimport_bcodelistsrch = currentSearchForm = new ew.Form("fimport_bcodelistsrch");

// Filters
fimport_bcodelistsrch.filterList = <?php echo $import_bcode_list->getFilterList() ?>;

// Init search panel as collapsed
fimport_bcodelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$import_bcode->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($import_bcode_list->TotalRecs > 0 && $import_bcode_list->ExportOptions->visible()) { ?>
<?php $import_bcode_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($import_bcode_list->ImportOptions->visible()) { ?>
<?php $import_bcode_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($import_bcode_list->SearchOptions->visible()) { ?>
<?php $import_bcode_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($import_bcode_list->FilterOptions->visible()) { ?>
<?php $import_bcode_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$import_bcode_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$import_bcode->isExport() && !$import_bcode->CurrentAction) { ?>
<form name="fimport_bcodelistsrch" id="fimport_bcodelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($import_bcode_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fimport_bcodelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="import_bcode">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($import_bcode_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($import_bcode_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $import_bcode_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($import_bcode_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($import_bcode_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($import_bcode_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($import_bcode_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $import_bcode_list->showPageHeader(); ?>
<?php
$import_bcode_list->showMessage();
?>
<?php if ($import_bcode_list->TotalRecs > 0 || $import_bcode->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($import_bcode_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> import_bcode">
<?php if (!$import_bcode->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$import_bcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($import_bcode_list->Pager)) $import_bcode_list->Pager = new PrevNextPager($import_bcode_list->StartRec, $import_bcode_list->DisplayRecs, $import_bcode_list->TotalRecs, $import_bcode_list->AutoHidePager) ?>
<?php if ($import_bcode_list->Pager->RecordCount > 0 && $import_bcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($import_bcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($import_bcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $import_bcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($import_bcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($import_bcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $import_bcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($import_bcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $import_bcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $import_bcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $import_bcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($import_bcode_list->TotalRecs > 0 && (!$import_bcode_list->AutoHidePageSizeSelector || $import_bcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="import_bcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($import_bcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($import_bcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($import_bcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($import_bcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($import_bcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($import_bcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $import_bcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fimport_bcodelist" id="fimport_bcodelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($import_bcode_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $import_bcode_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="import_bcode">
<div id="gmp_import_bcode" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($import_bcode_list->TotalRecs > 0 || $import_bcode->isGridEdit()) { ?>
<table id="tbl_import_bcodelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$import_bcode_list->RowType = ROWTYPE_HEADER;

// Render list options
$import_bcode_list->renderListOptions();

// Render list options (header, left)
$import_bcode_list->ListOptions->render("header", "left");
?>
<?php if ($import_bcode->id->Visible) { // id ?>
	<?php if ($import_bcode->sortUrl($import_bcode->id) == "") { ?>
		<th data-name="id" class="<?php echo $import_bcode->id->headerCellClass() ?>"><div id="elh_import_bcode_id" class="import_bcode_id"><div class="ew-table-header-caption"><?php echo $import_bcode->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $import_bcode->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $import_bcode->SortUrl($import_bcode->id) ?>',2);"><div id="elh_import_bcode_id" class="import_bcode_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $import_bcode->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($import_bcode->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($import_bcode->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($import_bcode->_barcode->Visible) { // barcode ?>
	<?php if ($import_bcode->sortUrl($import_bcode->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $import_bcode->_barcode->headerCellClass() ?>"><div id="elh_import_bcode__barcode" class="import_bcode__barcode"><div class="ew-table-header-caption"><?php echo $import_bcode->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $import_bcode->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $import_bcode->SortUrl($import_bcode->_barcode) ?>',2);"><div id="elh_import_bcode__barcode" class="import_bcode__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $import_bcode->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($import_bcode->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($import_bcode->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($import_bcode->material_requirement->Visible) { // material_requirement ?>
	<?php if ($import_bcode->sortUrl($import_bcode->material_requirement) == "") { ?>
		<th data-name="material_requirement" class="<?php echo $import_bcode->material_requirement->headerCellClass() ?>"><div id="elh_import_bcode_material_requirement" class="import_bcode_material_requirement"><div class="ew-table-header-caption"><?php echo $import_bcode->material_requirement->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_requirement" class="<?php echo $import_bcode->material_requirement->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $import_bcode->SortUrl($import_bcode->material_requirement) ?>',2);"><div id="elh_import_bcode_material_requirement" class="import_bcode_material_requirement">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $import_bcode->material_requirement->caption() ?></span><span class="ew-table-header-sort"><?php if ($import_bcode->material_requirement->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($import_bcode->material_requirement->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($import_bcode->operator->Visible) { // operator ?>
	<?php if ($import_bcode->sortUrl($import_bcode->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $import_bcode->operator->headerCellClass() ?>"><div id="elh_import_bcode_operator" class="import_bcode_operator"><div class="ew-table-header-caption"><?php echo $import_bcode->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $import_bcode->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $import_bcode->SortUrl($import_bcode->operator) ?>',2);"><div id="elh_import_bcode_operator" class="import_bcode_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $import_bcode->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($import_bcode->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($import_bcode->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($import_bcode->datetime->Visible) { // datetime ?>
	<?php if ($import_bcode->sortUrl($import_bcode->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $import_bcode->datetime->headerCellClass() ?>"><div id="elh_import_bcode_datetime" class="import_bcode_datetime"><div class="ew-table-header-caption"><?php echo $import_bcode->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $import_bcode->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $import_bcode->SortUrl($import_bcode->datetime) ?>',2);"><div id="elh_import_bcode_datetime" class="import_bcode_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $import_bcode->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($import_bcode->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($import_bcode->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$import_bcode_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($import_bcode->ExportAll && $import_bcode->isExport()) {
	$import_bcode_list->StopRec = $import_bcode_list->TotalRecs;
} else {

	// Set the last record to display
	if ($import_bcode_list->TotalRecs > $import_bcode_list->StartRec + $import_bcode_list->DisplayRecs - 1)
		$import_bcode_list->StopRec = $import_bcode_list->StartRec + $import_bcode_list->DisplayRecs - 1;
	else
		$import_bcode_list->StopRec = $import_bcode_list->TotalRecs;
}
$import_bcode_list->RecCnt = $import_bcode_list->StartRec - 1;
if ($import_bcode_list->Recordset && !$import_bcode_list->Recordset->EOF) {
	$import_bcode_list->Recordset->moveFirst();
	$selectLimit = $import_bcode_list->UseSelectLimit;
	if (!$selectLimit && $import_bcode_list->StartRec > 1)
		$import_bcode_list->Recordset->move($import_bcode_list->StartRec - 1);
} elseif (!$import_bcode->AllowAddDeleteRow && $import_bcode_list->StopRec == 0) {
	$import_bcode_list->StopRec = $import_bcode->GridAddRowCount;
}

// Initialize aggregate
$import_bcode->RowType = ROWTYPE_AGGREGATEINIT;
$import_bcode->resetAttributes();
$import_bcode_list->renderRow();
while ($import_bcode_list->RecCnt < $import_bcode_list->StopRec) {
	$import_bcode_list->RecCnt++;
	if ($import_bcode_list->RecCnt >= $import_bcode_list->StartRec) {
		$import_bcode_list->RowCnt++;

		// Set up key count
		$import_bcode_list->KeyCount = $import_bcode_list->RowIndex;

		// Init row class and style
		$import_bcode->resetAttributes();
		$import_bcode->CssClass = "";
		if ($import_bcode->isGridAdd()) {
		} else {
			$import_bcode_list->loadRowValues($import_bcode_list->Recordset); // Load row values
		}
		$import_bcode->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$import_bcode->RowAttrs = array_merge($import_bcode->RowAttrs, array('data-rowindex'=>$import_bcode_list->RowCnt, 'id'=>'r' . $import_bcode_list->RowCnt . '_import_bcode', 'data-rowtype'=>$import_bcode->RowType));

		// Render row
		$import_bcode_list->renderRow();

		// Render list options
		$import_bcode_list->renderListOptions();
?>
	<tr<?php echo $import_bcode->rowAttributes() ?>>
<?php

// Render list options (body, left)
$import_bcode_list->ListOptions->render("body", "left", $import_bcode_list->RowCnt);
?>
	<?php if ($import_bcode->id->Visible) { // id ?>
		<td data-name="id"<?php echo $import_bcode->id->cellAttributes() ?>>
<span id="el<?php echo $import_bcode_list->RowCnt ?>_import_bcode_id" class="import_bcode_id">
<span<?php echo $import_bcode->id->viewAttributes() ?>>
<?php echo $import_bcode->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($import_bcode->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $import_bcode->_barcode->cellAttributes() ?>>
<span id="el<?php echo $import_bcode_list->RowCnt ?>_import_bcode__barcode" class="import_bcode__barcode">
<span<?php echo $import_bcode->_barcode->viewAttributes() ?>>
<?php echo $import_bcode->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($import_bcode->material_requirement->Visible) { // material_requirement ?>
		<td data-name="material_requirement"<?php echo $import_bcode->material_requirement->cellAttributes() ?>>
<span id="el<?php echo $import_bcode_list->RowCnt ?>_import_bcode_material_requirement" class="import_bcode_material_requirement">
<span<?php echo $import_bcode->material_requirement->viewAttributes() ?>>
<?php echo $import_bcode->material_requirement->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($import_bcode->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $import_bcode->operator->cellAttributes() ?>>
<span id="el<?php echo $import_bcode_list->RowCnt ?>_import_bcode_operator" class="import_bcode_operator">
<span<?php echo $import_bcode->operator->viewAttributes() ?>>
<?php echo $import_bcode->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($import_bcode->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $import_bcode->datetime->cellAttributes() ?>>
<span id="el<?php echo $import_bcode_list->RowCnt ?>_import_bcode_datetime" class="import_bcode_datetime">
<span<?php echo $import_bcode->datetime->viewAttributes() ?>>
<?php echo $import_bcode->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$import_bcode_list->ListOptions->render("body", "right", $import_bcode_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$import_bcode->isGridAdd())
		$import_bcode_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$import_bcode->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($import_bcode_list->Recordset)
	$import_bcode_list->Recordset->Close();
?>
<?php if (!$import_bcode->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$import_bcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($import_bcode_list->Pager)) $import_bcode_list->Pager = new PrevNextPager($import_bcode_list->StartRec, $import_bcode_list->DisplayRecs, $import_bcode_list->TotalRecs, $import_bcode_list->AutoHidePager) ?>
<?php if ($import_bcode_list->Pager->RecordCount > 0 && $import_bcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($import_bcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($import_bcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $import_bcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($import_bcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($import_bcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $import_bcode_list->pageUrl() ?>start=<?php echo $import_bcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $import_bcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($import_bcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $import_bcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $import_bcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $import_bcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($import_bcode_list->TotalRecs > 0 && (!$import_bcode_list->AutoHidePageSizeSelector || $import_bcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="import_bcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($import_bcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($import_bcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($import_bcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($import_bcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($import_bcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($import_bcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $import_bcode_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($import_bcode_list->TotalRecs == 0 && !$import_bcode->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $import_bcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$import_bcode_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$import_bcode->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$import_bcode->isExport()) { ?>
<script>
ew.scrollableTable("gmp_import_bcode", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$import_bcode_list->terminate();
?>