<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$importer_add = new importer_add();

// Run the page
$importer_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$importer_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fimporteradd = currentForm = new ew.Form("fimporteradd", "add");

// Validate form
fimporteradd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($importer_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->grp->caption(), $importer->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->name->caption(), $importer->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->code->caption(), $importer->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($importer->code->errorMessage()) ?>");
		<?php if ($importer_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->status->caption(), $importer->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->operator->caption(), $importer->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->datetime->caption(), $importer->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fimporteradd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fimporteradd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fimporteradd.lists["x_grp"] = <?php echo $importer_add->grp->Lookup->toClientList() ?>;
fimporteradd.lists["x_grp"].options = <?php echo JsonEncode($importer_add->grp->options(FALSE, TRUE)) ?>;
fimporteradd.lists["x_status"] = <?php echo $importer_add->status->Lookup->toClientList() ?>;
fimporteradd.lists["x_status"].options = <?php echo JsonEncode($importer_add->status->options(FALSE, TRUE)) ?>;
fimporteradd.lists["x_operator"] = <?php echo $importer_add->operator->Lookup->toClientList() ?>;
fimporteradd.lists["x_operator"].options = <?php echo JsonEncode($importer_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $importer_add->showPageHeader(); ?>
<?php
$importer_add->showMessage();
?>
<form name="fimporteradd" id="fimporteradd" class="<?php echo $importer_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($importer_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $importer_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="importer">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$importer_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($importer->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_importer_grp" for="x_grp" class="<?php echo $importer_add->LeftColumnClass ?>"><?php echo $importer->grp->caption() ?><?php echo ($importer->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $importer_add->RightColumnClass ?>"><div<?php echo $importer->grp->cellAttributes() ?>>
<span id="el_importer_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="importer" data-field="x_grp" data-value-separator="<?php echo $importer->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $importer->grp->editAttributes() ?>>
		<?php echo $importer->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $importer->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($importer->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_importer_name" for="x_name" class="<?php echo $importer_add->LeftColumnClass ?>"><?php echo $importer->name->caption() ?><?php echo ($importer->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $importer_add->RightColumnClass ?>"><div<?php echo $importer->name->cellAttributes() ?>>
<span id="el_importer_name">
<input type="text" data-table="importer" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($importer->name->getPlaceHolder()) ?>" value="<?php echo $importer->name->EditValue ?>"<?php echo $importer->name->editAttributes() ?>>
</span>
<?php echo $importer->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($importer->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_importer_code" for="x_code" class="<?php echo $importer_add->LeftColumnClass ?>"><?php echo $importer->code->caption() ?><?php echo ($importer->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $importer_add->RightColumnClass ?>"><div<?php echo $importer->code->cellAttributes() ?>>
<span id="el_importer_code">
<input type="text" data-table="importer" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($importer->code->getPlaceHolder()) ?>" value="<?php echo $importer->code->EditValue ?>"<?php echo $importer->code->editAttributes() ?>>
</span>
<?php echo $importer->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($importer->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_importer_status" for="x_status" class="<?php echo $importer_add->LeftColumnClass ?>"><?php echo $importer->status->caption() ?><?php echo ($importer->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $importer_add->RightColumnClass ?>"><div<?php echo $importer->status->cellAttributes() ?>>
<span id="el_importer_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="importer" data-field="x_status" data-value-separator="<?php echo $importer->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $importer->status->editAttributes() ?>>
		<?php echo $importer->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $importer->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$importer_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $importer_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $importer_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$importer_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$importer_add->terminate();
?>