<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$importer_addopt = new importer_addopt();

// Run the page
$importer_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$importer_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fimporteraddopt = currentForm = new ew.Form("fimporteraddopt", "addopt");

// Validate form
fimporteraddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($importer_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->grp->caption(), $importer->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->name->caption(), $importer->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->code->caption(), $importer->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($importer->code->errorMessage()) ?>");
		<?php if ($importer_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->status->caption(), $importer->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->operator->caption(), $importer->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($importer_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $importer->datetime->caption(), $importer->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fimporteraddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fimporteraddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fimporteraddopt.lists["x_grp"] = <?php echo $importer_addopt->grp->Lookup->toClientList() ?>;
fimporteraddopt.lists["x_grp"].options = <?php echo JsonEncode($importer_addopt->grp->options(FALSE, TRUE)) ?>;
fimporteraddopt.lists["x_status"] = <?php echo $importer_addopt->status->Lookup->toClientList() ?>;
fimporteraddopt.lists["x_status"].options = <?php echo JsonEncode($importer_addopt->status->options(FALSE, TRUE)) ?>;
fimporteraddopt.lists["x_operator"] = <?php echo $importer_addopt->operator->Lookup->toClientList() ?>;
fimporteraddopt.lists["x_operator"].options = <?php echo JsonEncode($importer_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $importer_addopt->showPageHeader(); ?>
<?php
$importer_addopt->showMessage();
?>
<form name="fimporteraddopt" id="fimporteraddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($importer_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $importer_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $importer_addopt->TableVar ?>">
<?php if ($importer->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $importer->grp->caption() ?><?php echo ($importer->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="importer" data-field="x_grp" data-value-separator="<?php echo $importer->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $importer->grp->editAttributes() ?>>
		<?php echo $importer->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $importer->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($importer->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $importer->name->caption() ?><?php echo ($importer->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="importer" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($importer->name->getPlaceHolder()) ?>" value="<?php echo $importer->name->EditValue ?>"<?php echo $importer->name->editAttributes() ?>>
<?php echo $importer->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($importer->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $importer->code->caption() ?><?php echo ($importer->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="importer" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($importer->code->getPlaceHolder()) ?>" value="<?php echo $importer->code->EditValue ?>"<?php echo $importer->code->editAttributes() ?>>
<?php echo $importer->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($importer->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $importer->status->caption() ?><?php echo ($importer->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="importer" data-field="x_status" data-value-separator="<?php echo $importer->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $importer->status->editAttributes() ?>>
		<?php echo $importer->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $importer->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($importer->operator->Visible) { // operator ?>
	<input type="hidden" data-table="importer" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($importer->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($importer->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="importer" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($importer->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$importer_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$importer_addopt->terminate();
?>