<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$importer_delete = new importer_delete();

// Run the page
$importer_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$importer_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fimporterdelete = currentForm = new ew.Form("fimporterdelete", "delete");

// Form_CustomValidate event
fimporterdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fimporterdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fimporterdelete.lists["x_grp"] = <?php echo $importer_delete->grp->Lookup->toClientList() ?>;
fimporterdelete.lists["x_grp"].options = <?php echo JsonEncode($importer_delete->grp->options(FALSE, TRUE)) ?>;
fimporterdelete.lists["x_status"] = <?php echo $importer_delete->status->Lookup->toClientList() ?>;
fimporterdelete.lists["x_status"].options = <?php echo JsonEncode($importer_delete->status->options(FALSE, TRUE)) ?>;
fimporterdelete.lists["x_operator"] = <?php echo $importer_delete->operator->Lookup->toClientList() ?>;
fimporterdelete.lists["x_operator"].options = <?php echo JsonEncode($importer_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $importer_delete->showPageHeader(); ?>
<?php
$importer_delete->showMessage();
?>
<form name="fimporterdelete" id="fimporterdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($importer_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $importer_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="importer">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($importer_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($importer->id->Visible) { // id ?>
		<th class="<?php echo $importer->id->headerCellClass() ?>"><span id="elh_importer_id" class="importer_id"><?php echo $importer->id->caption() ?></span></th>
<?php } ?>
<?php if ($importer->grp->Visible) { // grp ?>
		<th class="<?php echo $importer->grp->headerCellClass() ?>"><span id="elh_importer_grp" class="importer_grp"><?php echo $importer->grp->caption() ?></span></th>
<?php } ?>
<?php if ($importer->name->Visible) { // name ?>
		<th class="<?php echo $importer->name->headerCellClass() ?>"><span id="elh_importer_name" class="importer_name"><?php echo $importer->name->caption() ?></span></th>
<?php } ?>
<?php if ($importer->code->Visible) { // code ?>
		<th class="<?php echo $importer->code->headerCellClass() ?>"><span id="elh_importer_code" class="importer_code"><?php echo $importer->code->caption() ?></span></th>
<?php } ?>
<?php if ($importer->status->Visible) { // status ?>
		<th class="<?php echo $importer->status->headerCellClass() ?>"><span id="elh_importer_status" class="importer_status"><?php echo $importer->status->caption() ?></span></th>
<?php } ?>
<?php if ($importer->operator->Visible) { // operator ?>
		<th class="<?php echo $importer->operator->headerCellClass() ?>"><span id="elh_importer_operator" class="importer_operator"><?php echo $importer->operator->caption() ?></span></th>
<?php } ?>
<?php if ($importer->datetime->Visible) { // datetime ?>
		<th class="<?php echo $importer->datetime->headerCellClass() ?>"><span id="elh_importer_datetime" class="importer_datetime"><?php echo $importer->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$importer_delete->RecCnt = 0;
$i = 0;
while (!$importer_delete->Recordset->EOF) {
	$importer_delete->RecCnt++;
	$importer_delete->RowCnt++;

	// Set row properties
	$importer->resetAttributes();
	$importer->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$importer_delete->loadRowValues($importer_delete->Recordset);

	// Render row
	$importer_delete->renderRow();
?>
	<tr<?php echo $importer->rowAttributes() ?>>
<?php if ($importer->id->Visible) { // id ?>
		<td<?php echo $importer->id->cellAttributes() ?>>
<span id="el<?php echo $importer_delete->RowCnt ?>_importer_id" class="importer_id">
<span<?php echo $importer->id->viewAttributes() ?>>
<?php echo $importer->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($importer->grp->Visible) { // grp ?>
		<td<?php echo $importer->grp->cellAttributes() ?>>
<span id="el<?php echo $importer_delete->RowCnt ?>_importer_grp" class="importer_grp">
<span<?php echo $importer->grp->viewAttributes() ?>>
<?php echo $importer->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($importer->name->Visible) { // name ?>
		<td<?php echo $importer->name->cellAttributes() ?>>
<span id="el<?php echo $importer_delete->RowCnt ?>_importer_name" class="importer_name">
<span<?php echo $importer->name->viewAttributes() ?>>
<?php echo $importer->name->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($importer->code->Visible) { // code ?>
		<td<?php echo $importer->code->cellAttributes() ?>>
<span id="el<?php echo $importer_delete->RowCnt ?>_importer_code" class="importer_code">
<span<?php echo $importer->code->viewAttributes() ?>>
<?php echo $importer->code->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($importer->status->Visible) { // status ?>
		<td<?php echo $importer->status->cellAttributes() ?>>
<span id="el<?php echo $importer_delete->RowCnt ?>_importer_status" class="importer_status">
<span<?php echo $importer->status->viewAttributes() ?>>
<?php echo $importer->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($importer->operator->Visible) { // operator ?>
		<td<?php echo $importer->operator->cellAttributes() ?>>
<span id="el<?php echo $importer_delete->RowCnt ?>_importer_operator" class="importer_operator">
<span<?php echo $importer->operator->viewAttributes() ?>>
<?php echo $importer->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($importer->datetime->Visible) { // datetime ?>
		<td<?php echo $importer->datetime->cellAttributes() ?>>
<span id="el<?php echo $importer_delete->RowCnt ?>_importer_datetime" class="importer_datetime">
<span<?php echo $importer->datetime->viewAttributes() ?>>
<?php echo $importer->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$importer_delete->Recordset->moveNext();
}
$importer_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $importer_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$importer_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$importer_delete->terminate();
?>