<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$importer_list = new importer_list();

// Run the page
$importer_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$importer_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$importer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fimporterlist = currentForm = new ew.Form("fimporterlist", "list");
fimporterlist.formKeyCountName = '<?php echo $importer_list->FormKeyCountName ?>';

// Form_CustomValidate event
fimporterlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fimporterlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fimporterlist.lists["x_grp"] = <?php echo $importer_list->grp->Lookup->toClientList() ?>;
fimporterlist.lists["x_grp"].options = <?php echo JsonEncode($importer_list->grp->options(FALSE, TRUE)) ?>;
fimporterlist.lists["x_status"] = <?php echo $importer_list->status->Lookup->toClientList() ?>;
fimporterlist.lists["x_status"].options = <?php echo JsonEncode($importer_list->status->options(FALSE, TRUE)) ?>;
fimporterlist.lists["x_operator"] = <?php echo $importer_list->operator->Lookup->toClientList() ?>;
fimporterlist.lists["x_operator"].options = <?php echo JsonEncode($importer_list->operator->lookupOptions()) ?>;

// Form object for search
var fimporterlistsrch = currentSearchForm = new ew.Form("fimporterlistsrch");

// Filters
fimporterlistsrch.filterList = <?php echo $importer_list->getFilterList() ?>;

// Init search panel as collapsed
fimporterlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$importer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($importer_list->TotalRecs > 0 && $importer_list->ExportOptions->visible()) { ?>
<?php $importer_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($importer_list->ImportOptions->visible()) { ?>
<?php $importer_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($importer_list->SearchOptions->visible()) { ?>
<?php $importer_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($importer_list->FilterOptions->visible()) { ?>
<?php $importer_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$importer_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$importer->isExport() && !$importer->CurrentAction) { ?>
<form name="fimporterlistsrch" id="fimporterlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($importer_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fimporterlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="importer">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($importer_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($importer_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $importer_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($importer_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($importer_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($importer_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($importer_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $importer_list->showPageHeader(); ?>
<?php
$importer_list->showMessage();
?>
<?php if ($importer_list->TotalRecs > 0 || $importer->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($importer_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> importer">
<?php if (!$importer->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$importer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($importer_list->Pager)) $importer_list->Pager = new PrevNextPager($importer_list->StartRec, $importer_list->DisplayRecs, $importer_list->TotalRecs, $importer_list->AutoHidePager) ?>
<?php if ($importer_list->Pager->RecordCount > 0 && $importer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($importer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($importer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $importer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($importer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($importer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $importer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($importer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $importer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $importer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $importer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($importer_list->TotalRecs > 0 && (!$importer_list->AutoHidePageSizeSelector || $importer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="importer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($importer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($importer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($importer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($importer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($importer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($importer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $importer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fimporterlist" id="fimporterlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($importer_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $importer_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="importer">
<div id="gmp_importer" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($importer_list->TotalRecs > 0 || $importer->isGridEdit()) { ?>
<table id="tbl_importerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$importer_list->RowType = ROWTYPE_HEADER;

// Render list options
$importer_list->renderListOptions();

// Render list options (header, left)
$importer_list->ListOptions->render("header", "left");
?>
<?php if ($importer->id->Visible) { // id ?>
	<?php if ($importer->sortUrl($importer->id) == "") { ?>
		<th data-name="id" class="<?php echo $importer->id->headerCellClass() ?>"><div id="elh_importer_id" class="importer_id"><div class="ew-table-header-caption"><?php echo $importer->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $importer->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $importer->SortUrl($importer->id) ?>',2);"><div id="elh_importer_id" class="importer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $importer->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($importer->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($importer->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($importer->grp->Visible) { // grp ?>
	<?php if ($importer->sortUrl($importer->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $importer->grp->headerCellClass() ?>"><div id="elh_importer_grp" class="importer_grp"><div class="ew-table-header-caption"><?php echo $importer->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $importer->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $importer->SortUrl($importer->grp) ?>',2);"><div id="elh_importer_grp" class="importer_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $importer->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($importer->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($importer->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($importer->name->Visible) { // name ?>
	<?php if ($importer->sortUrl($importer->name) == "") { ?>
		<th data-name="name" class="<?php echo $importer->name->headerCellClass() ?>"><div id="elh_importer_name" class="importer_name"><div class="ew-table-header-caption"><?php echo $importer->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $importer->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $importer->SortUrl($importer->name) ?>',2);"><div id="elh_importer_name" class="importer_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $importer->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($importer->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($importer->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($importer->code->Visible) { // code ?>
	<?php if ($importer->sortUrl($importer->code) == "") { ?>
		<th data-name="code" class="<?php echo $importer->code->headerCellClass() ?>"><div id="elh_importer_code" class="importer_code"><div class="ew-table-header-caption"><?php echo $importer->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $importer->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $importer->SortUrl($importer->code) ?>',2);"><div id="elh_importer_code" class="importer_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $importer->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($importer->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($importer->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($importer->status->Visible) { // status ?>
	<?php if ($importer->sortUrl($importer->status) == "") { ?>
		<th data-name="status" class="<?php echo $importer->status->headerCellClass() ?>"><div id="elh_importer_status" class="importer_status"><div class="ew-table-header-caption"><?php echo $importer->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $importer->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $importer->SortUrl($importer->status) ?>',2);"><div id="elh_importer_status" class="importer_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $importer->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($importer->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($importer->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($importer->operator->Visible) { // operator ?>
	<?php if ($importer->sortUrl($importer->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $importer->operator->headerCellClass() ?>"><div id="elh_importer_operator" class="importer_operator"><div class="ew-table-header-caption"><?php echo $importer->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $importer->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $importer->SortUrl($importer->operator) ?>',2);"><div id="elh_importer_operator" class="importer_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $importer->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($importer->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($importer->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($importer->datetime->Visible) { // datetime ?>
	<?php if ($importer->sortUrl($importer->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $importer->datetime->headerCellClass() ?>"><div id="elh_importer_datetime" class="importer_datetime"><div class="ew-table-header-caption"><?php echo $importer->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $importer->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $importer->SortUrl($importer->datetime) ?>',2);"><div id="elh_importer_datetime" class="importer_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $importer->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($importer->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($importer->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$importer_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($importer->ExportAll && $importer->isExport()) {
	$importer_list->StopRec = $importer_list->TotalRecs;
} else {

	// Set the last record to display
	if ($importer_list->TotalRecs > $importer_list->StartRec + $importer_list->DisplayRecs - 1)
		$importer_list->StopRec = $importer_list->StartRec + $importer_list->DisplayRecs - 1;
	else
		$importer_list->StopRec = $importer_list->TotalRecs;
}
$importer_list->RecCnt = $importer_list->StartRec - 1;
if ($importer_list->Recordset && !$importer_list->Recordset->EOF) {
	$importer_list->Recordset->moveFirst();
	$selectLimit = $importer_list->UseSelectLimit;
	if (!$selectLimit && $importer_list->StartRec > 1)
		$importer_list->Recordset->move($importer_list->StartRec - 1);
} elseif (!$importer->AllowAddDeleteRow && $importer_list->StopRec == 0) {
	$importer_list->StopRec = $importer->GridAddRowCount;
}

// Initialize aggregate
$importer->RowType = ROWTYPE_AGGREGATEINIT;
$importer->resetAttributes();
$importer_list->renderRow();
while ($importer_list->RecCnt < $importer_list->StopRec) {
	$importer_list->RecCnt++;
	if ($importer_list->RecCnt >= $importer_list->StartRec) {
		$importer_list->RowCnt++;

		// Set up key count
		$importer_list->KeyCount = $importer_list->RowIndex;

		// Init row class and style
		$importer->resetAttributes();
		$importer->CssClass = "";
		if ($importer->isGridAdd()) {
		} else {
			$importer_list->loadRowValues($importer_list->Recordset); // Load row values
		}
		$importer->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$importer->RowAttrs = array_merge($importer->RowAttrs, array('data-rowindex'=>$importer_list->RowCnt, 'id'=>'r' . $importer_list->RowCnt . '_importer', 'data-rowtype'=>$importer->RowType));

		// Render row
		$importer_list->renderRow();

		// Render list options
		$importer_list->renderListOptions();
?>
	<tr<?php echo $importer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$importer_list->ListOptions->render("body", "left", $importer_list->RowCnt);
?>
	<?php if ($importer->id->Visible) { // id ?>
		<td data-name="id"<?php echo $importer->id->cellAttributes() ?>>
<span id="el<?php echo $importer_list->RowCnt ?>_importer_id" class="importer_id">
<span<?php echo $importer->id->viewAttributes() ?>>
<?php echo $importer->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($importer->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $importer->grp->cellAttributes() ?>>
<span id="el<?php echo $importer_list->RowCnt ?>_importer_grp" class="importer_grp">
<span<?php echo $importer->grp->viewAttributes() ?>>
<?php echo $importer->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($importer->name->Visible) { // name ?>
		<td data-name="name"<?php echo $importer->name->cellAttributes() ?>>
<span id="el<?php echo $importer_list->RowCnt ?>_importer_name" class="importer_name">
<span<?php echo $importer->name->viewAttributes() ?>>
<?php echo $importer->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($importer->code->Visible) { // code ?>
		<td data-name="code"<?php echo $importer->code->cellAttributes() ?>>
<span id="el<?php echo $importer_list->RowCnt ?>_importer_code" class="importer_code">
<span<?php echo $importer->code->viewAttributes() ?>>
<?php echo $importer->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($importer->status->Visible) { // status ?>
		<td data-name="status"<?php echo $importer->status->cellAttributes() ?>>
<span id="el<?php echo $importer_list->RowCnt ?>_importer_status" class="importer_status">
<span<?php echo $importer->status->viewAttributes() ?>>
<?php echo $importer->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($importer->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $importer->operator->cellAttributes() ?>>
<span id="el<?php echo $importer_list->RowCnt ?>_importer_operator" class="importer_operator">
<span<?php echo $importer->operator->viewAttributes() ?>>
<?php echo $importer->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($importer->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $importer->datetime->cellAttributes() ?>>
<span id="el<?php echo $importer_list->RowCnt ?>_importer_datetime" class="importer_datetime">
<span<?php echo $importer->datetime->viewAttributes() ?>>
<?php echo $importer->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$importer_list->ListOptions->render("body", "right", $importer_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$importer->isGridAdd())
		$importer_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$importer->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($importer_list->Recordset)
	$importer_list->Recordset->Close();
?>
<?php if (!$importer->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$importer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($importer_list->Pager)) $importer_list->Pager = new PrevNextPager($importer_list->StartRec, $importer_list->DisplayRecs, $importer_list->TotalRecs, $importer_list->AutoHidePager) ?>
<?php if ($importer_list->Pager->RecordCount > 0 && $importer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($importer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($importer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $importer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($importer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($importer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $importer_list->pageUrl() ?>start=<?php echo $importer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $importer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($importer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $importer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $importer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $importer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($importer_list->TotalRecs > 0 && (!$importer_list->AutoHidePageSizeSelector || $importer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="importer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($importer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($importer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($importer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($importer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($importer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($importer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $importer_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($importer_list->TotalRecs == 0 && !$importer->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $importer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$importer_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$importer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$importer->isExport()) { ?>
<script>
ew.scrollableTable("gmp_importer", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$importer_list->terminate();
?>