<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$importer_view = new importer_view();

// Run the page
$importer_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$importer_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$importer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fimporterview = currentForm = new ew.Form("fimporterview", "view");

// Form_CustomValidate event
fimporterview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fimporterview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fimporterview.lists["x_grp"] = <?php echo $importer_view->grp->Lookup->toClientList() ?>;
fimporterview.lists["x_grp"].options = <?php echo JsonEncode($importer_view->grp->options(FALSE, TRUE)) ?>;
fimporterview.lists["x_status"] = <?php echo $importer_view->status->Lookup->toClientList() ?>;
fimporterview.lists["x_status"].options = <?php echo JsonEncode($importer_view->status->options(FALSE, TRUE)) ?>;
fimporterview.lists["x_operator"] = <?php echo $importer_view->operator->Lookup->toClientList() ?>;
fimporterview.lists["x_operator"].options = <?php echo JsonEncode($importer_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$importer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $importer_view->ExportOptions->render("body") ?>
<?php $importer_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $importer_view->showPageHeader(); ?>
<?php
$importer_view->showMessage();
?>
<form name="fimporterview" id="fimporterview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($importer_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $importer_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="importer">
<input type="hidden" name="modal" value="<?php echo (int)$importer_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($importer->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $importer_view->TableLeftColumnClass ?>"><span id="elh_importer_id"><?php echo $importer->id->caption() ?></span></td>
		<td data-name="id"<?php echo $importer->id->cellAttributes() ?>>
<span id="el_importer_id">
<span<?php echo $importer->id->viewAttributes() ?>>
<?php echo $importer->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($importer->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $importer_view->TableLeftColumnClass ?>"><span id="elh_importer_grp"><?php echo $importer->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $importer->grp->cellAttributes() ?>>
<span id="el_importer_grp">
<span<?php echo $importer->grp->viewAttributes() ?>>
<?php echo $importer->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($importer->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $importer_view->TableLeftColumnClass ?>"><span id="elh_importer_name"><?php echo $importer->name->caption() ?></span></td>
		<td data-name="name"<?php echo $importer->name->cellAttributes() ?>>
<span id="el_importer_name">
<span<?php echo $importer->name->viewAttributes() ?>>
<?php echo $importer->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($importer->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $importer_view->TableLeftColumnClass ?>"><span id="elh_importer_code"><?php echo $importer->code->caption() ?></span></td>
		<td data-name="code"<?php echo $importer->code->cellAttributes() ?>>
<span id="el_importer_code">
<span<?php echo $importer->code->viewAttributes() ?>>
<?php echo $importer->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($importer->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $importer_view->TableLeftColumnClass ?>"><span id="elh_importer_status"><?php echo $importer->status->caption() ?></span></td>
		<td data-name="status"<?php echo $importer->status->cellAttributes() ?>>
<span id="el_importer_status">
<span<?php echo $importer->status->viewAttributes() ?>>
<?php echo $importer->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($importer->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $importer_view->TableLeftColumnClass ?>"><span id="elh_importer_operator"><?php echo $importer->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $importer->operator->cellAttributes() ?>>
<span id="el_importer_operator">
<span<?php echo $importer->operator->viewAttributes() ?>>
<?php echo $importer->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($importer->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $importer_view->TableLeftColumnClass ?>"><span id="elh_importer_datetime"><?php echo $importer->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $importer->datetime->cellAttributes() ?>>
<span id="el_importer_datetime">
<span<?php echo $importer->datetime->viewAttributes() ?>>
<?php echo $importer->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$importer_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$importer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$importer_view->terminate();
?>