<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$incoterm_edit = new incoterm_edit();

// Run the page
$incoterm_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$incoterm_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fincotermedit = currentForm = new ew.Form("fincotermedit", "edit");

// Validate form
fincotermedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($incoterm_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $incoterm->id->caption(), $incoterm->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($incoterm_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $incoterm->item->caption(), $incoterm->item->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fincotermedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fincotermedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $incoterm_edit->showPageHeader(); ?>
<?php
$incoterm_edit->showMessage();
?>
<form name="fincotermedit" id="fincotermedit" class="<?php echo $incoterm_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($incoterm_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $incoterm_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="incoterm">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$incoterm_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($incoterm->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_incoterm_id" class="<?php echo $incoterm_edit->LeftColumnClass ?>"><?php echo $incoterm->id->caption() ?><?php echo ($incoterm->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $incoterm_edit->RightColumnClass ?>"><div<?php echo $incoterm->id->cellAttributes() ?>>
<span id="el_incoterm_id">
<span<?php echo $incoterm->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($incoterm->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="incoterm" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($incoterm->id->CurrentValue) ?>">
<?php echo $incoterm->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($incoterm->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_incoterm_item" for="x_item" class="<?php echo $incoterm_edit->LeftColumnClass ?>"><?php echo $incoterm->item->caption() ?><?php echo ($incoterm->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $incoterm_edit->RightColumnClass ?>"><div<?php echo $incoterm->item->cellAttributes() ?>>
<span id="el_incoterm_item">
<input type="text" data-table="incoterm" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($incoterm->item->getPlaceHolder()) ?>" value="<?php echo $incoterm->item->EditValue ?>"<?php echo $incoterm->item->editAttributes() ?>>
</span>
<?php echo $incoterm->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$incoterm_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $incoterm_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $incoterm_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$incoterm_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$incoterm_edit->terminate();
?>