<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$incoterm_list = new incoterm_list();

// Run the page
$incoterm_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$incoterm_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$incoterm->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fincotermlist = currentForm = new ew.Form("fincotermlist", "list");
fincotermlist.formKeyCountName = '<?php echo $incoterm_list->FormKeyCountName ?>';

// Form_CustomValidate event
fincotermlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fincotermlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fincotermlistsrch = currentSearchForm = new ew.Form("fincotermlistsrch");

// Filters
fincotermlistsrch.filterList = <?php echo $incoterm_list->getFilterList() ?>;

// Init search panel as collapsed
fincotermlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$incoterm->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($incoterm_list->TotalRecs > 0 && $incoterm_list->ExportOptions->visible()) { ?>
<?php $incoterm_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($incoterm_list->ImportOptions->visible()) { ?>
<?php $incoterm_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($incoterm_list->SearchOptions->visible()) { ?>
<?php $incoterm_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($incoterm_list->FilterOptions->visible()) { ?>
<?php $incoterm_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$incoterm_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$incoterm->isExport() && !$incoterm->CurrentAction) { ?>
<form name="fincotermlistsrch" id="fincotermlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($incoterm_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fincotermlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="incoterm">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($incoterm_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($incoterm_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $incoterm_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($incoterm_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($incoterm_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($incoterm_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($incoterm_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $incoterm_list->showPageHeader(); ?>
<?php
$incoterm_list->showMessage();
?>
<?php if ($incoterm_list->TotalRecs > 0 || $incoterm->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($incoterm_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> incoterm">
<?php if (!$incoterm->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$incoterm->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($incoterm_list->Pager)) $incoterm_list->Pager = new PrevNextPager($incoterm_list->StartRec, $incoterm_list->DisplayRecs, $incoterm_list->TotalRecs, $incoterm_list->AutoHidePager) ?>
<?php if ($incoterm_list->Pager->RecordCount > 0 && $incoterm_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($incoterm_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($incoterm_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $incoterm_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($incoterm_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($incoterm_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $incoterm_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($incoterm_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $incoterm_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $incoterm_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $incoterm_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($incoterm_list->TotalRecs > 0 && (!$incoterm_list->AutoHidePageSizeSelector || $incoterm_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="incoterm">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($incoterm_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($incoterm_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($incoterm_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($incoterm_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($incoterm_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($incoterm->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $incoterm_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fincotermlist" id="fincotermlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($incoterm_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $incoterm_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="incoterm">
<div id="gmp_incoterm" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($incoterm_list->TotalRecs > 0 || $incoterm->isGridEdit()) { ?>
<table id="tbl_incotermlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$incoterm_list->RowType = ROWTYPE_HEADER;

// Render list options
$incoterm_list->renderListOptions();

// Render list options (header, left)
$incoterm_list->ListOptions->render("header", "left");
?>
<?php if ($incoterm->id->Visible) { // id ?>
	<?php if ($incoterm->sortUrl($incoterm->id) == "") { ?>
		<th data-name="id" class="<?php echo $incoterm->id->headerCellClass() ?>"><div id="elh_incoterm_id" class="incoterm_id"><div class="ew-table-header-caption"><?php echo $incoterm->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $incoterm->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $incoterm->SortUrl($incoterm->id) ?>',2);"><div id="elh_incoterm_id" class="incoterm_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $incoterm->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($incoterm->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($incoterm->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($incoterm->item->Visible) { // item ?>
	<?php if ($incoterm->sortUrl($incoterm->item) == "") { ?>
		<th data-name="item" class="<?php echo $incoterm->item->headerCellClass() ?>"><div id="elh_incoterm_item" class="incoterm_item"><div class="ew-table-header-caption"><?php echo $incoterm->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $incoterm->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $incoterm->SortUrl($incoterm->item) ?>',2);"><div id="elh_incoterm_item" class="incoterm_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $incoterm->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($incoterm->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($incoterm->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$incoterm_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($incoterm->ExportAll && $incoterm->isExport()) {
	$incoterm_list->StopRec = $incoterm_list->TotalRecs;
} else {

	// Set the last record to display
	if ($incoterm_list->TotalRecs > $incoterm_list->StartRec + $incoterm_list->DisplayRecs - 1)
		$incoterm_list->StopRec = $incoterm_list->StartRec + $incoterm_list->DisplayRecs - 1;
	else
		$incoterm_list->StopRec = $incoterm_list->TotalRecs;
}
$incoterm_list->RecCnt = $incoterm_list->StartRec - 1;
if ($incoterm_list->Recordset && !$incoterm_list->Recordset->EOF) {
	$incoterm_list->Recordset->moveFirst();
	$selectLimit = $incoterm_list->UseSelectLimit;
	if (!$selectLimit && $incoterm_list->StartRec > 1)
		$incoterm_list->Recordset->move($incoterm_list->StartRec - 1);
} elseif (!$incoterm->AllowAddDeleteRow && $incoterm_list->StopRec == 0) {
	$incoterm_list->StopRec = $incoterm->GridAddRowCount;
}

// Initialize aggregate
$incoterm->RowType = ROWTYPE_AGGREGATEINIT;
$incoterm->resetAttributes();
$incoterm_list->renderRow();
while ($incoterm_list->RecCnt < $incoterm_list->StopRec) {
	$incoterm_list->RecCnt++;
	if ($incoterm_list->RecCnt >= $incoterm_list->StartRec) {
		$incoterm_list->RowCnt++;

		// Set up key count
		$incoterm_list->KeyCount = $incoterm_list->RowIndex;

		// Init row class and style
		$incoterm->resetAttributes();
		$incoterm->CssClass = "";
		if ($incoterm->isGridAdd()) {
		} else {
			$incoterm_list->loadRowValues($incoterm_list->Recordset); // Load row values
		}
		$incoterm->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$incoterm->RowAttrs = array_merge($incoterm->RowAttrs, array('data-rowindex'=>$incoterm_list->RowCnt, 'id'=>'r' . $incoterm_list->RowCnt . '_incoterm', 'data-rowtype'=>$incoterm->RowType));

		// Render row
		$incoterm_list->renderRow();

		// Render list options
		$incoterm_list->renderListOptions();
?>
	<tr<?php echo $incoterm->rowAttributes() ?>>
<?php

// Render list options (body, left)
$incoterm_list->ListOptions->render("body", "left", $incoterm_list->RowCnt);
?>
	<?php if ($incoterm->id->Visible) { // id ?>
		<td data-name="id"<?php echo $incoterm->id->cellAttributes() ?>>
<span id="el<?php echo $incoterm_list->RowCnt ?>_incoterm_id" class="incoterm_id">
<span<?php echo $incoterm->id->viewAttributes() ?>>
<?php echo $incoterm->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($incoterm->item->Visible) { // item ?>
		<td data-name="item"<?php echo $incoterm->item->cellAttributes() ?>>
<span id="el<?php echo $incoterm_list->RowCnt ?>_incoterm_item" class="incoterm_item">
<span<?php echo $incoterm->item->viewAttributes() ?>>
<?php echo $incoterm->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$incoterm_list->ListOptions->render("body", "right", $incoterm_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$incoterm->isGridAdd())
		$incoterm_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$incoterm->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($incoterm_list->Recordset)
	$incoterm_list->Recordset->Close();
?>
<?php if (!$incoterm->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$incoterm->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($incoterm_list->Pager)) $incoterm_list->Pager = new PrevNextPager($incoterm_list->StartRec, $incoterm_list->DisplayRecs, $incoterm_list->TotalRecs, $incoterm_list->AutoHidePager) ?>
<?php if ($incoterm_list->Pager->RecordCount > 0 && $incoterm_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($incoterm_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($incoterm_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $incoterm_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($incoterm_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($incoterm_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $incoterm_list->pageUrl() ?>start=<?php echo $incoterm_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $incoterm_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($incoterm_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $incoterm_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $incoterm_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $incoterm_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($incoterm_list->TotalRecs > 0 && (!$incoterm_list->AutoHidePageSizeSelector || $incoterm_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="incoterm">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($incoterm_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($incoterm_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($incoterm_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($incoterm_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($incoterm_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($incoterm->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $incoterm_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($incoterm_list->TotalRecs == 0 && !$incoterm->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $incoterm_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$incoterm_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$incoterm->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$incoterm->isExport()) { ?>
<script>
ew.scrollableTable("gmp_incoterm", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$incoterm_list->terminate();
?>