<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$incoterm_view = new incoterm_view();

// Run the page
$incoterm_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$incoterm_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$incoterm->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fincotermview = currentForm = new ew.Form("fincotermview", "view");

// Form_CustomValidate event
fincotermview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fincotermview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$incoterm->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $incoterm_view->ExportOptions->render("body") ?>
<?php $incoterm_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $incoterm_view->showPageHeader(); ?>
<?php
$incoterm_view->showMessage();
?>
<form name="fincotermview" id="fincotermview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($incoterm_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $incoterm_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="incoterm">
<input type="hidden" name="modal" value="<?php echo (int)$incoterm_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($incoterm->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $incoterm_view->TableLeftColumnClass ?>"><span id="elh_incoterm_id"><?php echo $incoterm->id->caption() ?></span></td>
		<td data-name="id"<?php echo $incoterm->id->cellAttributes() ?>>
<span id="el_incoterm_id">
<span<?php echo $incoterm->id->viewAttributes() ?>>
<?php echo $incoterm->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($incoterm->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $incoterm_view->TableLeftColumnClass ?>"><span id="elh_incoterm_item"><?php echo $incoterm->item->caption() ?></span></td>
		<td data-name="item"<?php echo $incoterm->item->cellAttributes() ?>>
<span id="el_incoterm_item">
<span<?php echo $incoterm->item->viewAttributes() ?>>
<?php echo $incoterm->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$incoterm_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$incoterm->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$incoterm_view->terminate();
?>