<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$int_fibre_help_edit = new int_fibre_help_edit();

// Run the page
$int_fibre_help_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$int_fibre_help_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fint_fibre_helpedit = currentForm = new ew.Form("fint_fibre_helpedit", "edit");

// Validate form
fint_fibre_helpedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($int_fibre_help_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_fibre_help->id->caption(), $int_fibre_help->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_fibre_help_edit->level->Required) { ?>
			elm = this.getElements("x" + infix + "_level");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_fibre_help->level->caption(), $int_fibre_help->level->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_fibre_help_edit->table_name->Required) { ?>
			elm = this.getElements("x" + infix + "_table_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_fibre_help->table_name->caption(), $int_fibre_help->table_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_fibre_help_edit->table_caption->Required) { ?>
			elm = this.getElements("x" + infix + "_table_caption");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_fibre_help->table_caption->caption(), $int_fibre_help->table_caption->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_fibre_help_edit->admin_notes->Required) { ?>
			elm = this.getElements("x" + infix + "_admin_notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_fibre_help->admin_notes->caption(), $int_fibre_help->admin_notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fint_fibre_helpedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_fibre_helpedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_fibre_helpedit.lists["x_level"] = <?php echo $int_fibre_help_edit->level->Lookup->toClientList() ?>;
fint_fibre_helpedit.lists["x_level"].options = <?php echo JsonEncode($int_fibre_help_edit->level->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $int_fibre_help_edit->showPageHeader(); ?>
<?php
$int_fibre_help_edit->showMessage();
?>
<form name="fint_fibre_helpedit" id="fint_fibre_helpedit" class="<?php echo $int_fibre_help_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($int_fibre_help_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $int_fibre_help_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="int_fibre_help">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$int_fibre_help_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($int_fibre_help->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_int_fibre_help_id" class="<?php echo $int_fibre_help_edit->LeftColumnClass ?>"><?php echo $int_fibre_help->id->caption() ?><?php echo ($int_fibre_help->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_fibre_help_edit->RightColumnClass ?>"><div<?php echo $int_fibre_help->id->cellAttributes() ?>>
<span id="el_int_fibre_help_id">
<span<?php echo $int_fibre_help->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($int_fibre_help->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="int_fibre_help" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($int_fibre_help->id->CurrentValue) ?>">
<?php echo $int_fibre_help->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_fibre_help->level->Visible) { // level ?>
	<div id="r_level" class="form-group row">
		<label id="elh_int_fibre_help_level" for="x_level" class="<?php echo $int_fibre_help_edit->LeftColumnClass ?>"><?php echo $int_fibre_help->level->caption() ?><?php echo ($int_fibre_help->level->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_fibre_help_edit->RightColumnClass ?>"><div<?php echo $int_fibre_help->level->cellAttributes() ?>>
<span id="el_int_fibre_help_level">
<span<?php echo $int_fibre_help->level->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($int_fibre_help->level->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="int_fibre_help" data-field="x_level" name="x_level" id="x_level" value="<?php echo HtmlEncode($int_fibre_help->level->CurrentValue) ?>">
<?php echo $int_fibre_help->level->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_fibre_help->table_name->Visible) { // table_name ?>
	<div id="r_table_name" class="form-group row">
		<label id="elh_int_fibre_help_table_name" for="x_table_name" class="<?php echo $int_fibre_help_edit->LeftColumnClass ?>"><?php echo $int_fibre_help->table_name->caption() ?><?php echo ($int_fibre_help->table_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_fibre_help_edit->RightColumnClass ?>"><div<?php echo $int_fibre_help->table_name->cellAttributes() ?>>
<span id="el_int_fibre_help_table_name">
<span<?php echo $int_fibre_help->table_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($int_fibre_help->table_name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="int_fibre_help" data-field="x_table_name" name="x_table_name" id="x_table_name" value="<?php echo HtmlEncode($int_fibre_help->table_name->CurrentValue) ?>">
<?php echo $int_fibre_help->table_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_fibre_help->table_caption->Visible) { // table_caption ?>
	<div id="r_table_caption" class="form-group row">
		<label id="elh_int_fibre_help_table_caption" for="x_table_caption" class="<?php echo $int_fibre_help_edit->LeftColumnClass ?>"><?php echo $int_fibre_help->table_caption->caption() ?><?php echo ($int_fibre_help->table_caption->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_fibre_help_edit->RightColumnClass ?>"><div<?php echo $int_fibre_help->table_caption->cellAttributes() ?>>
<span id="el_int_fibre_help_table_caption">
<span<?php echo $int_fibre_help->table_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($int_fibre_help->table_caption->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="int_fibre_help" data-field="x_table_caption" name="x_table_caption" id="x_table_caption" value="<?php echo HtmlEncode($int_fibre_help->table_caption->CurrentValue) ?>">
<?php echo $int_fibre_help->table_caption->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_fibre_help->admin_notes->Visible) { // admin_notes ?>
	<div id="r_admin_notes" class="form-group row">
		<label id="elh_int_fibre_help_admin_notes" class="<?php echo $int_fibre_help_edit->LeftColumnClass ?>"><?php echo $int_fibre_help->admin_notes->caption() ?><?php echo ($int_fibre_help->admin_notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_fibre_help_edit->RightColumnClass ?>"><div<?php echo $int_fibre_help->admin_notes->cellAttributes() ?>>
<span id="el_int_fibre_help_admin_notes">
<?php AppendClass($int_fibre_help->admin_notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="int_fibre_help" data-field="x_admin_notes" name="x_admin_notes" id="x_admin_notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($int_fibre_help->admin_notes->getPlaceHolder()) ?>"<?php echo $int_fibre_help->admin_notes->editAttributes() ?>><?php echo $int_fibre_help->admin_notes->EditValue ?></textarea>
<script>
ew.createEditor("fint_fibre_helpedit", "x_admin_notes", 35, 4, <?php echo ($int_fibre_help->admin_notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $int_fibre_help->admin_notes->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$int_fibre_help_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $int_fibre_help_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $int_fibre_help_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$int_fibre_help_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$int_fibre_help_edit->terminate();
?>