<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$int_fibre_help_list = new int_fibre_help_list();

// Run the page
$int_fibre_help_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$int_fibre_help_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$int_fibre_help->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fint_fibre_helplist = currentForm = new ew.Form("fint_fibre_helplist", "list");
fint_fibre_helplist.formKeyCountName = '<?php echo $int_fibre_help_list->FormKeyCountName ?>';

// Form_CustomValidate event
fint_fibre_helplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_fibre_helplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_fibre_helplist.lists["x_level"] = <?php echo $int_fibre_help_list->level->Lookup->toClientList() ?>;
fint_fibre_helplist.lists["x_level"].options = <?php echo JsonEncode($int_fibre_help_list->level->options(FALSE, TRUE)) ?>;

// Form object for search
var fint_fibre_helplistsrch = currentSearchForm = new ew.Form("fint_fibre_helplistsrch");

// Validate function for search
fint_fibre_helplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fint_fibre_helplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_fibre_helplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_fibre_helplistsrch.lists["x_level"] = <?php echo $int_fibre_help_list->level->Lookup->toClientList() ?>;
fint_fibre_helplistsrch.lists["x_level"].options = <?php echo JsonEncode($int_fibre_help_list->level->options(FALSE, TRUE)) ?>;

// Filters
fint_fibre_helplistsrch.filterList = <?php echo $int_fibre_help_list->getFilterList() ?>;

// Init search panel as collapsed
fint_fibre_helplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$int_fibre_help->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($int_fibre_help_list->TotalRecs > 0 && $int_fibre_help_list->ExportOptions->visible()) { ?>
<?php $int_fibre_help_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($int_fibre_help_list->ImportOptions->visible()) { ?>
<?php $int_fibre_help_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($int_fibre_help_list->SearchOptions->visible()) { ?>
<?php $int_fibre_help_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($int_fibre_help_list->FilterOptions->visible()) { ?>
<?php $int_fibre_help_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$int_fibre_help_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$int_fibre_help->isExport() && !$int_fibre_help->CurrentAction) { ?>
<form name="fint_fibre_helplistsrch" id="fint_fibre_helplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($int_fibre_help_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fint_fibre_helplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="int_fibre_help">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$int_fibre_help_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$int_fibre_help->RowType = ROWTYPE_SEARCH;

// Render row
$int_fibre_help->resetAttributes();
$int_fibre_help_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($int_fibre_help->level->Visible) { // level ?>
	<div id="xsc_level" class="ew-cell form-group">
		<label for="x_level" class="ew-search-caption ew-label"><?php echo $int_fibre_help->level->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_level" id="z_level" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="int_fibre_help" data-field="x_level" data-value-separator="<?php echo $int_fibre_help->level->displayValueSeparatorAttribute() ?>" id="x_level" name="x_level"<?php echo $int_fibre_help->level->editAttributes() ?>>
		<?php echo $int_fibre_help->level->selectOptionListHtml("x_level") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($int_fibre_help->table_name->Visible) { // table_name ?>
	<div id="xsc_table_name" class="ew-cell form-group">
		<label for="x_table_name" class="ew-search-caption ew-label"><?php echo $int_fibre_help->table_name->caption() ?></label>
		<span class="ew-search-operator"><select name="z_table_name" id="z_table_name" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($int_fibre_help->table_name->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="int_fibre_help" data-field="x_table_name" name="x_table_name" id="x_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($int_fibre_help->table_name->getPlaceHolder()) ?>" value="<?php echo $int_fibre_help->table_name->EditValue ?>"<?php echo $int_fibre_help->table_name->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_table_name style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_table_name style="d-none"">
<input type="text" data-table="int_fibre_help" data-field="x_table_name" name="y_table_name" id="y_table_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($int_fibre_help->table_name->getPlaceHolder()) ?>" value="<?php echo $int_fibre_help->table_name->EditValue2 ?>"<?php echo $int_fibre_help->table_name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($int_fibre_help->table_caption->Visible) { // table_caption ?>
	<div id="xsc_table_caption" class="ew-cell form-group">
		<label for="x_table_caption" class="ew-search-caption ew-label"><?php echo $int_fibre_help->table_caption->caption() ?></label>
		<span class="ew-search-operator"><select name="z_table_caption" id="z_table_caption" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($int_fibre_help->table_caption->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="int_fibre_help" data-field="x_table_caption" name="x_table_caption" id="x_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($int_fibre_help->table_caption->getPlaceHolder()) ?>" value="<?php echo $int_fibre_help->table_caption->EditValue ?>"<?php echo $int_fibre_help->table_caption->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_table_caption style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_table_caption style="d-none"">
<input type="text" data-table="int_fibre_help" data-field="x_table_caption" name="y_table_caption" id="y_table_caption" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($int_fibre_help->table_caption->getPlaceHolder()) ?>" value="<?php echo $int_fibre_help->table_caption->EditValue2 ?>"<?php echo $int_fibre_help->table_caption->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($int_fibre_help_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($int_fibre_help_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $int_fibre_help_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($int_fibre_help_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($int_fibre_help_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($int_fibre_help_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($int_fibre_help_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $int_fibre_help_list->showPageHeader(); ?>
<?php
$int_fibre_help_list->showMessage();
?>
<?php if ($int_fibre_help_list->TotalRecs > 0 || $int_fibre_help->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($int_fibre_help_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> int_fibre_help">
<?php if (!$int_fibre_help->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$int_fibre_help->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($int_fibre_help_list->Pager)) $int_fibre_help_list->Pager = new PrevNextPager($int_fibre_help_list->StartRec, $int_fibre_help_list->DisplayRecs, $int_fibre_help_list->TotalRecs, $int_fibre_help_list->AutoHidePager) ?>
<?php if ($int_fibre_help_list->Pager->RecordCount > 0 && $int_fibre_help_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($int_fibre_help_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($int_fibre_help_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $int_fibre_help_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($int_fibre_help_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($int_fibre_help_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($int_fibre_help_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($int_fibre_help_list->TotalRecs > 0 && (!$int_fibre_help_list->AutoHidePageSizeSelector || $int_fibre_help_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="int_fibre_help">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($int_fibre_help_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($int_fibre_help_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($int_fibre_help_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($int_fibre_help_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($int_fibre_help_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($int_fibre_help->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $int_fibre_help_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fint_fibre_helplist" id="fint_fibre_helplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($int_fibre_help_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $int_fibre_help_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="int_fibre_help">
<div id="gmp_int_fibre_help" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($int_fibre_help_list->TotalRecs > 0 || $int_fibre_help->isGridEdit()) { ?>
<table id="tbl_int_fibre_helplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$int_fibre_help_list->RowType = ROWTYPE_HEADER;

// Render list options
$int_fibre_help_list->renderListOptions();

// Render list options (header, left)
$int_fibre_help_list->ListOptions->render("header", "left");
?>
<?php if ($int_fibre_help->id->Visible) { // id ?>
	<?php if ($int_fibre_help->sortUrl($int_fibre_help->id) == "") { ?>
		<th data-name="id" class="<?php echo $int_fibre_help->id->headerCellClass() ?>"><div id="elh_int_fibre_help_id" class="int_fibre_help_id"><div class="ew-table-header-caption"><?php echo $int_fibre_help->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $int_fibre_help->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_fibre_help->SortUrl($int_fibre_help->id) ?>',2);"><div id="elh_int_fibre_help_id" class="int_fibre_help_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_fibre_help->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_fibre_help->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_fibre_help->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_fibre_help->level->Visible) { // level ?>
	<?php if ($int_fibre_help->sortUrl($int_fibre_help->level) == "") { ?>
		<th data-name="level" class="<?php echo $int_fibre_help->level->headerCellClass() ?>"><div id="elh_int_fibre_help_level" class="int_fibre_help_level"><div class="ew-table-header-caption"><?php echo $int_fibre_help->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $int_fibre_help->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_fibre_help->SortUrl($int_fibre_help->level) ?>',2);"><div id="elh_int_fibre_help_level" class="int_fibre_help_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_fibre_help->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_fibre_help->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_fibre_help->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_fibre_help->table_name->Visible) { // table_name ?>
	<?php if ($int_fibre_help->sortUrl($int_fibre_help->table_name) == "") { ?>
		<th data-name="table_name" class="<?php echo $int_fibre_help->table_name->headerCellClass() ?>"><div id="elh_int_fibre_help_table_name" class="int_fibre_help_table_name"><div class="ew-table-header-caption"><?php echo $int_fibre_help->table_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="table_name" class="<?php echo $int_fibre_help->table_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_fibre_help->SortUrl($int_fibre_help->table_name) ?>',2);"><div id="elh_int_fibre_help_table_name" class="int_fibre_help_table_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_fibre_help->table_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($int_fibre_help->table_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_fibre_help->table_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_fibre_help->table_caption->Visible) { // table_caption ?>
	<?php if ($int_fibre_help->sortUrl($int_fibre_help->table_caption) == "") { ?>
		<th data-name="table_caption" class="<?php echo $int_fibre_help->table_caption->headerCellClass() ?>"><div id="elh_int_fibre_help_table_caption" class="int_fibre_help_table_caption"><div class="ew-table-header-caption"><?php echo $int_fibre_help->table_caption->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="table_caption" class="<?php echo $int_fibre_help->table_caption->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_fibre_help->SortUrl($int_fibre_help->table_caption) ?>',2);"><div id="elh_int_fibre_help_table_caption" class="int_fibre_help_table_caption">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_fibre_help->table_caption->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($int_fibre_help->table_caption->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_fibre_help->table_caption->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_fibre_help->admin_notes->Visible) { // admin_notes ?>
	<?php if ($int_fibre_help->sortUrl($int_fibre_help->admin_notes) == "") { ?>
		<th data-name="admin_notes" class="<?php echo $int_fibre_help->admin_notes->headerCellClass() ?>"><div id="elh_int_fibre_help_admin_notes" class="int_fibre_help_admin_notes"><div class="ew-table-header-caption"><?php echo $int_fibre_help->admin_notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="admin_notes" class="<?php echo $int_fibre_help->admin_notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_fibre_help->SortUrl($int_fibre_help->admin_notes) ?>',2);"><div id="elh_int_fibre_help_admin_notes" class="int_fibre_help_admin_notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_fibre_help->admin_notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($int_fibre_help->admin_notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_fibre_help->admin_notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$int_fibre_help_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($int_fibre_help->ExportAll && $int_fibre_help->isExport()) {
	$int_fibre_help_list->StopRec = $int_fibre_help_list->TotalRecs;
} else {

	// Set the last record to display
	if ($int_fibre_help_list->TotalRecs > $int_fibre_help_list->StartRec + $int_fibre_help_list->DisplayRecs - 1)
		$int_fibre_help_list->StopRec = $int_fibre_help_list->StartRec + $int_fibre_help_list->DisplayRecs - 1;
	else
		$int_fibre_help_list->StopRec = $int_fibre_help_list->TotalRecs;
}
$int_fibre_help_list->RecCnt = $int_fibre_help_list->StartRec - 1;
if ($int_fibre_help_list->Recordset && !$int_fibre_help_list->Recordset->EOF) {
	$int_fibre_help_list->Recordset->moveFirst();
	$selectLimit = $int_fibre_help_list->UseSelectLimit;
	if (!$selectLimit && $int_fibre_help_list->StartRec > 1)
		$int_fibre_help_list->Recordset->move($int_fibre_help_list->StartRec - 1);
} elseif (!$int_fibre_help->AllowAddDeleteRow && $int_fibre_help_list->StopRec == 0) {
	$int_fibre_help_list->StopRec = $int_fibre_help->GridAddRowCount;
}

// Initialize aggregate
$int_fibre_help->RowType = ROWTYPE_AGGREGATEINIT;
$int_fibre_help->resetAttributes();
$int_fibre_help_list->renderRow();
while ($int_fibre_help_list->RecCnt < $int_fibre_help_list->StopRec) {
	$int_fibre_help_list->RecCnt++;
	if ($int_fibre_help_list->RecCnt >= $int_fibre_help_list->StartRec) {
		$int_fibre_help_list->RowCnt++;

		// Set up key count
		$int_fibre_help_list->KeyCount = $int_fibre_help_list->RowIndex;

		// Init row class and style
		$int_fibre_help->resetAttributes();
		$int_fibre_help->CssClass = "";
		if ($int_fibre_help->isGridAdd()) {
		} else {
			$int_fibre_help_list->loadRowValues($int_fibre_help_list->Recordset); // Load row values
		}
		$int_fibre_help->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$int_fibre_help->RowAttrs = array_merge($int_fibre_help->RowAttrs, array('data-rowindex'=>$int_fibre_help_list->RowCnt, 'id'=>'r' . $int_fibre_help_list->RowCnt . '_int_fibre_help', 'data-rowtype'=>$int_fibre_help->RowType));

		// Render row
		$int_fibre_help_list->renderRow();

		// Render list options
		$int_fibre_help_list->renderListOptions();
?>
	<tr<?php echo $int_fibre_help->rowAttributes() ?>>
<?php

// Render list options (body, left)
$int_fibre_help_list->ListOptions->render("body", "left", $int_fibre_help_list->RowCnt);
?>
	<?php if ($int_fibre_help->id->Visible) { // id ?>
		<td data-name="id"<?php echo $int_fibre_help->id->cellAttributes() ?>>
<span id="el<?php echo $int_fibre_help_list->RowCnt ?>_int_fibre_help_id" class="int_fibre_help_id">
<span<?php echo $int_fibre_help->id->viewAttributes() ?>>
<?php echo $int_fibre_help->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_fibre_help->level->Visible) { // level ?>
		<td data-name="level"<?php echo $int_fibre_help->level->cellAttributes() ?>>
<span id="el<?php echo $int_fibre_help_list->RowCnt ?>_int_fibre_help_level" class="int_fibre_help_level">
<span<?php echo $int_fibre_help->level->viewAttributes() ?>>
<?php echo $int_fibre_help->level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_fibre_help->table_name->Visible) { // table_name ?>
		<td data-name="table_name"<?php echo $int_fibre_help->table_name->cellAttributes() ?>>
<span id="el<?php echo $int_fibre_help_list->RowCnt ?>_int_fibre_help_table_name" class="int_fibre_help_table_name">
<span<?php echo $int_fibre_help->table_name->viewAttributes() ?>>
<?php echo $int_fibre_help->table_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_fibre_help->table_caption->Visible) { // table_caption ?>
		<td data-name="table_caption"<?php echo $int_fibre_help->table_caption->cellAttributes() ?>>
<span id="el<?php echo $int_fibre_help_list->RowCnt ?>_int_fibre_help_table_caption" class="int_fibre_help_table_caption">
<span<?php echo $int_fibre_help->table_caption->viewAttributes() ?>>
<?php echo $int_fibre_help->table_caption->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_fibre_help->admin_notes->Visible) { // admin_notes ?>
		<td data-name="admin_notes"<?php echo $int_fibre_help->admin_notes->cellAttributes() ?>>
<span id="el<?php echo $int_fibre_help_list->RowCnt ?>_int_fibre_help_admin_notes" class="int_fibre_help_admin_notes">
<span<?php echo $int_fibre_help->admin_notes->viewAttributes() ?>>
<?php echo $int_fibre_help->admin_notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$int_fibre_help_list->ListOptions->render("body", "right", $int_fibre_help_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$int_fibre_help->isGridAdd())
		$int_fibre_help_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$int_fibre_help->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($int_fibre_help_list->Recordset)
	$int_fibre_help_list->Recordset->Close();
?>
<?php if (!$int_fibre_help->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$int_fibre_help->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($int_fibre_help_list->Pager)) $int_fibre_help_list->Pager = new PrevNextPager($int_fibre_help_list->StartRec, $int_fibre_help_list->DisplayRecs, $int_fibre_help_list->TotalRecs, $int_fibre_help_list->AutoHidePager) ?>
<?php if ($int_fibre_help_list->Pager->RecordCount > 0 && $int_fibre_help_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($int_fibre_help_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($int_fibre_help_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $int_fibre_help_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($int_fibre_help_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($int_fibre_help_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $int_fibre_help_list->pageUrl() ?>start=<?php echo $int_fibre_help_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($int_fibre_help_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $int_fibre_help_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($int_fibre_help_list->TotalRecs > 0 && (!$int_fibre_help_list->AutoHidePageSizeSelector || $int_fibre_help_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="int_fibre_help">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($int_fibre_help_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($int_fibre_help_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($int_fibre_help_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($int_fibre_help_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($int_fibre_help_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($int_fibre_help->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $int_fibre_help_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($int_fibre_help_list->TotalRecs == 0 && !$int_fibre_help->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $int_fibre_help_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$int_fibre_help_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$int_fibre_help->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$int_fibre_help->isExport()) { ?>
<script>
ew.scrollableTable("gmp_int_fibre_help", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$int_fibre_help_list->terminate();
?>