<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$int_portal_list_add = new int_portal_list_add();

// Run the page
$int_portal_list_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$int_portal_list_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fint_portal_listadd = currentForm = new ew.Form("fint_portal_listadd", "add");

// Validate form
fint_portal_listadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($int_portal_list_add->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_portal_list->url->caption(), $int_portal_list->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_portal_list_add->db->Required) { ?>
			elm = this.getElements("x" + infix + "_db");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_portal_list->db->caption(), $int_portal_list->db->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_portal_list_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_portal_list->category->caption(), $int_portal_list->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_portal_list_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_portal_list->status->caption(), $int_portal_list->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($int_portal_list->status->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fint_portal_listadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_portal_listadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_portal_listadd.lists["x_category"] = <?php echo $int_portal_list_add->category->Lookup->toClientList() ?>;
fint_portal_listadd.lists["x_category"].options = <?php echo JsonEncode($int_portal_list_add->category->lookupOptions()) ?>;
fint_portal_listadd.autoSuggests["x_category"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $int_portal_list_add->showPageHeader(); ?>
<?php
$int_portal_list_add->showMessage();
?>
<form name="fint_portal_listadd" id="fint_portal_listadd" class="<?php echo $int_portal_list_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($int_portal_list_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $int_portal_list_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="int_portal_list">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$int_portal_list_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($int_portal_list->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_int_portal_list_url" for="x_url" class="<?php echo $int_portal_list_add->LeftColumnClass ?>"><?php echo $int_portal_list->url->caption() ?><?php echo ($int_portal_list->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_portal_list_add->RightColumnClass ?>"><div<?php echo $int_portal_list->url->cellAttributes() ?>>
<span id="el_int_portal_list_url">
<input type="text" data-table="int_portal_list" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($int_portal_list->url->getPlaceHolder()) ?>" value="<?php echo $int_portal_list->url->EditValue ?>"<?php echo $int_portal_list->url->editAttributes() ?>>
</span>
<?php echo $int_portal_list->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_portal_list->db->Visible) { // db ?>
	<div id="r_db" class="form-group row">
		<label id="elh_int_portal_list_db" for="x_db" class="<?php echo $int_portal_list_add->LeftColumnClass ?>"><?php echo $int_portal_list->db->caption() ?><?php echo ($int_portal_list->db->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_portal_list_add->RightColumnClass ?>"><div<?php echo $int_portal_list->db->cellAttributes() ?>>
<span id="el_int_portal_list_db">
<input type="text" data-table="int_portal_list" data-field="x_db" name="x_db" id="x_db" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($int_portal_list->db->getPlaceHolder()) ?>" value="<?php echo $int_portal_list->db->EditValue ?>"<?php echo $int_portal_list->db->editAttributes() ?>>
</span>
<?php echo $int_portal_list->db->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_portal_list->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_int_portal_list_category" class="<?php echo $int_portal_list_add->LeftColumnClass ?>"><?php echo $int_portal_list->category->caption() ?><?php echo ($int_portal_list->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_portal_list_add->RightColumnClass ?>"><div<?php echo $int_portal_list->category->cellAttributes() ?>>
<span id="el_int_portal_list_category">
<?php
$wrkonchange = "" . trim(@$int_portal_list->category->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$int_portal_list->category->EditAttrs["onchange"] = "";
?>
<span id="as_x_category" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_category" id="sv_x_category" value="<?php echo RemoveHtml($int_portal_list->category->EditValue) ?>" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($int_portal_list->category->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($int_portal_list->category->getPlaceHolder()) ?>"<?php echo $int_portal_list->category->editAttributes() ?>>
</span>
<input type="hidden" data-table="int_portal_list" data-field="x_category" data-value-separator="<?php echo $int_portal_list->category->displayValueSeparatorAttribute() ?>" name="x_category" id="x_category" value="<?php echo HtmlEncode($int_portal_list->category->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fint_portal_listadd.createAutoSuggest({"id":"x_category","forceSelect":false});
</script>
<?php echo $int_portal_list->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $int_portal_list->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_portal_list->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_int_portal_list_status" for="x_status" class="<?php echo $int_portal_list_add->LeftColumnClass ?>"><?php echo $int_portal_list->status->caption() ?><?php echo ($int_portal_list->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_portal_list_add->RightColumnClass ?>"><div<?php echo $int_portal_list->status->cellAttributes() ?>>
<span id="el_int_portal_list_status">
<input type="text" data-table="int_portal_list" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($int_portal_list->status->getPlaceHolder()) ?>" value="<?php echo $int_portal_list->status->EditValue ?>"<?php echo $int_portal_list->status->editAttributes() ?>>
</span>
<?php echo $int_portal_list->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$int_portal_list_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $int_portal_list_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $int_portal_list_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$int_portal_list_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$int_portal_list_add->terminate();
?>