<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$int_portal_list_view = new int_portal_list_view();

// Run the page
$int_portal_list_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$int_portal_list_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$int_portal_list->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fint_portal_listview = currentForm = new ew.Form("fint_portal_listview", "view");

// Form_CustomValidate event
fint_portal_listview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_portal_listview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_portal_listview.lists["x_category"] = <?php echo $int_portal_list_view->category->Lookup->toClientList() ?>;
fint_portal_listview.lists["x_category"].options = <?php echo JsonEncode($int_portal_list_view->category->lookupOptions()) ?>;
fint_portal_listview.autoSuggests["x_category"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$int_portal_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $int_portal_list_view->ExportOptions->render("body") ?>
<?php $int_portal_list_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $int_portal_list_view->showPageHeader(); ?>
<?php
$int_portal_list_view->showMessage();
?>
<form name="fint_portal_listview" id="fint_portal_listview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($int_portal_list_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $int_portal_list_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="int_portal_list">
<input type="hidden" name="modal" value="<?php echo (int)$int_portal_list_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($int_portal_list->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $int_portal_list_view->TableLeftColumnClass ?>"><span id="elh_int_portal_list_id"><?php echo $int_portal_list->id->caption() ?></span></td>
		<td data-name="id"<?php echo $int_portal_list->id->cellAttributes() ?>>
<span id="el_int_portal_list_id">
<span<?php echo $int_portal_list->id->viewAttributes() ?>>
<?php echo $int_portal_list->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_portal_list->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $int_portal_list_view->TableLeftColumnClass ?>"><span id="elh_int_portal_list_url"><?php echo $int_portal_list->url->caption() ?></span></td>
		<td data-name="url"<?php echo $int_portal_list->url->cellAttributes() ?>>
<span id="el_int_portal_list_url">
<span<?php echo $int_portal_list->url->viewAttributes() ?>>
<?php echo $int_portal_list->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_portal_list->db->Visible) { // db ?>
	<tr id="r_db">
		<td class="<?php echo $int_portal_list_view->TableLeftColumnClass ?>"><span id="elh_int_portal_list_db"><?php echo $int_portal_list->db->caption() ?></span></td>
		<td data-name="db"<?php echo $int_portal_list->db->cellAttributes() ?>>
<span id="el_int_portal_list_db">
<span<?php echo $int_portal_list->db->viewAttributes() ?>>
<?php echo $int_portal_list->db->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_portal_list->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $int_portal_list_view->TableLeftColumnClass ?>"><span id="elh_int_portal_list_category"><?php echo $int_portal_list->category->caption() ?></span></td>
		<td data-name="category"<?php echo $int_portal_list->category->cellAttributes() ?>>
<span id="el_int_portal_list_category">
<span<?php echo $int_portal_list->category->viewAttributes() ?>>
<?php echo $int_portal_list->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_portal_list->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $int_portal_list_view->TableLeftColumnClass ?>"><span id="elh_int_portal_list_status"><?php echo $int_portal_list->status->caption() ?></span></td>
		<td data-name="status"<?php echo $int_portal_list->status->cellAttributes() ?>>
<span id="el_int_portal_list_status">
<span<?php echo $int_portal_list->status->viewAttributes() ?>>
<?php echo $int_portal_list->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$int_portal_list_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$int_portal_list->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$int_portal_list_view->terminate();
?>