<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$int_shop_add = new int_shop_add();

// Run the page
$int_shop_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$int_shop_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fint_shopadd = currentForm = new ew.Form("fint_shopadd", "add");

// Validate form
fint_shopadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($int_shop_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->category->caption(), $int_shop->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->short_description->Required) { ?>
			elm = this.getElements("x" + infix + "_short_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->short_description->caption(), $int_shop->short_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->includes->Required) { ?>
			elm = this.getElements("x" + infix + "_includes[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->includes->caption(), $int_shop->includes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->description->caption(), $int_shop->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->price->caption(), $int_shop->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($int_shop->price->errorMessage()) ?>");
		<?php if ($int_shop_add->discount_coupon->Required) { ?>
			elm = this.getElements("x" + infix + "_discount_coupon");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->discount_coupon->caption(), $int_shop->discount_coupon->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->discount->Required) { ?>
			elm = this.getElements("x" + infix + "_discount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->discount->caption(), $int_shop->discount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_discount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($int_shop->discount->errorMessage()) ?>");
		<?php if ($int_shop_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->amount->caption(), $int_shop->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($int_shop->amount->errorMessage()) ?>");
		<?php if ($int_shop_add->valid_till->Required) { ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->valid_till->caption(), $int_shop->valid_till->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($int_shop->valid_till->errorMessage()) ?>");
		<?php if ($int_shop_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->status->caption(), $int_shop->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($int_shop->status->errorMessage()) ?>");
		<?php if ($int_shop_add->_response->Required) { ?>
			elm = this.getElements("x" + infix + "__response");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->_response->caption(), $int_shop->_response->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__response");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($int_shop->_response->errorMessage()) ?>");
		<?php if ($int_shop_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->code->caption(), $int_shop->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->show_to->Required) { ?>
			elm = this.getElements("x" + infix + "_show_to[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->show_to->caption(), $int_shop->show_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->operator->caption(), $int_shop->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($int_shop_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $int_shop->datetime->caption(), $int_shop->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fint_shopadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_shopadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_shopadd.lists["x_category[]"] = <?php echo $int_shop_add->category->Lookup->toClientList() ?>;
fint_shopadd.lists["x_category[]"].options = <?php echo JsonEncode($int_shop_add->category->lookupOptions()) ?>;
fint_shopadd.lists["x_includes[]"] = <?php echo $int_shop_add->includes->Lookup->toClientList() ?>;
fint_shopadd.lists["x_includes[]"].options = <?php echo JsonEncode($int_shop_add->includes->lookupOptions()) ?>;
fint_shopadd.lists["x_show_to[]"] = <?php echo $int_shop_add->show_to->Lookup->toClientList() ?>;
fint_shopadd.lists["x_show_to[]"].options = <?php echo JsonEncode($int_shop_add->show_to->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $int_shop_add->showPageHeader(); ?>
<?php
$int_shop_add->showMessage();
?>
<form name="fint_shopadd" id="fint_shopadd" class="<?php echo $int_shop_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($int_shop_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $int_shop_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="int_shop">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$int_shop_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($int_shop->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_int_shop_category" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->category->caption() ?><?php echo ($int_shop->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->category->cellAttributes() ?>>
<span id="el_int_shop_category">
<div id="tp_x_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="int_shop" data-field="x_category" data-value-separator="<?php echo $int_shop->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="{value}"<?php echo $int_shop->category->editAttributes() ?>></div>
<div id="dsl_x_category" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $int_shop->category->checkBoxListHtml(FALSE, "x_category[]") ?>
</div></div>
<?php echo $int_shop->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $int_shop->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->short_description->Visible) { // short_description ?>
	<div id="r_short_description" class="form-group row">
		<label id="elh_int_shop_short_description" for="x_short_description" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->short_description->caption() ?><?php echo ($int_shop->short_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->short_description->cellAttributes() ?>>
<span id="el_int_shop_short_description">
<input type="text" data-table="int_shop" data-field="x_short_description" name="x_short_description" id="x_short_description" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($int_shop->short_description->getPlaceHolder()) ?>" value="<?php echo $int_shop->short_description->EditValue ?>"<?php echo $int_shop->short_description->editAttributes() ?>>
</span>
<?php echo $int_shop->short_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->includes->Visible) { // includes ?>
	<div id="r_includes" class="form-group row">
		<label id="elh_int_shop_includes" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->includes->caption() ?><?php echo ($int_shop->includes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->includes->cellAttributes() ?>>
<span id="el_int_shop_includes">
<div id="tp_x_includes" class="ew-template"><input type="checkbox" class="form-check-input" data-table="int_shop" data-field="x_includes" data-value-separator="<?php echo $int_shop->includes->displayValueSeparatorAttribute() ?>" name="x_includes[]" id="x_includes[]" value="{value}"<?php echo $int_shop->includes->editAttributes() ?>></div>
<div id="dsl_x_includes" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $int_shop->includes->checkBoxListHtml(FALSE, "x_includes[]") ?>
</div></div>
<?php echo $int_shop->includes->Lookup->getParamTag("p_x_includes") ?>
</span>
<?php echo $int_shop->includes->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_int_shop_description" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->description->caption() ?><?php echo ($int_shop->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->description->cellAttributes() ?>>
<span id="el_int_shop_description">
<?php AppendClass($int_shop->description->EditAttrs["class"], "editor"); ?>
<textarea data-table="int_shop" data-field="x_description" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($int_shop->description->getPlaceHolder()) ?>"<?php echo $int_shop->description->editAttributes() ?>><?php echo $int_shop->description->EditValue ?></textarea>
<script>
ew.createEditor("fint_shopadd", "x_description", 35, 4, <?php echo ($int_shop->description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $int_shop->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_int_shop_price" for="x_price" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->price->caption() ?><?php echo ($int_shop->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->price->cellAttributes() ?>>
<span id="el_int_shop_price">
<input type="text" data-table="int_shop" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($int_shop->price->getPlaceHolder()) ?>" value="<?php echo $int_shop->price->EditValue ?>"<?php echo $int_shop->price->editAttributes() ?>>
</span>
<?php echo $int_shop->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->discount_coupon->Visible) { // discount_coupon ?>
	<div id="r_discount_coupon" class="form-group row">
		<label id="elh_int_shop_discount_coupon" for="x_discount_coupon" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->discount_coupon->caption() ?><?php echo ($int_shop->discount_coupon->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->discount_coupon->cellAttributes() ?>>
<span id="el_int_shop_discount_coupon">
<input type="text" data-table="int_shop" data-field="x_discount_coupon" name="x_discount_coupon" id="x_discount_coupon" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($int_shop->discount_coupon->getPlaceHolder()) ?>" value="<?php echo $int_shop->discount_coupon->EditValue ?>"<?php echo $int_shop->discount_coupon->editAttributes() ?>>
</span>
<?php echo $int_shop->discount_coupon->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->discount->Visible) { // discount ?>
	<div id="r_discount" class="form-group row">
		<label id="elh_int_shop_discount" for="x_discount" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->discount->caption() ?><?php echo ($int_shop->discount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->discount->cellAttributes() ?>>
<span id="el_int_shop_discount">
<input type="text" data-table="int_shop" data-field="x_discount" name="x_discount" id="x_discount" size="30" placeholder="<?php echo HtmlEncode($int_shop->discount->getPlaceHolder()) ?>" value="<?php echo $int_shop->discount->EditValue ?>"<?php echo $int_shop->discount->editAttributes() ?>>
</span>
<?php echo $int_shop->discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_int_shop_amount" for="x_amount" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->amount->caption() ?><?php echo ($int_shop->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->amount->cellAttributes() ?>>
<span id="el_int_shop_amount">
<input type="text" data-table="int_shop" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($int_shop->amount->getPlaceHolder()) ?>" value="<?php echo $int_shop->amount->EditValue ?>"<?php echo $int_shop->amount->editAttributes() ?>>
</span>
<?php echo $int_shop->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->valid_till->Visible) { // valid_till ?>
	<div id="r_valid_till" class="form-group row">
		<label id="elh_int_shop_valid_till" for="x_valid_till" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->valid_till->caption() ?><?php echo ($int_shop->valid_till->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->valid_till->cellAttributes() ?>>
<span id="el_int_shop_valid_till">
<input type="text" data-table="int_shop" data-field="x_valid_till" data-format="7" name="x_valid_till" id="x_valid_till" placeholder="<?php echo HtmlEncode($int_shop->valid_till->getPlaceHolder()) ?>" value="<?php echo $int_shop->valid_till->EditValue ?>"<?php echo $int_shop->valid_till->editAttributes() ?>>
<?php if (!$int_shop->valid_till->ReadOnly && !$int_shop->valid_till->Disabled && !isset($int_shop->valid_till->EditAttrs["readonly"]) && !isset($int_shop->valid_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fint_shopadd", "x_valid_till", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $int_shop->valid_till->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_int_shop_status" for="x_status" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->status->caption() ?><?php echo ($int_shop->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->status->cellAttributes() ?>>
<span id="el_int_shop_status">
<input type="text" data-table="int_shop" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($int_shop->status->getPlaceHolder()) ?>" value="<?php echo $int_shop->status->EditValue ?>"<?php echo $int_shop->status->editAttributes() ?>>
</span>
<?php echo $int_shop->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->_response->Visible) { // response ?>
	<div id="r__response" class="form-group row">
		<label id="elh_int_shop__response" for="x__response" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->_response->caption() ?><?php echo ($int_shop->_response->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->_response->cellAttributes() ?>>
<span id="el_int_shop__response">
<input type="text" data-table="int_shop" data-field="x__response" name="x__response" id="x__response" size="30" placeholder="<?php echo HtmlEncode($int_shop->_response->getPlaceHolder()) ?>" value="<?php echo $int_shop->_response->EditValue ?>"<?php echo $int_shop->_response->editAttributes() ?>>
</span>
<?php echo $int_shop->_response->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_int_shop_code" for="x_code" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->code->caption() ?><?php echo ($int_shop->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->code->cellAttributes() ?>>
<span id="el_int_shop_code">
<textarea data-table="int_shop" data-field="x_code" name="x_code" id="x_code" cols="35" rows="4" placeholder="<?php echo HtmlEncode($int_shop->code->getPlaceHolder()) ?>"<?php echo $int_shop->code->editAttributes() ?>><?php echo $int_shop->code->EditValue ?></textarea>
</span>
<?php echo $int_shop->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($int_shop->show_to->Visible) { // show_to ?>
	<div id="r_show_to" class="form-group row">
		<label id="elh_int_shop_show_to" class="<?php echo $int_shop_add->LeftColumnClass ?>"><?php echo $int_shop->show_to->caption() ?><?php echo ($int_shop->show_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $int_shop_add->RightColumnClass ?>"><div<?php echo $int_shop->show_to->cellAttributes() ?>>
<span id="el_int_shop_show_to">
<div id="tp_x_show_to" class="ew-template"><input type="checkbox" class="form-check-input" data-table="int_shop" data-field="x_show_to" data-value-separator="<?php echo $int_shop->show_to->displayValueSeparatorAttribute() ?>" name="x_show_to[]" id="x_show_to[]" value="{value}"<?php echo $int_shop->show_to->editAttributes() ?>></div>
<div id="dsl_x_show_to" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $int_shop->show_to->checkBoxListHtml(FALSE, "x_show_to[]") ?>
</div></div>
<?php echo $int_shop->show_to->Lookup->getParamTag("p_x_show_to") ?>
</span>
<?php echo $int_shop->show_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$int_shop_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $int_shop_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $int_shop_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$int_shop_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$int_shop_add->terminate();
?>