<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$int_shop_list = new int_shop_list();

// Run the page
$int_shop_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$int_shop_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$int_shop->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fint_shoplist = currentForm = new ew.Form("fint_shoplist", "list");
fint_shoplist.formKeyCountName = '<?php echo $int_shop_list->FormKeyCountName ?>';

// Form_CustomValidate event
fint_shoplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_shoplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_shoplist.lists["x_category[]"] = <?php echo $int_shop_list->category->Lookup->toClientList() ?>;
fint_shoplist.lists["x_category[]"].options = <?php echo JsonEncode($int_shop_list->category->lookupOptions()) ?>;

// Form object for search
var fint_shoplistsrch = currentSearchForm = new ew.Form("fint_shoplistsrch");

// Validate function for search
fint_shoplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($int_shop->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fint_shoplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_shoplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fint_shoplistsrch.filterList = <?php echo $int_shop_list->getFilterList() ?>;

// Init search panel as collapsed
fint_shoplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$int_shop->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($int_shop_list->TotalRecs > 0 && $int_shop_list->ExportOptions->visible()) { ?>
<?php $int_shop_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($int_shop_list->ImportOptions->visible()) { ?>
<?php $int_shop_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($int_shop_list->SearchOptions->visible()) { ?>
<?php $int_shop_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($int_shop_list->FilterOptions->visible()) { ?>
<?php $int_shop_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$int_shop_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$int_shop->isExport() && !$int_shop->CurrentAction) { ?>
<form name="fint_shoplistsrch" id="fint_shoplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($int_shop_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fint_shoplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="int_shop">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$int_shop_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$int_shop->RowType = ROWTYPE_SEARCH;

// Render row
$int_shop->resetAttributes();
$int_shop_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($int_shop->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $int_shop->id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="int_shop" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($int_shop->id->getPlaceHolder()) ?>" value="<?php echo $int_shop->id->EditValue ?>"<?php echo $int_shop->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $int_shop_list->showPageHeader(); ?>
<?php
$int_shop_list->showMessage();
?>
<?php if ($int_shop_list->TotalRecs > 0 || $int_shop->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($int_shop_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> int_shop">
<?php if (!$int_shop->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$int_shop->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($int_shop_list->Pager)) $int_shop_list->Pager = new PrevNextPager($int_shop_list->StartRec, $int_shop_list->DisplayRecs, $int_shop_list->TotalRecs, $int_shop_list->AutoHidePager) ?>
<?php if ($int_shop_list->Pager->RecordCount > 0 && $int_shop_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($int_shop_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($int_shop_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $int_shop_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($int_shop_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($int_shop_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $int_shop_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($int_shop_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $int_shop_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $int_shop_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $int_shop_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($int_shop_list->TotalRecs > 0 && (!$int_shop_list->AutoHidePageSizeSelector || $int_shop_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="int_shop">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($int_shop_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($int_shop_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($int_shop_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($int_shop_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($int_shop_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($int_shop->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $int_shop_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fint_shoplist" id="fint_shoplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($int_shop_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $int_shop_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="int_shop">
<div id="gmp_int_shop" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($int_shop_list->TotalRecs > 0 || $int_shop->isGridEdit()) { ?>
<table id="tbl_int_shoplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$int_shop_list->RowType = ROWTYPE_HEADER;

// Render list options
$int_shop_list->renderListOptions();

// Render list options (header, left)
$int_shop_list->ListOptions->render("header", "left");
?>
<?php if ($int_shop->id->Visible) { // id ?>
	<?php if ($int_shop->sortUrl($int_shop->id) == "") { ?>
		<th data-name="id" class="<?php echo $int_shop->id->headerCellClass() ?>"><div id="elh_int_shop_id" class="int_shop_id"><div class="ew-table-header-caption"><?php echo $int_shop->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $int_shop->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->id) ?>',2);"><div id="elh_int_shop_id" class="int_shop_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->category->Visible) { // category ?>
	<?php if ($int_shop->sortUrl($int_shop->category) == "") { ?>
		<th data-name="category" class="<?php echo $int_shop->category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_category" class="int_shop_category"><div class="ew-table-header-caption"><?php echo $int_shop->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $int_shop->category->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->category) ?>',2);"><div id="elh_int_shop_category" class="int_shop_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->short_description->Visible) { // short_description ?>
	<?php if ($int_shop->sortUrl($int_shop->short_description) == "") { ?>
		<th data-name="short_description" class="<?php echo $int_shop->short_description->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_short_description" class="int_shop_short_description"><div class="ew-table-header-caption"><?php echo $int_shop->short_description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="short_description" class="<?php echo $int_shop->short_description->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->short_description) ?>',2);"><div id="elh_int_shop_short_description" class="int_shop_short_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->short_description->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->short_description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->short_description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->description->Visible) { // description ?>
	<?php if ($int_shop->sortUrl($int_shop->description) == "") { ?>
		<th data-name="description" class="<?php echo $int_shop->description->headerCellClass() ?>"><div id="elh_int_shop_description" class="int_shop_description"><div class="ew-table-header-caption"><?php echo $int_shop->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $int_shop->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->description) ?>',2);"><div id="elh_int_shop_description" class="int_shop_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->description->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->price->Visible) { // price ?>
	<?php if ($int_shop->sortUrl($int_shop->price) == "") { ?>
		<th data-name="price" class="<?php echo $int_shop->price->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_price" class="int_shop_price"><div class="ew-table-header-caption"><?php echo $int_shop->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $int_shop->price->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->price) ?>',2);"><div id="elh_int_shop_price" class="int_shop_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->discount_coupon->Visible) { // discount_coupon ?>
	<?php if ($int_shop->sortUrl($int_shop->discount_coupon) == "") { ?>
		<th data-name="discount_coupon" class="<?php echo $int_shop->discount_coupon->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_discount_coupon" class="int_shop_discount_coupon"><div class="ew-table-header-caption"><?php echo $int_shop->discount_coupon->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="discount_coupon" class="<?php echo $int_shop->discount_coupon->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->discount_coupon) ?>',2);"><div id="elh_int_shop_discount_coupon" class="int_shop_discount_coupon">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->discount_coupon->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->discount_coupon->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->discount_coupon->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->discount->Visible) { // discount ?>
	<?php if ($int_shop->sortUrl($int_shop->discount) == "") { ?>
		<th data-name="discount" class="<?php echo $int_shop->discount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_discount" class="int_shop_discount"><div class="ew-table-header-caption"><?php echo $int_shop->discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="discount" class="<?php echo $int_shop->discount->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->discount) ?>',2);"><div id="elh_int_shop_discount" class="int_shop_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->amount->Visible) { // amount ?>
	<?php if ($int_shop->sortUrl($int_shop->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $int_shop->amount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_amount" class="int_shop_amount"><div class="ew-table-header-caption"><?php echo $int_shop->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $int_shop->amount->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->amount) ?>',2);"><div id="elh_int_shop_amount" class="int_shop_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->valid_till->Visible) { // valid_till ?>
	<?php if ($int_shop->sortUrl($int_shop->valid_till) == "") { ?>
		<th data-name="valid_till" class="<?php echo $int_shop->valid_till->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_valid_till" class="int_shop_valid_till"><div class="ew-table-header-caption"><?php echo $int_shop->valid_till->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="valid_till" class="<?php echo $int_shop->valid_till->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->valid_till) ?>',2);"><div id="elh_int_shop_valid_till" class="int_shop_valid_till">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->valid_till->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->valid_till->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->valid_till->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->status->Visible) { // status ?>
	<?php if ($int_shop->sortUrl($int_shop->status) == "") { ?>
		<th data-name="status" class="<?php echo $int_shop->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_status" class="int_shop_status"><div class="ew-table-header-caption"><?php echo $int_shop->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $int_shop->status->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->status) ?>',2);"><div id="elh_int_shop_status" class="int_shop_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->operator->Visible) { // operator ?>
	<?php if ($int_shop->sortUrl($int_shop->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $int_shop->operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_operator" class="int_shop_operator"><div class="ew-table-header-caption"><?php echo $int_shop->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $int_shop->operator->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->operator) ?>',2);"><div id="elh_int_shop_operator" class="int_shop_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($int_shop->datetime->Visible) { // datetime ?>
	<?php if ($int_shop->sortUrl($int_shop->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $int_shop->datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_int_shop_datetime" class="int_shop_datetime"><div class="ew-table-header-caption"><?php echo $int_shop->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $int_shop->datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $int_shop->SortUrl($int_shop->datetime) ?>',2);"><div id="elh_int_shop_datetime" class="int_shop_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $int_shop->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($int_shop->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($int_shop->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$int_shop_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($int_shop->ExportAll && $int_shop->isExport()) {
	$int_shop_list->StopRec = $int_shop_list->TotalRecs;
} else {

	// Set the last record to display
	if ($int_shop_list->TotalRecs > $int_shop_list->StartRec + $int_shop_list->DisplayRecs - 1)
		$int_shop_list->StopRec = $int_shop_list->StartRec + $int_shop_list->DisplayRecs - 1;
	else
		$int_shop_list->StopRec = $int_shop_list->TotalRecs;
}
$int_shop_list->RecCnt = $int_shop_list->StartRec - 1;
if ($int_shop_list->Recordset && !$int_shop_list->Recordset->EOF) {
	$int_shop_list->Recordset->moveFirst();
	$selectLimit = $int_shop_list->UseSelectLimit;
	if (!$selectLimit && $int_shop_list->StartRec > 1)
		$int_shop_list->Recordset->move($int_shop_list->StartRec - 1);
} elseif (!$int_shop->AllowAddDeleteRow && $int_shop_list->StopRec == 0) {
	$int_shop_list->StopRec = $int_shop->GridAddRowCount;
}

// Initialize aggregate
$int_shop->RowType = ROWTYPE_AGGREGATEINIT;
$int_shop->resetAttributes();
$int_shop_list->renderRow();
while ($int_shop_list->RecCnt < $int_shop_list->StopRec) {
	$int_shop_list->RecCnt++;
	if ($int_shop_list->RecCnt >= $int_shop_list->StartRec) {
		$int_shop_list->RowCnt++;

		// Set up key count
		$int_shop_list->KeyCount = $int_shop_list->RowIndex;

		// Init row class and style
		$int_shop->resetAttributes();
		$int_shop->CssClass = "";
		if ($int_shop->isGridAdd()) {
		} else {
			$int_shop_list->loadRowValues($int_shop_list->Recordset); // Load row values
		}
		$int_shop->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$int_shop->RowAttrs = array_merge($int_shop->RowAttrs, array('data-rowindex'=>$int_shop_list->RowCnt, 'id'=>'r' . $int_shop_list->RowCnt . '_int_shop', 'data-rowtype'=>$int_shop->RowType));

		// Render row
		$int_shop_list->renderRow();

		// Render list options
		$int_shop_list->renderListOptions();
?>
	<tr<?php echo $int_shop->rowAttributes() ?>>
<?php

// Render list options (body, left)
$int_shop_list->ListOptions->render("body", "left", $int_shop_list->RowCnt);
?>
	<?php if ($int_shop->id->Visible) { // id ?>
		<td data-name="id"<?php echo $int_shop->id->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_id" class="int_shop_id">
<span<?php echo $int_shop->id->viewAttributes() ?>>
<?php echo $int_shop->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->category->Visible) { // category ?>
		<td data-name="category"<?php echo $int_shop->category->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_category" class="int_shop_category">
<span<?php echo $int_shop->category->viewAttributes() ?>>
<?php echo $int_shop->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->short_description->Visible) { // short_description ?>
		<td data-name="short_description"<?php echo $int_shop->short_description->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_short_description" class="int_shop_short_description">
<span<?php echo $int_shop->short_description->viewAttributes() ?>>
<?php echo $int_shop->short_description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->description->Visible) { // description ?>
		<td data-name="description"<?php echo $int_shop->description->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_description" class="int_shop_description">
<span<?php echo $int_shop->description->viewAttributes() ?>>
<?php echo $int_shop->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->price->Visible) { // price ?>
		<td data-name="price"<?php echo $int_shop->price->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_price" class="int_shop_price">
<span<?php echo $int_shop->price->viewAttributes() ?>>
<?php echo $int_shop->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->discount_coupon->Visible) { // discount_coupon ?>
		<td data-name="discount_coupon"<?php echo $int_shop->discount_coupon->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_discount_coupon" class="int_shop_discount_coupon">
<span<?php echo $int_shop->discount_coupon->viewAttributes() ?>>
<?php echo $int_shop->discount_coupon->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->discount->Visible) { // discount ?>
		<td data-name="discount"<?php echo $int_shop->discount->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_discount" class="int_shop_discount">
<span<?php echo $int_shop->discount->viewAttributes() ?>>
<?php echo $int_shop->discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $int_shop->amount->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_amount" class="int_shop_amount">
<span<?php echo $int_shop->amount->viewAttributes() ?>>
<?php echo $int_shop->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->valid_till->Visible) { // valid_till ?>
		<td data-name="valid_till"<?php echo $int_shop->valid_till->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_valid_till" class="int_shop_valid_till">
<span<?php echo $int_shop->valid_till->viewAttributes() ?>>
<?php echo $int_shop->valid_till->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->status->Visible) { // status ?>
		<td data-name="status"<?php echo $int_shop->status->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_status" class="int_shop_status">
<span<?php echo $int_shop->status->viewAttributes() ?>>
<?php echo $int_shop->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $int_shop->operator->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_operator" class="int_shop_operator">
<span<?php echo $int_shop->operator->viewAttributes() ?>>
<?php echo $int_shop->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($int_shop->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $int_shop->datetime->cellAttributes() ?>>
<span id="el<?php echo $int_shop_list->RowCnt ?>_int_shop_datetime" class="int_shop_datetime">
<span<?php echo $int_shop->datetime->viewAttributes() ?>>
<?php echo $int_shop->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$int_shop_list->ListOptions->render("body", "right", $int_shop_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$int_shop->isGridAdd())
		$int_shop_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$int_shop->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($int_shop_list->Recordset)
	$int_shop_list->Recordset->Close();
?>
<?php if (!$int_shop->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$int_shop->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($int_shop_list->Pager)) $int_shop_list->Pager = new PrevNextPager($int_shop_list->StartRec, $int_shop_list->DisplayRecs, $int_shop_list->TotalRecs, $int_shop_list->AutoHidePager) ?>
<?php if ($int_shop_list->Pager->RecordCount > 0 && $int_shop_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($int_shop_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($int_shop_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $int_shop_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($int_shop_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($int_shop_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $int_shop_list->pageUrl() ?>start=<?php echo $int_shop_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $int_shop_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($int_shop_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $int_shop_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $int_shop_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $int_shop_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($int_shop_list->TotalRecs > 0 && (!$int_shop_list->AutoHidePageSizeSelector || $int_shop_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="int_shop">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($int_shop_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($int_shop_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($int_shop_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($int_shop_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($int_shop_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($int_shop->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $int_shop_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($int_shop_list->TotalRecs == 0 && !$int_shop->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $int_shop_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$int_shop_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$int_shop->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$int_shop->isExport()) { ?>
<script>
ew.scrollableTable("gmp_int_shop", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$int_shop_list->terminate();
?>