<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$int_shop_view = new int_shop_view();

// Run the page
$int_shop_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$int_shop_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$int_shop->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fint_shopview = currentForm = new ew.Form("fint_shopview", "view");

// Form_CustomValidate event
fint_shopview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fint_shopview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fint_shopview.lists["x_includes[]"] = <?php echo $int_shop_view->includes->Lookup->toClientList() ?>;
fint_shopview.lists["x_includes[]"].options = <?php echo JsonEncode($int_shop_view->includes->lookupOptions()) ?>;
fint_shopview.lists["x_show_to[]"] = <?php echo $int_shop_view->show_to->Lookup->toClientList() ?>;
fint_shopview.lists["x_show_to[]"].options = <?php echo JsonEncode($int_shop_view->show_to->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$int_shop->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $int_shop_view->ExportOptions->render("body") ?>
<?php $int_shop_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $int_shop_view->showPageHeader(); ?>
<?php
$int_shop_view->showMessage();
?>
<form name="fint_shopview" id="fint_shopview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($int_shop_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $int_shop_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="int_shop">
<input type="hidden" name="modal" value="<?php echo (int)$int_shop_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($int_shop->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $int_shop_view->TableLeftColumnClass ?>"><span id="elh_int_shop_id"><?php echo $int_shop->id->caption() ?></span></td>
		<td data-name="id"<?php echo $int_shop->id->cellAttributes() ?>>
<span id="el_int_shop_id">
<span<?php echo $int_shop->id->viewAttributes() ?>>
<?php echo $int_shop->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_shop->includes->Visible) { // includes ?>
	<tr id="r_includes">
		<td class="<?php echo $int_shop_view->TableLeftColumnClass ?>"><span id="elh_int_shop_includes"><?php echo $int_shop->includes->caption() ?></span></td>
		<td data-name="includes"<?php echo $int_shop->includes->cellAttributes() ?>>
<span id="el_int_shop_includes">
<span<?php echo $int_shop->includes->viewAttributes() ?>>
<?php echo $int_shop->includes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_shop->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $int_shop_view->TableLeftColumnClass ?>"><span id="elh_int_shop_description"><?php echo $int_shop->description->caption() ?></span></td>
		<td data-name="description"<?php echo $int_shop->description->cellAttributes() ?>>
<span id="el_int_shop_description">
<span<?php echo $int_shop->description->viewAttributes() ?>>
<?php echo $int_shop->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_shop->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $int_shop_view->TableLeftColumnClass ?>"><span id="elh_int_shop_code"><?php echo $int_shop->code->caption() ?></span></td>
		<td data-name="code"<?php echo $int_shop->code->cellAttributes() ?>>
<span id="el_int_shop_code">
<span<?php echo $int_shop->code->viewAttributes() ?>>
<?php echo $int_shop->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($int_shop->show_to->Visible) { // show_to ?>
	<tr id="r_show_to">
		<td class="<?php echo $int_shop_view->TableLeftColumnClass ?>"><span id="elh_int_shop_show_to"><?php echo $int_shop->show_to->caption() ?></span></td>
		<td data-name="show_to"<?php echo $int_shop->show_to->cellAttributes() ?>>
<span id="el_int_shop_show_to">
<span<?php echo $int_shop->show_to->viewAttributes() ?>>
<?php echo $int_shop->show_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$int_shop_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$int_shop->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$int_shop_view->terminate();
?>