<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_info_add = new investor_info_add();

// Run the page
$investor_info_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_info_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var finvestor_infoadd = currentForm = new ew.Form("finvestor_infoadd", "add");

// Validate form
finvestor_infoadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($investor_info_add->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->aadhaar_no->caption(), $investor_info->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($investor_info->aadhaar_no->errorMessage()) ?>");
		<?php if ($investor_info_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->name->caption(), $investor_info->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->gender->caption(), $investor_info->gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->dob->caption(), $investor_info->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->mobile->caption(), $investor_info->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->_email->caption(), $investor_info->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->address->caption(), $investor_info->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->care_of->Required) { ?>
			elm = this.getElements("x" + infix + "_care_of");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->care_of->caption(), $investor_info->care_of->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->father_name->caption(), $investor_info->father_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->mother_name->Required) { ?>
			elm = this.getElements("x" + infix + "_mother_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->mother_name->caption(), $investor_info->mother_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->nominee_name->Required) { ?>
			elm = this.getElements("x" + infix + "_nominee_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->nominee_name->caption(), $investor_info->nominee_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->nominee_relation->Required) { ?>
			elm = this.getElements("x" + infix + "_nominee_relation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->nominee_relation->caption(), $investor_info->nominee_relation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->pan_no->caption(), $investor_info->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $investor_info->uploads->caption(), $investor_info->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->adviser->Required) { ?>
			elm = this.getElements("x" + infix + "_adviser");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->adviser->caption(), $investor_info->adviser->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->share_no->Required) { ?>
			elm = this.getElements("x" + infix + "_share_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->share_no->caption(), $investor_info->share_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->remarks->caption(), $investor_info->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->operator->caption(), $investor_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->datetime->caption(), $investor_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
finvestor_infoadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_infoadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_infoadd.lists["x_gender"] = <?php echo $investor_info_add->gender->Lookup->toClientList() ?>;
finvestor_infoadd.lists["x_gender"].options = <?php echo JsonEncode($investor_info_add->gender->options(FALSE, TRUE)) ?>;
finvestor_infoadd.lists["x_nominee_relation"] = <?php echo $investor_info_add->nominee_relation->Lookup->toClientList() ?>;
finvestor_infoadd.lists["x_nominee_relation"].options = <?php echo JsonEncode($investor_info_add->nominee_relation->options(FALSE, TRUE)) ?>;
finvestor_infoadd.lists["x_adviser"] = <?php echo $investor_info_add->adviser->Lookup->toClientList() ?>;
finvestor_infoadd.lists["x_adviser"].options = <?php echo JsonEncode($investor_info_add->adviser->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $investor_info_add->showPageHeader(); ?>
<?php
$investor_info_add->showMessage();
?>
<form name="finvestor_infoadd" id="finvestor_infoadd" class="<?php echo $investor_info_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_info_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_info_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$investor_info_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($investor_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label id="elh_investor_info_aadhaar_no" for="x_aadhaar_no" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->aadhaar_no->caption() ?><?php echo ($investor_info->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->aadhaar_no->cellAttributes() ?>>
<span id="el_investor_info_aadhaar_no">
<input type="text" data-table="investor_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($investor_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $investor_info->aadhaar_no->EditValue ?>"<?php echo $investor_info->aadhaar_no->editAttributes() ?>>
</span>
<?php echo $investor_info->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_investor_info_name" for="x_name" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->name->caption() ?><?php echo ($investor_info->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->name->cellAttributes() ?>>
<span id="el_investor_info_name">
<input type="text" data-table="investor_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->name->getPlaceHolder()) ?>" value="<?php echo $investor_info->name->EditValue ?>"<?php echo $investor_info->name->editAttributes() ?>>
</span>
<?php echo $investor_info->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label id="elh_investor_info_gender" for="x_gender" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->gender->caption() ?><?php echo ($investor_info->gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->gender->cellAttributes() ?>>
<span id="el_investor_info_gender">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_gender" data-value-separator="<?php echo $investor_info->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $investor_info->gender->editAttributes() ?>>
		<?php echo $investor_info->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
</span>
<?php echo $investor_info->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label id="elh_investor_info_dob" for="x_dob" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->dob->caption() ?><?php echo ($investor_info->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->dob->cellAttributes() ?>>
<span id="el_investor_info_dob">
<input type="text" data-table="investor_info" data-field="x_dob" data-format="7" name="x_dob" id="x_dob" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->dob->getPlaceHolder()) ?>" value="<?php echo $investor_info->dob->EditValue ?>"<?php echo $investor_info->dob->editAttributes() ?>>
<?php if (!$investor_info->dob->ReadOnly && !$investor_info->dob->Disabled && !isset($investor_info->dob->EditAttrs["readonly"]) && !isset($investor_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infoadd", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $investor_info->dob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_investor_info_mobile" for="x_mobile" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->mobile->caption() ?><?php echo ($investor_info->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->mobile->cellAttributes() ?>>
<span id="el_investor_info_mobile">
<input type="text" data-table="investor_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($investor_info->mobile->getPlaceHolder()) ?>" value="<?php echo $investor_info->mobile->EditValue ?>"<?php echo $investor_info->mobile->editAttributes() ?>>
</span>
<?php echo $investor_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_investor_info__email" for="x__email" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->_email->caption() ?><?php echo ($investor_info->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->_email->cellAttributes() ?>>
<span id="el_investor_info__email">
<input type="text" data-table="investor_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->_email->getPlaceHolder()) ?>" value="<?php echo $investor_info->_email->EditValue ?>"<?php echo $investor_info->_email->editAttributes() ?>>
</span>
<?php echo $investor_info->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_investor_info_address" for="x_address" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->address->caption() ?><?php echo ($investor_info->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->address->cellAttributes() ?>>
<span id="el_investor_info_address">
<input type="text" data-table="investor_info" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="252" placeholder="<?php echo HtmlEncode($investor_info->address->getPlaceHolder()) ?>" value="<?php echo $investor_info->address->EditValue ?>"<?php echo $investor_info->address->editAttributes() ?>>
</span>
<?php echo $investor_info->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->care_of->Visible) { // care_of ?>
	<div id="r_care_of" class="form-group row">
		<label id="elh_investor_info_care_of" for="x_care_of" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->care_of->caption() ?><?php echo ($investor_info->care_of->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->care_of->cellAttributes() ?>>
<span id="el_investor_info_care_of">
<input type="text" data-table="investor_info" data-field="x_care_of" name="x_care_of" id="x_care_of" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->care_of->getPlaceHolder()) ?>" value="<?php echo $investor_info->care_of->EditValue ?>"<?php echo $investor_info->care_of->editAttributes() ?>>
</span>
<?php echo $investor_info->care_of->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label id="elh_investor_info_father_name" for="x_father_name" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->father_name->caption() ?><?php echo ($investor_info->father_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->father_name->cellAttributes() ?>>
<span id="el_investor_info_father_name">
<input type="text" data-table="investor_info" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->father_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->father_name->EditValue ?>"<?php echo $investor_info->father_name->editAttributes() ?>>
</span>
<?php echo $investor_info->father_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->mother_name->Visible) { // mother_name ?>
	<div id="r_mother_name" class="form-group row">
		<label id="elh_investor_info_mother_name" for="x_mother_name" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->mother_name->caption() ?><?php echo ($investor_info->mother_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->mother_name->cellAttributes() ?>>
<span id="el_investor_info_mother_name">
<input type="text" data-table="investor_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->mother_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->mother_name->EditValue ?>"<?php echo $investor_info->mother_name->editAttributes() ?>>
</span>
<?php echo $investor_info->mother_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->nominee_name->Visible) { // nominee_name ?>
	<div id="r_nominee_name" class="form-group row">
		<label id="elh_investor_info_nominee_name" for="x_nominee_name" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->nominee_name->caption() ?><?php echo ($investor_info->nominee_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->nominee_name->cellAttributes() ?>>
<span id="el_investor_info_nominee_name">
<input type="text" data-table="investor_info" data-field="x_nominee_name" name="x_nominee_name" id="x_nominee_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->nominee_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->nominee_name->EditValue ?>"<?php echo $investor_info->nominee_name->editAttributes() ?>>
</span>
<?php echo $investor_info->nominee_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->nominee_relation->Visible) { // nominee_relation ?>
	<div id="r_nominee_relation" class="form-group row">
		<label id="elh_investor_info_nominee_relation" for="x_nominee_relation" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->nominee_relation->caption() ?><?php echo ($investor_info->nominee_relation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->nominee_relation->cellAttributes() ?>>
<span id="el_investor_info_nominee_relation">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_nominee_relation" data-value-separator="<?php echo $investor_info->nominee_relation->displayValueSeparatorAttribute() ?>" id="x_nominee_relation" name="x_nominee_relation"<?php echo $investor_info->nominee_relation->editAttributes() ?>>
		<?php echo $investor_info->nominee_relation->selectOptionListHtml("x_nominee_relation") ?>
	</select>
</div>
</span>
<?php echo $investor_info->nominee_relation->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label id="elh_investor_info_pan_no" for="x_pan_no" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->pan_no->caption() ?><?php echo ($investor_info->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->pan_no->cellAttributes() ?>>
<span id="el_investor_info_pan_no">
<input type="text" data-table="investor_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($investor_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $investor_info->pan_no->EditValue ?>"<?php echo $investor_info->pan_no->editAttributes() ?>>
</span>
<?php echo $investor_info->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_investor_info_uploads" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->uploads->caption() ?><?php echo ($investor_info->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->uploads->cellAttributes() ?>>
<span id="el_investor_info_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $investor_info->uploads->title() ? $investor_info->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($investor_info->uploads->ReadOnly || $investor_info->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="investor_info" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $investor_info->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $investor_info->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="500">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $investor_info->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $investor_info->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $investor_info->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $investor_info->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->adviser->Visible) { // adviser ?>
	<div id="r_adviser" class="form-group row">
		<label id="elh_investor_info_adviser" for="x_adviser" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->adviser->caption() ?><?php echo ($investor_info->adviser->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->adviser->cellAttributes() ?>>
<span id="el_investor_info_adviser">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_adviser" data-value-separator="<?php echo $investor_info->adviser->displayValueSeparatorAttribute() ?>" id="x_adviser" name="x_adviser"<?php echo $investor_info->adviser->editAttributes() ?>>
		<?php echo $investor_info->adviser->selectOptionListHtml("x_adviser") ?>
	</select>
</div>
<?php echo $investor_info->adviser->Lookup->getParamTag("p_x_adviser") ?>
</span>
<?php echo $investor_info->adviser->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->share_no->Visible) { // share_no ?>
	<div id="r_share_no" class="form-group row">
		<label id="elh_investor_info_share_no" for="x_share_no" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->share_no->caption() ?><?php echo ($investor_info->share_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->share_no->cellAttributes() ?>>
<span id="el_investor_info_share_no">
<textarea data-table="investor_info" data-field="x_share_no" name="x_share_no" id="x_share_no" cols="30" rows="2" placeholder="<?php echo HtmlEncode($investor_info->share_no->getPlaceHolder()) ?>"<?php echo $investor_info->share_no->editAttributes() ?>><?php echo $investor_info->share_no->EditValue ?></textarea>
</span>
<?php echo $investor_info->share_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_investor_info_remarks" for="x_remarks" class="<?php echo $investor_info_add->LeftColumnClass ?>"><?php echo $investor_info->remarks->caption() ?><?php echo ($investor_info->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_add->RightColumnClass ?>"><div<?php echo $investor_info->remarks->cellAttributes() ?>>
<span id="el_investor_info_remarks">
<input type="text" data-table="investor_info" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($investor_info->remarks->getPlaceHolder()) ?>" value="<?php echo $investor_info->remarks->EditValue ?>"<?php echo $investor_info->remarks->editAttributes() ?>>
</span>
<?php echo $investor_info->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$investor_info_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $investor_info_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $investor_info_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$investor_info_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$('#x_aadhaar_no').attr('type', 'number');
$('#x_mobile').attr('type', 'number');
$("#el_investor_info_aadhaar_no").append('<div class="input-group-append" ><h6 style="color:blue" onclick="javascript:checkaadhaar()"><i class="fa fa-check"></i> Verify Aadhaar</h6></div>');

function checkaadhaar()
{
	var aadhaar = $("#x_aadhaar_no").val();
	if (aadhaar.length != 12)
	{
		alert('Enter Correct Aadhaar No.')
	}
	else
	{
		$.getJSON('apcajax_2.php?maadhaar='+aadhaar,function(data)
		{
			if (data == 0)
			{
				$.getJSON('apcajaxes.php?maadhaarotp='+aadhaar,function(data1)
				{
					const arrayotp = JSON.parse(data1);
					var clientId = arrayotp.result.data.client_id ? arrayotp.result.data.client_id : '';
					Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h1 class="modal-title">Enter OTP</h1><button type="button" class="close" data-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body"><label for="otp">Please enter the OTP (One-Time Password) <br>received for Aadhaar verification on your registered mobile number.</label><br><br><input type="text" id="otp" name="otp" required autofocus><input type="hidden" id="cid" name="cid" value="'+clientId+'"><input type="hidden" id="aadh" name="aadh" value="'+aadhaar+'"><br></div><div class="modal-footer"><input type="button" id="sbtn" class="btn btn-primary" value="SUBMIT" onclick="SUBMITModal()"><button id="cbtn" type="button" class="btn btn-danger" onclick="CLOSEModal()">Close</button></div></div></div>';
					$("body").prepend(Obj);
					$("#myModal").modal("show");
				})
			}
			else
			{
			Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h1 class="modal-title">New Request</h1><button type="button" class="close" data-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body"><h5>An Aadhaar number already exists for the provided Aadhaar No. on ID# '+data+'</h5></div><div class="modal-footer"><a href="investor_infoedit.php?id='+data+'" target="_self" class="btn btn-primary">Access the previous ID</a><button type="button" class="btn btn-danger" data-dismiss="modal">Close</button></div></div></div>';
			$("body").prepend(Obj);
			$("#myModal").modal("show")

			//new Audio('beep.mp3').play(); // define your audio	
			}				
		});
	}
}

function SUBMITModal()
{
	var otp = $("#otp").val();
	var cid = $("#cid").val();			
	$.getJSON('apcajaxes.php?getaadhaardatabyotp='+otp+'&cid='+cid);
	$("#sbtn").hide();
	setTimeout($("#cbtn").click(), 1000); 
}

function CLOSEModal()
{
	var aadhaar = $("#aadh").val();			
	$.getJSON('apcajax_2.php?maadhaar='+aadhaar, function(data2)
	{
	$("#myModal").modal("hide");
	setTimeout(location.href = "investor_infoedit.php?id="+data2, 1000);
	})
}
</script>
<?php include_once "footer.php" ?>
<?php
$investor_info_add->terminate();
?>