<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_info_edit = new investor_info_edit();

// Run the page
$investor_info_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_info_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var finvestor_infoedit = currentForm = new ew.Form("finvestor_infoedit", "edit");

// Validate form
finvestor_infoedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($investor_info_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->id->caption(), $investor_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->aadhaar_no->caption(), $investor_info->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($investor_info->aadhaar_no->errorMessage()) ?>");
		<?php if ($investor_info_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->name->caption(), $investor_info->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->gender->caption(), $investor_info->gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->dob->caption(), $investor_info->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->mobile->caption(), $investor_info->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->_email->caption(), $investor_info->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->address->caption(), $investor_info->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->care_of->Required) { ?>
			elm = this.getElements("x" + infix + "_care_of");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->care_of->caption(), $investor_info->care_of->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->father_name->caption(), $investor_info->father_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->mother_name->Required) { ?>
			elm = this.getElements("x" + infix + "_mother_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->mother_name->caption(), $investor_info->mother_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->nominee_name->Required) { ?>
			elm = this.getElements("x" + infix + "_nominee_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->nominee_name->caption(), $investor_info->nominee_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->nominee_relation->Required) { ?>
			elm = this.getElements("x" + infix + "_nominee_relation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->nominee_relation->caption(), $investor_info->nominee_relation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->pan_no->caption(), $investor_info->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $investor_info->uploads->caption(), $investor_info->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $investor_info->image->caption(), $investor_info->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->adviser->Required) { ?>
			elm = this.getElements("x" + infix + "_adviser");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->adviser->caption(), $investor_info->adviser->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->share_no->Required) { ?>
			elm = this.getElements("x" + infix + "_share_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->share_no->caption(), $investor_info->share_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->remarks->caption(), $investor_info->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->operator->caption(), $investor_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->datetime->caption(), $investor_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->pan_response->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_response");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->pan_response->caption(), $investor_info->pan_response->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_info_edit->aadhaar_response->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_response");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_info->aadhaar_response->caption(), $investor_info->aadhaar_response->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
finvestor_infoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_infoedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_infoedit.lists["x_gender"] = <?php echo $investor_info_edit->gender->Lookup->toClientList() ?>;
finvestor_infoedit.lists["x_gender"].options = <?php echo JsonEncode($investor_info_edit->gender->options(FALSE, TRUE)) ?>;
finvestor_infoedit.lists["x_nominee_relation"] = <?php echo $investor_info_edit->nominee_relation->Lookup->toClientList() ?>;
finvestor_infoedit.lists["x_nominee_relation"].options = <?php echo JsonEncode($investor_info_edit->nominee_relation->options(FALSE, TRUE)) ?>;
finvestor_infoedit.lists["x_adviser"] = <?php echo $investor_info_edit->adviser->Lookup->toClientList() ?>;
finvestor_infoedit.lists["x_adviser"].options = <?php echo JsonEncode($investor_info_edit->adviser->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $investor_info_edit->showPageHeader(); ?>
<?php
$investor_info_edit->showMessage();
?>
<form name="finvestor_infoedit" id="finvestor_infoedit" class="<?php echo $investor_info_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_info_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_info_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$investor_info_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($investor_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_investor_info_id" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->id->caption() ?><?php echo ($investor_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->id->cellAttributes() ?>>
<span id="el_investor_info_id">
<span<?php echo $investor_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($investor_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="investor_info" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($investor_info->id->CurrentValue) ?>">
<?php echo $investor_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label id="elh_investor_info_aadhaar_no" for="x_aadhaar_no" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->aadhaar_no->caption() ?><?php echo ($investor_info->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->aadhaar_no->cellAttributes() ?>>
<span id="el_investor_info_aadhaar_no">
<input type="text" data-table="investor_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($investor_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $investor_info->aadhaar_no->EditValue ?>"<?php echo $investor_info->aadhaar_no->editAttributes() ?>>
</span>
<?php echo $investor_info->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_investor_info_name" for="x_name" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->name->caption() ?><?php echo ($investor_info->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->name->cellAttributes() ?>>
<span id="el_investor_info_name">
<input type="text" data-table="investor_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->name->getPlaceHolder()) ?>" value="<?php echo $investor_info->name->EditValue ?>"<?php echo $investor_info->name->editAttributes() ?>>
</span>
<?php echo $investor_info->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label id="elh_investor_info_gender" for="x_gender" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->gender->caption() ?><?php echo ($investor_info->gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->gender->cellAttributes() ?>>
<span id="el_investor_info_gender">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_gender" data-value-separator="<?php echo $investor_info->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $investor_info->gender->editAttributes() ?>>
		<?php echo $investor_info->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
</span>
<?php echo $investor_info->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label id="elh_investor_info_dob" for="x_dob" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->dob->caption() ?><?php echo ($investor_info->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->dob->cellAttributes() ?>>
<span id="el_investor_info_dob">
<input type="text" data-table="investor_info" data-field="x_dob" data-format="7" name="x_dob" id="x_dob" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->dob->getPlaceHolder()) ?>" value="<?php echo $investor_info->dob->EditValue ?>"<?php echo $investor_info->dob->editAttributes() ?>>
<?php if (!$investor_info->dob->ReadOnly && !$investor_info->dob->Disabled && !isset($investor_info->dob->EditAttrs["readonly"]) && !isset($investor_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infoedit", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $investor_info->dob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_investor_info_mobile" for="x_mobile" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->mobile->caption() ?><?php echo ($investor_info->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->mobile->cellAttributes() ?>>
<span id="el_investor_info_mobile">
<input type="text" data-table="investor_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($investor_info->mobile->getPlaceHolder()) ?>" value="<?php echo $investor_info->mobile->EditValue ?>"<?php echo $investor_info->mobile->editAttributes() ?>>
</span>
<?php echo $investor_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_investor_info__email" for="x__email" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->_email->caption() ?><?php echo ($investor_info->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->_email->cellAttributes() ?>>
<span id="el_investor_info__email">
<input type="text" data-table="investor_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->_email->getPlaceHolder()) ?>" value="<?php echo $investor_info->_email->EditValue ?>"<?php echo $investor_info->_email->editAttributes() ?>>
</span>
<?php echo $investor_info->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_investor_info_address" for="x_address" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->address->caption() ?><?php echo ($investor_info->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->address->cellAttributes() ?>>
<span id="el_investor_info_address">
<input type="text" data-table="investor_info" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="252" placeholder="<?php echo HtmlEncode($investor_info->address->getPlaceHolder()) ?>" value="<?php echo $investor_info->address->EditValue ?>"<?php echo $investor_info->address->editAttributes() ?>>
</span>
<?php echo $investor_info->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->care_of->Visible) { // care_of ?>
	<div id="r_care_of" class="form-group row">
		<label id="elh_investor_info_care_of" for="x_care_of" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->care_of->caption() ?><?php echo ($investor_info->care_of->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->care_of->cellAttributes() ?>>
<span id="el_investor_info_care_of">
<input type="text" data-table="investor_info" data-field="x_care_of" name="x_care_of" id="x_care_of" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->care_of->getPlaceHolder()) ?>" value="<?php echo $investor_info->care_of->EditValue ?>"<?php echo $investor_info->care_of->editAttributes() ?>>
</span>
<?php echo $investor_info->care_of->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label id="elh_investor_info_father_name" for="x_father_name" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->father_name->caption() ?><?php echo ($investor_info->father_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->father_name->cellAttributes() ?>>
<span id="el_investor_info_father_name">
<input type="text" data-table="investor_info" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->father_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->father_name->EditValue ?>"<?php echo $investor_info->father_name->editAttributes() ?>>
</span>
<?php echo $investor_info->father_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->mother_name->Visible) { // mother_name ?>
	<div id="r_mother_name" class="form-group row">
		<label id="elh_investor_info_mother_name" for="x_mother_name" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->mother_name->caption() ?><?php echo ($investor_info->mother_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->mother_name->cellAttributes() ?>>
<span id="el_investor_info_mother_name">
<input type="text" data-table="investor_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->mother_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->mother_name->EditValue ?>"<?php echo $investor_info->mother_name->editAttributes() ?>>
</span>
<?php echo $investor_info->mother_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->nominee_name->Visible) { // nominee_name ?>
	<div id="r_nominee_name" class="form-group row">
		<label id="elh_investor_info_nominee_name" for="x_nominee_name" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->nominee_name->caption() ?><?php echo ($investor_info->nominee_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->nominee_name->cellAttributes() ?>>
<span id="el_investor_info_nominee_name">
<input type="text" data-table="investor_info" data-field="x_nominee_name" name="x_nominee_name" id="x_nominee_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->nominee_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->nominee_name->EditValue ?>"<?php echo $investor_info->nominee_name->editAttributes() ?>>
</span>
<?php echo $investor_info->nominee_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->nominee_relation->Visible) { // nominee_relation ?>
	<div id="r_nominee_relation" class="form-group row">
		<label id="elh_investor_info_nominee_relation" for="x_nominee_relation" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->nominee_relation->caption() ?><?php echo ($investor_info->nominee_relation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->nominee_relation->cellAttributes() ?>>
<span id="el_investor_info_nominee_relation">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_nominee_relation" data-value-separator="<?php echo $investor_info->nominee_relation->displayValueSeparatorAttribute() ?>" id="x_nominee_relation" name="x_nominee_relation"<?php echo $investor_info->nominee_relation->editAttributes() ?>>
		<?php echo $investor_info->nominee_relation->selectOptionListHtml("x_nominee_relation") ?>
	</select>
</div>
</span>
<?php echo $investor_info->nominee_relation->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label id="elh_investor_info_pan_no" for="x_pan_no" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->pan_no->caption() ?><?php echo ($investor_info->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->pan_no->cellAttributes() ?>>
<span id="el_investor_info_pan_no">
<input type="text" data-table="investor_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($investor_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $investor_info->pan_no->EditValue ?>"<?php echo $investor_info->pan_no->editAttributes() ?>>
</span>
<?php echo $investor_info->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_investor_info_uploads" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->uploads->caption() ?><?php echo ($investor_info->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->uploads->cellAttributes() ?>>
<span id="el_investor_info_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $investor_info->uploads->title() ? $investor_info->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($investor_info->uploads->ReadOnly || $investor_info->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="investor_info" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $investor_info->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $investor_info->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="500">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $investor_info->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $investor_info->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $investor_info->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $investor_info->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_investor_info_image" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->image->caption() ?><?php echo ($investor_info->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->image->cellAttributes() ?>>
<span id="el_investor_info_image">
<div id="fd_x_image">
<span title="<?php echo $investor_info->image->title() ? $investor_info->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($investor_info->image->ReadOnly || $investor_info->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="investor_info" data-field="x_image" name="x_image" id="x_image"<?php echo $investor_info->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $investor_info->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="16777215">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $investor_info->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $investor_info->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $investor_info->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->adviser->Visible) { // adviser ?>
	<div id="r_adviser" class="form-group row">
		<label id="elh_investor_info_adviser" for="x_adviser" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->adviser->caption() ?><?php echo ($investor_info->adviser->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->adviser->cellAttributes() ?>>
<span id="el_investor_info_adviser">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_adviser" data-value-separator="<?php echo $investor_info->adviser->displayValueSeparatorAttribute() ?>" id="x_adviser" name="x_adviser"<?php echo $investor_info->adviser->editAttributes() ?>>
		<?php echo $investor_info->adviser->selectOptionListHtml("x_adviser") ?>
	</select>
</div>
<?php echo $investor_info->adviser->Lookup->getParamTag("p_x_adviser") ?>
</span>
<?php echo $investor_info->adviser->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->share_no->Visible) { // share_no ?>
	<div id="r_share_no" class="form-group row">
		<label id="elh_investor_info_share_no" for="x_share_no" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->share_no->caption() ?><?php echo ($investor_info->share_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->share_no->cellAttributes() ?>>
<span id="el_investor_info_share_no">
<textarea data-table="investor_info" data-field="x_share_no" name="x_share_no" id="x_share_no" cols="30" rows="2" placeholder="<?php echo HtmlEncode($investor_info->share_no->getPlaceHolder()) ?>"<?php echo $investor_info->share_no->editAttributes() ?>><?php echo $investor_info->share_no->EditValue ?></textarea>
</span>
<?php echo $investor_info->share_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_investor_info_remarks" for="x_remarks" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->remarks->caption() ?><?php echo ($investor_info->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->remarks->cellAttributes() ?>>
<span id="el_investor_info_remarks">
<input type="text" data-table="investor_info" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($investor_info->remarks->getPlaceHolder()) ?>" value="<?php echo $investor_info->remarks->EditValue ?>"<?php echo $investor_info->remarks->editAttributes() ?>>
</span>
<?php echo $investor_info->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->pan_response->Visible) { // pan_response ?>
	<div id="r_pan_response" class="form-group row">
		<label id="elh_investor_info_pan_response" for="x_pan_response" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->pan_response->caption() ?><?php echo ($investor_info->pan_response->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->pan_response->cellAttributes() ?>>
<span id="el_investor_info_pan_response">
<span<?php echo $investor_info->pan_response->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($investor_info->pan_response->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="investor_info" data-field="x_pan_response" name="x_pan_response" id="x_pan_response" value="<?php echo HtmlEncode($investor_info->pan_response->CurrentValue) ?>">
<?php echo $investor_info->pan_response->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_info->aadhaar_response->Visible) { // aadhaar_response ?>
	<div id="r_aadhaar_response" class="form-group row">
		<label id="elh_investor_info_aadhaar_response" for="x_aadhaar_response" class="<?php echo $investor_info_edit->LeftColumnClass ?>"><?php echo $investor_info->aadhaar_response->caption() ?><?php echo ($investor_info->aadhaar_response->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_info_edit->RightColumnClass ?>"><div<?php echo $investor_info->aadhaar_response->cellAttributes() ?>>
<span id="el_investor_info_aadhaar_response">
<span<?php echo $investor_info->aadhaar_response->viewAttributes() ?>>
<?php echo $investor_info->aadhaar_response->EditValue ?></span>
</span>
<input type="hidden" data-table="investor_info" data-field="x_aadhaar_response" name="x_aadhaar_response" id="x_aadhaar_response" value="<?php echo HtmlEncode($investor_info->aadhaar_response->CurrentValue) ?>">
<?php echo $investor_info->aadhaar_response->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$investor_info_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $investor_info_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $investor_info_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$investor_info_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

var panresponse = $("#x_pan_response").val();
if (panresponse.length < 4)
{
$("#el_investor_info_pan_no").append('<div class="input-group-append" ><h6 style="color:blue" onclick="javascript:checkpan()"><i class="fa fa-check"></i> Verify PAN No.</h6></div>');
}

function checkpan()
{
	var ID = $("#x_id").val();
	var name = $("#x_name").val();
	var pan = $("#x_pan_no").val();
	$.getJSON('apcajaxes.php?cpan='+pan,function(data)
	{
		if (data == 0)
		{
			alert('Enter Correct PAN No.');
		}
		else
		{
			if (name.toUpperCase() === data.result.result.name.toUpperCase())
			{
				$.getJSON('apcajaxes.php?id='+ID+'&panresponse='+data.result.result.panStatus+'&pan='+pan);
				$("#x_pan_no").attr('readonly','readonly'); 		
				$("#el_investor_info_pan_response").val(data.result.result.panStatus); 					}
				$("#x_pan_response").val(data.result.result.panStatus);
			}
		$("#error").remove();
		$('#r_pan_no').append('<span style="color:green" id="error">'+data.result.result.name+'<br>'+data.result.result.panStatus+'<br>AadhaarPan Link: '+data.result.result.aadhaarSeedingStatus+'</span>')
	})
}
</script>
<?php include_once "footer.php" ?>
<?php
$investor_info_edit->terminate();
?>