<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_info_list = new investor_info_list();

// Run the page
$investor_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$investor_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var finvestor_infolist = currentForm = new ew.Form("finvestor_infolist", "list");
finvestor_infolist.formKeyCountName = '<?php echo $investor_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
finvestor_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_infolist.lists["x_gender"] = <?php echo $investor_info_list->gender->Lookup->toClientList() ?>;
finvestor_infolist.lists["x_gender"].options = <?php echo JsonEncode($investor_info_list->gender->options(FALSE, TRUE)) ?>;
finvestor_infolist.lists["x_nominee_relation"] = <?php echo $investor_info_list->nominee_relation->Lookup->toClientList() ?>;
finvestor_infolist.lists["x_nominee_relation"].options = <?php echo JsonEncode($investor_info_list->nominee_relation->options(FALSE, TRUE)) ?>;
finvestor_infolist.lists["x_adviser"] = <?php echo $investor_info_list->adviser->Lookup->toClientList() ?>;
finvestor_infolist.lists["x_adviser"].options = <?php echo JsonEncode($investor_info_list->adviser->lookupOptions()) ?>;

// Form object for search
var finvestor_infolistsrch = currentSearchForm = new ew.Form("finvestor_infolistsrch");

// Filters
finvestor_infolistsrch.filterList = <?php echo $investor_info_list->getFilterList() ?>;

// Init search panel as collapsed
finvestor_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$investor_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($investor_info_list->TotalRecs > 0 && $investor_info_list->ExportOptions->visible()) { ?>
<?php $investor_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($investor_info_list->ImportOptions->visible()) { ?>
<?php $investor_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($investor_info_list->SearchOptions->visible()) { ?>
<?php $investor_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($investor_info_list->FilterOptions->visible()) { ?>
<?php $investor_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$investor_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$investor_info->isExport() && !$investor_info->CurrentAction) { ?>
<form name="finvestor_infolistsrch" id="finvestor_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($investor_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="finvestor_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="investor_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($investor_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($investor_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $investor_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($investor_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($investor_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($investor_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($investor_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $investor_info_list->showPageHeader(); ?>
<?php
$investor_info_list->showMessage();
?>
<?php if ($investor_info_list->TotalRecs > 0 || $investor_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($investor_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> investor_info">
<?php if (!$investor_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$investor_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($investor_info_list->Pager)) $investor_info_list->Pager = new PrevNextPager($investor_info_list->StartRec, $investor_info_list->DisplayRecs, $investor_info_list->TotalRecs, $investor_info_list->AutoHidePager) ?>
<?php if ($investor_info_list->Pager->RecordCount > 0 && $investor_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($investor_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($investor_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $investor_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($investor_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($investor_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $investor_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($investor_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $investor_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $investor_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $investor_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($investor_info_list->TotalRecs > 0 && (!$investor_info_list->AutoHidePageSizeSelector || $investor_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="investor_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($investor_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($investor_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($investor_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($investor_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($investor_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($investor_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $investor_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="finvestor_infolist" id="finvestor_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<div id="gmp_investor_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($investor_info_list->TotalRecs > 0 || $investor_info->isGridEdit()) { ?>
<table id="tbl_investor_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$investor_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$investor_info_list->renderListOptions();

// Render list options (header, left)
$investor_info_list->ListOptions->render("header", "left");
?>
<?php if ($investor_info->id->Visible) { // id ?>
	<?php if ($investor_info->sortUrl($investor_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $investor_info->id->headerCellClass() ?>"><div id="elh_investor_info_id" class="investor_info_id"><div class="ew-table-header-caption"><?php echo $investor_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $investor_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->id) ?>',2);"><div id="elh_investor_info_id" class="investor_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->qty->Visible) { // qty ?>
	<?php if ($investor_info->sortUrl($investor_info->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $investor_info->qty->headerCellClass() ?>"><div id="elh_investor_info_qty" class="investor_info_qty"><div class="ew-table-header-caption"><?php echo $investor_info->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $investor_info->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->qty) ?>',2);"><div id="elh_investor_info_qty" class="investor_info_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<?php if ($investor_info->sortUrl($investor_info->aadhaar_no) == "") { ?>
		<th data-name="aadhaar_no" class="<?php echo $investor_info->aadhaar_no->headerCellClass() ?>"><div id="elh_investor_info_aadhaar_no" class="investor_info_aadhaar_no"><div class="ew-table-header-caption"><?php echo $investor_info->aadhaar_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="aadhaar_no" class="<?php echo $investor_info->aadhaar_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->aadhaar_no) ?>',2);"><div id="elh_investor_info_aadhaar_no" class="investor_info_aadhaar_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->aadhaar_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->aadhaar_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->aadhaar_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->name->Visible) { // name ?>
	<?php if ($investor_info->sortUrl($investor_info->name) == "") { ?>
		<th data-name="name" class="<?php echo $investor_info->name->headerCellClass() ?>"><div id="elh_investor_info_name" class="investor_info_name"><div class="ew-table-header-caption"><?php echo $investor_info->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $investor_info->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->name) ?>',2);"><div id="elh_investor_info_name" class="investor_info_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->gender->Visible) { // gender ?>
	<?php if ($investor_info->sortUrl($investor_info->gender) == "") { ?>
		<th data-name="gender" class="<?php echo $investor_info->gender->headerCellClass() ?>"><div id="elh_investor_info_gender" class="investor_info_gender"><div class="ew-table-header-caption"><?php echo $investor_info->gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gender" class="<?php echo $investor_info->gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->gender) ?>',2);"><div id="elh_investor_info_gender" class="investor_info_gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->dob->Visible) { // dob ?>
	<?php if ($investor_info->sortUrl($investor_info->dob) == "") { ?>
		<th data-name="dob" class="<?php echo $investor_info->dob->headerCellClass() ?>"><div id="elh_investor_info_dob" class="investor_info_dob"><div class="ew-table-header-caption"><?php echo $investor_info->dob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dob" class="<?php echo $investor_info->dob->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->dob) ?>',2);"><div id="elh_investor_info_dob" class="investor_info_dob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->dob->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->dob->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->dob->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->mobile->Visible) { // mobile ?>
	<?php if ($investor_info->sortUrl($investor_info->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $investor_info->mobile->headerCellClass() ?>"><div id="elh_investor_info_mobile" class="investor_info_mobile"><div class="ew-table-header-caption"><?php echo $investor_info->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $investor_info->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->mobile) ?>',2);"><div id="elh_investor_info_mobile" class="investor_info_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->_email->Visible) { // email ?>
	<?php if ($investor_info->sortUrl($investor_info->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $investor_info->_email->headerCellClass() ?>"><div id="elh_investor_info__email" class="investor_info__email"><div class="ew-table-header-caption"><?php echo $investor_info->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $investor_info->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->_email) ?>',2);"><div id="elh_investor_info__email" class="investor_info__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->address->Visible) { // address ?>
	<?php if ($investor_info->sortUrl($investor_info->address) == "") { ?>
		<th data-name="address" class="<?php echo $investor_info->address->headerCellClass() ?>"><div id="elh_investor_info_address" class="investor_info_address"><div class="ew-table-header-caption"><?php echo $investor_info->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $investor_info->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->address) ?>',2);"><div id="elh_investor_info_address" class="investor_info_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->care_of->Visible) { // care_of ?>
	<?php if ($investor_info->sortUrl($investor_info->care_of) == "") { ?>
		<th data-name="care_of" class="<?php echo $investor_info->care_of->headerCellClass() ?>"><div id="elh_investor_info_care_of" class="investor_info_care_of"><div class="ew-table-header-caption"><?php echo $investor_info->care_of->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="care_of" class="<?php echo $investor_info->care_of->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->care_of) ?>',2);"><div id="elh_investor_info_care_of" class="investor_info_care_of">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->care_of->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->care_of->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->care_of->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->father_name->Visible) { // father_name ?>
	<?php if ($investor_info->sortUrl($investor_info->father_name) == "") { ?>
		<th data-name="father_name" class="<?php echo $investor_info->father_name->headerCellClass() ?>"><div id="elh_investor_info_father_name" class="investor_info_father_name"><div class="ew-table-header-caption"><?php echo $investor_info->father_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="father_name" class="<?php echo $investor_info->father_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->father_name) ?>',2);"><div id="elh_investor_info_father_name" class="investor_info_father_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->father_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->father_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->father_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->mother_name->Visible) { // mother_name ?>
	<?php if ($investor_info->sortUrl($investor_info->mother_name) == "") { ?>
		<th data-name="mother_name" class="<?php echo $investor_info->mother_name->headerCellClass() ?>"><div id="elh_investor_info_mother_name" class="investor_info_mother_name"><div class="ew-table-header-caption"><?php echo $investor_info->mother_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mother_name" class="<?php echo $investor_info->mother_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->mother_name) ?>',2);"><div id="elh_investor_info_mother_name" class="investor_info_mother_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->mother_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->mother_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->mother_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->nominee_name->Visible) { // nominee_name ?>
	<?php if ($investor_info->sortUrl($investor_info->nominee_name) == "") { ?>
		<th data-name="nominee_name" class="<?php echo $investor_info->nominee_name->headerCellClass() ?>"><div id="elh_investor_info_nominee_name" class="investor_info_nominee_name"><div class="ew-table-header-caption"><?php echo $investor_info->nominee_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nominee_name" class="<?php echo $investor_info->nominee_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->nominee_name) ?>',2);"><div id="elh_investor_info_nominee_name" class="investor_info_nominee_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->nominee_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->nominee_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->nominee_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->nominee_relation->Visible) { // nominee_relation ?>
	<?php if ($investor_info->sortUrl($investor_info->nominee_relation) == "") { ?>
		<th data-name="nominee_relation" class="<?php echo $investor_info->nominee_relation->headerCellClass() ?>"><div id="elh_investor_info_nominee_relation" class="investor_info_nominee_relation"><div class="ew-table-header-caption"><?php echo $investor_info->nominee_relation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nominee_relation" class="<?php echo $investor_info->nominee_relation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->nominee_relation) ?>',2);"><div id="elh_investor_info_nominee_relation" class="investor_info_nominee_relation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->nominee_relation->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->nominee_relation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->nominee_relation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->pan_no->Visible) { // pan_no ?>
	<?php if ($investor_info->sortUrl($investor_info->pan_no) == "") { ?>
		<th data-name="pan_no" class="<?php echo $investor_info->pan_no->headerCellClass() ?>"><div id="elh_investor_info_pan_no" class="investor_info_pan_no"><div class="ew-table-header-caption"><?php echo $investor_info->pan_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pan_no" class="<?php echo $investor_info->pan_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->pan_no) ?>',2);"><div id="elh_investor_info_pan_no" class="investor_info_pan_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->pan_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->pan_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->pan_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->image->Visible) { // image ?>
	<?php if ($investor_info->sortUrl($investor_info->image) == "") { ?>
		<th data-name="image" class="<?php echo $investor_info->image->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_investor_info_image" class="investor_info_image"><div class="ew-table-header-caption"><?php echo $investor_info->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $investor_info->image->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->image) ?>',2);"><div id="elh_investor_info_image" class="investor_info_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->image->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->adviser->Visible) { // adviser ?>
	<?php if ($investor_info->sortUrl($investor_info->adviser) == "") { ?>
		<th data-name="adviser" class="<?php echo $investor_info->adviser->headerCellClass() ?>"><div id="elh_investor_info_adviser" class="investor_info_adviser"><div class="ew-table-header-caption"><?php echo $investor_info->adviser->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="adviser" class="<?php echo $investor_info->adviser->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->adviser) ?>',2);"><div id="elh_investor_info_adviser" class="investor_info_adviser">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->adviser->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->adviser->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->adviser->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->share_no->Visible) { // share_no ?>
	<?php if ($investor_info->sortUrl($investor_info->share_no) == "") { ?>
		<th data-name="share_no" class="<?php echo $investor_info->share_no->headerCellClass() ?>"><div id="elh_investor_info_share_no" class="investor_info_share_no"><div class="ew-table-header-caption"><?php echo $investor_info->share_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="share_no" class="<?php echo $investor_info->share_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->share_no) ?>',2);"><div id="elh_investor_info_share_no" class="investor_info_share_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->share_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->share_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->share_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->inv_start_date->Visible) { // inv_start_date ?>
	<?php if ($investor_info->sortUrl($investor_info->inv_start_date) == "") { ?>
		<th data-name="inv_start_date" class="<?php echo $investor_info->inv_start_date->headerCellClass() ?>"><div id="elh_investor_info_inv_start_date" class="investor_info_inv_start_date"><div class="ew-table-header-caption"><?php echo $investor_info->inv_start_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="inv_start_date" class="<?php echo $investor_info->inv_start_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->inv_start_date) ?>',2);"><div id="elh_investor_info_inv_start_date" class="investor_info_inv_start_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->inv_start_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->inv_start_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->inv_start_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->amount->Visible) { // amount ?>
	<?php if ($investor_info->sortUrl($investor_info->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $investor_info->amount->headerCellClass() ?>"><div id="elh_investor_info_amount" class="investor_info_amount"><div class="ew-table-header-caption"><?php echo $investor_info->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $investor_info->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->amount) ?>',2);"><div id="elh_investor_info_amount" class="investor_info_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->gurantee->Visible) { // gurantee ?>
	<?php if ($investor_info->sortUrl($investor_info->gurantee) == "") { ?>
		<th data-name="gurantee" class="<?php echo $investor_info->gurantee->headerCellClass() ?>"><div id="elh_investor_info_gurantee" class="investor_info_gurantee"><div class="ew-table-header-caption"><?php echo $investor_info->gurantee->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gurantee" class="<?php echo $investor_info->gurantee->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->gurantee) ?>',2);"><div id="elh_investor_info_gurantee" class="investor_info_gurantee">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->gurantee->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->gurantee->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->gurantee->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->remarks->Visible) { // remarks ?>
	<?php if ($investor_info->sortUrl($investor_info->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $investor_info->remarks->headerCellClass() ?>"><div id="elh_investor_info_remarks" class="investor_info_remarks"><div class="ew-table-header-caption"><?php echo $investor_info->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $investor_info->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->remarks) ?>',2);"><div id="elh_investor_info_remarks" class="investor_info_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($investor_info->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->operator->Visible) { // operator ?>
	<?php if ($investor_info->sortUrl($investor_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $investor_info->operator->headerCellClass() ?>"><div id="elh_investor_info_operator" class="investor_info_operator"><div class="ew-table-header-caption"><?php echo $investor_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $investor_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->operator) ?>',2);"><div id="elh_investor_info_operator" class="investor_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_info->datetime->Visible) { // datetime ?>
	<?php if ($investor_info->sortUrl($investor_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $investor_info->datetime->headerCellClass() ?>"><div id="elh_investor_info_datetime" class="investor_info_datetime"><div class="ew-table-header-caption"><?php echo $investor_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $investor_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_info->SortUrl($investor_info->datetime) ?>',2);"><div id="elh_investor_info_datetime" class="investor_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$investor_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($investor_info->ExportAll && $investor_info->isExport()) {
	$investor_info_list->StopRec = $investor_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($investor_info_list->TotalRecs > $investor_info_list->StartRec + $investor_info_list->DisplayRecs - 1)
		$investor_info_list->StopRec = $investor_info_list->StartRec + $investor_info_list->DisplayRecs - 1;
	else
		$investor_info_list->StopRec = $investor_info_list->TotalRecs;
}
$investor_info_list->RecCnt = $investor_info_list->StartRec - 1;
if ($investor_info_list->Recordset && !$investor_info_list->Recordset->EOF) {
	$investor_info_list->Recordset->moveFirst();
	$selectLimit = $investor_info_list->UseSelectLimit;
	if (!$selectLimit && $investor_info_list->StartRec > 1)
		$investor_info_list->Recordset->move($investor_info_list->StartRec - 1);
} elseif (!$investor_info->AllowAddDeleteRow && $investor_info_list->StopRec == 0) {
	$investor_info_list->StopRec = $investor_info->GridAddRowCount;
}

// Initialize aggregate
$investor_info->RowType = ROWTYPE_AGGREGATEINIT;
$investor_info->resetAttributes();
$investor_info_list->renderRow();
while ($investor_info_list->RecCnt < $investor_info_list->StopRec) {
	$investor_info_list->RecCnt++;
	if ($investor_info_list->RecCnt >= $investor_info_list->StartRec) {
		$investor_info_list->RowCnt++;

		// Set up key count
		$investor_info_list->KeyCount = $investor_info_list->RowIndex;

		// Init row class and style
		$investor_info->resetAttributes();
		$investor_info->CssClass = "";
		if ($investor_info->isGridAdd()) {
		} else {
			$investor_info_list->loadRowValues($investor_info_list->Recordset); // Load row values
		}
		$investor_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$investor_info->RowAttrs = array_merge($investor_info->RowAttrs, array('data-rowindex'=>$investor_info_list->RowCnt, 'id'=>'r' . $investor_info_list->RowCnt . '_investor_info', 'data-rowtype'=>$investor_info->RowType));

		// Render row
		$investor_info_list->renderRow();

		// Render list options
		$investor_info_list->renderListOptions();
?>
	<tr<?php echo $investor_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$investor_info_list->ListOptions->render("body", "left", $investor_info_list->RowCnt);
?>
	<?php if ($investor_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $investor_info->id->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_id" class="investor_info_id">
<span<?php echo $investor_info->id->viewAttributes() ?>>
<?php echo $investor_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $investor_info->qty->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_qty" class="investor_info_qty">
<span<?php echo $investor_info->qty->viewAttributes() ?>>
<?php if ((!EmptyString($investor_info->qty->getViewValue())) && $investor_info->qty->linkAttributes() <> "") { ?>
<a<?php echo $investor_info->qty->linkAttributes() ?>><?php echo $investor_info->qty->getViewValue() ?></a>
<?php } else { ?>
<?php echo $investor_info->qty->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->aadhaar_no->Visible) { // aadhaar_no ?>
		<td data-name="aadhaar_no"<?php echo $investor_info->aadhaar_no->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_aadhaar_no" class="investor_info_aadhaar_no">
<span<?php echo $investor_info->aadhaar_no->viewAttributes() ?>>
<?php echo $investor_info->aadhaar_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->name->Visible) { // name ?>
		<td data-name="name"<?php echo $investor_info->name->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_name" class="investor_info_name">
<span<?php echo $investor_info->name->viewAttributes() ?>>
<?php echo $investor_info->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->gender->Visible) { // gender ?>
		<td data-name="gender"<?php echo $investor_info->gender->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_gender" class="investor_info_gender">
<span<?php echo $investor_info->gender->viewAttributes() ?>>
<?php echo $investor_info->gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->dob->Visible) { // dob ?>
		<td data-name="dob"<?php echo $investor_info->dob->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_dob" class="investor_info_dob">
<span<?php echo $investor_info->dob->viewAttributes() ?>>
<?php echo $investor_info->dob->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $investor_info->mobile->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_mobile" class="investor_info_mobile">
<span<?php echo $investor_info->mobile->viewAttributes() ?>>
<?php echo $investor_info->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $investor_info->_email->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info__email" class="investor_info__email">
<span<?php echo $investor_info->_email->viewAttributes() ?>>
<?php echo $investor_info->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->address->Visible) { // address ?>
		<td data-name="address"<?php echo $investor_info->address->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_address" class="investor_info_address">
<span<?php echo $investor_info->address->viewAttributes() ?>>
<?php echo $investor_info->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->care_of->Visible) { // care_of ?>
		<td data-name="care_of"<?php echo $investor_info->care_of->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_care_of" class="investor_info_care_of">
<span<?php echo $investor_info->care_of->viewAttributes() ?>>
<?php echo $investor_info->care_of->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->father_name->Visible) { // father_name ?>
		<td data-name="father_name"<?php echo $investor_info->father_name->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_father_name" class="investor_info_father_name">
<span<?php echo $investor_info->father_name->viewAttributes() ?>>
<?php echo $investor_info->father_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->mother_name->Visible) { // mother_name ?>
		<td data-name="mother_name"<?php echo $investor_info->mother_name->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_mother_name" class="investor_info_mother_name">
<span<?php echo $investor_info->mother_name->viewAttributes() ?>>
<?php echo $investor_info->mother_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->nominee_name->Visible) { // nominee_name ?>
		<td data-name="nominee_name"<?php echo $investor_info->nominee_name->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_nominee_name" class="investor_info_nominee_name">
<span<?php echo $investor_info->nominee_name->viewAttributes() ?>>
<?php echo $investor_info->nominee_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->nominee_relation->Visible) { // nominee_relation ?>
		<td data-name="nominee_relation"<?php echo $investor_info->nominee_relation->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_nominee_relation" class="investor_info_nominee_relation">
<span<?php echo $investor_info->nominee_relation->viewAttributes() ?>>
<?php echo $investor_info->nominee_relation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->pan_no->Visible) { // pan_no ?>
		<td data-name="pan_no"<?php echo $investor_info->pan_no->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_pan_no" class="investor_info_pan_no">
<span<?php echo $investor_info->pan_no->viewAttributes() ?>>
<?php echo $investor_info->pan_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->image->Visible) { // image ?>
		<td data-name="image"<?php echo $investor_info->image->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_image" class="investor_info_image">
<span>
<?php echo GetFileViewTag($investor_info->image, $investor_info->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->adviser->Visible) { // adviser ?>
		<td data-name="adviser"<?php echo $investor_info->adviser->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_adviser" class="investor_info_adviser">
<span<?php echo $investor_info->adviser->viewAttributes() ?>>
<?php echo $investor_info->adviser->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->share_no->Visible) { // share_no ?>
		<td data-name="share_no"<?php echo $investor_info->share_no->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_share_no" class="investor_info_share_no">
<span<?php echo $investor_info->share_no->viewAttributes() ?>>
<?php echo $investor_info->share_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->inv_start_date->Visible) { // inv_start_date ?>
		<td data-name="inv_start_date"<?php echo $investor_info->inv_start_date->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_inv_start_date" class="investor_info_inv_start_date">
<span<?php echo $investor_info->inv_start_date->viewAttributes() ?>>
<?php echo $investor_info->inv_start_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $investor_info->amount->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_amount" class="investor_info_amount">
<span<?php echo $investor_info->amount->viewAttributes() ?>>
<?php echo $investor_info->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->gurantee->Visible) { // gurantee ?>
		<td data-name="gurantee"<?php echo $investor_info->gurantee->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_gurantee" class="investor_info_gurantee">
<span<?php echo $investor_info->gurantee->viewAttributes() ?>>
<?php echo $investor_info->gurantee->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $investor_info->remarks->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_remarks" class="investor_info_remarks">
<span<?php echo $investor_info->remarks->viewAttributes() ?>>
<?php echo $investor_info->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $investor_info->operator->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_operator" class="investor_info_operator">
<span<?php echo $investor_info->operator->viewAttributes() ?>>
<?php echo $investor_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $investor_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $investor_info_list->RowCnt ?>_investor_info_datetime" class="investor_info_datetime">
<span<?php echo $investor_info->datetime->viewAttributes() ?>>
<?php echo $investor_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$investor_info_list->ListOptions->render("body", "right", $investor_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$investor_info->isGridAdd())
		$investor_info_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$investor_info->RowType = ROWTYPE_AGGREGATE;
$investor_info->resetAttributes();
$investor_info_list->renderRow();
?>
<?php if ($investor_info_list->TotalRecs > 0 && !$investor_info->isGridAdd() && !$investor_info->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$investor_info_list->renderListOptions();

// Render list options (footer, left)
$investor_info_list->ListOptions->render("footer", "left");
?>
	<?php if ($investor_info->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $investor_info->id->footerCellClass() ?>"><span id="elf_investor_info_id" class="investor_info_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->qty->Visible) { // qty ?>
		<td data-name="qty" class="<?php echo $investor_info->qty->footerCellClass() ?>"><span id="elf_investor_info_qty" class="investor_info_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $investor_info->qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($investor_info->aadhaar_no->Visible) { // aadhaar_no ?>
		<td data-name="aadhaar_no" class="<?php echo $investor_info->aadhaar_no->footerCellClass() ?>"><span id="elf_investor_info_aadhaar_no" class="investor_info_aadhaar_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->name->Visible) { // name ?>
		<td data-name="name" class="<?php echo $investor_info->name->footerCellClass() ?>"><span id="elf_investor_info_name" class="investor_info_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->gender->Visible) { // gender ?>
		<td data-name="gender" class="<?php echo $investor_info->gender->footerCellClass() ?>"><span id="elf_investor_info_gender" class="investor_info_gender">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->dob->Visible) { // dob ?>
		<td data-name="dob" class="<?php echo $investor_info->dob->footerCellClass() ?>"><span id="elf_investor_info_dob" class="investor_info_dob">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->mobile->Visible) { // mobile ?>
		<td data-name="mobile" class="<?php echo $investor_info->mobile->footerCellClass() ?>"><span id="elf_investor_info_mobile" class="investor_info_mobile">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->_email->Visible) { // email ?>
		<td data-name="_email" class="<?php echo $investor_info->_email->footerCellClass() ?>"><span id="elf_investor_info__email" class="investor_info__email">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->address->Visible) { // address ?>
		<td data-name="address" class="<?php echo $investor_info->address->footerCellClass() ?>"><span id="elf_investor_info_address" class="investor_info_address">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->care_of->Visible) { // care_of ?>
		<td data-name="care_of" class="<?php echo $investor_info->care_of->footerCellClass() ?>"><span id="elf_investor_info_care_of" class="investor_info_care_of">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->father_name->Visible) { // father_name ?>
		<td data-name="father_name" class="<?php echo $investor_info->father_name->footerCellClass() ?>"><span id="elf_investor_info_father_name" class="investor_info_father_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->mother_name->Visible) { // mother_name ?>
		<td data-name="mother_name" class="<?php echo $investor_info->mother_name->footerCellClass() ?>"><span id="elf_investor_info_mother_name" class="investor_info_mother_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->nominee_name->Visible) { // nominee_name ?>
		<td data-name="nominee_name" class="<?php echo $investor_info->nominee_name->footerCellClass() ?>"><span id="elf_investor_info_nominee_name" class="investor_info_nominee_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->nominee_relation->Visible) { // nominee_relation ?>
		<td data-name="nominee_relation" class="<?php echo $investor_info->nominee_relation->footerCellClass() ?>"><span id="elf_investor_info_nominee_relation" class="investor_info_nominee_relation">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->pan_no->Visible) { // pan_no ?>
		<td data-name="pan_no" class="<?php echo $investor_info->pan_no->footerCellClass() ?>"><span id="elf_investor_info_pan_no" class="investor_info_pan_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->image->Visible) { // image ?>
		<td data-name="image" class="<?php echo $investor_info->image->footerCellClass() ?>"><span id="elf_investor_info_image" class="investor_info_image">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->adviser->Visible) { // adviser ?>
		<td data-name="adviser" class="<?php echo $investor_info->adviser->footerCellClass() ?>"><span id="elf_investor_info_adviser" class="investor_info_adviser">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->share_no->Visible) { // share_no ?>
		<td data-name="share_no" class="<?php echo $investor_info->share_no->footerCellClass() ?>"><span id="elf_investor_info_share_no" class="investor_info_share_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->inv_start_date->Visible) { // inv_start_date ?>
		<td data-name="inv_start_date" class="<?php echo $investor_info->inv_start_date->footerCellClass() ?>"><span id="elf_investor_info_inv_start_date" class="investor_info_inv_start_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $investor_info->amount->footerCellClass() ?>"><span id="elf_investor_info_amount" class="investor_info_amount">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->gurantee->Visible) { // gurantee ?>
		<td data-name="gurantee" class="<?php echo $investor_info->gurantee->footerCellClass() ?>"><span id="elf_investor_info_gurantee" class="investor_info_gurantee">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $investor_info->remarks->footerCellClass() ?>"><span id="elf_investor_info_remarks" class="investor_info_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $investor_info->operator->footerCellClass() ?>"><span id="elf_investor_info_operator" class="investor_info_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $investor_info->datetime->footerCellClass() ?>"><span id="elf_investor_info_datetime" class="investor_info_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$investor_info_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$investor_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($investor_info_list->Recordset)
	$investor_info_list->Recordset->Close();
?>
<?php if (!$investor_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$investor_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($investor_info_list->Pager)) $investor_info_list->Pager = new PrevNextPager($investor_info_list->StartRec, $investor_info_list->DisplayRecs, $investor_info_list->TotalRecs, $investor_info_list->AutoHidePager) ?>
<?php if ($investor_info_list->Pager->RecordCount > 0 && $investor_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($investor_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($investor_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $investor_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($investor_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($investor_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $investor_info_list->pageUrl() ?>start=<?php echo $investor_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $investor_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($investor_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $investor_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $investor_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $investor_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($investor_info_list->TotalRecs > 0 && (!$investor_info_list->AutoHidePageSizeSelector || $investor_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="investor_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($investor_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($investor_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($investor_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($investor_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($investor_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($investor_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $investor_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($investor_info_list->TotalRecs == 0 && !$investor_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $investor_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$investor_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$investor_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$investor_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_investor_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$investor_info_list->terminate();
?>