<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_info_search = new investor_info_search();

// Run the page
$investor_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($investor_info_search->IsModal) { ?>
var finvestor_infosearch = currentAdvancedSearchForm = new ew.Form("finvestor_infosearch", "search");
<?php } else { ?>
var finvestor_infosearch = currentForm = new ew.Form("finvestor_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
finvestor_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_infosearch.lists["x_gender"] = <?php echo $investor_info_search->gender->Lookup->toClientList() ?>;
finvestor_infosearch.lists["x_gender"].options = <?php echo JsonEncode($investor_info_search->gender->options(FALSE, TRUE)) ?>;
finvestor_infosearch.lists["x_nominee_relation"] = <?php echo $investor_info_search->nominee_relation->Lookup->toClientList() ?>;
finvestor_infosearch.lists["x_nominee_relation"].options = <?php echo JsonEncode($investor_info_search->nominee_relation->options(FALSE, TRUE)) ?>;
finvestor_infosearch.lists["x_adviser"] = <?php echo $investor_info_search->adviser->Lookup->toClientList() ?>;
finvestor_infosearch.lists["x_adviser"].options = <?php echo JsonEncode($investor_info_search->adviser->lookupOptions()) ?>;

// Form object for search
// Validate function for search

finvestor_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_aadhaar_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->aadhaar_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_inv_start_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->inv_start_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_gurantee");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->gurantee->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_otp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->otp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pan_response");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->pan_response->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pan_verify_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->pan_verify_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_aadhaar_verify_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_info->aadhaar_verify_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $investor_info_search->showPageHeader(); ?>
<?php
$investor_info_search->showMessage();
?>
<form name="finvestor_infosearch" id="finvestor_infosearch" class="<?php echo $investor_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$investor_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($investor_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_id"><?php echo $investor_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->id->cellAttributes() ?>>
			<span id="el_investor_info_id">
<input type="text" data-table="investor_info" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($investor_info->id->getPlaceHolder()) ?>" value="<?php echo $investor_info->id->EditValue ?>"<?php echo $investor_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_qty"><?php echo $investor_info->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->qty->cellAttributes() ?>>
			<span id="el_investor_info_qty">
<input type="text" data-table="investor_info" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($investor_info->qty->getPlaceHolder()) ?>" value="<?php echo $investor_info->qty->EditValue ?>"<?php echo $investor_info->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label for="x_aadhaar_no" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_aadhaar_no"><?php echo $investor_info->aadhaar_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->aadhaar_no->cellAttributes() ?>>
			<span id="el_investor_info_aadhaar_no">
<input type="text" data-table="investor_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($investor_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $investor_info->aadhaar_no->EditValue ?>"<?php echo $investor_info->aadhaar_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_name"><?php echo $investor_info->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->name->cellAttributes() ?>>
			<span id="el_investor_info_name">
<input type="text" data-table="investor_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->name->getPlaceHolder()) ?>" value="<?php echo $investor_info->name->EditValue ?>"<?php echo $investor_info->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label for="x_gender" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_gender"><?php echo $investor_info->gender->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gender" id="z_gender" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->gender->cellAttributes() ?>>
			<span id="el_investor_info_gender">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_gender" data-value-separator="<?php echo $investor_info->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $investor_info->gender->editAttributes() ?>>
		<?php echo $investor_info->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label for="x_dob" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_dob"><?php echo $investor_info->dob->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_dob" id="z_dob" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->dob->cellAttributes() ?>>
			<span id="el_investor_info_dob">
<input type="text" data-table="investor_info" data-field="x_dob" data-format="7" name="x_dob" id="x_dob" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->dob->getPlaceHolder()) ?>" value="<?php echo $investor_info->dob->EditValue ?>"<?php echo $investor_info->dob->editAttributes() ?>>
<?php if (!$investor_info->dob->ReadOnly && !$investor_info->dob->Disabled && !isset($investor_info->dob->EditAttrs["readonly"]) && !isset($investor_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infosearch", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_mobile"><?php echo $investor_info->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->mobile->cellAttributes() ?>>
			<span id="el_investor_info_mobile">
<input type="text" data-table="investor_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($investor_info->mobile->getPlaceHolder()) ?>" value="<?php echo $investor_info->mobile->EditValue ?>"<?php echo $investor_info->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info__email"><?php echo $investor_info->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->_email->cellAttributes() ?>>
			<span id="el_investor_info__email">
<input type="text" data-table="investor_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->_email->getPlaceHolder()) ?>" value="<?php echo $investor_info->_email->EditValue ?>"<?php echo $investor_info->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_address"><?php echo $investor_info->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->address->cellAttributes() ?>>
			<span id="el_investor_info_address">
<input type="text" data-table="investor_info" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="252" placeholder="<?php echo HtmlEncode($investor_info->address->getPlaceHolder()) ?>" value="<?php echo $investor_info->address->EditValue ?>"<?php echo $investor_info->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->care_of->Visible) { // care_of ?>
	<div id="r_care_of" class="form-group row">
		<label for="x_care_of" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_care_of"><?php echo $investor_info->care_of->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_care_of" id="z_care_of" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->care_of->cellAttributes() ?>>
			<span id="el_investor_info_care_of">
<input type="text" data-table="investor_info" data-field="x_care_of" name="x_care_of" id="x_care_of" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->care_of->getPlaceHolder()) ?>" value="<?php echo $investor_info->care_of->EditValue ?>"<?php echo $investor_info->care_of->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label for="x_father_name" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_father_name"><?php echo $investor_info->father_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_father_name" id="z_father_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->father_name->cellAttributes() ?>>
			<span id="el_investor_info_father_name">
<input type="text" data-table="investor_info" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->father_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->father_name->EditValue ?>"<?php echo $investor_info->father_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->mother_name->Visible) { // mother_name ?>
	<div id="r_mother_name" class="form-group row">
		<label for="x_mother_name" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_mother_name"><?php echo $investor_info->mother_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mother_name" id="z_mother_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->mother_name->cellAttributes() ?>>
			<span id="el_investor_info_mother_name">
<input type="text" data-table="investor_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->mother_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->mother_name->EditValue ?>"<?php echo $investor_info->mother_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->nominee_name->Visible) { // nominee_name ?>
	<div id="r_nominee_name" class="form-group row">
		<label for="x_nominee_name" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_nominee_name"><?php echo $investor_info->nominee_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_nominee_name" id="z_nominee_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->nominee_name->cellAttributes() ?>>
			<span id="el_investor_info_nominee_name">
<input type="text" data-table="investor_info" data-field="x_nominee_name" name="x_nominee_name" id="x_nominee_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($investor_info->nominee_name->getPlaceHolder()) ?>" value="<?php echo $investor_info->nominee_name->EditValue ?>"<?php echo $investor_info->nominee_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->nominee_relation->Visible) { // nominee_relation ?>
	<div id="r_nominee_relation" class="form-group row">
		<label for="x_nominee_relation" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_nominee_relation"><?php echo $investor_info->nominee_relation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_nominee_relation" id="z_nominee_relation" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->nominee_relation->cellAttributes() ?>>
			<span id="el_investor_info_nominee_relation">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_nominee_relation" data-value-separator="<?php echo $investor_info->nominee_relation->displayValueSeparatorAttribute() ?>" id="x_nominee_relation" name="x_nominee_relation"<?php echo $investor_info->nominee_relation->editAttributes() ?>>
		<?php echo $investor_info->nominee_relation->selectOptionListHtml("x_nominee_relation") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label for="x_pan_no" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_pan_no"><?php echo $investor_info->pan_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->pan_no->cellAttributes() ?>>
			<span id="el_investor_info_pan_no">
<input type="text" data-table="investor_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($investor_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $investor_info->pan_no->EditValue ?>"<?php echo $investor_info->pan_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_uploads"><?php echo $investor_info->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->uploads->cellAttributes() ?>>
			<span id="el_investor_info_uploads">
<input type="text" data-table="investor_info" data-field="x_uploads" name="x_uploads" id="x_uploads" placeholder="<?php echo HtmlEncode($investor_info->uploads->getPlaceHolder()) ?>" value="<?php echo $investor_info->uploads->EditValue ?>"<?php echo $investor_info->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_image"><?php echo $investor_info->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->image->cellAttributes() ?>>
			<span id="el_investor_info_image">
<input type="text" data-table="investor_info" data-field="x_image" name="x_image" id="x_image" placeholder="<?php echo HtmlEncode($investor_info->image->getPlaceHolder()) ?>" value="<?php echo $investor_info->image->EditValue ?>"<?php echo $investor_info->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->adviser->Visible) { // adviser ?>
	<div id="r_adviser" class="form-group row">
		<label for="x_adviser" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_adviser"><?php echo $investor_info->adviser->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_adviser" id="z_adviser" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->adviser->cellAttributes() ?>>
			<span id="el_investor_info_adviser">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_info" data-field="x_adviser" data-value-separator="<?php echo $investor_info->adviser->displayValueSeparatorAttribute() ?>" id="x_adviser" name="x_adviser"<?php echo $investor_info->adviser->editAttributes() ?>>
		<?php echo $investor_info->adviser->selectOptionListHtml("x_adviser") ?>
	</select>
</div>
<?php echo $investor_info->adviser->Lookup->getParamTag("p_x_adviser") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->share_no->Visible) { // share_no ?>
	<div id="r_share_no" class="form-group row">
		<label for="x_share_no" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_share_no"><?php echo $investor_info->share_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_share_no" id="z_share_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->share_no->cellAttributes() ?>>
			<span id="el_investor_info_share_no">
<input type="text" data-table="investor_info" data-field="x_share_no" name="x_share_no" id="x_share_no" size="30" placeholder="<?php echo HtmlEncode($investor_info->share_no->getPlaceHolder()) ?>" value="<?php echo $investor_info->share_no->EditValue ?>"<?php echo $investor_info->share_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->inv_start_date->Visible) { // inv_start_date ?>
	<div id="r_inv_start_date" class="form-group row">
		<label for="x_inv_start_date" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_inv_start_date"><?php echo $investor_info->inv_start_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_inv_start_date" id="z_inv_start_date" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->inv_start_date->cellAttributes() ?>>
			<span id="el_investor_info_inv_start_date">
<input type="text" data-table="investor_info" data-field="x_inv_start_date" name="x_inv_start_date" id="x_inv_start_date" placeholder="<?php echo HtmlEncode($investor_info->inv_start_date->getPlaceHolder()) ?>" value="<?php echo $investor_info->inv_start_date->EditValue ?>"<?php echo $investor_info->inv_start_date->editAttributes() ?>>
<?php if (!$investor_info->inv_start_date->ReadOnly && !$investor_info->inv_start_date->Disabled && !isset($investor_info->inv_start_date->EditAttrs["readonly"]) && !isset($investor_info->inv_start_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infosearch", "x_inv_start_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_amount"><?php echo $investor_info->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->amount->cellAttributes() ?>>
			<span id="el_investor_info_amount">
<input type="text" data-table="investor_info" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($investor_info->amount->getPlaceHolder()) ?>" value="<?php echo $investor_info->amount->EditValue ?>"<?php echo $investor_info->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->gurantee->Visible) { // gurantee ?>
	<div id="r_gurantee" class="form-group row">
		<label for="x_gurantee" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_gurantee"><?php echo $investor_info->gurantee->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gurantee" id="z_gurantee" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->gurantee->cellAttributes() ?>>
			<span id="el_investor_info_gurantee">
<input type="text" data-table="investor_info" data-field="x_gurantee" name="x_gurantee" id="x_gurantee" size="30" placeholder="<?php echo HtmlEncode($investor_info->gurantee->getPlaceHolder()) ?>" value="<?php echo $investor_info->gurantee->EditValue ?>"<?php echo $investor_info->gurantee->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_remarks"><?php echo $investor_info->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->remarks->cellAttributes() ?>>
			<span id="el_investor_info_remarks">
<input type="text" data-table="investor_info" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($investor_info->remarks->getPlaceHolder()) ?>" value="<?php echo $investor_info->remarks->EditValue ?>"<?php echo $investor_info->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_operator"><?php echo $investor_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->operator->cellAttributes() ?>>
			<span id="el_investor_info_operator">
<input type="text" data-table="investor_info" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($investor_info->operator->getPlaceHolder()) ?>" value="<?php echo $investor_info->operator->EditValue ?>"<?php echo $investor_info->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_datetime"><?php echo $investor_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->datetime->cellAttributes() ?>>
			<span id="el_investor_info_datetime">
<input type="text" data-table="investor_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($investor_info->datetime->getPlaceHolder()) ?>" value="<?php echo $investor_info->datetime->EditValue ?>"<?php echo $investor_info->datetime->editAttributes() ?>>
<?php if (!$investor_info->datetime->ReadOnly && !$investor_info->datetime->Disabled && !isset($investor_info->datetime->EditAttrs["readonly"]) && !isset($investor_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->otp->Visible) { // otp ?>
	<div id="r_otp" class="form-group row">
		<label for="x_otp" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_otp"><?php echo $investor_info->otp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_otp" id="z_otp" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->otp->cellAttributes() ?>>
			<span id="el_investor_info_otp">
<input type="text" data-table="investor_info" data-field="x_otp" name="x_otp" id="x_otp" size="30" placeholder="<?php echo HtmlEncode($investor_info->otp->getPlaceHolder()) ?>" value="<?php echo $investor_info->otp->EditValue ?>"<?php echo $investor_info->otp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->pan_response->Visible) { // pan_response ?>
	<div id="r_pan_response" class="form-group row">
		<label for="x_pan_response" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_pan_response"><?php echo $investor_info->pan_response->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pan_response" id="z_pan_response" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->pan_response->cellAttributes() ?>>
			<span id="el_investor_info_pan_response">
<input type="text" data-table="investor_info" data-field="x_pan_response" name="x_pan_response" id="x_pan_response" placeholder="<?php echo HtmlEncode($investor_info->pan_response->getPlaceHolder()) ?>" value="<?php echo $investor_info->pan_response->EditValue ?>"<?php echo $investor_info->pan_response->editAttributes() ?>>
<?php if (!$investor_info->pan_response->ReadOnly && !$investor_info->pan_response->Disabled && !isset($investor_info->pan_response->EditAttrs["readonly"]) && !isset($investor_info->pan_response->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infosearch", "x_pan_response", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->pan_verify_datetime->Visible) { // pan_verify_datetime ?>
	<div id="r_pan_verify_datetime" class="form-group row">
		<label for="x_pan_verify_datetime" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_pan_verify_datetime"><?php echo $investor_info->pan_verify_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pan_verify_datetime" id="z_pan_verify_datetime" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->pan_verify_datetime->cellAttributes() ?>>
			<span id="el_investor_info_pan_verify_datetime">
<input type="text" data-table="investor_info" data-field="x_pan_verify_datetime" name="x_pan_verify_datetime" id="x_pan_verify_datetime" placeholder="<?php echo HtmlEncode($investor_info->pan_verify_datetime->getPlaceHolder()) ?>" value="<?php echo $investor_info->pan_verify_datetime->EditValue ?>"<?php echo $investor_info->pan_verify_datetime->editAttributes() ?>>
<?php if (!$investor_info->pan_verify_datetime->ReadOnly && !$investor_info->pan_verify_datetime->Disabled && !isset($investor_info->pan_verify_datetime->EditAttrs["readonly"]) && !isset($investor_info->pan_verify_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infosearch", "x_pan_verify_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->aadhaar_response->Visible) { // aadhaar_response ?>
	<div id="r_aadhaar_response" class="form-group row">
		<label for="x_aadhaar_response" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_aadhaar_response"><?php echo $investor_info->aadhaar_response->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_aadhaar_response" id="z_aadhaar_response" value="LIKE"></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->aadhaar_response->cellAttributes() ?>>
			<span id="el_investor_info_aadhaar_response">
<input type="text" data-table="investor_info" data-field="x_aadhaar_response" name="x_aadhaar_response" id="x_aadhaar_response" size="35" placeholder="<?php echo HtmlEncode($investor_info->aadhaar_response->getPlaceHolder()) ?>" value="<?php echo $investor_info->aadhaar_response->EditValue ?>"<?php echo $investor_info->aadhaar_response->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_info->aadhaar_verify_datetime->Visible) { // aadhaar_verify_datetime ?>
	<div id="r_aadhaar_verify_datetime" class="form-group row">
		<label for="x_aadhaar_verify_datetime" class="<?php echo $investor_info_search->LeftColumnClass ?>"><span id="elh_investor_info_aadhaar_verify_datetime"><?php echo $investor_info->aadhaar_verify_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_aadhaar_verify_datetime" id="z_aadhaar_verify_datetime" value="="></span>
		</label>
		<div class="<?php echo $investor_info_search->RightColumnClass ?>"><div<?php echo $investor_info->aadhaar_verify_datetime->cellAttributes() ?>>
			<span id="el_investor_info_aadhaar_verify_datetime">
<input type="text" data-table="investor_info" data-field="x_aadhaar_verify_datetime" name="x_aadhaar_verify_datetime" id="x_aadhaar_verify_datetime" placeholder="<?php echo HtmlEncode($investor_info->aadhaar_verify_datetime->getPlaceHolder()) ?>" value="<?php echo $investor_info->aadhaar_verify_datetime->EditValue ?>"<?php echo $investor_info->aadhaar_verify_datetime->editAttributes() ?>>
<?php if (!$investor_info->aadhaar_verify_datetime->ReadOnly && !$investor_info->aadhaar_verify_datetime->Disabled && !isset($investor_info->aadhaar_verify_datetime->EditAttrs["readonly"]) && !isset($investor_info->aadhaar_verify_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_infosearch", "x_aadhaar_verify_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$investor_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $investor_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$investor_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$investor_info_search->terminate();
?>