<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_info_view = new investor_info_view();

// Run the page
$investor_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$investor_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var finvestor_infoview = currentForm = new ew.Form("finvestor_infoview", "view");

// Form_CustomValidate event
finvestor_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_infoview.lists["x_gender"] = <?php echo $investor_info_view->gender->Lookup->toClientList() ?>;
finvestor_infoview.lists["x_gender"].options = <?php echo JsonEncode($investor_info_view->gender->options(FALSE, TRUE)) ?>;
finvestor_infoview.lists["x_nominee_relation"] = <?php echo $investor_info_view->nominee_relation->Lookup->toClientList() ?>;
finvestor_infoview.lists["x_nominee_relation"].options = <?php echo JsonEncode($investor_info_view->nominee_relation->options(FALSE, TRUE)) ?>;
finvestor_infoview.lists["x_adviser"] = <?php echo $investor_info_view->adviser->Lookup->toClientList() ?>;
finvestor_infoview.lists["x_adviser"].options = <?php echo JsonEncode($investor_info_view->adviser->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$investor_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $investor_info_view->ExportOptions->render("body") ?>
<?php $investor_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $investor_info_view->showPageHeader(); ?>
<?php
$investor_info_view->showMessage();
?>
<form name="finvestor_infoview" id="finvestor_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<input type="hidden" name="modal" value="<?php echo (int)$investor_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($investor_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_id"><?php echo $investor_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $investor_info->id->cellAttributes() ?>>
<span id="el_investor_info_id">
<span<?php echo $investor_info->id->viewAttributes() ?>>
<?php echo $investor_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->qty->Visible) { // qty ?>
	<tr id="r_qty">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_qty"><?php echo $investor_info->qty->caption() ?></span></td>
		<td data-name="qty"<?php echo $investor_info->qty->cellAttributes() ?>>
<span id="el_investor_info_qty">
<span<?php echo $investor_info->qty->viewAttributes() ?>>
<?php if ((!EmptyString($investor_info->qty->getViewValue())) && $investor_info->qty->linkAttributes() <> "") { ?>
<a<?php echo $investor_info->qty->linkAttributes() ?>><?php echo $investor_info->qty->getViewValue() ?></a>
<?php } else { ?>
<?php echo $investor_info->qty->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<tr id="r_aadhaar_no">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_aadhaar_no"><?php echo $investor_info->aadhaar_no->caption() ?></span></td>
		<td data-name="aadhaar_no"<?php echo $investor_info->aadhaar_no->cellAttributes() ?>>
<span id="el_investor_info_aadhaar_no">
<span<?php echo $investor_info->aadhaar_no->viewAttributes() ?>>
<?php echo $investor_info->aadhaar_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_name"><?php echo $investor_info->name->caption() ?></span></td>
		<td data-name="name"<?php echo $investor_info->name->cellAttributes() ?>>
<span id="el_investor_info_name">
<span<?php echo $investor_info->name->viewAttributes() ?>>
<?php echo $investor_info->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->gender->Visible) { // gender ?>
	<tr id="r_gender">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_gender"><?php echo $investor_info->gender->caption() ?></span></td>
		<td data-name="gender"<?php echo $investor_info->gender->cellAttributes() ?>>
<span id="el_investor_info_gender">
<span<?php echo $investor_info->gender->viewAttributes() ?>>
<?php echo $investor_info->gender->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->dob->Visible) { // dob ?>
	<tr id="r_dob">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_dob"><?php echo $investor_info->dob->caption() ?></span></td>
		<td data-name="dob"<?php echo $investor_info->dob->cellAttributes() ?>>
<span id="el_investor_info_dob">
<span<?php echo $investor_info->dob->viewAttributes() ?>>
<?php echo $investor_info->dob->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_mobile"><?php echo $investor_info->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $investor_info->mobile->cellAttributes() ?>>
<span id="el_investor_info_mobile">
<span<?php echo $investor_info->mobile->viewAttributes() ?>>
<?php echo $investor_info->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info__email"><?php echo $investor_info->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $investor_info->_email->cellAttributes() ?>>
<span id="el_investor_info__email">
<span<?php echo $investor_info->_email->viewAttributes() ?>>
<?php echo $investor_info->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_address"><?php echo $investor_info->address->caption() ?></span></td>
		<td data-name="address"<?php echo $investor_info->address->cellAttributes() ?>>
<span id="el_investor_info_address">
<span<?php echo $investor_info->address->viewAttributes() ?>>
<?php echo $investor_info->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->care_of->Visible) { // care_of ?>
	<tr id="r_care_of">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_care_of"><?php echo $investor_info->care_of->caption() ?></span></td>
		<td data-name="care_of"<?php echo $investor_info->care_of->cellAttributes() ?>>
<span id="el_investor_info_care_of">
<span<?php echo $investor_info->care_of->viewAttributes() ?>>
<?php echo $investor_info->care_of->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->father_name->Visible) { // father_name ?>
	<tr id="r_father_name">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_father_name"><?php echo $investor_info->father_name->caption() ?></span></td>
		<td data-name="father_name"<?php echo $investor_info->father_name->cellAttributes() ?>>
<span id="el_investor_info_father_name">
<span<?php echo $investor_info->father_name->viewAttributes() ?>>
<?php echo $investor_info->father_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->mother_name->Visible) { // mother_name ?>
	<tr id="r_mother_name">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_mother_name"><?php echo $investor_info->mother_name->caption() ?></span></td>
		<td data-name="mother_name"<?php echo $investor_info->mother_name->cellAttributes() ?>>
<span id="el_investor_info_mother_name">
<span<?php echo $investor_info->mother_name->viewAttributes() ?>>
<?php echo $investor_info->mother_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->nominee_name->Visible) { // nominee_name ?>
	<tr id="r_nominee_name">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_nominee_name"><?php echo $investor_info->nominee_name->caption() ?></span></td>
		<td data-name="nominee_name"<?php echo $investor_info->nominee_name->cellAttributes() ?>>
<span id="el_investor_info_nominee_name">
<span<?php echo $investor_info->nominee_name->viewAttributes() ?>>
<?php echo $investor_info->nominee_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->nominee_relation->Visible) { // nominee_relation ?>
	<tr id="r_nominee_relation">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_nominee_relation"><?php echo $investor_info->nominee_relation->caption() ?></span></td>
		<td data-name="nominee_relation"<?php echo $investor_info->nominee_relation->cellAttributes() ?>>
<span id="el_investor_info_nominee_relation">
<span<?php echo $investor_info->nominee_relation->viewAttributes() ?>>
<?php echo $investor_info->nominee_relation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->pan_no->Visible) { // pan_no ?>
	<tr id="r_pan_no">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_pan_no"><?php echo $investor_info->pan_no->caption() ?></span></td>
		<td data-name="pan_no"<?php echo $investor_info->pan_no->cellAttributes() ?>>
<span id="el_investor_info_pan_no">
<span<?php echo $investor_info->pan_no->viewAttributes() ?>>
<?php echo $investor_info->pan_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_uploads"><?php echo $investor_info->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $investor_info->uploads->cellAttributes() ?>>
<span id="el_investor_info_uploads">
<span>
<?php echo GetFileViewTag($investor_info->uploads, $investor_info->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_image"><?php echo $investor_info->image->caption() ?></span></td>
		<td data-name="image"<?php echo $investor_info->image->cellAttributes() ?>>
<span id="el_investor_info_image">
<span>
<?php echo GetFileViewTag($investor_info->image, $investor_info->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->adviser->Visible) { // adviser ?>
	<tr id="r_adviser">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_adviser"><?php echo $investor_info->adviser->caption() ?></span></td>
		<td data-name="adviser"<?php echo $investor_info->adviser->cellAttributes() ?>>
<span id="el_investor_info_adviser">
<span<?php echo $investor_info->adviser->viewAttributes() ?>>
<?php echo $investor_info->adviser->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->share_no->Visible) { // share_no ?>
	<tr id="r_share_no">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_share_no"><?php echo $investor_info->share_no->caption() ?></span></td>
		<td data-name="share_no"<?php echo $investor_info->share_no->cellAttributes() ?>>
<span id="el_investor_info_share_no">
<span<?php echo $investor_info->share_no->viewAttributes() ?>>
<?php echo $investor_info->share_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->inv_start_date->Visible) { // inv_start_date ?>
	<tr id="r_inv_start_date">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_inv_start_date"><?php echo $investor_info->inv_start_date->caption() ?></span></td>
		<td data-name="inv_start_date"<?php echo $investor_info->inv_start_date->cellAttributes() ?>>
<span id="el_investor_info_inv_start_date">
<span<?php echo $investor_info->inv_start_date->viewAttributes() ?>>
<?php echo $investor_info->inv_start_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_amount"><?php echo $investor_info->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $investor_info->amount->cellAttributes() ?>>
<span id="el_investor_info_amount">
<span<?php echo $investor_info->amount->viewAttributes() ?>>
<?php echo $investor_info->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->gurantee->Visible) { // gurantee ?>
	<tr id="r_gurantee">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_gurantee"><?php echo $investor_info->gurantee->caption() ?></span></td>
		<td data-name="gurantee"<?php echo $investor_info->gurantee->cellAttributes() ?>>
<span id="el_investor_info_gurantee">
<span<?php echo $investor_info->gurantee->viewAttributes() ?>>
<?php echo $investor_info->gurantee->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_remarks"><?php echo $investor_info->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $investor_info->remarks->cellAttributes() ?>>
<span id="el_investor_info_remarks">
<span<?php echo $investor_info->remarks->viewAttributes() ?>>
<?php echo $investor_info->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_operator"><?php echo $investor_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $investor_info->operator->cellAttributes() ?>>
<span id="el_investor_info_operator">
<span<?php echo $investor_info->operator->viewAttributes() ?>>
<?php echo $investor_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $investor_info_view->TableLeftColumnClass ?>"><span id="elh_investor_info_datetime"><?php echo $investor_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $investor_info->datetime->cellAttributes() ?>>
<span id="el_investor_info_datetime">
<span<?php echo $investor_info->datetime->viewAttributes() ?>>
<?php echo $investor_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$investor_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$investor_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$investor_info_view->terminate();
?>