<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_list_add = new investor_list_add();

// Run the page
$investor_list_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_list_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var finvestor_listadd = currentForm = new ew.Form("finvestor_listadd", "add");

// Validate form
finvestor_listadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($investor_list_add->share_no->Required) { ?>
			elm = this.getElements("x" + infix + "_share_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_list->share_no->caption(), $investor_list->share_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_share_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($investor_list->share_no->errorMessage()) ?>");
		<?php if ($investor_list_add->folio_no->Required) { ?>
			elm = this.getElements("x" + infix + "_folio_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_list->folio_no->caption(), $investor_list->folio_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_list_add->qty->Required) { ?>
			elm = this.getElements("x" + infix + "_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_list->qty->caption(), $investor_list->qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($investor_list->qty->errorMessage()) ?>");
		<?php if ($investor_list_add->transfer_id_old->Required) { ?>
			elm = this.getElements("x" + infix + "_transfer_id_old");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_list->transfer_id_old->caption(), $investor_list->transfer_id_old->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_transfer_id_old");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($investor_list->transfer_id_old->errorMessage()) ?>");
		<?php if ($investor_list_add->transfer_id_new->Required) { ?>
			elm = this.getElements("x" + infix + "_transfer_id_new");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_list->transfer_id_new->caption(), $investor_list->transfer_id_new->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_transfer_id_new");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($investor_list->transfer_id_new->errorMessage()) ?>");
		<?php if ($investor_list_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_list->operator->caption(), $investor_list->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($investor_list_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $investor_list->datetime->caption(), $investor_list->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
finvestor_listadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_listadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_listadd.lists["x_folio_no"] = <?php echo $investor_list_add->folio_no->Lookup->toClientList() ?>;
finvestor_listadd.lists["x_folio_no"].options = <?php echo JsonEncode($investor_list_add->folio_no->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $investor_list_add->showPageHeader(); ?>
<?php
$investor_list_add->showMessage();
?>
<form name="finvestor_listadd" id="finvestor_listadd" class="<?php echo $investor_list_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_list_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_list_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_list">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$investor_list_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($investor_list->share_no->Visible) { // share_no ?>
	<div id="r_share_no" class="form-group row">
		<label id="elh_investor_list_share_no" for="x_share_no" class="<?php echo $investor_list_add->LeftColumnClass ?>"><?php echo $investor_list->share_no->caption() ?><?php echo ($investor_list->share_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_list_add->RightColumnClass ?>"><div<?php echo $investor_list->share_no->cellAttributes() ?>>
<span id="el_investor_list_share_no">
<input type="text" data-table="investor_list" data-field="x_share_no" name="x_share_no" id="x_share_no" size="30" placeholder="<?php echo HtmlEncode($investor_list->share_no->getPlaceHolder()) ?>" value="<?php echo $investor_list->share_no->EditValue ?>"<?php echo $investor_list->share_no->editAttributes() ?>>
</span>
<?php echo $investor_list->share_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_list->folio_no->Visible) { // folio_no ?>
	<div id="r_folio_no" class="form-group row">
		<label id="elh_investor_list_folio_no" for="x_folio_no" class="<?php echo $investor_list_add->LeftColumnClass ?>"><?php echo $investor_list->folio_no->caption() ?><?php echo ($investor_list->folio_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_list_add->RightColumnClass ?>"><div<?php echo $investor_list->folio_no->cellAttributes() ?>>
<span id="el_investor_list_folio_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_list" data-field="x_folio_no" data-value-separator="<?php echo $investor_list->folio_no->displayValueSeparatorAttribute() ?>" id="x_folio_no" name="x_folio_no"<?php echo $investor_list->folio_no->editAttributes() ?>>
		<?php echo $investor_list->folio_no->selectOptionListHtml("x_folio_no") ?>
	</select>
</div>
<?php echo $investor_list->folio_no->Lookup->getParamTag("p_x_folio_no") ?>
</span>
<?php echo $investor_list->folio_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_list->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label id="elh_investor_list_qty" for="x_qty" class="<?php echo $investor_list_add->LeftColumnClass ?>"><?php echo $investor_list->qty->caption() ?><?php echo ($investor_list->qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_list_add->RightColumnClass ?>"><div<?php echo $investor_list->qty->cellAttributes() ?>>
<span id="el_investor_list_qty">
<input type="text" data-table="investor_list" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($investor_list->qty->getPlaceHolder()) ?>" value="<?php echo $investor_list->qty->EditValue ?>"<?php echo $investor_list->qty->editAttributes() ?>>
</span>
<?php echo $investor_list->qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_list->transfer_id_old->Visible) { // transfer_id_old ?>
	<div id="r_transfer_id_old" class="form-group row">
		<label id="elh_investor_list_transfer_id_old" for="x_transfer_id_old" class="<?php echo $investor_list_add->LeftColumnClass ?>"><?php echo $investor_list->transfer_id_old->caption() ?><?php echo ($investor_list->transfer_id_old->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_list_add->RightColumnClass ?>"><div<?php echo $investor_list->transfer_id_old->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_old">
<input type="text" data-table="investor_list" data-field="x_transfer_id_old" name="x_transfer_id_old" id="x_transfer_id_old" size="30" placeholder="<?php echo HtmlEncode($investor_list->transfer_id_old->getPlaceHolder()) ?>" value="<?php echo $investor_list->transfer_id_old->EditValue ?>"<?php echo $investor_list->transfer_id_old->editAttributes() ?>>
</span>
<?php echo $investor_list->transfer_id_old->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($investor_list->transfer_id_new->Visible) { // transfer_id_new ?>
	<div id="r_transfer_id_new" class="form-group row">
		<label id="elh_investor_list_transfer_id_new" for="x_transfer_id_new" class="<?php echo $investor_list_add->LeftColumnClass ?>"><?php echo $investor_list->transfer_id_new->caption() ?><?php echo ($investor_list->transfer_id_new->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $investor_list_add->RightColumnClass ?>"><div<?php echo $investor_list->transfer_id_new->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_new">
<input type="text" data-table="investor_list" data-field="x_transfer_id_new" name="x_transfer_id_new" id="x_transfer_id_new" size="30" placeholder="<?php echo HtmlEncode($investor_list->transfer_id_new->getPlaceHolder()) ?>" value="<?php echo $investor_list->transfer_id_new->EditValue ?>"<?php echo $investor_list->transfer_id_new->editAttributes() ?>>
</span>
<?php echo $investor_list->transfer_id_new->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$investor_list_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $investor_list_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $investor_list_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$investor_list_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$investor_list_add->terminate();
?>