<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_list_list = new investor_list_list();

// Run the page
$investor_list_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_list_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$investor_list->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var finvestor_listlist = currentForm = new ew.Form("finvestor_listlist", "list");
finvestor_listlist.formKeyCountName = '<?php echo $investor_list_list->FormKeyCountName ?>';

// Form_CustomValidate event
finvestor_listlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_listlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_listlist.lists["x_folio_no"] = <?php echo $investor_list_list->folio_no->Lookup->toClientList() ?>;
finvestor_listlist.lists["x_folio_no"].options = <?php echo JsonEncode($investor_list_list->folio_no->lookupOptions()) ?>;

// Form object for search
var finvestor_listlistsrch = currentSearchForm = new ew.Form("finvestor_listlistsrch");

// Filters
finvestor_listlistsrch.filterList = <?php echo $investor_list_list->getFilterList() ?>;

// Init search panel as collapsed
finvestor_listlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$investor_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($investor_list_list->TotalRecs > 0 && $investor_list_list->ExportOptions->visible()) { ?>
<?php $investor_list_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($investor_list_list->ImportOptions->visible()) { ?>
<?php $investor_list_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($investor_list_list->SearchOptions->visible()) { ?>
<?php $investor_list_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($investor_list_list->FilterOptions->visible()) { ?>
<?php $investor_list_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$investor_list_list->renderOtherOptions();
?>
<?php $investor_list_list->showPageHeader(); ?>
<?php
$investor_list_list->showMessage();
?>
<?php if ($investor_list_list->TotalRecs > 0 || $investor_list->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($investor_list_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> investor_list">
<?php if (!$investor_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$investor_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($investor_list_list->Pager)) $investor_list_list->Pager = new PrevNextPager($investor_list_list->StartRec, $investor_list_list->DisplayRecs, $investor_list_list->TotalRecs, $investor_list_list->AutoHidePager) ?>
<?php if ($investor_list_list->Pager->RecordCount > 0 && $investor_list_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($investor_list_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($investor_list_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $investor_list_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($investor_list_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($investor_list_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $investor_list_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($investor_list_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $investor_list_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $investor_list_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $investor_list_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($investor_list_list->TotalRecs > 0 && (!$investor_list_list->AutoHidePageSizeSelector || $investor_list_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="investor_list">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($investor_list_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($investor_list_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($investor_list_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($investor_list_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($investor_list_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($investor_list->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $investor_list_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="finvestor_listlist" id="finvestor_listlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_list_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_list_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_list">
<div id="gmp_investor_list" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($investor_list_list->TotalRecs > 0 || $investor_list->isGridEdit()) { ?>
<table id="tbl_investor_listlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$investor_list_list->RowType = ROWTYPE_HEADER;

// Render list options
$investor_list_list->renderListOptions();

// Render list options (header, left)
$investor_list_list->ListOptions->render("header", "left");
?>
<?php if ($investor_list->id->Visible) { // id ?>
	<?php if ($investor_list->sortUrl($investor_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $investor_list->id->headerCellClass() ?>"><div id="elh_investor_list_id" class="investor_list_id"><div class="ew-table-header-caption"><?php echo $investor_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $investor_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->id) ?>',2);"><div id="elh_investor_list_id" class="investor_list_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_list->share_no->Visible) { // share_no ?>
	<?php if ($investor_list->sortUrl($investor_list->share_no) == "") { ?>
		<th data-name="share_no" class="<?php echo $investor_list->share_no->headerCellClass() ?>"><div id="elh_investor_list_share_no" class="investor_list_share_no"><div class="ew-table-header-caption"><?php echo $investor_list->share_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="share_no" class="<?php echo $investor_list->share_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->share_no) ?>',2);"><div id="elh_investor_list_share_no" class="investor_list_share_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->share_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->share_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->share_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_list->folio_no->Visible) { // folio_no ?>
	<?php if ($investor_list->sortUrl($investor_list->folio_no) == "") { ?>
		<th data-name="folio_no" class="<?php echo $investor_list->folio_no->headerCellClass() ?>"><div id="elh_investor_list_folio_no" class="investor_list_folio_no"><div class="ew-table-header-caption"><?php echo $investor_list->folio_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="folio_no" class="<?php echo $investor_list->folio_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->folio_no) ?>',2);"><div id="elh_investor_list_folio_no" class="investor_list_folio_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->folio_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->folio_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->folio_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_list->qty->Visible) { // qty ?>
	<?php if ($investor_list->sortUrl($investor_list->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $investor_list->qty->headerCellClass() ?>"><div id="elh_investor_list_qty" class="investor_list_qty"><div class="ew-table-header-caption"><?php echo $investor_list->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $investor_list->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->qty) ?>',2);"><div id="elh_investor_list_qty" class="investor_list_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_list->transfer_id_old->Visible) { // transfer_id_old ?>
	<?php if ($investor_list->sortUrl($investor_list->transfer_id_old) == "") { ?>
		<th data-name="transfer_id_old" class="<?php echo $investor_list->transfer_id_old->headerCellClass() ?>"><div id="elh_investor_list_transfer_id_old" class="investor_list_transfer_id_old"><div class="ew-table-header-caption"><?php echo $investor_list->transfer_id_old->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_id_old" class="<?php echo $investor_list->transfer_id_old->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->transfer_id_old) ?>',2);"><div id="elh_investor_list_transfer_id_old" class="investor_list_transfer_id_old">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->transfer_id_old->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->transfer_id_old->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->transfer_id_old->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_list->transfer_id_new->Visible) { // transfer_id_new ?>
	<?php if ($investor_list->sortUrl($investor_list->transfer_id_new) == "") { ?>
		<th data-name="transfer_id_new" class="<?php echo $investor_list->transfer_id_new->headerCellClass() ?>"><div id="elh_investor_list_transfer_id_new" class="investor_list_transfer_id_new"><div class="ew-table-header-caption"><?php echo $investor_list->transfer_id_new->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_id_new" class="<?php echo $investor_list->transfer_id_new->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->transfer_id_new) ?>',2);"><div id="elh_investor_list_transfer_id_new" class="investor_list_transfer_id_new">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->transfer_id_new->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->transfer_id_new->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->transfer_id_new->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_list->operator->Visible) { // operator ?>
	<?php if ($investor_list->sortUrl($investor_list->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $investor_list->operator->headerCellClass() ?>"><div id="elh_investor_list_operator" class="investor_list_operator"><div class="ew-table-header-caption"><?php echo $investor_list->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $investor_list->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->operator) ?>',2);"><div id="elh_investor_list_operator" class="investor_list_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($investor_list->datetime->Visible) { // datetime ?>
	<?php if ($investor_list->sortUrl($investor_list->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $investor_list->datetime->headerCellClass() ?>"><div id="elh_investor_list_datetime" class="investor_list_datetime"><div class="ew-table-header-caption"><?php echo $investor_list->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $investor_list->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $investor_list->SortUrl($investor_list->datetime) ?>',2);"><div id="elh_investor_list_datetime" class="investor_list_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $investor_list->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($investor_list->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($investor_list->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$investor_list_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($investor_list->ExportAll && $investor_list->isExport()) {
	$investor_list_list->StopRec = $investor_list_list->TotalRecs;
} else {

	// Set the last record to display
	if ($investor_list_list->TotalRecs > $investor_list_list->StartRec + $investor_list_list->DisplayRecs - 1)
		$investor_list_list->StopRec = $investor_list_list->StartRec + $investor_list_list->DisplayRecs - 1;
	else
		$investor_list_list->StopRec = $investor_list_list->TotalRecs;
}
$investor_list_list->RecCnt = $investor_list_list->StartRec - 1;
if ($investor_list_list->Recordset && !$investor_list_list->Recordset->EOF) {
	$investor_list_list->Recordset->moveFirst();
	$selectLimit = $investor_list_list->UseSelectLimit;
	if (!$selectLimit && $investor_list_list->StartRec > 1)
		$investor_list_list->Recordset->move($investor_list_list->StartRec - 1);
} elseif (!$investor_list->AllowAddDeleteRow && $investor_list_list->StopRec == 0) {
	$investor_list_list->StopRec = $investor_list->GridAddRowCount;
}

// Initialize aggregate
$investor_list->RowType = ROWTYPE_AGGREGATEINIT;
$investor_list->resetAttributes();
$investor_list_list->renderRow();
while ($investor_list_list->RecCnt < $investor_list_list->StopRec) {
	$investor_list_list->RecCnt++;
	if ($investor_list_list->RecCnt >= $investor_list_list->StartRec) {
		$investor_list_list->RowCnt++;

		// Set up key count
		$investor_list_list->KeyCount = $investor_list_list->RowIndex;

		// Init row class and style
		$investor_list->resetAttributes();
		$investor_list->CssClass = "";
		if ($investor_list->isGridAdd()) {
		} else {
			$investor_list_list->loadRowValues($investor_list_list->Recordset); // Load row values
		}
		$investor_list->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$investor_list->RowAttrs = array_merge($investor_list->RowAttrs, array('data-rowindex'=>$investor_list_list->RowCnt, 'id'=>'r' . $investor_list_list->RowCnt . '_investor_list', 'data-rowtype'=>$investor_list->RowType));

		// Render row
		$investor_list_list->renderRow();

		// Render list options
		$investor_list_list->renderListOptions();
?>
	<tr<?php echo $investor_list->rowAttributes() ?>>
<?php

// Render list options (body, left)
$investor_list_list->ListOptions->render("body", "left", $investor_list_list->RowCnt);
?>
	<?php if ($investor_list->id->Visible) { // id ?>
		<td data-name="id"<?php echo $investor_list->id->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_id" class="investor_list_id">
<span<?php echo $investor_list->id->viewAttributes() ?>>
<?php echo $investor_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_list->share_no->Visible) { // share_no ?>
		<td data-name="share_no"<?php echo $investor_list->share_no->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_share_no" class="investor_list_share_no">
<span<?php echo $investor_list->share_no->viewAttributes() ?>>
<?php echo $investor_list->share_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_list->folio_no->Visible) { // folio_no ?>
		<td data-name="folio_no"<?php echo $investor_list->folio_no->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_folio_no" class="investor_list_folio_no">
<span<?php echo $investor_list->folio_no->viewAttributes() ?>>
<?php echo $investor_list->folio_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_list->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $investor_list->qty->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_qty" class="investor_list_qty">
<span<?php echo $investor_list->qty->viewAttributes() ?>>
<?php echo $investor_list->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_list->transfer_id_old->Visible) { // transfer_id_old ?>
		<td data-name="transfer_id_old"<?php echo $investor_list->transfer_id_old->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_transfer_id_old" class="investor_list_transfer_id_old">
<span<?php echo $investor_list->transfer_id_old->viewAttributes() ?>>
<?php echo $investor_list->transfer_id_old->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_list->transfer_id_new->Visible) { // transfer_id_new ?>
		<td data-name="transfer_id_new"<?php echo $investor_list->transfer_id_new->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_transfer_id_new" class="investor_list_transfer_id_new">
<span<?php echo $investor_list->transfer_id_new->viewAttributes() ?>>
<?php echo $investor_list->transfer_id_new->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_list->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $investor_list->operator->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_operator" class="investor_list_operator">
<span<?php echo $investor_list->operator->viewAttributes() ?>>
<?php echo $investor_list->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($investor_list->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $investor_list->datetime->cellAttributes() ?>>
<span id="el<?php echo $investor_list_list->RowCnt ?>_investor_list_datetime" class="investor_list_datetime">
<span<?php echo $investor_list->datetime->viewAttributes() ?>>
<?php echo $investor_list->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$investor_list_list->ListOptions->render("body", "right", $investor_list_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$investor_list->isGridAdd())
		$investor_list_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$investor_list->RowType = ROWTYPE_AGGREGATE;
$investor_list->resetAttributes();
$investor_list_list->renderRow();
?>
<?php if ($investor_list_list->TotalRecs > 0 && !$investor_list->isGridAdd() && !$investor_list->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$investor_list_list->renderListOptions();

// Render list options (footer, left)
$investor_list_list->ListOptions->render("footer", "left");
?>
	<?php if ($investor_list->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $investor_list->id->footerCellClass() ?>"><span id="elf_investor_list_id" class="investor_list_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_list->share_no->Visible) { // share_no ?>
		<td data-name="share_no" class="<?php echo $investor_list->share_no->footerCellClass() ?>"><span id="elf_investor_list_share_no" class="investor_list_share_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_list->folio_no->Visible) { // folio_no ?>
		<td data-name="folio_no" class="<?php echo $investor_list->folio_no->footerCellClass() ?>"><span id="elf_investor_list_folio_no" class="investor_list_folio_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_list->qty->Visible) { // qty ?>
		<td data-name="qty" class="<?php echo $investor_list->qty->footerCellClass() ?>"><span id="elf_investor_list_qty" class="investor_list_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $investor_list->qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($investor_list->transfer_id_old->Visible) { // transfer_id_old ?>
		<td data-name="transfer_id_old" class="<?php echo $investor_list->transfer_id_old->footerCellClass() ?>"><span id="elf_investor_list_transfer_id_old" class="investor_list_transfer_id_old">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_list->transfer_id_new->Visible) { // transfer_id_new ?>
		<td data-name="transfer_id_new" class="<?php echo $investor_list->transfer_id_new->footerCellClass() ?>"><span id="elf_investor_list_transfer_id_new" class="investor_list_transfer_id_new">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_list->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $investor_list->operator->footerCellClass() ?>"><span id="elf_investor_list_operator" class="investor_list_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($investor_list->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $investor_list->datetime->footerCellClass() ?>"><span id="elf_investor_list_datetime" class="investor_list_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$investor_list_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$investor_list->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($investor_list_list->Recordset)
	$investor_list_list->Recordset->Close();
?>
<?php if (!$investor_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$investor_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($investor_list_list->Pager)) $investor_list_list->Pager = new PrevNextPager($investor_list_list->StartRec, $investor_list_list->DisplayRecs, $investor_list_list->TotalRecs, $investor_list_list->AutoHidePager) ?>
<?php if ($investor_list_list->Pager->RecordCount > 0 && $investor_list_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($investor_list_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($investor_list_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $investor_list_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($investor_list_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($investor_list_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $investor_list_list->pageUrl() ?>start=<?php echo $investor_list_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $investor_list_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($investor_list_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $investor_list_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $investor_list_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $investor_list_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($investor_list_list->TotalRecs > 0 && (!$investor_list_list->AutoHidePageSizeSelector || $investor_list_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="investor_list">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($investor_list_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($investor_list_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($investor_list_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($investor_list_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($investor_list_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($investor_list->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $investor_list_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($investor_list_list->TotalRecs == 0 && !$investor_list->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $investor_list_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$investor_list_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$investor_list->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$investor_list->isExport()) { ?>
<script>
ew.scrollableTable("gmp_investor_list", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$investor_list_list->terminate();
?>