<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_list_search = new investor_list_search();

// Run the page
$investor_list_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_list_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($investor_list_search->IsModal) { ?>
var finvestor_listsearch = currentAdvancedSearchForm = new ew.Form("finvestor_listsearch", "search");
<?php } else { ?>
var finvestor_listsearch = currentForm = new ew.Form("finvestor_listsearch", "search");
<?php } ?>

// Form_CustomValidate event
finvestor_listsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_listsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_listsearch.lists["x_folio_no"] = <?php echo $investor_list_search->folio_no->Lookup->toClientList() ?>;
finvestor_listsearch.lists["x_folio_no"].options = <?php echo JsonEncode($investor_list_search->folio_no->lookupOptions()) ?>;

// Form object for search
// Validate function for search

finvestor_listsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_list->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_share_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_list->share_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_list->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_transfer_id_old");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_list->transfer_id_old->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_transfer_id_new");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_list->transfer_id_new->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_list->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($investor_list->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $investor_list_search->showPageHeader(); ?>
<?php
$investor_list_search->showMessage();
?>
<form name="finvestor_listsearch" id="finvestor_listsearch" class="<?php echo $investor_list_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_list_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_list_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_list">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$investor_list_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($investor_list->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_id"><?php echo $investor_list->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->id->cellAttributes() ?>>
			<span id="el_investor_list_id">
<input type="text" data-table="investor_list" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($investor_list->id->getPlaceHolder()) ?>" value="<?php echo $investor_list->id->EditValue ?>"<?php echo $investor_list->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_list->share_no->Visible) { // share_no ?>
	<div id="r_share_no" class="form-group row">
		<label for="x_share_no" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_share_no"><?php echo $investor_list->share_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_share_no" id="z_share_no" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->share_no->cellAttributes() ?>>
			<span id="el_investor_list_share_no">
<input type="text" data-table="investor_list" data-field="x_share_no" name="x_share_no" id="x_share_no" size="30" placeholder="<?php echo HtmlEncode($investor_list->share_no->getPlaceHolder()) ?>" value="<?php echo $investor_list->share_no->EditValue ?>"<?php echo $investor_list->share_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_list->folio_no->Visible) { // folio_no ?>
	<div id="r_folio_no" class="form-group row">
		<label for="x_folio_no" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_folio_no"><?php echo $investor_list->folio_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_folio_no" id="z_folio_no" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->folio_no->cellAttributes() ?>>
			<span id="el_investor_list_folio_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="investor_list" data-field="x_folio_no" data-value-separator="<?php echo $investor_list->folio_no->displayValueSeparatorAttribute() ?>" id="x_folio_no" name="x_folio_no"<?php echo $investor_list->folio_no->editAttributes() ?>>
		<?php echo $investor_list->folio_no->selectOptionListHtml("x_folio_no") ?>
	</select>
</div>
<?php echo $investor_list->folio_no->Lookup->getParamTag("p_x_folio_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_list->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_qty"><?php echo $investor_list->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->qty->cellAttributes() ?>>
			<span id="el_investor_list_qty">
<input type="text" data-table="investor_list" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($investor_list->qty->getPlaceHolder()) ?>" value="<?php echo $investor_list->qty->EditValue ?>"<?php echo $investor_list->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_list->transfer_id_old->Visible) { // transfer_id_old ?>
	<div id="r_transfer_id_old" class="form-group row">
		<label for="x_transfer_id_old" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_transfer_id_old"><?php echo $investor_list->transfer_id_old->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_transfer_id_old" id="z_transfer_id_old" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->transfer_id_old->cellAttributes() ?>>
			<span id="el_investor_list_transfer_id_old">
<input type="text" data-table="investor_list" data-field="x_transfer_id_old" name="x_transfer_id_old" id="x_transfer_id_old" size="30" placeholder="<?php echo HtmlEncode($investor_list->transfer_id_old->getPlaceHolder()) ?>" value="<?php echo $investor_list->transfer_id_old->EditValue ?>"<?php echo $investor_list->transfer_id_old->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_list->transfer_id_new->Visible) { // transfer_id_new ?>
	<div id="r_transfer_id_new" class="form-group row">
		<label for="x_transfer_id_new" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_transfer_id_new"><?php echo $investor_list->transfer_id_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_transfer_id_new" id="z_transfer_id_new" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->transfer_id_new->cellAttributes() ?>>
			<span id="el_investor_list_transfer_id_new">
<input type="text" data-table="investor_list" data-field="x_transfer_id_new" name="x_transfer_id_new" id="x_transfer_id_new" size="30" placeholder="<?php echo HtmlEncode($investor_list->transfer_id_new->getPlaceHolder()) ?>" value="<?php echo $investor_list->transfer_id_new->EditValue ?>"<?php echo $investor_list->transfer_id_new->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_list->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_operator"><?php echo $investor_list->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->operator->cellAttributes() ?>>
			<span id="el_investor_list_operator">
<input type="text" data-table="investor_list" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($investor_list->operator->getPlaceHolder()) ?>" value="<?php echo $investor_list->operator->EditValue ?>"<?php echo $investor_list->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($investor_list->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $investor_list_search->LeftColumnClass ?>"><span id="elh_investor_list_datetime"><?php echo $investor_list->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $investor_list_search->RightColumnClass ?>"><div<?php echo $investor_list->datetime->cellAttributes() ?>>
			<span id="el_investor_list_datetime">
<input type="text" data-table="investor_list" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($investor_list->datetime->getPlaceHolder()) ?>" value="<?php echo $investor_list->datetime->EditValue ?>"<?php echo $investor_list->datetime->editAttributes() ?>>
<?php if (!$investor_list->datetime->ReadOnly && !$investor_list->datetime->Disabled && !isset($investor_list->datetime->EditAttrs["readonly"]) && !isset($investor_list->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvestor_listsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$investor_list_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $investor_list_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$investor_list_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$investor_list_search->terminate();
?>