<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$investor_list_view = new investor_list_view();

// Run the page
$investor_list_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$investor_list_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$investor_list->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var finvestor_listview = currentForm = new ew.Form("finvestor_listview", "view");

// Form_CustomValidate event
finvestor_listview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvestor_listview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvestor_listview.lists["x_folio_no"] = <?php echo $investor_list_view->folio_no->Lookup->toClientList() ?>;
finvestor_listview.lists["x_folio_no"].options = <?php echo JsonEncode($investor_list_view->folio_no->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$investor_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $investor_list_view->ExportOptions->render("body") ?>
<?php $investor_list_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $investor_list_view->showPageHeader(); ?>
<?php
$investor_list_view->showMessage();
?>
<form name="finvestor_listview" id="finvestor_listview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($investor_list_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $investor_list_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="investor_list">
<input type="hidden" name="modal" value="<?php echo (int)$investor_list_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($investor_list->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_id"><?php echo $investor_list->id->caption() ?></span></td>
		<td data-name="id"<?php echo $investor_list->id->cellAttributes() ?>>
<span id="el_investor_list_id">
<span<?php echo $investor_list->id->viewAttributes() ?>>
<?php echo $investor_list->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_list->share_no->Visible) { // share_no ?>
	<tr id="r_share_no">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_share_no"><?php echo $investor_list->share_no->caption() ?></span></td>
		<td data-name="share_no"<?php echo $investor_list->share_no->cellAttributes() ?>>
<span id="el_investor_list_share_no">
<span<?php echo $investor_list->share_no->viewAttributes() ?>>
<?php echo $investor_list->share_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_list->folio_no->Visible) { // folio_no ?>
	<tr id="r_folio_no">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_folio_no"><?php echo $investor_list->folio_no->caption() ?></span></td>
		<td data-name="folio_no"<?php echo $investor_list->folio_no->cellAttributes() ?>>
<span id="el_investor_list_folio_no">
<span<?php echo $investor_list->folio_no->viewAttributes() ?>>
<?php echo $investor_list->folio_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_list->qty->Visible) { // qty ?>
	<tr id="r_qty">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_qty"><?php echo $investor_list->qty->caption() ?></span></td>
		<td data-name="qty"<?php echo $investor_list->qty->cellAttributes() ?>>
<span id="el_investor_list_qty">
<span<?php echo $investor_list->qty->viewAttributes() ?>>
<?php echo $investor_list->qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_list->transfer_id_old->Visible) { // transfer_id_old ?>
	<tr id="r_transfer_id_old">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_transfer_id_old"><?php echo $investor_list->transfer_id_old->caption() ?></span></td>
		<td data-name="transfer_id_old"<?php echo $investor_list->transfer_id_old->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_old">
<span<?php echo $investor_list->transfer_id_old->viewAttributes() ?>>
<?php echo $investor_list->transfer_id_old->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_list->transfer_id_new->Visible) { // transfer_id_new ?>
	<tr id="r_transfer_id_new">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_transfer_id_new"><?php echo $investor_list->transfer_id_new->caption() ?></span></td>
		<td data-name="transfer_id_new"<?php echo $investor_list->transfer_id_new->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_new">
<span<?php echo $investor_list->transfer_id_new->viewAttributes() ?>>
<?php echo $investor_list->transfer_id_new->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_list->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_operator"><?php echo $investor_list->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $investor_list->operator->cellAttributes() ?>>
<span id="el_investor_list_operator">
<span<?php echo $investor_list->operator->viewAttributes() ?>>
<?php echo $investor_list->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($investor_list->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $investor_list_view->TableLeftColumnClass ?>"><span id="elh_investor_list_datetime"><?php echo $investor_list->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $investor_list->datetime->cellAttributes() ?>>
<span id="el_investor_list_datetime">
<span<?php echo $investor_list->datetime->viewAttributes() ?>>
<?php echo $investor_list->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$investor_list_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$investor_list->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$investor_list_view->terminate();
?>