<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$invoice_details_add = new invoice_details_add();

// Run the page
$invoice_details_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$invoice_details_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var finvoice_detailsadd = currentForm = new ew.Form("finvoice_detailsadd", "add");

// Validate form
finvoice_detailsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($invoice_details_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->_barcode->caption(), $invoice_details->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->exporter->Required) { ?>
			elm = this.getElements("x" + infix + "_exporter");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->exporter->caption(), $invoice_details->exporter->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->consignee->Required) { ?>
			elm = this.getElements("x" + infix + "_consignee");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->consignee->caption(), $invoice_details->consignee->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->consignee_other->Required) { ?>
			elm = this.getElements("x" + infix + "_consignee_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->consignee_other->caption(), $invoice_details->consignee_other->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->packing_list_no->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_list_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->packing_list_no->caption(), $invoice_details->packing_list_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->d_11->Required) { ?>
			elm = this.getElements("x" + infix + "_d_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->d_11->caption(), $invoice_details->d_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->description_11->Required) { ?>
			elm = this.getElements("x" + infix + "_description_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->description_11->caption(), $invoice_details->description_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->in_template->Required) { ?>
			elm = this.getElements("x" + infix + "_in_template");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->in_template->caption(), $invoice_details->in_template->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->pl_template->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_template");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->pl_template->caption(), $invoice_details->pl_template->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->invoice_no->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->invoice_no->caption(), $invoice_details->invoice_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->invoice_date->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->invoice_date->caption(), $invoice_details->invoice_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($invoice_details->invoice_date->errorMessage()) ?>");
		<?php if ($invoice_details_add->po_no->Required) { ?>
			elm = this.getElements("x" + infix + "_po_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->po_no->caption(), $invoice_details->po_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->other_reference->Required) { ?>
			elm = this.getElements("x" + infix + "_other_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->other_reference->caption(), $invoice_details->other_reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->origin->Required) { ?>
			elm = this.getElements("x" + infix + "_origin");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->origin->caption(), $invoice_details->origin->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->final_destination->Required) { ?>
			elm = this.getElements("x" + infix + "_final_destination");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->final_destination->caption(), $invoice_details->final_destination->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->payment_terms->caption(), $invoice_details->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->pre_carriage_receipt->Required) { ?>
			elm = this.getElements("x" + infix + "_pre_carriage_receipt");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->pre_carriage_receipt->caption(), $invoice_details->pre_carriage_receipt->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->place_of_receipt->Required) { ?>
			elm = this.getElements("x" + infix + "_place_of_receipt");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->place_of_receipt->caption(), $invoice_details->place_of_receipt->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->loading_port->Required) { ?>
			elm = this.getElements("x" + infix + "_loading_port");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->loading_port->caption(), $invoice_details->loading_port->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->port_discharge->Required) { ?>
			elm = this.getElements("x" + infix + "_port_discharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->port_discharge->caption(), $invoice_details->port_discharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->d_01->Required) { ?>
			elm = this.getElements("x" + infix + "_d_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->d_01->caption(), $invoice_details->d_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_description_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->description_01->caption(), $invoice_details->description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->d_02->Required) { ?>
			elm = this.getElements("x" + infix + "_d_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->d_02->caption(), $invoice_details->d_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_description_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->description_02->caption(), $invoice_details->description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->gross_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_gross_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->gross_weight->caption(), $invoice_details->gross_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->nett_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_nett_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->nett_weight->caption(), $invoice_details->nett_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->cbm->caption(), $invoice_details->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->exporter_bank_details->Required) { ?>
			elm = this.getElements("x" + infix + "_exporter_bank_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->exporter_bank_details->caption(), $invoice_details->exporter_bank_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->intermediary_bank->Required) { ?>
			elm = this.getElements("x" + infix + "_intermediary_bank");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->intermediary_bank->caption(), $invoice_details->intermediary_bank->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->shipment_mode->Required) { ?>
			elm = this.getElements("x" + infix + "_shipment_mode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->shipment_mode->caption(), $invoice_details->shipment_mode->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_shipment_mode");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($invoice_details->shipment_mode->errorMessage()) ?>");
		<?php if ($invoice_details_add->ex_factory_date->Required) { ?>
			elm = this.getElements("x" + infix + "_ex_factory_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->ex_factory_date->caption(), $invoice_details->ex_factory_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ex_factory_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($invoice_details->ex_factory_date->errorMessage()) ?>");
		<?php if ($invoice_details_add->sailing_date->Required) { ?>
			elm = this.getElements("x" + infix + "_sailing_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->sailing_date->caption(), $invoice_details->sailing_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sailing_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($invoice_details->sailing_date->errorMessage()) ?>");
		<?php if ($invoice_details_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->operator->caption(), $invoice_details->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->datetime->caption(), $invoice_details->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->cart_lines->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_lines");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->cart_lines->caption(), $invoice_details->cart_lines->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cart_lines");
			if (elm && !ew.checkByRegEx(elm.value, /^([0-9,]){5,5}$/))
				return this.onError(elm, "<?php echo JsEncode($invoice_details->cart_lines->errorMessage()) ?>");
		<?php if ($invoice_details_add->pl_lines->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_lines");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->pl_lines->caption(), $invoice_details->pl_lines->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pl_lines");
			if (elm && !ew.checkByRegEx(elm.value, /^([0-9,]){5,5}$/))
				return this.onError(elm, "<?php echo JsEncode($invoice_details->pl_lines->errorMessage()) ?>");
		<?php if ($invoice_details_add->freezed->Required) { ?>
			elm = this.getElements("x" + infix + "_freezed");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->freezed->caption(), $invoice_details->freezed->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->port_delivery->Required) { ?>
			elm = this.getElements("x" + infix + "_port_delivery");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->port_delivery->caption(), $invoice_details->port_delivery->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($invoice_details_add->dispatch_details->Required) { ?>
			elm = this.getElements("x" + infix + "_dispatch_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $invoice_details->dispatch_details->caption(), $invoice_details->dispatch_details->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
finvoice_detailsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvoice_detailsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvoice_detailsadd.lists["x_exporter"] = <?php echo $invoice_details_add->exporter->Lookup->toClientList() ?>;
finvoice_detailsadd.lists["x_exporter"].options = <?php echo JsonEncode($invoice_details_add->exporter->lookupOptions()) ?>;
finvoice_detailsadd.lists["x_consignee"] = <?php echo $invoice_details_add->consignee->Lookup->toClientList() ?>;
finvoice_detailsadd.lists["x_consignee"].options = <?php echo JsonEncode($invoice_details_add->consignee->lookupOptions()) ?>;
finvoice_detailsadd.lists["x_consignee_other"] = <?php echo $invoice_details_add->consignee_other->Lookup->toClientList() ?>;
finvoice_detailsadd.lists["x_consignee_other"].options = <?php echo JsonEncode($invoice_details_add->consignee_other->lookupOptions()) ?>;
finvoice_detailsadd.lists["x_packing_list_no"] = <?php echo $invoice_details_add->packing_list_no->Lookup->toClientList() ?>;
finvoice_detailsadd.lists["x_packing_list_no"].options = <?php echo JsonEncode($invoice_details_add->packing_list_no->lookupOptions()) ?>;
finvoice_detailsadd.lists["x_in_template"] = <?php echo $invoice_details_add->in_template->Lookup->toClientList() ?>;
finvoice_detailsadd.lists["x_in_template"].options = <?php echo JsonEncode($invoice_details_add->in_template->lookupOptions()) ?>;
finvoice_detailsadd.lists["x_pl_template"] = <?php echo $invoice_details_add->pl_template->Lookup->toClientList() ?>;
finvoice_detailsadd.lists["x_pl_template"].options = <?php echo JsonEncode($invoice_details_add->pl_template->lookupOptions()) ?>;
finvoice_detailsadd.lists["x_freezed"] = <?php echo $invoice_details_add->freezed->Lookup->toClientList() ?>;
finvoice_detailsadd.lists["x_freezed"].options = <?php echo JsonEncode($invoice_details_add->freezed->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $invoice_details_add->showPageHeader(); ?>
<?php
$invoice_details_add->showMessage();
?>
<form name="finvoice_detailsadd" id="finvoice_detailsadd" class="<?php echo $invoice_details_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($invoice_details_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $invoice_details_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="invoice_details">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$invoice_details_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($invoice_details->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_invoice_details__barcode" for="x__barcode" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->_barcode->caption() ?><?php echo ($invoice_details->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->_barcode->cellAttributes() ?>>
<span id="el_invoice_details__barcode">
<textarea data-table="invoice_details" data-field="x__barcode" name="x__barcode" id="x__barcode" cols="35" rows="4" placeholder="<?php echo HtmlEncode($invoice_details->_barcode->getPlaceHolder()) ?>"<?php echo $invoice_details->_barcode->editAttributes() ?>><?php echo $invoice_details->_barcode->EditValue ?></textarea>
</span>
<?php echo $invoice_details->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->exporter->Visible) { // exporter ?>
	<div id="r_exporter" class="form-group row">
		<label id="elh_invoice_details_exporter" for="x_exporter" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->exporter->caption() ?><?php echo ($invoice_details->exporter->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->exporter->cellAttributes() ?>>
<span id="el_invoice_details_exporter">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_exporter" data-value-separator="<?php echo $invoice_details->exporter->displayValueSeparatorAttribute() ?>" id="x_exporter" name="x_exporter"<?php echo $invoice_details->exporter->editAttributes() ?>>
		<?php echo $invoice_details->exporter->selectOptionListHtml("x_exporter") ?>
	</select>
</div>
<?php echo $invoice_details->exporter->Lookup->getParamTag("p_x_exporter") ?>
</span>
<?php echo $invoice_details->exporter->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->consignee->Visible) { // consignee ?>
	<div id="r_consignee" class="form-group row">
		<label id="elh_invoice_details_consignee" for="x_consignee" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->consignee->caption() ?><?php echo ($invoice_details->consignee->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->consignee->cellAttributes() ?>>
<span id="el_invoice_details_consignee">
<?php $invoice_details->consignee->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$invoice_details->consignee->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_consignee" data-value-separator="<?php echo $invoice_details->consignee->displayValueSeparatorAttribute() ?>" id="x_consignee" name="x_consignee"<?php echo $invoice_details->consignee->editAttributes() ?>>
		<?php echo $invoice_details->consignee->selectOptionListHtml("x_consignee") ?>
	</select>
</div>
<?php echo $invoice_details->consignee->Lookup->getParamTag("p_x_consignee") ?>
</span>
<?php echo $invoice_details->consignee->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->consignee_other->Visible) { // consignee_other ?>
	<div id="r_consignee_other" class="form-group row">
		<label id="elh_invoice_details_consignee_other" for="x_consignee_other" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->consignee_other->caption() ?><?php echo ($invoice_details->consignee_other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->consignee_other->cellAttributes() ?>>
<span id="el_invoice_details_consignee_other">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_consignee_other" data-value-separator="<?php echo $invoice_details->consignee_other->displayValueSeparatorAttribute() ?>" id="x_consignee_other" name="x_consignee_other"<?php echo $invoice_details->consignee_other->editAttributes() ?>>
		<?php echo $invoice_details->consignee_other->selectOptionListHtml("x_consignee_other") ?>
	</select>
</div>
<?php echo $invoice_details->consignee_other->Lookup->getParamTag("p_x_consignee_other") ?>
</span>
<?php echo $invoice_details->consignee_other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->packing_list_no->Visible) { // packing_list_no ?>
	<div id="r_packing_list_no" class="form-group row">
		<label id="elh_invoice_details_packing_list_no" for="x_packing_list_no" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->packing_list_no->caption() ?><?php echo ($invoice_details->packing_list_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->packing_list_no->cellAttributes() ?>>
<span id="el_invoice_details_packing_list_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_packing_list_no" data-value-separator="<?php echo $invoice_details->packing_list_no->displayValueSeparatorAttribute() ?>" id="x_packing_list_no" name="x_packing_list_no"<?php echo $invoice_details->packing_list_no->editAttributes() ?>>
		<?php echo $invoice_details->packing_list_no->selectOptionListHtml("x_packing_list_no") ?>
	</select>
</div>
<?php echo $invoice_details->packing_list_no->Lookup->getParamTag("p_x_packing_list_no") ?>
</span>
<?php echo $invoice_details->packing_list_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->d_11->Visible) { // d_11 ?>
	<div id="r_d_11" class="form-group row">
		<label id="elh_invoice_details_d_11" for="x_d_11" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->d_11->caption() ?><?php echo ($invoice_details->d_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->d_11->cellAttributes() ?>>
<span id="el_invoice_details_d_11">
<input type="text" data-table="invoice_details" data-field="x_d_11" name="x_d_11" id="x_d_11" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->d_11->getPlaceHolder()) ?>" value="<?php echo $invoice_details->d_11->EditValue ?>"<?php echo $invoice_details->d_11->editAttributes() ?>>
</span>
<?php echo $invoice_details->d_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label id="elh_invoice_details_description_11" for="x_description_11" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->description_11->caption() ?><?php echo ($invoice_details->description_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->description_11->cellAttributes() ?>>
<span id="el_invoice_details_description_11">
<textarea data-table="invoice_details" data-field="x_description_11" name="x_description_11" id="x_description_11" cols="35" rows="4" placeholder="<?php echo HtmlEncode($invoice_details->description_11->getPlaceHolder()) ?>"<?php echo $invoice_details->description_11->editAttributes() ?>><?php echo $invoice_details->description_11->EditValue ?></textarea>
</span>
<?php echo $invoice_details->description_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->in_template->Visible) { // in_template ?>
	<div id="r_in_template" class="form-group row">
		<label id="elh_invoice_details_in_template" for="x_in_template" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->in_template->caption() ?><?php echo ($invoice_details->in_template->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->in_template->cellAttributes() ?>>
<span id="el_invoice_details_in_template">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_in_template" data-value-separator="<?php echo $invoice_details->in_template->displayValueSeparatorAttribute() ?>" id="x_in_template" name="x_in_template"<?php echo $invoice_details->in_template->editAttributes() ?>>
		<?php echo $invoice_details->in_template->selectOptionListHtml("x_in_template") ?>
	</select>
</div>
<?php echo $invoice_details->in_template->Lookup->getParamTag("p_x_in_template") ?>
</span>
<?php echo $invoice_details->in_template->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->pl_template->Visible) { // pl_template ?>
	<div id="r_pl_template" class="form-group row">
		<label id="elh_invoice_details_pl_template" for="x_pl_template" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->pl_template->caption() ?><?php echo ($invoice_details->pl_template->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->pl_template->cellAttributes() ?>>
<span id="el_invoice_details_pl_template">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_pl_template" data-value-separator="<?php echo $invoice_details->pl_template->displayValueSeparatorAttribute() ?>" id="x_pl_template" name="x_pl_template"<?php echo $invoice_details->pl_template->editAttributes() ?>>
		<?php echo $invoice_details->pl_template->selectOptionListHtml("x_pl_template") ?>
	</select>
</div>
<?php echo $invoice_details->pl_template->Lookup->getParamTag("p_x_pl_template") ?>
</span>
<?php echo $invoice_details->pl_template->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->invoice_no->Visible) { // invoice_no ?>
	<div id="r_invoice_no" class="form-group row">
		<label id="elh_invoice_details_invoice_no" for="x_invoice_no" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->invoice_no->caption() ?><?php echo ($invoice_details->invoice_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->invoice_no->cellAttributes() ?>>
<span id="el_invoice_details_invoice_no">
<input type="text" data-table="invoice_details" data-field="x_invoice_no" name="x_invoice_no" id="x_invoice_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->invoice_no->getPlaceHolder()) ?>" value="<?php echo $invoice_details->invoice_no->EditValue ?>"<?php echo $invoice_details->invoice_no->editAttributes() ?>>
</span>
<?php echo $invoice_details->invoice_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label id="elh_invoice_details_invoice_date" for="x_invoice_date" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->invoice_date->caption() ?><?php echo ($invoice_details->invoice_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->invoice_date->cellAttributes() ?>>
<span id="el_invoice_details_invoice_date">
<input type="text" data-table="invoice_details" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($invoice_details->invoice_date->getPlaceHolder()) ?>" value="<?php echo $invoice_details->invoice_date->EditValue ?>"<?php echo $invoice_details->invoice_date->editAttributes() ?>>
<?php if (!$invoice_details->invoice_date->ReadOnly && !$invoice_details->invoice_date->Disabled && !isset($invoice_details->invoice_date->EditAttrs["readonly"]) && !isset($invoice_details->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvoice_detailsadd", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $invoice_details->invoice_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->po_no->Visible) { // po_no ?>
	<div id="r_po_no" class="form-group row">
		<label id="elh_invoice_details_po_no" for="x_po_no" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->po_no->caption() ?><?php echo ($invoice_details->po_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->po_no->cellAttributes() ?>>
<span id="el_invoice_details_po_no">
<textarea data-table="invoice_details" data-field="x_po_no" name="x_po_no" id="x_po_no" cols="35" rows="3" placeholder="<?php echo HtmlEncode($invoice_details->po_no->getPlaceHolder()) ?>"<?php echo $invoice_details->po_no->editAttributes() ?>><?php echo $invoice_details->po_no->EditValue ?></textarea>
</span>
<?php echo $invoice_details->po_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->other_reference->Visible) { // other_reference ?>
	<div id="r_other_reference" class="form-group row">
		<label id="elh_invoice_details_other_reference" for="x_other_reference" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->other_reference->caption() ?><?php echo ($invoice_details->other_reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->other_reference->cellAttributes() ?>>
<span id="el_invoice_details_other_reference">
<input type="text" data-table="invoice_details" data-field="x_other_reference" name="x_other_reference" id="x_other_reference" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->other_reference->getPlaceHolder()) ?>" value="<?php echo $invoice_details->other_reference->EditValue ?>"<?php echo $invoice_details->other_reference->editAttributes() ?>>
</span>
<?php echo $invoice_details->other_reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->origin->Visible) { // origin ?>
	<div id="r_origin" class="form-group row">
		<label id="elh_invoice_details_origin" for="x_origin" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->origin->caption() ?><?php echo ($invoice_details->origin->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->origin->cellAttributes() ?>>
<span id="el_invoice_details_origin">
<input type="text" data-table="invoice_details" data-field="x_origin" name="x_origin" id="x_origin" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($invoice_details->origin->getPlaceHolder()) ?>" value="<?php echo $invoice_details->origin->EditValue ?>"<?php echo $invoice_details->origin->editAttributes() ?>>
</span>
<?php echo $invoice_details->origin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->final_destination->Visible) { // final_destination ?>
	<div id="r_final_destination" class="form-group row">
		<label id="elh_invoice_details_final_destination" for="x_final_destination" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->final_destination->caption() ?><?php echo ($invoice_details->final_destination->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->final_destination->cellAttributes() ?>>
<span id="el_invoice_details_final_destination">
<input type="text" data-table="invoice_details" data-field="x_final_destination" name="x_final_destination" id="x_final_destination" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->final_destination->getPlaceHolder()) ?>" value="<?php echo $invoice_details->final_destination->EditValue ?>"<?php echo $invoice_details->final_destination->editAttributes() ?>>
</span>
<?php echo $invoice_details->final_destination->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label id="elh_invoice_details_payment_terms" for="x_payment_terms" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->payment_terms->caption() ?><?php echo ($invoice_details->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->payment_terms->cellAttributes() ?>>
<span id="el_invoice_details_payment_terms">
<textarea data-table="invoice_details" data-field="x_payment_terms" name="x_payment_terms" id="x_payment_terms" cols="35" rows="4" placeholder="<?php echo HtmlEncode($invoice_details->payment_terms->getPlaceHolder()) ?>"<?php echo $invoice_details->payment_terms->editAttributes() ?>><?php echo $invoice_details->payment_terms->EditValue ?></textarea>
</span>
<?php echo $invoice_details->payment_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
	<div id="r_pre_carriage_receipt" class="form-group row">
		<label id="elh_invoice_details_pre_carriage_receipt" for="x_pre_carriage_receipt" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->pre_carriage_receipt->caption() ?><?php echo ($invoice_details->pre_carriage_receipt->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->pre_carriage_receipt->cellAttributes() ?>>
<span id="el_invoice_details_pre_carriage_receipt">
<input type="text" data-table="invoice_details" data-field="x_pre_carriage_receipt" name="x_pre_carriage_receipt" id="x_pre_carriage_receipt" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->pre_carriage_receipt->getPlaceHolder()) ?>" value="<?php echo $invoice_details->pre_carriage_receipt->EditValue ?>"<?php echo $invoice_details->pre_carriage_receipt->editAttributes() ?>>
</span>
<?php echo $invoice_details->pre_carriage_receipt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->place_of_receipt->Visible) { // place_of_receipt ?>
	<div id="r_place_of_receipt" class="form-group row">
		<label id="elh_invoice_details_place_of_receipt" for="x_place_of_receipt" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->place_of_receipt->caption() ?><?php echo ($invoice_details->place_of_receipt->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->place_of_receipt->cellAttributes() ?>>
<span id="el_invoice_details_place_of_receipt">
<input type="text" data-table="invoice_details" data-field="x_place_of_receipt" name="x_place_of_receipt" id="x_place_of_receipt" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->place_of_receipt->getPlaceHolder()) ?>" value="<?php echo $invoice_details->place_of_receipt->EditValue ?>"<?php echo $invoice_details->place_of_receipt->editAttributes() ?>>
</span>
<?php echo $invoice_details->place_of_receipt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->loading_port->Visible) { // loading_port ?>
	<div id="r_loading_port" class="form-group row">
		<label id="elh_invoice_details_loading_port" for="x_loading_port" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->loading_port->caption() ?><?php echo ($invoice_details->loading_port->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->loading_port->cellAttributes() ?>>
<span id="el_invoice_details_loading_port">
<input type="text" data-table="invoice_details" data-field="x_loading_port" name="x_loading_port" id="x_loading_port" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->loading_port->getPlaceHolder()) ?>" value="<?php echo $invoice_details->loading_port->EditValue ?>"<?php echo $invoice_details->loading_port->editAttributes() ?>>
</span>
<?php echo $invoice_details->loading_port->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->port_discharge->Visible) { // port_discharge ?>
	<div id="r_port_discharge" class="form-group row">
		<label id="elh_invoice_details_port_discharge" for="x_port_discharge" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->port_discharge->caption() ?><?php echo ($invoice_details->port_discharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->port_discharge->cellAttributes() ?>>
<span id="el_invoice_details_port_discharge">
<input type="text" data-table="invoice_details" data-field="x_port_discharge" name="x_port_discharge" id="x_port_discharge" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->port_discharge->getPlaceHolder()) ?>" value="<?php echo $invoice_details->port_discharge->EditValue ?>"<?php echo $invoice_details->port_discharge->editAttributes() ?>>
</span>
<?php echo $invoice_details->port_discharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->d_01->Visible) { // d_01 ?>
	<div id="r_d_01" class="form-group row">
		<label id="elh_invoice_details_d_01" for="x_d_01" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->d_01->caption() ?><?php echo ($invoice_details->d_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->d_01->cellAttributes() ?>>
<span id="el_invoice_details_d_01">
<input type="text" data-table="invoice_details" data-field="x_d_01" name="x_d_01" id="x_d_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->d_01->getPlaceHolder()) ?>" value="<?php echo $invoice_details->d_01->EditValue ?>"<?php echo $invoice_details->d_01->editAttributes() ?>>
</span>
<?php echo $invoice_details->d_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label id="elh_invoice_details_description_01" for="x_description_01" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->description_01->caption() ?><?php echo ($invoice_details->description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->description_01->cellAttributes() ?>>
<span id="el_invoice_details_description_01">
<input type="text" data-table="invoice_details" data-field="x_description_01" name="x_description_01" id="x_description_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->description_01->getPlaceHolder()) ?>" value="<?php echo $invoice_details->description_01->EditValue ?>"<?php echo $invoice_details->description_01->editAttributes() ?>>
</span>
<?php echo $invoice_details->description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->d_02->Visible) { // d_02 ?>
	<div id="r_d_02" class="form-group row">
		<label id="elh_invoice_details_d_02" for="x_d_02" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->d_02->caption() ?><?php echo ($invoice_details->d_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->d_02->cellAttributes() ?>>
<span id="el_invoice_details_d_02">
<input type="text" data-table="invoice_details" data-field="x_d_02" name="x_d_02" id="x_d_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->d_02->getPlaceHolder()) ?>" value="<?php echo $invoice_details->d_02->EditValue ?>"<?php echo $invoice_details->d_02->editAttributes() ?>>
</span>
<?php echo $invoice_details->d_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label id="elh_invoice_details_description_02" for="x_description_02" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->description_02->caption() ?><?php echo ($invoice_details->description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->description_02->cellAttributes() ?>>
<span id="el_invoice_details_description_02">
<input type="text" data-table="invoice_details" data-field="x_description_02" name="x_description_02" id="x_description_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->description_02->getPlaceHolder()) ?>" value="<?php echo $invoice_details->description_02->EditValue ?>"<?php echo $invoice_details->description_02->editAttributes() ?>>
</span>
<?php echo $invoice_details->description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->gross_weight->Visible) { // gross_weight ?>
	<div id="r_gross_weight" class="form-group row">
		<label id="elh_invoice_details_gross_weight" for="x_gross_weight" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->gross_weight->caption() ?><?php echo ($invoice_details->gross_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->gross_weight->cellAttributes() ?>>
<span id="el_invoice_details_gross_weight">
<input type="text" data-table="invoice_details" data-field="x_gross_weight" name="x_gross_weight" id="x_gross_weight" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->gross_weight->getPlaceHolder()) ?>" value="<?php echo $invoice_details->gross_weight->EditValue ?>"<?php echo $invoice_details->gross_weight->editAttributes() ?>>
</span>
<?php echo $invoice_details->gross_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->nett_weight->Visible) { // nett_weight ?>
	<div id="r_nett_weight" class="form-group row">
		<label id="elh_invoice_details_nett_weight" for="x_nett_weight" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->nett_weight->caption() ?><?php echo ($invoice_details->nett_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->nett_weight->cellAttributes() ?>>
<span id="el_invoice_details_nett_weight">
<input type="text" data-table="invoice_details" data-field="x_nett_weight" name="x_nett_weight" id="x_nett_weight" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->nett_weight->getPlaceHolder()) ?>" value="<?php echo $invoice_details->nett_weight->EditValue ?>"<?php echo $invoice_details->nett_weight->editAttributes() ?>>
</span>
<?php echo $invoice_details->nett_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_invoice_details_cbm" for="x_cbm" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->cbm->caption() ?><?php echo ($invoice_details->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->cbm->cellAttributes() ?>>
<span id="el_invoice_details_cbm">
<input type="text" data-table="invoice_details" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->cbm->getPlaceHolder()) ?>" value="<?php echo $invoice_details->cbm->EditValue ?>"<?php echo $invoice_details->cbm->editAttributes() ?>>
</span>
<?php echo $invoice_details->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->exporter_bank_details->Visible) { // exporter_bank_details ?>
	<div id="r_exporter_bank_details" class="form-group row">
		<label id="elh_invoice_details_exporter_bank_details" for="x_exporter_bank_details" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->exporter_bank_details->caption() ?><?php echo ($invoice_details->exporter_bank_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->exporter_bank_details->cellAttributes() ?>>
<span id="el_invoice_details_exporter_bank_details">
<textarea data-table="invoice_details" data-field="x_exporter_bank_details" name="x_exporter_bank_details" id="x_exporter_bank_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($invoice_details->exporter_bank_details->getPlaceHolder()) ?>"<?php echo $invoice_details->exporter_bank_details->editAttributes() ?>><?php echo $invoice_details->exporter_bank_details->EditValue ?></textarea>
</span>
<?php echo $invoice_details->exporter_bank_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->intermediary_bank->Visible) { // intermediary_bank ?>
	<div id="r_intermediary_bank" class="form-group row">
		<label id="elh_invoice_details_intermediary_bank" for="x_intermediary_bank" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->intermediary_bank->caption() ?><?php echo ($invoice_details->intermediary_bank->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->intermediary_bank->cellAttributes() ?>>
<span id="el_invoice_details_intermediary_bank">
<textarea data-table="invoice_details" data-field="x_intermediary_bank" name="x_intermediary_bank" id="x_intermediary_bank" cols="35" rows="4" placeholder="<?php echo HtmlEncode($invoice_details->intermediary_bank->getPlaceHolder()) ?>"<?php echo $invoice_details->intermediary_bank->editAttributes() ?>><?php echo $invoice_details->intermediary_bank->EditValue ?></textarea>
</span>
<?php echo $invoice_details->intermediary_bank->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->shipment_mode->Visible) { // shipment_mode ?>
	<div id="r_shipment_mode" class="form-group row">
		<label id="elh_invoice_details_shipment_mode" for="x_shipment_mode" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->shipment_mode->caption() ?><?php echo ($invoice_details->shipment_mode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->shipment_mode->cellAttributes() ?>>
<span id="el_invoice_details_shipment_mode">
<input type="text" data-table="invoice_details" data-field="x_shipment_mode" name="x_shipment_mode" id="x_shipment_mode" size="30" placeholder="<?php echo HtmlEncode($invoice_details->shipment_mode->getPlaceHolder()) ?>" value="<?php echo $invoice_details->shipment_mode->EditValue ?>"<?php echo $invoice_details->shipment_mode->editAttributes() ?>>
</span>
<?php echo $invoice_details->shipment_mode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->ex_factory_date->Visible) { // ex_factory_date ?>
	<div id="r_ex_factory_date" class="form-group row">
		<label id="elh_invoice_details_ex_factory_date" for="x_ex_factory_date" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->ex_factory_date->caption() ?><?php echo ($invoice_details->ex_factory_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->ex_factory_date->cellAttributes() ?>>
<span id="el_invoice_details_ex_factory_date">
<input type="text" data-table="invoice_details" data-field="x_ex_factory_date" name="x_ex_factory_date" id="x_ex_factory_date" placeholder="<?php echo HtmlEncode($invoice_details->ex_factory_date->getPlaceHolder()) ?>" value="<?php echo $invoice_details->ex_factory_date->EditValue ?>"<?php echo $invoice_details->ex_factory_date->editAttributes() ?>>
<?php if (!$invoice_details->ex_factory_date->ReadOnly && !$invoice_details->ex_factory_date->Disabled && !isset($invoice_details->ex_factory_date->EditAttrs["readonly"]) && !isset($invoice_details->ex_factory_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvoice_detailsadd", "x_ex_factory_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $invoice_details->ex_factory_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->sailing_date->Visible) { // sailing_date ?>
	<div id="r_sailing_date" class="form-group row">
		<label id="elh_invoice_details_sailing_date" for="x_sailing_date" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->sailing_date->caption() ?><?php echo ($invoice_details->sailing_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->sailing_date->cellAttributes() ?>>
<span id="el_invoice_details_sailing_date">
<input type="text" data-table="invoice_details" data-field="x_sailing_date" name="x_sailing_date" id="x_sailing_date" placeholder="<?php echo HtmlEncode($invoice_details->sailing_date->getPlaceHolder()) ?>" value="<?php echo $invoice_details->sailing_date->EditValue ?>"<?php echo $invoice_details->sailing_date->editAttributes() ?>>
<?php if (!$invoice_details->sailing_date->ReadOnly && !$invoice_details->sailing_date->Disabled && !isset($invoice_details->sailing_date->EditAttrs["readonly"]) && !isset($invoice_details->sailing_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvoice_detailsadd", "x_sailing_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $invoice_details->sailing_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->cart_lines->Visible) { // cart_lines ?>
	<div id="r_cart_lines" class="form-group row">
		<label id="elh_invoice_details_cart_lines" for="x_cart_lines" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->cart_lines->caption() ?><?php echo ($invoice_details->cart_lines->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->cart_lines->cellAttributes() ?>>
<span id="el_invoice_details_cart_lines">
<input type="text" data-table="invoice_details" data-field="x_cart_lines" name="x_cart_lines" id="x_cart_lines" size="30" placeholder="<?php echo HtmlEncode($invoice_details->cart_lines->getPlaceHolder()) ?>" value="<?php echo $invoice_details->cart_lines->EditValue ?>"<?php echo $invoice_details->cart_lines->editAttributes() ?>>
</span>
<?php echo $invoice_details->cart_lines->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->pl_lines->Visible) { // pl_lines ?>
	<div id="r_pl_lines" class="form-group row">
		<label id="elh_invoice_details_pl_lines" for="x_pl_lines" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->pl_lines->caption() ?><?php echo ($invoice_details->pl_lines->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->pl_lines->cellAttributes() ?>>
<span id="el_invoice_details_pl_lines">
<input type="text" data-table="invoice_details" data-field="x_pl_lines" name="x_pl_lines" id="x_pl_lines" size="30" placeholder="<?php echo HtmlEncode($invoice_details->pl_lines->getPlaceHolder()) ?>" value="<?php echo $invoice_details->pl_lines->EditValue ?>"<?php echo $invoice_details->pl_lines->editAttributes() ?>>
</span>
<?php echo $invoice_details->pl_lines->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->freezed->Visible) { // freezed ?>
	<div id="r_freezed" class="form-group row">
		<label id="elh_invoice_details_freezed" for="x_freezed" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->freezed->caption() ?><?php echo ($invoice_details->freezed->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->freezed->cellAttributes() ?>>
<span id="el_invoice_details_freezed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_freezed" data-value-separator="<?php echo $invoice_details->freezed->displayValueSeparatorAttribute() ?>" id="x_freezed" name="x_freezed"<?php echo $invoice_details->freezed->editAttributes() ?>>
		<?php echo $invoice_details->freezed->selectOptionListHtml("x_freezed") ?>
	</select>
</div>
</span>
<?php echo $invoice_details->freezed->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->port_delivery->Visible) { // port_delivery ?>
	<div id="r_port_delivery" class="form-group row">
		<label id="elh_invoice_details_port_delivery" for="x_port_delivery" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->port_delivery->caption() ?><?php echo ($invoice_details->port_delivery->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->port_delivery->cellAttributes() ?>>
<span id="el_invoice_details_port_delivery">
<input type="text" data-table="invoice_details" data-field="x_port_delivery" name="x_port_delivery" id="x_port_delivery" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->port_delivery->getPlaceHolder()) ?>" value="<?php echo $invoice_details->port_delivery->EditValue ?>"<?php echo $invoice_details->port_delivery->editAttributes() ?>>
</span>
<?php echo $invoice_details->port_delivery->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->dispatch_details->Visible) { // dispatch_details ?>
	<div id="r_dispatch_details" class="form-group row">
		<label id="elh_invoice_details_dispatch_details" for="x_dispatch_details" class="<?php echo $invoice_details_add->LeftColumnClass ?>"><?php echo $invoice_details->dispatch_details->caption() ?><?php echo ($invoice_details->dispatch_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $invoice_details_add->RightColumnClass ?>"><div<?php echo $invoice_details->dispatch_details->cellAttributes() ?>>
<span id="el_invoice_details_dispatch_details">
<input type="text" data-table="invoice_details" data-field="x_dispatch_details" name="x_dispatch_details" id="x_dispatch_details" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->dispatch_details->getPlaceHolder()) ?>" value="<?php echo $invoice_details->dispatch_details->EditValue ?>"<?php echo $invoice_details->dispatch_details->editAttributes() ?>>
</span>
<?php echo $invoice_details->dispatch_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$invoice_details_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $invoice_details_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $invoice_details_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$invoice_details_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#r_po_no").append('<div class="input-group-append" ><h6 style="color:blue" onclick="javascript:populatebuyerpo()"><i class="fa fa-check"></i> Populate Buyer PO</h6></div>');

function populatebuyerpo()
{
	var pl = $("#x_packing_list_no").val();
			$.getJSON('apcajax.php?getbuyerpobyplno='+pl,function(data) {
			$("#x_po_no").val(data);
			});
}
</script>
<?php include_once "footer.php" ?>
<?php
$invoice_details_add->terminate();
?>