<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$invoice_details_list = new invoice_details_list();

// Run the page
$invoice_details_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$invoice_details_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$invoice_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var finvoice_detailslist = currentForm = new ew.Form("finvoice_detailslist", "list");
finvoice_detailslist.formKeyCountName = '<?php echo $invoice_details_list->FormKeyCountName ?>';

// Form_CustomValidate event
finvoice_detailslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvoice_detailslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvoice_detailslist.lists["x_exporter"] = <?php echo $invoice_details_list->exporter->Lookup->toClientList() ?>;
finvoice_detailslist.lists["x_exporter"].options = <?php echo JsonEncode($invoice_details_list->exporter->lookupOptions()) ?>;
finvoice_detailslist.lists["x_consignee"] = <?php echo $invoice_details_list->consignee->Lookup->toClientList() ?>;
finvoice_detailslist.lists["x_consignee"].options = <?php echo JsonEncode($invoice_details_list->consignee->lookupOptions()) ?>;
finvoice_detailslist.lists["x_consignee_other"] = <?php echo $invoice_details_list->consignee_other->Lookup->toClientList() ?>;
finvoice_detailslist.lists["x_consignee_other"].options = <?php echo JsonEncode($invoice_details_list->consignee_other->lookupOptions()) ?>;
finvoice_detailslist.lists["x_packing_list_no"] = <?php echo $invoice_details_list->packing_list_no->Lookup->toClientList() ?>;
finvoice_detailslist.lists["x_packing_list_no"].options = <?php echo JsonEncode($invoice_details_list->packing_list_no->lookupOptions()) ?>;
finvoice_detailslist.lists["x_in_template"] = <?php echo $invoice_details_list->in_template->Lookup->toClientList() ?>;
finvoice_detailslist.lists["x_in_template"].options = <?php echo JsonEncode($invoice_details_list->in_template->lookupOptions()) ?>;
finvoice_detailslist.lists["x_pl_template"] = <?php echo $invoice_details_list->pl_template->Lookup->toClientList() ?>;
finvoice_detailslist.lists["x_pl_template"].options = <?php echo JsonEncode($invoice_details_list->pl_template->lookupOptions()) ?>;
finvoice_detailslist.lists["x_freezed"] = <?php echo $invoice_details_list->freezed->Lookup->toClientList() ?>;
finvoice_detailslist.lists["x_freezed"].options = <?php echo JsonEncode($invoice_details_list->freezed->options(FALSE, TRUE)) ?>;

// Form object for search
var finvoice_detailslistsrch = currentSearchForm = new ew.Form("finvoice_detailslistsrch");

// Filters
finvoice_detailslistsrch.filterList = <?php echo $invoice_details_list->getFilterList() ?>;

// Init search panel as collapsed
finvoice_detailslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$invoice_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($invoice_details_list->TotalRecs > 0 && $invoice_details_list->ExportOptions->visible()) { ?>
<?php $invoice_details_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($invoice_details_list->ImportOptions->visible()) { ?>
<?php $invoice_details_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($invoice_details_list->SearchOptions->visible()) { ?>
<?php $invoice_details_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($invoice_details_list->FilterOptions->visible()) { ?>
<?php $invoice_details_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$invoice_details_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$invoice_details->isExport() && !$invoice_details->CurrentAction) { ?>
<form name="finvoice_detailslistsrch" id="finvoice_detailslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($invoice_details_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="finvoice_detailslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="invoice_details">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($invoice_details_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($invoice_details_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $invoice_details_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($invoice_details_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($invoice_details_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($invoice_details_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($invoice_details_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $invoice_details_list->showPageHeader(); ?>
<?php
$invoice_details_list->showMessage();
?>
<?php if ($invoice_details_list->TotalRecs > 0 || $invoice_details->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($invoice_details_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> invoice_details">
<?php if (!$invoice_details->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$invoice_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($invoice_details_list->Pager)) $invoice_details_list->Pager = new PrevNextPager($invoice_details_list->StartRec, $invoice_details_list->DisplayRecs, $invoice_details_list->TotalRecs, $invoice_details_list->AutoHidePager) ?>
<?php if ($invoice_details_list->Pager->RecordCount > 0 && $invoice_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($invoice_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($invoice_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $invoice_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($invoice_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($invoice_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $invoice_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($invoice_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $invoice_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $invoice_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $invoice_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($invoice_details_list->TotalRecs > 0 && (!$invoice_details_list->AutoHidePageSizeSelector || $invoice_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="invoice_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($invoice_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($invoice_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($invoice_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($invoice_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($invoice_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($invoice_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $invoice_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="finvoice_detailslist" id="finvoice_detailslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($invoice_details_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $invoice_details_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="invoice_details">
<div id="gmp_invoice_details" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($invoice_details_list->TotalRecs > 0 || $invoice_details->isGridEdit()) { ?>
<table id="tbl_invoice_detailslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$invoice_details_list->RowType = ROWTYPE_HEADER;

// Render list options
$invoice_details_list->renderListOptions();

// Render list options (header, left)
$invoice_details_list->ListOptions->render("header", "left");
?>
<?php if ($invoice_details->id->Visible) { // id ?>
	<?php if ($invoice_details->sortUrl($invoice_details->id) == "") { ?>
		<th data-name="id" class="<?php echo $invoice_details->id->headerCellClass() ?>"><div id="elh_invoice_details_id" class="invoice_details_id"><div class="ew-table-header-caption"><?php echo $invoice_details->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $invoice_details->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->id) ?>',2);"><div id="elh_invoice_details_id" class="invoice_details_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->exporter->Visible) { // exporter ?>
	<?php if ($invoice_details->sortUrl($invoice_details->exporter) == "") { ?>
		<th data-name="exporter" class="<?php echo $invoice_details->exporter->headerCellClass() ?>"><div id="elh_invoice_details_exporter" class="invoice_details_exporter"><div class="ew-table-header-caption"><?php echo $invoice_details->exporter->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="exporter" class="<?php echo $invoice_details->exporter->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->exporter) ?>',2);"><div id="elh_invoice_details_exporter" class="invoice_details_exporter">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->exporter->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->exporter->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->exporter->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->consignee->Visible) { // consignee ?>
	<?php if ($invoice_details->sortUrl($invoice_details->consignee) == "") { ?>
		<th data-name="consignee" class="<?php echo $invoice_details->consignee->headerCellClass() ?>"><div id="elh_invoice_details_consignee" class="invoice_details_consignee"><div class="ew-table-header-caption"><?php echo $invoice_details->consignee->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consignee" class="<?php echo $invoice_details->consignee->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->consignee) ?>',2);"><div id="elh_invoice_details_consignee" class="invoice_details_consignee">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->consignee->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->consignee->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->consignee->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->consignee_other->Visible) { // consignee_other ?>
	<?php if ($invoice_details->sortUrl($invoice_details->consignee_other) == "") { ?>
		<th data-name="consignee_other" class="<?php echo $invoice_details->consignee_other->headerCellClass() ?>"><div id="elh_invoice_details_consignee_other" class="invoice_details_consignee_other"><div class="ew-table-header-caption"><?php echo $invoice_details->consignee_other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consignee_other" class="<?php echo $invoice_details->consignee_other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->consignee_other) ?>',2);"><div id="elh_invoice_details_consignee_other" class="invoice_details_consignee_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->consignee_other->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->consignee_other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->consignee_other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->packing_list_no->Visible) { // packing_list_no ?>
	<?php if ($invoice_details->sortUrl($invoice_details->packing_list_no) == "") { ?>
		<th data-name="packing_list_no" class="<?php echo $invoice_details->packing_list_no->headerCellClass() ?>"><div id="elh_invoice_details_packing_list_no" class="invoice_details_packing_list_no"><div class="ew-table-header-caption"><?php echo $invoice_details->packing_list_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_list_no" class="<?php echo $invoice_details->packing_list_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->packing_list_no) ?>',2);"><div id="elh_invoice_details_packing_list_no" class="invoice_details_packing_list_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->packing_list_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->packing_list_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->packing_list_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->d_11->Visible) { // d_11 ?>
	<?php if ($invoice_details->sortUrl($invoice_details->d_11) == "") { ?>
		<th data-name="d_11" class="<?php echo $invoice_details->d_11->headerCellClass() ?>"><div id="elh_invoice_details_d_11" class="invoice_details_d_11"><div class="ew-table-header-caption"><?php echo $invoice_details->d_11->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_11" class="<?php echo $invoice_details->d_11->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->d_11) ?>',2);"><div id="elh_invoice_details_d_11" class="invoice_details_d_11">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->d_11->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->d_11->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->d_11->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->in_template->Visible) { // in_template ?>
	<?php if ($invoice_details->sortUrl($invoice_details->in_template) == "") { ?>
		<th data-name="in_template" class="<?php echo $invoice_details->in_template->headerCellClass() ?>"><div id="elh_invoice_details_in_template" class="invoice_details_in_template"><div class="ew-table-header-caption"><?php echo $invoice_details->in_template->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="in_template" class="<?php echo $invoice_details->in_template->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->in_template) ?>',2);"><div id="elh_invoice_details_in_template" class="invoice_details_in_template">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->in_template->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->in_template->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->in_template->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->pl_template->Visible) { // pl_template ?>
	<?php if ($invoice_details->sortUrl($invoice_details->pl_template) == "") { ?>
		<th data-name="pl_template" class="<?php echo $invoice_details->pl_template->headerCellClass() ?>"><div id="elh_invoice_details_pl_template" class="invoice_details_pl_template"><div class="ew-table-header-caption"><?php echo $invoice_details->pl_template->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_template" class="<?php echo $invoice_details->pl_template->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->pl_template) ?>',2);"><div id="elh_invoice_details_pl_template" class="invoice_details_pl_template">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->pl_template->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->pl_template->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->pl_template->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->invoice_no->Visible) { // invoice_no ?>
	<?php if ($invoice_details->sortUrl($invoice_details->invoice_no) == "") { ?>
		<th data-name="invoice_no" class="<?php echo $invoice_details->invoice_no->headerCellClass() ?>"><div id="elh_invoice_details_invoice_no" class="invoice_details_invoice_no"><div class="ew-table-header-caption"><?php echo $invoice_details->invoice_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_no" class="<?php echo $invoice_details->invoice_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->invoice_no) ?>',2);"><div id="elh_invoice_details_invoice_no" class="invoice_details_invoice_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->invoice_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->invoice_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->invoice_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->invoice_date->Visible) { // invoice_date ?>
	<?php if ($invoice_details->sortUrl($invoice_details->invoice_date) == "") { ?>
		<th data-name="invoice_date" class="<?php echo $invoice_details->invoice_date->headerCellClass() ?>"><div id="elh_invoice_details_invoice_date" class="invoice_details_invoice_date"><div class="ew-table-header-caption"><?php echo $invoice_details->invoice_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_date" class="<?php echo $invoice_details->invoice_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->invoice_date) ?>',2);"><div id="elh_invoice_details_invoice_date" class="invoice_details_invoice_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->invoice_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->invoice_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->invoice_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->po_no->Visible) { // po_no ?>
	<?php if ($invoice_details->sortUrl($invoice_details->po_no) == "") { ?>
		<th data-name="po_no" class="<?php echo $invoice_details->po_no->headerCellClass() ?>"><div id="elh_invoice_details_po_no" class="invoice_details_po_no"><div class="ew-table-header-caption"><?php echo $invoice_details->po_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_no" class="<?php echo $invoice_details->po_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->po_no) ?>',2);"><div id="elh_invoice_details_po_no" class="invoice_details_po_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->po_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->po_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->po_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->other_reference->Visible) { // other_reference ?>
	<?php if ($invoice_details->sortUrl($invoice_details->other_reference) == "") { ?>
		<th data-name="other_reference" class="<?php echo $invoice_details->other_reference->headerCellClass() ?>"><div id="elh_invoice_details_other_reference" class="invoice_details_other_reference"><div class="ew-table-header-caption"><?php echo $invoice_details->other_reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other_reference" class="<?php echo $invoice_details->other_reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->other_reference) ?>',2);"><div id="elh_invoice_details_other_reference" class="invoice_details_other_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->other_reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->other_reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->other_reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->origin->Visible) { // origin ?>
	<?php if ($invoice_details->sortUrl($invoice_details->origin) == "") { ?>
		<th data-name="origin" class="<?php echo $invoice_details->origin->headerCellClass() ?>"><div id="elh_invoice_details_origin" class="invoice_details_origin"><div class="ew-table-header-caption"><?php echo $invoice_details->origin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="origin" class="<?php echo $invoice_details->origin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->origin) ?>',2);"><div id="elh_invoice_details_origin" class="invoice_details_origin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->origin->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->origin->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->origin->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->final_destination->Visible) { // final_destination ?>
	<?php if ($invoice_details->sortUrl($invoice_details->final_destination) == "") { ?>
		<th data-name="final_destination" class="<?php echo $invoice_details->final_destination->headerCellClass() ?>"><div id="elh_invoice_details_final_destination" class="invoice_details_final_destination"><div class="ew-table-header-caption"><?php echo $invoice_details->final_destination->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="final_destination" class="<?php echo $invoice_details->final_destination->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->final_destination) ?>',2);"><div id="elh_invoice_details_final_destination" class="invoice_details_final_destination">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->final_destination->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->final_destination->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->final_destination->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->payment_terms->Visible) { // payment_terms ?>
	<?php if ($invoice_details->sortUrl($invoice_details->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $invoice_details->payment_terms->headerCellClass() ?>"><div id="elh_invoice_details_payment_terms" class="invoice_details_payment_terms"><div class="ew-table-header-caption"><?php echo $invoice_details->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $invoice_details->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->payment_terms) ?>',2);"><div id="elh_invoice_details_payment_terms" class="invoice_details_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->payment_terms->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
	<?php if ($invoice_details->sortUrl($invoice_details->pre_carriage_receipt) == "") { ?>
		<th data-name="pre_carriage_receipt" class="<?php echo $invoice_details->pre_carriage_receipt->headerCellClass() ?>"><div id="elh_invoice_details_pre_carriage_receipt" class="invoice_details_pre_carriage_receipt"><div class="ew-table-header-caption"><?php echo $invoice_details->pre_carriage_receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pre_carriage_receipt" class="<?php echo $invoice_details->pre_carriage_receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->pre_carriage_receipt) ?>',2);"><div id="elh_invoice_details_pre_carriage_receipt" class="invoice_details_pre_carriage_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->pre_carriage_receipt->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->pre_carriage_receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->pre_carriage_receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->place_of_receipt->Visible) { // place_of_receipt ?>
	<?php if ($invoice_details->sortUrl($invoice_details->place_of_receipt) == "") { ?>
		<th data-name="place_of_receipt" class="<?php echo $invoice_details->place_of_receipt->headerCellClass() ?>"><div id="elh_invoice_details_place_of_receipt" class="invoice_details_place_of_receipt"><div class="ew-table-header-caption"><?php echo $invoice_details->place_of_receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="place_of_receipt" class="<?php echo $invoice_details->place_of_receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->place_of_receipt) ?>',2);"><div id="elh_invoice_details_place_of_receipt" class="invoice_details_place_of_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->place_of_receipt->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->place_of_receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->place_of_receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->loading_port->Visible) { // loading_port ?>
	<?php if ($invoice_details->sortUrl($invoice_details->loading_port) == "") { ?>
		<th data-name="loading_port" class="<?php echo $invoice_details->loading_port->headerCellClass() ?>"><div id="elh_invoice_details_loading_port" class="invoice_details_loading_port"><div class="ew-table-header-caption"><?php echo $invoice_details->loading_port->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="loading_port" class="<?php echo $invoice_details->loading_port->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->loading_port) ?>',2);"><div id="elh_invoice_details_loading_port" class="invoice_details_loading_port">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->loading_port->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->loading_port->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->loading_port->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->port_discharge->Visible) { // port_discharge ?>
	<?php if ($invoice_details->sortUrl($invoice_details->port_discharge) == "") { ?>
		<th data-name="port_discharge" class="<?php echo $invoice_details->port_discharge->headerCellClass() ?>"><div id="elh_invoice_details_port_discharge" class="invoice_details_port_discharge"><div class="ew-table-header-caption"><?php echo $invoice_details->port_discharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port_discharge" class="<?php echo $invoice_details->port_discharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->port_discharge) ?>',2);"><div id="elh_invoice_details_port_discharge" class="invoice_details_port_discharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->port_discharge->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->port_discharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->port_discharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->d_01->Visible) { // d_01 ?>
	<?php if ($invoice_details->sortUrl($invoice_details->d_01) == "") { ?>
		<th data-name="d_01" class="<?php echo $invoice_details->d_01->headerCellClass() ?>"><div id="elh_invoice_details_d_01" class="invoice_details_d_01"><div class="ew-table-header-caption"><?php echo $invoice_details->d_01->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_01" class="<?php echo $invoice_details->d_01->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->d_01) ?>',2);"><div id="elh_invoice_details_d_01" class="invoice_details_d_01">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->d_01->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->d_01->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->d_01->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->description_01->Visible) { // description_01 ?>
	<?php if ($invoice_details->sortUrl($invoice_details->description_01) == "") { ?>
		<th data-name="description_01" class="<?php echo $invoice_details->description_01->headerCellClass() ?>"><div id="elh_invoice_details_description_01" class="invoice_details_description_01"><div class="ew-table-header-caption"><?php echo $invoice_details->description_01->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_01" class="<?php echo $invoice_details->description_01->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->description_01) ?>',2);"><div id="elh_invoice_details_description_01" class="invoice_details_description_01">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->description_01->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->description_01->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->description_01->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->d_02->Visible) { // d_02 ?>
	<?php if ($invoice_details->sortUrl($invoice_details->d_02) == "") { ?>
		<th data-name="d_02" class="<?php echo $invoice_details->d_02->headerCellClass() ?>"><div id="elh_invoice_details_d_02" class="invoice_details_d_02"><div class="ew-table-header-caption"><?php echo $invoice_details->d_02->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_02" class="<?php echo $invoice_details->d_02->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->d_02) ?>',2);"><div id="elh_invoice_details_d_02" class="invoice_details_d_02">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->d_02->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->d_02->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->d_02->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->description_02->Visible) { // description_02 ?>
	<?php if ($invoice_details->sortUrl($invoice_details->description_02) == "") { ?>
		<th data-name="description_02" class="<?php echo $invoice_details->description_02->headerCellClass() ?>"><div id="elh_invoice_details_description_02" class="invoice_details_description_02"><div class="ew-table-header-caption"><?php echo $invoice_details->description_02->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_02" class="<?php echo $invoice_details->description_02->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->description_02) ?>',2);"><div id="elh_invoice_details_description_02" class="invoice_details_description_02">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->description_02->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->description_02->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->description_02->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->gross_weight->Visible) { // gross_weight ?>
	<?php if ($invoice_details->sortUrl($invoice_details->gross_weight) == "") { ?>
		<th data-name="gross_weight" class="<?php echo $invoice_details->gross_weight->headerCellClass() ?>"><div id="elh_invoice_details_gross_weight" class="invoice_details_gross_weight"><div class="ew-table-header-caption"><?php echo $invoice_details->gross_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gross_weight" class="<?php echo $invoice_details->gross_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->gross_weight) ?>',2);"><div id="elh_invoice_details_gross_weight" class="invoice_details_gross_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->gross_weight->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->gross_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->gross_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->nett_weight->Visible) { // nett_weight ?>
	<?php if ($invoice_details->sortUrl($invoice_details->nett_weight) == "") { ?>
		<th data-name="nett_weight" class="<?php echo $invoice_details->nett_weight->headerCellClass() ?>"><div id="elh_invoice_details_nett_weight" class="invoice_details_nett_weight"><div class="ew-table-header-caption"><?php echo $invoice_details->nett_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nett_weight" class="<?php echo $invoice_details->nett_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->nett_weight) ?>',2);"><div id="elh_invoice_details_nett_weight" class="invoice_details_nett_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->nett_weight->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->nett_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->nett_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->cbm->Visible) { // cbm ?>
	<?php if ($invoice_details->sortUrl($invoice_details->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $invoice_details->cbm->headerCellClass() ?>"><div id="elh_invoice_details_cbm" class="invoice_details_cbm"><div class="ew-table-header-caption"><?php echo $invoice_details->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $invoice_details->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->cbm) ?>',2);"><div id="elh_invoice_details_cbm" class="invoice_details_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->shipment_mode->Visible) { // shipment_mode ?>
	<?php if ($invoice_details->sortUrl($invoice_details->shipment_mode) == "") { ?>
		<th data-name="shipment_mode" class="<?php echo $invoice_details->shipment_mode->headerCellClass() ?>"><div id="elh_invoice_details_shipment_mode" class="invoice_details_shipment_mode"><div class="ew-table-header-caption"><?php echo $invoice_details->shipment_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipment_mode" class="<?php echo $invoice_details->shipment_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->shipment_mode) ?>',2);"><div id="elh_invoice_details_shipment_mode" class="invoice_details_shipment_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->shipment_mode->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->shipment_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->shipment_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->ex_factory_date->Visible) { // ex_factory_date ?>
	<?php if ($invoice_details->sortUrl($invoice_details->ex_factory_date) == "") { ?>
		<th data-name="ex_factory_date" class="<?php echo $invoice_details->ex_factory_date->headerCellClass() ?>"><div id="elh_invoice_details_ex_factory_date" class="invoice_details_ex_factory_date"><div class="ew-table-header-caption"><?php echo $invoice_details->ex_factory_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ex_factory_date" class="<?php echo $invoice_details->ex_factory_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->ex_factory_date) ?>',2);"><div id="elh_invoice_details_ex_factory_date" class="invoice_details_ex_factory_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->ex_factory_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->ex_factory_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->ex_factory_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->sailing_date->Visible) { // sailing_date ?>
	<?php if ($invoice_details->sortUrl($invoice_details->sailing_date) == "") { ?>
		<th data-name="sailing_date" class="<?php echo $invoice_details->sailing_date->headerCellClass() ?>"><div id="elh_invoice_details_sailing_date" class="invoice_details_sailing_date"><div class="ew-table-header-caption"><?php echo $invoice_details->sailing_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sailing_date" class="<?php echo $invoice_details->sailing_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->sailing_date) ?>',2);"><div id="elh_invoice_details_sailing_date" class="invoice_details_sailing_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->sailing_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->sailing_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->sailing_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->operator->Visible) { // operator ?>
	<?php if ($invoice_details->sortUrl($invoice_details->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $invoice_details->operator->headerCellClass() ?>"><div id="elh_invoice_details_operator" class="invoice_details_operator"><div class="ew-table-header-caption"><?php echo $invoice_details->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $invoice_details->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->operator) ?>',2);"><div id="elh_invoice_details_operator" class="invoice_details_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->datetime->Visible) { // datetime ?>
	<?php if ($invoice_details->sortUrl($invoice_details->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $invoice_details->datetime->headerCellClass() ?>"><div id="elh_invoice_details_datetime" class="invoice_details_datetime"><div class="ew-table-header-caption"><?php echo $invoice_details->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $invoice_details->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->datetime) ?>',2);"><div id="elh_invoice_details_datetime" class="invoice_details_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->cart_lines->Visible) { // cart_lines ?>
	<?php if ($invoice_details->sortUrl($invoice_details->cart_lines) == "") { ?>
		<th data-name="cart_lines" class="<?php echo $invoice_details->cart_lines->headerCellClass() ?>"><div id="elh_invoice_details_cart_lines" class="invoice_details_cart_lines"><div class="ew-table-header-caption"><?php echo $invoice_details->cart_lines->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cart_lines" class="<?php echo $invoice_details->cart_lines->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->cart_lines) ?>',2);"><div id="elh_invoice_details_cart_lines" class="invoice_details_cart_lines">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->cart_lines->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->cart_lines->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->cart_lines->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->pl_lines->Visible) { // pl_lines ?>
	<?php if ($invoice_details->sortUrl($invoice_details->pl_lines) == "") { ?>
		<th data-name="pl_lines" class="<?php echo $invoice_details->pl_lines->headerCellClass() ?>"><div id="elh_invoice_details_pl_lines" class="invoice_details_pl_lines"><div class="ew-table-header-caption"><?php echo $invoice_details->pl_lines->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_lines" class="<?php echo $invoice_details->pl_lines->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->pl_lines) ?>',2);"><div id="elh_invoice_details_pl_lines" class="invoice_details_pl_lines">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->pl_lines->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->pl_lines->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->pl_lines->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->freezed->Visible) { // freezed ?>
	<?php if ($invoice_details->sortUrl($invoice_details->freezed) == "") { ?>
		<th data-name="freezed" class="<?php echo $invoice_details->freezed->headerCellClass() ?>"><div id="elh_invoice_details_freezed" class="invoice_details_freezed"><div class="ew-table-header-caption"><?php echo $invoice_details->freezed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="freezed" class="<?php echo $invoice_details->freezed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->freezed) ?>',2);"><div id="elh_invoice_details_freezed" class="invoice_details_freezed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->freezed->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->freezed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->freezed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->a_operator->Visible) { // a_operator ?>
	<?php if ($invoice_details->sortUrl($invoice_details->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $invoice_details->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_invoice_details_a_operator" class="invoice_details_a_operator"><div class="ew-table-header-caption"><?php echo $invoice_details->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $invoice_details->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->a_operator) ?>',2);"><div id="elh_invoice_details_a_operator" class="invoice_details_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->port_delivery->Visible) { // port_delivery ?>
	<?php if ($invoice_details->sortUrl($invoice_details->port_delivery) == "") { ?>
		<th data-name="port_delivery" class="<?php echo $invoice_details->port_delivery->headerCellClass() ?>"><div id="elh_invoice_details_port_delivery" class="invoice_details_port_delivery"><div class="ew-table-header-caption"><?php echo $invoice_details->port_delivery->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port_delivery" class="<?php echo $invoice_details->port_delivery->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->port_delivery) ?>',2);"><div id="elh_invoice_details_port_delivery" class="invoice_details_port_delivery">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->port_delivery->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->port_delivery->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->port_delivery->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($invoice_details->dispatch_details->Visible) { // dispatch_details ?>
	<?php if ($invoice_details->sortUrl($invoice_details->dispatch_details) == "") { ?>
		<th data-name="dispatch_details" class="<?php echo $invoice_details->dispatch_details->headerCellClass() ?>"><div id="elh_invoice_details_dispatch_details" class="invoice_details_dispatch_details"><div class="ew-table-header-caption"><?php echo $invoice_details->dispatch_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch_details" class="<?php echo $invoice_details->dispatch_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $invoice_details->SortUrl($invoice_details->dispatch_details) ?>',2);"><div id="elh_invoice_details_dispatch_details" class="invoice_details_dispatch_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $invoice_details->dispatch_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($invoice_details->dispatch_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($invoice_details->dispatch_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$invoice_details_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($invoice_details->ExportAll && $invoice_details->isExport()) {
	$invoice_details_list->StopRec = $invoice_details_list->TotalRecs;
} else {

	// Set the last record to display
	if ($invoice_details_list->TotalRecs > $invoice_details_list->StartRec + $invoice_details_list->DisplayRecs - 1)
		$invoice_details_list->StopRec = $invoice_details_list->StartRec + $invoice_details_list->DisplayRecs - 1;
	else
		$invoice_details_list->StopRec = $invoice_details_list->TotalRecs;
}
$invoice_details_list->RecCnt = $invoice_details_list->StartRec - 1;
if ($invoice_details_list->Recordset && !$invoice_details_list->Recordset->EOF) {
	$invoice_details_list->Recordset->moveFirst();
	$selectLimit = $invoice_details_list->UseSelectLimit;
	if (!$selectLimit && $invoice_details_list->StartRec > 1)
		$invoice_details_list->Recordset->move($invoice_details_list->StartRec - 1);
} elseif (!$invoice_details->AllowAddDeleteRow && $invoice_details_list->StopRec == 0) {
	$invoice_details_list->StopRec = $invoice_details->GridAddRowCount;
}

// Initialize aggregate
$invoice_details->RowType = ROWTYPE_AGGREGATEINIT;
$invoice_details->resetAttributes();
$invoice_details_list->renderRow();
while ($invoice_details_list->RecCnt < $invoice_details_list->StopRec) {
	$invoice_details_list->RecCnt++;
	if ($invoice_details_list->RecCnt >= $invoice_details_list->StartRec) {
		$invoice_details_list->RowCnt++;

		// Set up key count
		$invoice_details_list->KeyCount = $invoice_details_list->RowIndex;

		// Init row class and style
		$invoice_details->resetAttributes();
		$invoice_details->CssClass = "";
		if ($invoice_details->isGridAdd()) {
		} else {
			$invoice_details_list->loadRowValues($invoice_details_list->Recordset); // Load row values
		}
		$invoice_details->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$invoice_details->RowAttrs = array_merge($invoice_details->RowAttrs, array('data-rowindex'=>$invoice_details_list->RowCnt, 'id'=>'r' . $invoice_details_list->RowCnt . '_invoice_details', 'data-rowtype'=>$invoice_details->RowType));

		// Render row
		$invoice_details_list->renderRow();

		// Render list options
		$invoice_details_list->renderListOptions();
?>
	<tr<?php echo $invoice_details->rowAttributes() ?>>
<?php

// Render list options (body, left)
$invoice_details_list->ListOptions->render("body", "left", $invoice_details_list->RowCnt);
?>
	<?php if ($invoice_details->id->Visible) { // id ?>
		<td data-name="id"<?php echo $invoice_details->id->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_id" class="invoice_details_id">
<span<?php echo $invoice_details->id->viewAttributes() ?>>
<?php echo $invoice_details->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->exporter->Visible) { // exporter ?>
		<td data-name="exporter"<?php echo $invoice_details->exporter->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_exporter" class="invoice_details_exporter">
<span<?php echo $invoice_details->exporter->viewAttributes() ?>>
<?php echo $invoice_details->exporter->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->consignee->Visible) { // consignee ?>
		<td data-name="consignee"<?php echo $invoice_details->consignee->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_consignee" class="invoice_details_consignee">
<span<?php echo $invoice_details->consignee->viewAttributes() ?>>
<?php echo $invoice_details->consignee->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->consignee_other->Visible) { // consignee_other ?>
		<td data-name="consignee_other"<?php echo $invoice_details->consignee_other->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_consignee_other" class="invoice_details_consignee_other">
<span<?php echo $invoice_details->consignee_other->viewAttributes() ?>>
<?php echo $invoice_details->consignee_other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->packing_list_no->Visible) { // packing_list_no ?>
		<td data-name="packing_list_no"<?php echo $invoice_details->packing_list_no->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_packing_list_no" class="invoice_details_packing_list_no">
<span<?php echo $invoice_details->packing_list_no->viewAttributes() ?>>
<?php echo $invoice_details->packing_list_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->d_11->Visible) { // d_11 ?>
		<td data-name="d_11"<?php echo $invoice_details->d_11->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_d_11" class="invoice_details_d_11">
<span<?php echo $invoice_details->d_11->viewAttributes() ?>>
<?php echo $invoice_details->d_11->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->in_template->Visible) { // in_template ?>
		<td data-name="in_template"<?php echo $invoice_details->in_template->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_in_template" class="invoice_details_in_template">
<span<?php echo $invoice_details->in_template->viewAttributes() ?>>
<?php echo $invoice_details->in_template->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->pl_template->Visible) { // pl_template ?>
		<td data-name="pl_template"<?php echo $invoice_details->pl_template->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_pl_template" class="invoice_details_pl_template">
<span<?php echo $invoice_details->pl_template->viewAttributes() ?>>
<?php echo $invoice_details->pl_template->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->invoice_no->Visible) { // invoice_no ?>
		<td data-name="invoice_no"<?php echo $invoice_details->invoice_no->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_invoice_no" class="invoice_details_invoice_no">
<span<?php echo $invoice_details->invoice_no->viewAttributes() ?>>
<?php echo $invoice_details->invoice_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date"<?php echo $invoice_details->invoice_date->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_invoice_date" class="invoice_details_invoice_date">
<span<?php echo $invoice_details->invoice_date->viewAttributes() ?>>
<?php echo $invoice_details->invoice_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->po_no->Visible) { // po_no ?>
		<td data-name="po_no"<?php echo $invoice_details->po_no->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_po_no" class="invoice_details_po_no">
<span<?php echo $invoice_details->po_no->viewAttributes() ?>>
<?php echo $invoice_details->po_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->other_reference->Visible) { // other_reference ?>
		<td data-name="other_reference"<?php echo $invoice_details->other_reference->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_other_reference" class="invoice_details_other_reference">
<span<?php echo $invoice_details->other_reference->viewAttributes() ?>>
<?php echo $invoice_details->other_reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->origin->Visible) { // origin ?>
		<td data-name="origin"<?php echo $invoice_details->origin->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_origin" class="invoice_details_origin">
<span<?php echo $invoice_details->origin->viewAttributes() ?>>
<?php echo $invoice_details->origin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->final_destination->Visible) { // final_destination ?>
		<td data-name="final_destination"<?php echo $invoice_details->final_destination->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_final_destination" class="invoice_details_final_destination">
<span<?php echo $invoice_details->final_destination->viewAttributes() ?>>
<?php echo $invoice_details->final_destination->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $invoice_details->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_payment_terms" class="invoice_details_payment_terms">
<span<?php echo $invoice_details->payment_terms->viewAttributes() ?>>
<?php echo $invoice_details->payment_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
		<td data-name="pre_carriage_receipt"<?php echo $invoice_details->pre_carriage_receipt->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_pre_carriage_receipt" class="invoice_details_pre_carriage_receipt">
<span<?php echo $invoice_details->pre_carriage_receipt->viewAttributes() ?>>
<?php echo $invoice_details->pre_carriage_receipt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->place_of_receipt->Visible) { // place_of_receipt ?>
		<td data-name="place_of_receipt"<?php echo $invoice_details->place_of_receipt->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_place_of_receipt" class="invoice_details_place_of_receipt">
<span<?php echo $invoice_details->place_of_receipt->viewAttributes() ?>>
<?php echo $invoice_details->place_of_receipt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->loading_port->Visible) { // loading_port ?>
		<td data-name="loading_port"<?php echo $invoice_details->loading_port->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_loading_port" class="invoice_details_loading_port">
<span<?php echo $invoice_details->loading_port->viewAttributes() ?>>
<?php echo $invoice_details->loading_port->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->port_discharge->Visible) { // port_discharge ?>
		<td data-name="port_discharge"<?php echo $invoice_details->port_discharge->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_port_discharge" class="invoice_details_port_discharge">
<span<?php echo $invoice_details->port_discharge->viewAttributes() ?>>
<?php echo $invoice_details->port_discharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->d_01->Visible) { // d_01 ?>
		<td data-name="d_01"<?php echo $invoice_details->d_01->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_d_01" class="invoice_details_d_01">
<span<?php echo $invoice_details->d_01->viewAttributes() ?>>
<?php echo $invoice_details->d_01->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->description_01->Visible) { // description_01 ?>
		<td data-name="description_01"<?php echo $invoice_details->description_01->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_description_01" class="invoice_details_description_01">
<span<?php echo $invoice_details->description_01->viewAttributes() ?>>
<?php echo $invoice_details->description_01->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->d_02->Visible) { // d_02 ?>
		<td data-name="d_02"<?php echo $invoice_details->d_02->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_d_02" class="invoice_details_d_02">
<span<?php echo $invoice_details->d_02->viewAttributes() ?>>
<?php echo $invoice_details->d_02->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->description_02->Visible) { // description_02 ?>
		<td data-name="description_02"<?php echo $invoice_details->description_02->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_description_02" class="invoice_details_description_02">
<span<?php echo $invoice_details->description_02->viewAttributes() ?>>
<?php echo $invoice_details->description_02->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->gross_weight->Visible) { // gross_weight ?>
		<td data-name="gross_weight"<?php echo $invoice_details->gross_weight->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_gross_weight" class="invoice_details_gross_weight">
<span<?php echo $invoice_details->gross_weight->viewAttributes() ?>>
<?php echo $invoice_details->gross_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->nett_weight->Visible) { // nett_weight ?>
		<td data-name="nett_weight"<?php echo $invoice_details->nett_weight->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_nett_weight" class="invoice_details_nett_weight">
<span<?php echo $invoice_details->nett_weight->viewAttributes() ?>>
<?php echo $invoice_details->nett_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $invoice_details->cbm->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_cbm" class="invoice_details_cbm">
<span<?php echo $invoice_details->cbm->viewAttributes() ?>>
<?php echo $invoice_details->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->shipment_mode->Visible) { // shipment_mode ?>
		<td data-name="shipment_mode"<?php echo $invoice_details->shipment_mode->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_shipment_mode" class="invoice_details_shipment_mode">
<span<?php echo $invoice_details->shipment_mode->viewAttributes() ?>>
<?php echo $invoice_details->shipment_mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->ex_factory_date->Visible) { // ex_factory_date ?>
		<td data-name="ex_factory_date"<?php echo $invoice_details->ex_factory_date->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_ex_factory_date" class="invoice_details_ex_factory_date">
<span<?php echo $invoice_details->ex_factory_date->viewAttributes() ?>>
<?php echo $invoice_details->ex_factory_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->sailing_date->Visible) { // sailing_date ?>
		<td data-name="sailing_date"<?php echo $invoice_details->sailing_date->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_sailing_date" class="invoice_details_sailing_date">
<span<?php echo $invoice_details->sailing_date->viewAttributes() ?>>
<?php echo $invoice_details->sailing_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $invoice_details->operator->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_operator" class="invoice_details_operator">
<span<?php echo $invoice_details->operator->viewAttributes() ?>>
<?php echo $invoice_details->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $invoice_details->datetime->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_datetime" class="invoice_details_datetime">
<span<?php echo $invoice_details->datetime->viewAttributes() ?>>
<?php echo $invoice_details->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->cart_lines->Visible) { // cart_lines ?>
		<td data-name="cart_lines"<?php echo $invoice_details->cart_lines->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_cart_lines" class="invoice_details_cart_lines">
<span<?php echo $invoice_details->cart_lines->viewAttributes() ?>>
<?php echo $invoice_details->cart_lines->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->pl_lines->Visible) { // pl_lines ?>
		<td data-name="pl_lines"<?php echo $invoice_details->pl_lines->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_pl_lines" class="invoice_details_pl_lines">
<span<?php echo $invoice_details->pl_lines->viewAttributes() ?>>
<?php echo $invoice_details->pl_lines->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->freezed->Visible) { // freezed ?>
		<td data-name="freezed"<?php echo $invoice_details->freezed->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_freezed" class="invoice_details_freezed">
<span<?php echo $invoice_details->freezed->viewAttributes() ?>>
<?php echo $invoice_details->freezed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $invoice_details->a_operator->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_a_operator" class="invoice_details_a_operator">
<span<?php echo $invoice_details->a_operator->viewAttributes() ?>>
<?php echo $invoice_details->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->port_delivery->Visible) { // port_delivery ?>
		<td data-name="port_delivery"<?php echo $invoice_details->port_delivery->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_port_delivery" class="invoice_details_port_delivery">
<span<?php echo $invoice_details->port_delivery->viewAttributes() ?>>
<?php echo $invoice_details->port_delivery->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($invoice_details->dispatch_details->Visible) { // dispatch_details ?>
		<td data-name="dispatch_details"<?php echo $invoice_details->dispatch_details->cellAttributes() ?>>
<span id="el<?php echo $invoice_details_list->RowCnt ?>_invoice_details_dispatch_details" class="invoice_details_dispatch_details">
<span<?php echo $invoice_details->dispatch_details->viewAttributes() ?>>
<?php echo $invoice_details->dispatch_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$invoice_details_list->ListOptions->render("body", "right", $invoice_details_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$invoice_details->isGridAdd())
		$invoice_details_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$invoice_details->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($invoice_details_list->Recordset)
	$invoice_details_list->Recordset->Close();
?>
<?php if (!$invoice_details->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$invoice_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($invoice_details_list->Pager)) $invoice_details_list->Pager = new PrevNextPager($invoice_details_list->StartRec, $invoice_details_list->DisplayRecs, $invoice_details_list->TotalRecs, $invoice_details_list->AutoHidePager) ?>
<?php if ($invoice_details_list->Pager->RecordCount > 0 && $invoice_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($invoice_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($invoice_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $invoice_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($invoice_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($invoice_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $invoice_details_list->pageUrl() ?>start=<?php echo $invoice_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $invoice_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($invoice_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $invoice_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $invoice_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $invoice_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($invoice_details_list->TotalRecs > 0 && (!$invoice_details_list->AutoHidePageSizeSelector || $invoice_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="invoice_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($invoice_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($invoice_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($invoice_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($invoice_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($invoice_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($invoice_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $invoice_details_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($invoice_details_list->TotalRecs == 0 && !$invoice_details->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $invoice_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$invoice_details_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$invoice_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$invoice_details->isExport()) { ?>
<script>
ew.scrollableTable("gmp_invoice_details", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$invoice_details_list->terminate();
?>