<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$invoice_details_search = new invoice_details_search();

// Run the page
$invoice_details_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$invoice_details_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($invoice_details_search->IsModal) { ?>
var finvoice_detailssearch = currentAdvancedSearchForm = new ew.Form("finvoice_detailssearch", "search");
<?php } else { ?>
var finvoice_detailssearch = currentForm = new ew.Form("finvoice_detailssearch", "search");
<?php } ?>

// Form_CustomValidate event
finvoice_detailssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvoice_detailssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvoice_detailssearch.lists["x_exporter"] = <?php echo $invoice_details_search->exporter->Lookup->toClientList() ?>;
finvoice_detailssearch.lists["x_exporter"].options = <?php echo JsonEncode($invoice_details_search->exporter->lookupOptions()) ?>;
finvoice_detailssearch.lists["x_consignee"] = <?php echo $invoice_details_search->consignee->Lookup->toClientList() ?>;
finvoice_detailssearch.lists["x_consignee"].options = <?php echo JsonEncode($invoice_details_search->consignee->lookupOptions()) ?>;
finvoice_detailssearch.lists["x_consignee_other"] = <?php echo $invoice_details_search->consignee_other->Lookup->toClientList() ?>;
finvoice_detailssearch.lists["x_consignee_other"].options = <?php echo JsonEncode($invoice_details_search->consignee_other->lookupOptions()) ?>;
finvoice_detailssearch.lists["x_packing_list_no"] = <?php echo $invoice_details_search->packing_list_no->Lookup->toClientList() ?>;
finvoice_detailssearch.lists["x_packing_list_no"].options = <?php echo JsonEncode($invoice_details_search->packing_list_no->lookupOptions()) ?>;
finvoice_detailssearch.lists["x_in_template"] = <?php echo $invoice_details_search->in_template->Lookup->toClientList() ?>;
finvoice_detailssearch.lists["x_in_template"].options = <?php echo JsonEncode($invoice_details_search->in_template->lookupOptions()) ?>;
finvoice_detailssearch.lists["x_pl_template"] = <?php echo $invoice_details_search->pl_template->Lookup->toClientList() ?>;
finvoice_detailssearch.lists["x_pl_template"].options = <?php echo JsonEncode($invoice_details_search->pl_template->lookupOptions()) ?>;
finvoice_detailssearch.lists["x_freezed"] = <?php echo $invoice_details_search->freezed->Lookup->toClientList() ?>;
finvoice_detailssearch.lists["x_freezed"].options = <?php echo JsonEncode($invoice_details_search->freezed->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

finvoice_detailssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->invoice_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_shipment_mode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->shipment_mode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ex_factory_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->ex_factory_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sailing_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->sailing_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cart_lines");
	if (elm && !ew.checkByRegEx(elm.value, /^([0-9,]){5,5}$/))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->cart_lines->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_lines");
	if (elm && !ew.checkByRegEx(elm.value, /^([0-9,]){5,5}$/))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->pl_lines->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($invoice_details->a_operator->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $invoice_details_search->showPageHeader(); ?>
<?php
$invoice_details_search->showMessage();
?>
<form name="finvoice_detailssearch" id="finvoice_detailssearch" class="<?php echo $invoice_details_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($invoice_details_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $invoice_details_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="invoice_details">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$invoice_details_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($invoice_details->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_id"><?php echo $invoice_details->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->id->cellAttributes() ?>>
			<span id="el_invoice_details_id">
<input type="text" data-table="invoice_details" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($invoice_details->id->getPlaceHolder()) ?>" value="<?php echo $invoice_details->id->EditValue ?>"<?php echo $invoice_details->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details__barcode"><?php echo $invoice_details->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->_barcode->cellAttributes() ?>>
			<span id="el_invoice_details__barcode">
<input type="text" data-table="invoice_details" data-field="x__barcode" name="x__barcode" id="x__barcode" size="35" placeholder="<?php echo HtmlEncode($invoice_details->_barcode->getPlaceHolder()) ?>" value="<?php echo $invoice_details->_barcode->EditValue ?>"<?php echo $invoice_details->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->exporter->Visible) { // exporter ?>
	<div id="r_exporter" class="form-group row">
		<label for="x_exporter" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_exporter"><?php echo $invoice_details->exporter->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_exporter" id="z_exporter" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->exporter->cellAttributes() ?>>
			<span id="el_invoice_details_exporter">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_exporter" data-value-separator="<?php echo $invoice_details->exporter->displayValueSeparatorAttribute() ?>" id="x_exporter" name="x_exporter"<?php echo $invoice_details->exporter->editAttributes() ?>>
		<?php echo $invoice_details->exporter->selectOptionListHtml("x_exporter") ?>
	</select>
</div>
<?php echo $invoice_details->exporter->Lookup->getParamTag("p_x_exporter") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->consignee->Visible) { // consignee ?>
	<div id="r_consignee" class="form-group row">
		<label for="x_consignee" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_consignee"><?php echo $invoice_details->consignee->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_consignee" id="z_consignee" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->consignee->cellAttributes() ?>>
			<span id="el_invoice_details_consignee">
<?php $invoice_details->consignee->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$invoice_details->consignee->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_consignee" data-value-separator="<?php echo $invoice_details->consignee->displayValueSeparatorAttribute() ?>" id="x_consignee" name="x_consignee"<?php echo $invoice_details->consignee->editAttributes() ?>>
		<?php echo $invoice_details->consignee->selectOptionListHtml("x_consignee") ?>
	</select>
</div>
<?php echo $invoice_details->consignee->Lookup->getParamTag("p_x_consignee") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->consignee_other->Visible) { // consignee_other ?>
	<div id="r_consignee_other" class="form-group row">
		<label for="x_consignee_other" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_consignee_other"><?php echo $invoice_details->consignee_other->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_consignee_other" id="z_consignee_other" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->consignee_other->cellAttributes() ?>>
			<span id="el_invoice_details_consignee_other">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_consignee_other" data-value-separator="<?php echo $invoice_details->consignee_other->displayValueSeparatorAttribute() ?>" id="x_consignee_other" name="x_consignee_other"<?php echo $invoice_details->consignee_other->editAttributes() ?>>
		<?php echo $invoice_details->consignee_other->selectOptionListHtml("x_consignee_other") ?>
	</select>
</div>
<?php echo $invoice_details->consignee_other->Lookup->getParamTag("p_x_consignee_other") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->packing_list_no->Visible) { // packing_list_no ?>
	<div id="r_packing_list_no" class="form-group row">
		<label for="x_packing_list_no" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_packing_list_no"><?php echo $invoice_details->packing_list_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_list_no" id="z_packing_list_no" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->packing_list_no->cellAttributes() ?>>
			<span id="el_invoice_details_packing_list_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_packing_list_no" data-value-separator="<?php echo $invoice_details->packing_list_no->displayValueSeparatorAttribute() ?>" id="x_packing_list_no" name="x_packing_list_no"<?php echo $invoice_details->packing_list_no->editAttributes() ?>>
		<?php echo $invoice_details->packing_list_no->selectOptionListHtml("x_packing_list_no") ?>
	</select>
</div>
<?php echo $invoice_details->packing_list_no->Lookup->getParamTag("p_x_packing_list_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->d_11->Visible) { // d_11 ?>
	<div id="r_d_11" class="form-group row">
		<label for="x_d_11" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_d_11"><?php echo $invoice_details->d_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_11" id="z_d_11" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->d_11->cellAttributes() ?>>
			<span id="el_invoice_details_d_11">
<input type="text" data-table="invoice_details" data-field="x_d_11" name="x_d_11" id="x_d_11" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->d_11->getPlaceHolder()) ?>" value="<?php echo $invoice_details->d_11->EditValue ?>"<?php echo $invoice_details->d_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label for="x_description_11" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_description_11"><?php echo $invoice_details->description_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_11" id="z_description_11" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->description_11->cellAttributes() ?>>
			<span id="el_invoice_details_description_11">
<input type="text" data-table="invoice_details" data-field="x_description_11" name="x_description_11" id="x_description_11" size="35" placeholder="<?php echo HtmlEncode($invoice_details->description_11->getPlaceHolder()) ?>" value="<?php echo $invoice_details->description_11->EditValue ?>"<?php echo $invoice_details->description_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->in_template->Visible) { // in_template ?>
	<div id="r_in_template" class="form-group row">
		<label for="x_in_template" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_in_template"><?php echo $invoice_details->in_template->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_in_template" id="z_in_template" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->in_template->cellAttributes() ?>>
			<span id="el_invoice_details_in_template">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_in_template" data-value-separator="<?php echo $invoice_details->in_template->displayValueSeparatorAttribute() ?>" id="x_in_template" name="x_in_template"<?php echo $invoice_details->in_template->editAttributes() ?>>
		<?php echo $invoice_details->in_template->selectOptionListHtml("x_in_template") ?>
	</select>
</div>
<?php echo $invoice_details->in_template->Lookup->getParamTag("p_x_in_template") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->pl_template->Visible) { // pl_template ?>
	<div id="r_pl_template" class="form-group row">
		<label for="x_pl_template" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_pl_template"><?php echo $invoice_details->pl_template->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_template" id="z_pl_template" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->pl_template->cellAttributes() ?>>
			<span id="el_invoice_details_pl_template">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_pl_template" data-value-separator="<?php echo $invoice_details->pl_template->displayValueSeparatorAttribute() ?>" id="x_pl_template" name="x_pl_template"<?php echo $invoice_details->pl_template->editAttributes() ?>>
		<?php echo $invoice_details->pl_template->selectOptionListHtml("x_pl_template") ?>
	</select>
</div>
<?php echo $invoice_details->pl_template->Lookup->getParamTag("p_x_pl_template") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->invoice_no->Visible) { // invoice_no ?>
	<div id="r_invoice_no" class="form-group row">
		<label for="x_invoice_no" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_invoice_no"><?php echo $invoice_details->invoice_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_no" id="z_invoice_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->invoice_no->cellAttributes() ?>>
			<span id="el_invoice_details_invoice_no">
<input type="text" data-table="invoice_details" data-field="x_invoice_no" name="x_invoice_no" id="x_invoice_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->invoice_no->getPlaceHolder()) ?>" value="<?php echo $invoice_details->invoice_no->EditValue ?>"<?php echo $invoice_details->invoice_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_invoice_date"><?php echo $invoice_details->invoice_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_invoice_date" id="z_invoice_date" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->invoice_date->cellAttributes() ?>>
			<span id="el_invoice_details_invoice_date">
<input type="text" data-table="invoice_details" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($invoice_details->invoice_date->getPlaceHolder()) ?>" value="<?php echo $invoice_details->invoice_date->EditValue ?>"<?php echo $invoice_details->invoice_date->editAttributes() ?>>
<?php if (!$invoice_details->invoice_date->ReadOnly && !$invoice_details->invoice_date->Disabled && !isset($invoice_details->invoice_date->EditAttrs["readonly"]) && !isset($invoice_details->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvoice_detailssearch", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->po_no->Visible) { // po_no ?>
	<div id="r_po_no" class="form-group row">
		<label for="x_po_no" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_po_no"><?php echo $invoice_details->po_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_no" id="z_po_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->po_no->cellAttributes() ?>>
			<span id="el_invoice_details_po_no">
<input type="text" data-table="invoice_details" data-field="x_po_no" name="x_po_no" id="x_po_no" maxlength="24" placeholder="<?php echo HtmlEncode($invoice_details->po_no->getPlaceHolder()) ?>" value="<?php echo $invoice_details->po_no->EditValue ?>"<?php echo $invoice_details->po_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->other_reference->Visible) { // other_reference ?>
	<div id="r_other_reference" class="form-group row">
		<label for="x_other_reference" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_other_reference"><?php echo $invoice_details->other_reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other_reference" id="z_other_reference" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->other_reference->cellAttributes() ?>>
			<span id="el_invoice_details_other_reference">
<input type="text" data-table="invoice_details" data-field="x_other_reference" name="x_other_reference" id="x_other_reference" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->other_reference->getPlaceHolder()) ?>" value="<?php echo $invoice_details->other_reference->EditValue ?>"<?php echo $invoice_details->other_reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->origin->Visible) { // origin ?>
	<div id="r_origin" class="form-group row">
		<label for="x_origin" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_origin"><?php echo $invoice_details->origin->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_origin" id="z_origin" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->origin->cellAttributes() ?>>
			<span id="el_invoice_details_origin">
<input type="text" data-table="invoice_details" data-field="x_origin" name="x_origin" id="x_origin" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($invoice_details->origin->getPlaceHolder()) ?>" value="<?php echo $invoice_details->origin->EditValue ?>"<?php echo $invoice_details->origin->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->final_destination->Visible) { // final_destination ?>
	<div id="r_final_destination" class="form-group row">
		<label for="x_final_destination" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_final_destination"><?php echo $invoice_details->final_destination->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_final_destination" id="z_final_destination" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->final_destination->cellAttributes() ?>>
			<span id="el_invoice_details_final_destination">
<input type="text" data-table="invoice_details" data-field="x_final_destination" name="x_final_destination" id="x_final_destination" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->final_destination->getPlaceHolder()) ?>" value="<?php echo $invoice_details->final_destination->EditValue ?>"<?php echo $invoice_details->final_destination->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label for="x_payment_terms" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_payment_terms"><?php echo $invoice_details->payment_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment_terms" id="z_payment_terms" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->payment_terms->cellAttributes() ?>>
			<span id="el_invoice_details_payment_terms">
<input type="text" data-table="invoice_details" data-field="x_payment_terms" name="x_payment_terms" id="x_payment_terms" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->payment_terms->getPlaceHolder()) ?>" value="<?php echo $invoice_details->payment_terms->EditValue ?>"<?php echo $invoice_details->payment_terms->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
	<div id="r_pre_carriage_receipt" class="form-group row">
		<label for="x_pre_carriage_receipt" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_pre_carriage_receipt"><?php echo $invoice_details->pre_carriage_receipt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pre_carriage_receipt" id="z_pre_carriage_receipt" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->pre_carriage_receipt->cellAttributes() ?>>
			<span id="el_invoice_details_pre_carriage_receipt">
<input type="text" data-table="invoice_details" data-field="x_pre_carriage_receipt" name="x_pre_carriage_receipt" id="x_pre_carriage_receipt" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->pre_carriage_receipt->getPlaceHolder()) ?>" value="<?php echo $invoice_details->pre_carriage_receipt->EditValue ?>"<?php echo $invoice_details->pre_carriage_receipt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->place_of_receipt->Visible) { // place_of_receipt ?>
	<div id="r_place_of_receipt" class="form-group row">
		<label for="x_place_of_receipt" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_place_of_receipt"><?php echo $invoice_details->place_of_receipt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_place_of_receipt" id="z_place_of_receipt" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->place_of_receipt->cellAttributes() ?>>
			<span id="el_invoice_details_place_of_receipt">
<input type="text" data-table="invoice_details" data-field="x_place_of_receipt" name="x_place_of_receipt" id="x_place_of_receipt" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->place_of_receipt->getPlaceHolder()) ?>" value="<?php echo $invoice_details->place_of_receipt->EditValue ?>"<?php echo $invoice_details->place_of_receipt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->loading_port->Visible) { // loading_port ?>
	<div id="r_loading_port" class="form-group row">
		<label for="x_loading_port" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_loading_port"><?php echo $invoice_details->loading_port->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_loading_port" id="z_loading_port" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->loading_port->cellAttributes() ?>>
			<span id="el_invoice_details_loading_port">
<input type="text" data-table="invoice_details" data-field="x_loading_port" name="x_loading_port" id="x_loading_port" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->loading_port->getPlaceHolder()) ?>" value="<?php echo $invoice_details->loading_port->EditValue ?>"<?php echo $invoice_details->loading_port->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->port_discharge->Visible) { // port_discharge ?>
	<div id="r_port_discharge" class="form-group row">
		<label for="x_port_discharge" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_port_discharge"><?php echo $invoice_details->port_discharge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_port_discharge" id="z_port_discharge" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->port_discharge->cellAttributes() ?>>
			<span id="el_invoice_details_port_discharge">
<input type="text" data-table="invoice_details" data-field="x_port_discharge" name="x_port_discharge" id="x_port_discharge" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->port_discharge->getPlaceHolder()) ?>" value="<?php echo $invoice_details->port_discharge->EditValue ?>"<?php echo $invoice_details->port_discharge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->d_01->Visible) { // d_01 ?>
	<div id="r_d_01" class="form-group row">
		<label for="x_d_01" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_d_01"><?php echo $invoice_details->d_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_01" id="z_d_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->d_01->cellAttributes() ?>>
			<span id="el_invoice_details_d_01">
<input type="text" data-table="invoice_details" data-field="x_d_01" name="x_d_01" id="x_d_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->d_01->getPlaceHolder()) ?>" value="<?php echo $invoice_details->d_01->EditValue ?>"<?php echo $invoice_details->d_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label for="x_description_01" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_description_01"><?php echo $invoice_details->description_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_01" id="z_description_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->description_01->cellAttributes() ?>>
			<span id="el_invoice_details_description_01">
<input type="text" data-table="invoice_details" data-field="x_description_01" name="x_description_01" id="x_description_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->description_01->getPlaceHolder()) ?>" value="<?php echo $invoice_details->description_01->EditValue ?>"<?php echo $invoice_details->description_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->d_02->Visible) { // d_02 ?>
	<div id="r_d_02" class="form-group row">
		<label for="x_d_02" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_d_02"><?php echo $invoice_details->d_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_02" id="z_d_02" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->d_02->cellAttributes() ?>>
			<span id="el_invoice_details_d_02">
<input type="text" data-table="invoice_details" data-field="x_d_02" name="x_d_02" id="x_d_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->d_02->getPlaceHolder()) ?>" value="<?php echo $invoice_details->d_02->EditValue ?>"<?php echo $invoice_details->d_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label for="x_description_02" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_description_02"><?php echo $invoice_details->description_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_02" id="z_description_02" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->description_02->cellAttributes() ?>>
			<span id="el_invoice_details_description_02">
<input type="text" data-table="invoice_details" data-field="x_description_02" name="x_description_02" id="x_description_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($invoice_details->description_02->getPlaceHolder()) ?>" value="<?php echo $invoice_details->description_02->EditValue ?>"<?php echo $invoice_details->description_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->gross_weight->Visible) { // gross_weight ?>
	<div id="r_gross_weight" class="form-group row">
		<label for="x_gross_weight" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_gross_weight"><?php echo $invoice_details->gross_weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gross_weight" id="z_gross_weight" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->gross_weight->cellAttributes() ?>>
			<span id="el_invoice_details_gross_weight">
<input type="text" data-table="invoice_details" data-field="x_gross_weight" name="x_gross_weight" id="x_gross_weight" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->gross_weight->getPlaceHolder()) ?>" value="<?php echo $invoice_details->gross_weight->EditValue ?>"<?php echo $invoice_details->gross_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->nett_weight->Visible) { // nett_weight ?>
	<div id="r_nett_weight" class="form-group row">
		<label for="x_nett_weight" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_nett_weight"><?php echo $invoice_details->nett_weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_nett_weight" id="z_nett_weight" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->nett_weight->cellAttributes() ?>>
			<span id="el_invoice_details_nett_weight">
<input type="text" data-table="invoice_details" data-field="x_nett_weight" name="x_nett_weight" id="x_nett_weight" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->nett_weight->getPlaceHolder()) ?>" value="<?php echo $invoice_details->nett_weight->EditValue ?>"<?php echo $invoice_details->nett_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_cbm"><?php echo $invoice_details->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cbm" id="z_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->cbm->cellAttributes() ?>>
			<span id="el_invoice_details_cbm">
<input type="text" data-table="invoice_details" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($invoice_details->cbm->getPlaceHolder()) ?>" value="<?php echo $invoice_details->cbm->EditValue ?>"<?php echo $invoice_details->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->exporter_bank_details->Visible) { // exporter_bank_details ?>
	<div id="r_exporter_bank_details" class="form-group row">
		<label for="x_exporter_bank_details" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_exporter_bank_details"><?php echo $invoice_details->exporter_bank_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_exporter_bank_details" id="z_exporter_bank_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->exporter_bank_details->cellAttributes() ?>>
			<span id="el_invoice_details_exporter_bank_details">
<input type="text" data-table="invoice_details" data-field="x_exporter_bank_details" name="x_exporter_bank_details" id="x_exporter_bank_details" size="35" placeholder="<?php echo HtmlEncode($invoice_details->exporter_bank_details->getPlaceHolder()) ?>" value="<?php echo $invoice_details->exporter_bank_details->EditValue ?>"<?php echo $invoice_details->exporter_bank_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->intermediary_bank->Visible) { // intermediary_bank ?>
	<div id="r_intermediary_bank" class="form-group row">
		<label for="x_intermediary_bank" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_intermediary_bank"><?php echo $invoice_details->intermediary_bank->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_intermediary_bank" id="z_intermediary_bank" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->intermediary_bank->cellAttributes() ?>>
			<span id="el_invoice_details_intermediary_bank">
<input type="text" data-table="invoice_details" data-field="x_intermediary_bank" name="x_intermediary_bank" id="x_intermediary_bank" size="35" placeholder="<?php echo HtmlEncode($invoice_details->intermediary_bank->getPlaceHolder()) ?>" value="<?php echo $invoice_details->intermediary_bank->EditValue ?>"<?php echo $invoice_details->intermediary_bank->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->shipment_mode->Visible) { // shipment_mode ?>
	<div id="r_shipment_mode" class="form-group row">
		<label for="x_shipment_mode" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_shipment_mode"><?php echo $invoice_details->shipment_mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shipment_mode" id="z_shipment_mode" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->shipment_mode->cellAttributes() ?>>
			<span id="el_invoice_details_shipment_mode">
<input type="text" data-table="invoice_details" data-field="x_shipment_mode" name="x_shipment_mode" id="x_shipment_mode" size="30" placeholder="<?php echo HtmlEncode($invoice_details->shipment_mode->getPlaceHolder()) ?>" value="<?php echo $invoice_details->shipment_mode->EditValue ?>"<?php echo $invoice_details->shipment_mode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->ex_factory_date->Visible) { // ex_factory_date ?>
	<div id="r_ex_factory_date" class="form-group row">
		<label for="x_ex_factory_date" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_ex_factory_date"><?php echo $invoice_details->ex_factory_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ex_factory_date" id="z_ex_factory_date" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->ex_factory_date->cellAttributes() ?>>
			<span id="el_invoice_details_ex_factory_date">
<input type="text" data-table="invoice_details" data-field="x_ex_factory_date" name="x_ex_factory_date" id="x_ex_factory_date" placeholder="<?php echo HtmlEncode($invoice_details->ex_factory_date->getPlaceHolder()) ?>" value="<?php echo $invoice_details->ex_factory_date->EditValue ?>"<?php echo $invoice_details->ex_factory_date->editAttributes() ?>>
<?php if (!$invoice_details->ex_factory_date->ReadOnly && !$invoice_details->ex_factory_date->Disabled && !isset($invoice_details->ex_factory_date->EditAttrs["readonly"]) && !isset($invoice_details->ex_factory_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvoice_detailssearch", "x_ex_factory_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->sailing_date->Visible) { // sailing_date ?>
	<div id="r_sailing_date" class="form-group row">
		<label for="x_sailing_date" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_sailing_date"><?php echo $invoice_details->sailing_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sailing_date" id="z_sailing_date" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->sailing_date->cellAttributes() ?>>
			<span id="el_invoice_details_sailing_date">
<input type="text" data-table="invoice_details" data-field="x_sailing_date" name="x_sailing_date" id="x_sailing_date" placeholder="<?php echo HtmlEncode($invoice_details->sailing_date->getPlaceHolder()) ?>" value="<?php echo $invoice_details->sailing_date->EditValue ?>"<?php echo $invoice_details->sailing_date->editAttributes() ?>>
<?php if (!$invoice_details->sailing_date->ReadOnly && !$invoice_details->sailing_date->Disabled && !isset($invoice_details->sailing_date->EditAttrs["readonly"]) && !isset($invoice_details->sailing_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvoice_detailssearch", "x_sailing_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_operator"><?php echo $invoice_details->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->operator->cellAttributes() ?>>
			<span id="el_invoice_details_operator">
<input type="text" data-table="invoice_details" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($invoice_details->operator->getPlaceHolder()) ?>" value="<?php echo $invoice_details->operator->EditValue ?>"<?php echo $invoice_details->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_datetime"><?php echo $invoice_details->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->datetime->cellAttributes() ?>>
			<span id="el_invoice_details_datetime">
<input type="text" data-table="invoice_details" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($invoice_details->datetime->getPlaceHolder()) ?>" value="<?php echo $invoice_details->datetime->EditValue ?>"<?php echo $invoice_details->datetime->editAttributes() ?>>
<?php if (!$invoice_details->datetime->ReadOnly && !$invoice_details->datetime->Disabled && !isset($invoice_details->datetime->EditAttrs["readonly"]) && !isset($invoice_details->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("finvoice_detailssearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->cart_lines->Visible) { // cart_lines ?>
	<div id="r_cart_lines" class="form-group row">
		<label for="x_cart_lines" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_cart_lines"><?php echo $invoice_details->cart_lines->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cart_lines" id="z_cart_lines" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->cart_lines->cellAttributes() ?>>
			<span id="el_invoice_details_cart_lines">
<input type="text" data-table="invoice_details" data-field="x_cart_lines" name="x_cart_lines" id="x_cart_lines" size="30" placeholder="<?php echo HtmlEncode($invoice_details->cart_lines->getPlaceHolder()) ?>" value="<?php echo $invoice_details->cart_lines->EditValue ?>"<?php echo $invoice_details->cart_lines->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->pl_lines->Visible) { // pl_lines ?>
	<div id="r_pl_lines" class="form-group row">
		<label for="x_pl_lines" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_pl_lines"><?php echo $invoice_details->pl_lines->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_lines" id="z_pl_lines" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->pl_lines->cellAttributes() ?>>
			<span id="el_invoice_details_pl_lines">
<input type="text" data-table="invoice_details" data-field="x_pl_lines" name="x_pl_lines" id="x_pl_lines" size="30" placeholder="<?php echo HtmlEncode($invoice_details->pl_lines->getPlaceHolder()) ?>" value="<?php echo $invoice_details->pl_lines->EditValue ?>"<?php echo $invoice_details->pl_lines->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->freezed->Visible) { // freezed ?>
	<div id="r_freezed" class="form-group row">
		<label for="x_freezed" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_freezed"><?php echo $invoice_details->freezed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_freezed" id="z_freezed" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->freezed->cellAttributes() ?>>
			<span id="el_invoice_details_freezed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="invoice_details" data-field="x_freezed" data-value-separator="<?php echo $invoice_details->freezed->displayValueSeparatorAttribute() ?>" id="x_freezed" name="x_freezed"<?php echo $invoice_details->freezed->editAttributes() ?>>
		<?php echo $invoice_details->freezed->selectOptionListHtml("x_freezed") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_a_operator"><?php echo $invoice_details->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->a_operator->cellAttributes() ?>>
			<span id="el_invoice_details_a_operator">
<input type="text" data-table="invoice_details" data-field="x_a_operator" name="x_a_operator" id="x_a_operator" size="30" placeholder="<?php echo HtmlEncode($invoice_details->a_operator->getPlaceHolder()) ?>" value="<?php echo $invoice_details->a_operator->EditValue ?>"<?php echo $invoice_details->a_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->port_delivery->Visible) { // port_delivery ?>
	<div id="r_port_delivery" class="form-group row">
		<label for="x_port_delivery" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_port_delivery"><?php echo $invoice_details->port_delivery->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_port_delivery" id="z_port_delivery" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->port_delivery->cellAttributes() ?>>
			<span id="el_invoice_details_port_delivery">
<input type="text" data-table="invoice_details" data-field="x_port_delivery" name="x_port_delivery" id="x_port_delivery" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->port_delivery->getPlaceHolder()) ?>" value="<?php echo $invoice_details->port_delivery->EditValue ?>"<?php echo $invoice_details->port_delivery->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($invoice_details->dispatch_details->Visible) { // dispatch_details ?>
	<div id="r_dispatch_details" class="form-group row">
		<label for="x_dispatch_details" class="<?php echo $invoice_details_search->LeftColumnClass ?>"><span id="elh_invoice_details_dispatch_details"><?php echo $invoice_details->dispatch_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_dispatch_details" id="z_dispatch_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $invoice_details_search->RightColumnClass ?>"><div<?php echo $invoice_details->dispatch_details->cellAttributes() ?>>
			<span id="el_invoice_details_dispatch_details">
<input type="text" data-table="invoice_details" data-field="x_dispatch_details" name="x_dispatch_details" id="x_dispatch_details" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($invoice_details->dispatch_details->getPlaceHolder()) ?>" value="<?php echo $invoice_details->dispatch_details->EditValue ?>"<?php echo $invoice_details->dispatch_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$invoice_details_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $invoice_details_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$invoice_details_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$invoice_details_search->terminate();
?>