<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$invoice_details_view = new invoice_details_view();

// Run the page
$invoice_details_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$invoice_details_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$invoice_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var finvoice_detailsview = currentForm = new ew.Form("finvoice_detailsview", "view");

// Form_CustomValidate event
finvoice_detailsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
finvoice_detailsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
finvoice_detailsview.lists["x_exporter"] = <?php echo $invoice_details_view->exporter->Lookup->toClientList() ?>;
finvoice_detailsview.lists["x_exporter"].options = <?php echo JsonEncode($invoice_details_view->exporter->lookupOptions()) ?>;
finvoice_detailsview.lists["x_consignee"] = <?php echo $invoice_details_view->consignee->Lookup->toClientList() ?>;
finvoice_detailsview.lists["x_consignee"].options = <?php echo JsonEncode($invoice_details_view->consignee->lookupOptions()) ?>;
finvoice_detailsview.lists["x_consignee_other"] = <?php echo $invoice_details_view->consignee_other->Lookup->toClientList() ?>;
finvoice_detailsview.lists["x_consignee_other"].options = <?php echo JsonEncode($invoice_details_view->consignee_other->lookupOptions()) ?>;
finvoice_detailsview.lists["x_packing_list_no"] = <?php echo $invoice_details_view->packing_list_no->Lookup->toClientList() ?>;
finvoice_detailsview.lists["x_packing_list_no"].options = <?php echo JsonEncode($invoice_details_view->packing_list_no->lookupOptions()) ?>;
finvoice_detailsview.lists["x_in_template"] = <?php echo $invoice_details_view->in_template->Lookup->toClientList() ?>;
finvoice_detailsview.lists["x_in_template"].options = <?php echo JsonEncode($invoice_details_view->in_template->lookupOptions()) ?>;
finvoice_detailsview.lists["x_pl_template"] = <?php echo $invoice_details_view->pl_template->Lookup->toClientList() ?>;
finvoice_detailsview.lists["x_pl_template"].options = <?php echo JsonEncode($invoice_details_view->pl_template->lookupOptions()) ?>;
finvoice_detailsview.lists["x_freezed"] = <?php echo $invoice_details_view->freezed->Lookup->toClientList() ?>;
finvoice_detailsview.lists["x_freezed"].options = <?php echo JsonEncode($invoice_details_view->freezed->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$invoice_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $invoice_details_view->ExportOptions->render("body") ?>
<?php $invoice_details_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $invoice_details_view->showPageHeader(); ?>
<?php
$invoice_details_view->showMessage();
?>
<form name="finvoice_detailsview" id="finvoice_detailsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($invoice_details_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $invoice_details_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="invoice_details">
<input type="hidden" name="modal" value="<?php echo (int)$invoice_details_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($invoice_details->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_id"><?php echo $invoice_details->id->caption() ?></span></td>
		<td data-name="id"<?php echo $invoice_details->id->cellAttributes() ?>>
<span id="el_invoice_details_id">
<span<?php echo $invoice_details->id->viewAttributes() ?>>
<?php echo $invoice_details->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details__barcode"><?php echo $invoice_details->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $invoice_details->_barcode->cellAttributes() ?>>
<span id="el_invoice_details__barcode">
<span<?php echo $invoice_details->_barcode->viewAttributes() ?>>
<?php echo $invoice_details->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->exporter->Visible) { // exporter ?>
	<tr id="r_exporter">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_exporter"><?php echo $invoice_details->exporter->caption() ?></span></td>
		<td data-name="exporter"<?php echo $invoice_details->exporter->cellAttributes() ?>>
<span id="el_invoice_details_exporter">
<span<?php echo $invoice_details->exporter->viewAttributes() ?>>
<?php echo $invoice_details->exporter->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->consignee->Visible) { // consignee ?>
	<tr id="r_consignee">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_consignee"><?php echo $invoice_details->consignee->caption() ?></span></td>
		<td data-name="consignee"<?php echo $invoice_details->consignee->cellAttributes() ?>>
<span id="el_invoice_details_consignee">
<span<?php echo $invoice_details->consignee->viewAttributes() ?>>
<?php echo $invoice_details->consignee->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->consignee_other->Visible) { // consignee_other ?>
	<tr id="r_consignee_other">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_consignee_other"><?php echo $invoice_details->consignee_other->caption() ?></span></td>
		<td data-name="consignee_other"<?php echo $invoice_details->consignee_other->cellAttributes() ?>>
<span id="el_invoice_details_consignee_other">
<span<?php echo $invoice_details->consignee_other->viewAttributes() ?>>
<?php echo $invoice_details->consignee_other->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->packing_list_no->Visible) { // packing_list_no ?>
	<tr id="r_packing_list_no">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_packing_list_no"><?php echo $invoice_details->packing_list_no->caption() ?></span></td>
		<td data-name="packing_list_no"<?php echo $invoice_details->packing_list_no->cellAttributes() ?>>
<span id="el_invoice_details_packing_list_no">
<span<?php echo $invoice_details->packing_list_no->viewAttributes() ?>>
<?php echo $invoice_details->packing_list_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->d_11->Visible) { // d_11 ?>
	<tr id="r_d_11">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_d_11"><?php echo $invoice_details->d_11->caption() ?></span></td>
		<td data-name="d_11"<?php echo $invoice_details->d_11->cellAttributes() ?>>
<span id="el_invoice_details_d_11">
<span<?php echo $invoice_details->d_11->viewAttributes() ?>>
<?php echo $invoice_details->d_11->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->description_11->Visible) { // description_11 ?>
	<tr id="r_description_11">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_description_11"><?php echo $invoice_details->description_11->caption() ?></span></td>
		<td data-name="description_11"<?php echo $invoice_details->description_11->cellAttributes() ?>>
<span id="el_invoice_details_description_11">
<span<?php echo $invoice_details->description_11->viewAttributes() ?>>
<?php echo $invoice_details->description_11->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->in_template->Visible) { // in_template ?>
	<tr id="r_in_template">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_in_template"><?php echo $invoice_details->in_template->caption() ?></span></td>
		<td data-name="in_template"<?php echo $invoice_details->in_template->cellAttributes() ?>>
<span id="el_invoice_details_in_template">
<span<?php echo $invoice_details->in_template->viewAttributes() ?>>
<?php echo $invoice_details->in_template->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->pl_template->Visible) { // pl_template ?>
	<tr id="r_pl_template">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_pl_template"><?php echo $invoice_details->pl_template->caption() ?></span></td>
		<td data-name="pl_template"<?php echo $invoice_details->pl_template->cellAttributes() ?>>
<span id="el_invoice_details_pl_template">
<span<?php echo $invoice_details->pl_template->viewAttributes() ?>>
<?php echo $invoice_details->pl_template->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->invoice_no->Visible) { // invoice_no ?>
	<tr id="r_invoice_no">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_invoice_no"><?php echo $invoice_details->invoice_no->caption() ?></span></td>
		<td data-name="invoice_no"<?php echo $invoice_details->invoice_no->cellAttributes() ?>>
<span id="el_invoice_details_invoice_no">
<span<?php echo $invoice_details->invoice_no->viewAttributes() ?>>
<?php echo $invoice_details->invoice_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->invoice_date->Visible) { // invoice_date ?>
	<tr id="r_invoice_date">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_invoice_date"><?php echo $invoice_details->invoice_date->caption() ?></span></td>
		<td data-name="invoice_date"<?php echo $invoice_details->invoice_date->cellAttributes() ?>>
<span id="el_invoice_details_invoice_date">
<span<?php echo $invoice_details->invoice_date->viewAttributes() ?>>
<?php echo $invoice_details->invoice_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->po_no->Visible) { // po_no ?>
	<tr id="r_po_no">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_po_no"><?php echo $invoice_details->po_no->caption() ?></span></td>
		<td data-name="po_no"<?php echo $invoice_details->po_no->cellAttributes() ?>>
<span id="el_invoice_details_po_no">
<span<?php echo $invoice_details->po_no->viewAttributes() ?>>
<?php echo $invoice_details->po_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->other_reference->Visible) { // other_reference ?>
	<tr id="r_other_reference">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_other_reference"><?php echo $invoice_details->other_reference->caption() ?></span></td>
		<td data-name="other_reference"<?php echo $invoice_details->other_reference->cellAttributes() ?>>
<span id="el_invoice_details_other_reference">
<span<?php echo $invoice_details->other_reference->viewAttributes() ?>>
<?php echo $invoice_details->other_reference->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->origin->Visible) { // origin ?>
	<tr id="r_origin">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_origin"><?php echo $invoice_details->origin->caption() ?></span></td>
		<td data-name="origin"<?php echo $invoice_details->origin->cellAttributes() ?>>
<span id="el_invoice_details_origin">
<span<?php echo $invoice_details->origin->viewAttributes() ?>>
<?php echo $invoice_details->origin->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->final_destination->Visible) { // final_destination ?>
	<tr id="r_final_destination">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_final_destination"><?php echo $invoice_details->final_destination->caption() ?></span></td>
		<td data-name="final_destination"<?php echo $invoice_details->final_destination->cellAttributes() ?>>
<span id="el_invoice_details_final_destination">
<span<?php echo $invoice_details->final_destination->viewAttributes() ?>>
<?php echo $invoice_details->final_destination->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->payment_terms->Visible) { // payment_terms ?>
	<tr id="r_payment_terms">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_payment_terms"><?php echo $invoice_details->payment_terms->caption() ?></span></td>
		<td data-name="payment_terms"<?php echo $invoice_details->payment_terms->cellAttributes() ?>>
<span id="el_invoice_details_payment_terms">
<span<?php echo $invoice_details->payment_terms->viewAttributes() ?>>
<?php echo $invoice_details->payment_terms->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
	<tr id="r_pre_carriage_receipt">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_pre_carriage_receipt"><?php echo $invoice_details->pre_carriage_receipt->caption() ?></span></td>
		<td data-name="pre_carriage_receipt"<?php echo $invoice_details->pre_carriage_receipt->cellAttributes() ?>>
<span id="el_invoice_details_pre_carriage_receipt">
<span<?php echo $invoice_details->pre_carriage_receipt->viewAttributes() ?>>
<?php echo $invoice_details->pre_carriage_receipt->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->place_of_receipt->Visible) { // place_of_receipt ?>
	<tr id="r_place_of_receipt">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_place_of_receipt"><?php echo $invoice_details->place_of_receipt->caption() ?></span></td>
		<td data-name="place_of_receipt"<?php echo $invoice_details->place_of_receipt->cellAttributes() ?>>
<span id="el_invoice_details_place_of_receipt">
<span<?php echo $invoice_details->place_of_receipt->viewAttributes() ?>>
<?php echo $invoice_details->place_of_receipt->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->loading_port->Visible) { // loading_port ?>
	<tr id="r_loading_port">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_loading_port"><?php echo $invoice_details->loading_port->caption() ?></span></td>
		<td data-name="loading_port"<?php echo $invoice_details->loading_port->cellAttributes() ?>>
<span id="el_invoice_details_loading_port">
<span<?php echo $invoice_details->loading_port->viewAttributes() ?>>
<?php echo $invoice_details->loading_port->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->port_discharge->Visible) { // port_discharge ?>
	<tr id="r_port_discharge">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_port_discharge"><?php echo $invoice_details->port_discharge->caption() ?></span></td>
		<td data-name="port_discharge"<?php echo $invoice_details->port_discharge->cellAttributes() ?>>
<span id="el_invoice_details_port_discharge">
<span<?php echo $invoice_details->port_discharge->viewAttributes() ?>>
<?php echo $invoice_details->port_discharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->d_01->Visible) { // d_01 ?>
	<tr id="r_d_01">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_d_01"><?php echo $invoice_details->d_01->caption() ?></span></td>
		<td data-name="d_01"<?php echo $invoice_details->d_01->cellAttributes() ?>>
<span id="el_invoice_details_d_01">
<span<?php echo $invoice_details->d_01->viewAttributes() ?>>
<?php echo $invoice_details->d_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->description_01->Visible) { // description_01 ?>
	<tr id="r_description_01">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_description_01"><?php echo $invoice_details->description_01->caption() ?></span></td>
		<td data-name="description_01"<?php echo $invoice_details->description_01->cellAttributes() ?>>
<span id="el_invoice_details_description_01">
<span<?php echo $invoice_details->description_01->viewAttributes() ?>>
<?php echo $invoice_details->description_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->d_02->Visible) { // d_02 ?>
	<tr id="r_d_02">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_d_02"><?php echo $invoice_details->d_02->caption() ?></span></td>
		<td data-name="d_02"<?php echo $invoice_details->d_02->cellAttributes() ?>>
<span id="el_invoice_details_d_02">
<span<?php echo $invoice_details->d_02->viewAttributes() ?>>
<?php echo $invoice_details->d_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->description_02->Visible) { // description_02 ?>
	<tr id="r_description_02">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_description_02"><?php echo $invoice_details->description_02->caption() ?></span></td>
		<td data-name="description_02"<?php echo $invoice_details->description_02->cellAttributes() ?>>
<span id="el_invoice_details_description_02">
<span<?php echo $invoice_details->description_02->viewAttributes() ?>>
<?php echo $invoice_details->description_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->gross_weight->Visible) { // gross_weight ?>
	<tr id="r_gross_weight">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_gross_weight"><?php echo $invoice_details->gross_weight->caption() ?></span></td>
		<td data-name="gross_weight"<?php echo $invoice_details->gross_weight->cellAttributes() ?>>
<span id="el_invoice_details_gross_weight">
<span<?php echo $invoice_details->gross_weight->viewAttributes() ?>>
<?php echo $invoice_details->gross_weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->nett_weight->Visible) { // nett_weight ?>
	<tr id="r_nett_weight">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_nett_weight"><?php echo $invoice_details->nett_weight->caption() ?></span></td>
		<td data-name="nett_weight"<?php echo $invoice_details->nett_weight->cellAttributes() ?>>
<span id="el_invoice_details_nett_weight">
<span<?php echo $invoice_details->nett_weight->viewAttributes() ?>>
<?php echo $invoice_details->nett_weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->cbm->Visible) { // cbm ?>
	<tr id="r_cbm">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_cbm"><?php echo $invoice_details->cbm->caption() ?></span></td>
		<td data-name="cbm"<?php echo $invoice_details->cbm->cellAttributes() ?>>
<span id="el_invoice_details_cbm">
<span<?php echo $invoice_details->cbm->viewAttributes() ?>>
<?php echo $invoice_details->cbm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->exporter_bank_details->Visible) { // exporter_bank_details ?>
	<tr id="r_exporter_bank_details">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_exporter_bank_details"><?php echo $invoice_details->exporter_bank_details->caption() ?></span></td>
		<td data-name="exporter_bank_details"<?php echo $invoice_details->exporter_bank_details->cellAttributes() ?>>
<span id="el_invoice_details_exporter_bank_details">
<span<?php echo $invoice_details->exporter_bank_details->viewAttributes() ?>>
<?php echo $invoice_details->exporter_bank_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->intermediary_bank->Visible) { // intermediary_bank ?>
	<tr id="r_intermediary_bank">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_intermediary_bank"><?php echo $invoice_details->intermediary_bank->caption() ?></span></td>
		<td data-name="intermediary_bank"<?php echo $invoice_details->intermediary_bank->cellAttributes() ?>>
<span id="el_invoice_details_intermediary_bank">
<span<?php echo $invoice_details->intermediary_bank->viewAttributes() ?>>
<?php echo $invoice_details->intermediary_bank->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->shipment_mode->Visible) { // shipment_mode ?>
	<tr id="r_shipment_mode">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_shipment_mode"><?php echo $invoice_details->shipment_mode->caption() ?></span></td>
		<td data-name="shipment_mode"<?php echo $invoice_details->shipment_mode->cellAttributes() ?>>
<span id="el_invoice_details_shipment_mode">
<span<?php echo $invoice_details->shipment_mode->viewAttributes() ?>>
<?php echo $invoice_details->shipment_mode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->ex_factory_date->Visible) { // ex_factory_date ?>
	<tr id="r_ex_factory_date">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_ex_factory_date"><?php echo $invoice_details->ex_factory_date->caption() ?></span></td>
		<td data-name="ex_factory_date"<?php echo $invoice_details->ex_factory_date->cellAttributes() ?>>
<span id="el_invoice_details_ex_factory_date">
<span<?php echo $invoice_details->ex_factory_date->viewAttributes() ?>>
<?php echo $invoice_details->ex_factory_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->sailing_date->Visible) { // sailing_date ?>
	<tr id="r_sailing_date">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_sailing_date"><?php echo $invoice_details->sailing_date->caption() ?></span></td>
		<td data-name="sailing_date"<?php echo $invoice_details->sailing_date->cellAttributes() ?>>
<span id="el_invoice_details_sailing_date">
<span<?php echo $invoice_details->sailing_date->viewAttributes() ?>>
<?php echo $invoice_details->sailing_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_operator"><?php echo $invoice_details->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $invoice_details->operator->cellAttributes() ?>>
<span id="el_invoice_details_operator">
<span<?php echo $invoice_details->operator->viewAttributes() ?>>
<?php echo $invoice_details->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_datetime"><?php echo $invoice_details->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $invoice_details->datetime->cellAttributes() ?>>
<span id="el_invoice_details_datetime">
<span<?php echo $invoice_details->datetime->viewAttributes() ?>>
<?php echo $invoice_details->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->cart_lines->Visible) { // cart_lines ?>
	<tr id="r_cart_lines">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_cart_lines"><?php echo $invoice_details->cart_lines->caption() ?></span></td>
		<td data-name="cart_lines"<?php echo $invoice_details->cart_lines->cellAttributes() ?>>
<span id="el_invoice_details_cart_lines">
<span<?php echo $invoice_details->cart_lines->viewAttributes() ?>>
<?php echo $invoice_details->cart_lines->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->pl_lines->Visible) { // pl_lines ?>
	<tr id="r_pl_lines">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_pl_lines"><?php echo $invoice_details->pl_lines->caption() ?></span></td>
		<td data-name="pl_lines"<?php echo $invoice_details->pl_lines->cellAttributes() ?>>
<span id="el_invoice_details_pl_lines">
<span<?php echo $invoice_details->pl_lines->viewAttributes() ?>>
<?php echo $invoice_details->pl_lines->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->freezed->Visible) { // freezed ?>
	<tr id="r_freezed">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_freezed"><?php echo $invoice_details->freezed->caption() ?></span></td>
		<td data-name="freezed"<?php echo $invoice_details->freezed->cellAttributes() ?>>
<span id="el_invoice_details_freezed">
<span<?php echo $invoice_details->freezed->viewAttributes() ?>>
<?php echo $invoice_details->freezed->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->a_operator->Visible) { // a_operator ?>
	<tr id="r_a_operator">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_a_operator"><?php echo $invoice_details->a_operator->caption() ?></span></td>
		<td data-name="a_operator"<?php echo $invoice_details->a_operator->cellAttributes() ?>>
<span id="el_invoice_details_a_operator">
<span<?php echo $invoice_details->a_operator->viewAttributes() ?>>
<?php echo $invoice_details->a_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->port_delivery->Visible) { // port_delivery ?>
	<tr id="r_port_delivery">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_port_delivery"><?php echo $invoice_details->port_delivery->caption() ?></span></td>
		<td data-name="port_delivery"<?php echo $invoice_details->port_delivery->cellAttributes() ?>>
<span id="el_invoice_details_port_delivery">
<span<?php echo $invoice_details->port_delivery->viewAttributes() ?>>
<?php echo $invoice_details->port_delivery->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($invoice_details->dispatch_details->Visible) { // dispatch_details ?>
	<tr id="r_dispatch_details">
		<td class="<?php echo $invoice_details_view->TableLeftColumnClass ?>"><span id="elh_invoice_details_dispatch_details"><?php echo $invoice_details->dispatch_details->caption() ?></span></td>
		<td data-name="dispatch_details"<?php echo $invoice_details->dispatch_details->cellAttributes() ?>>
<span id="el_invoice_details_dispatch_details">
<span<?php echo $invoice_details->dispatch_details->viewAttributes() ?>>
<?php echo $invoice_details->dispatch_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$invoice_details_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$invoice_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$invoice_details_view->terminate();
?>