<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$jc_mrlot_list = new jc_mrlot_list();

// Run the page
$jc_mrlot_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$jc_mrlot_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$jc_mrlot->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjc_mrlotlist = currentForm = new ew.Form("fjc_mrlotlist", "list");
fjc_mrlotlist.formKeyCountName = '<?php echo $jc_mrlot_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjc_mrlotlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjc_mrlotlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fjc_mrlotlistsrch = currentSearchForm = new ew.Form("fjc_mrlotlistsrch");

// Filters
fjc_mrlotlistsrch.filterList = <?php echo $jc_mrlot_list->getFilterList() ?>;

// Init search panel as collapsed
fjc_mrlotlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$jc_mrlot->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($jc_mrlot_list->TotalRecs > 0 && $jc_mrlot_list->ExportOptions->visible()) { ?>
<?php $jc_mrlot_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($jc_mrlot_list->ImportOptions->visible()) { ?>
<?php $jc_mrlot_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($jc_mrlot_list->SearchOptions->visible()) { ?>
<?php $jc_mrlot_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($jc_mrlot_list->FilterOptions->visible()) { ?>
<?php $jc_mrlot_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$jc_mrlot_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$jc_mrlot->isExport() && !$jc_mrlot->CurrentAction) { ?>
<form name="fjc_mrlotlistsrch" id="fjc_mrlotlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($jc_mrlot_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjc_mrlotlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="jc_mrlot">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($jc_mrlot_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($jc_mrlot_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $jc_mrlot_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($jc_mrlot_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($jc_mrlot_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($jc_mrlot_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($jc_mrlot_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $jc_mrlot_list->showPageHeader(); ?>
<?php
$jc_mrlot_list->showMessage();
?>
<?php if ($jc_mrlot_list->TotalRecs > 0 || $jc_mrlot->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($jc_mrlot_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> jc_mrlot">
<?php if (!$jc_mrlot->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$jc_mrlot->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($jc_mrlot_list->Pager)) $jc_mrlot_list->Pager = new PrevNextPager($jc_mrlot_list->StartRec, $jc_mrlot_list->DisplayRecs, $jc_mrlot_list->TotalRecs, $jc_mrlot_list->AutoHidePager) ?>
<?php if ($jc_mrlot_list->Pager->RecordCount > 0 && $jc_mrlot_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($jc_mrlot_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($jc_mrlot_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $jc_mrlot_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($jc_mrlot_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($jc_mrlot_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($jc_mrlot_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($jc_mrlot_list->TotalRecs > 0 && (!$jc_mrlot_list->AutoHidePageSizeSelector || $jc_mrlot_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="jc_mrlot">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($jc_mrlot_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($jc_mrlot_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($jc_mrlot_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($jc_mrlot_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($jc_mrlot_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($jc_mrlot->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $jc_mrlot_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjc_mrlotlist" id="fjc_mrlotlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($jc_mrlot_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $jc_mrlot_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="jc_mrlot">
<div id="gmp_jc_mrlot" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($jc_mrlot_list->TotalRecs > 0 || $jc_mrlot->isGridEdit()) { ?>
<table id="tbl_jc_mrlotlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$jc_mrlot_list->RowType = ROWTYPE_HEADER;

// Render list options
$jc_mrlot_list->renderListOptions();

// Render list options (header, left)
$jc_mrlot_list->ListOptions->render("header", "left");
?>
<?php if ($jc_mrlot->packing->Visible) { // packing ?>
	<?php if ($jc_mrlot->sortUrl($jc_mrlot->packing) == "") { ?>
		<th data-name="packing" class="<?php echo $jc_mrlot->packing->headerCellClass() ?>"><div id="elh_jc_mrlot_packing" class="jc_mrlot_packing"><div class="ew-table-header-caption"><?php echo $jc_mrlot->packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing" class="<?php echo $jc_mrlot->packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $jc_mrlot->SortUrl($jc_mrlot->packing) ?>',2);"><div id="elh_jc_mrlot_packing" class="jc_mrlot_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $jc_mrlot->packing->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($jc_mrlot->packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($jc_mrlot->packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($jc_mrlot->lot_no->Visible) { // lot_no ?>
	<?php if ($jc_mrlot->sortUrl($jc_mrlot->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $jc_mrlot->lot_no->headerCellClass() ?>"><div id="elh_jc_mrlot_lot_no" class="jc_mrlot_lot_no"><div class="ew-table-header-caption"><?php echo $jc_mrlot->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $jc_mrlot->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $jc_mrlot->SortUrl($jc_mrlot->lot_no) ?>',2);"><div id="elh_jc_mrlot_lot_no" class="jc_mrlot_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $jc_mrlot->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($jc_mrlot->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($jc_mrlot->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($jc_mrlot->Balance->Visible) { // Balance ?>
	<?php if ($jc_mrlot->sortUrl($jc_mrlot->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $jc_mrlot->Balance->headerCellClass() ?>"><div id="elh_jc_mrlot_Balance" class="jc_mrlot_Balance"><div class="ew-table-header-caption"><?php echo $jc_mrlot->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $jc_mrlot->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $jc_mrlot->SortUrl($jc_mrlot->Balance) ?>',2);"><div id="elh_jc_mrlot_Balance" class="jc_mrlot_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $jc_mrlot->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($jc_mrlot->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($jc_mrlot->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$jc_mrlot_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($jc_mrlot->ExportAll && $jc_mrlot->isExport()) {
	$jc_mrlot_list->StopRec = $jc_mrlot_list->TotalRecs;
} else {

	// Set the last record to display
	if ($jc_mrlot_list->TotalRecs > $jc_mrlot_list->StartRec + $jc_mrlot_list->DisplayRecs - 1)
		$jc_mrlot_list->StopRec = $jc_mrlot_list->StartRec + $jc_mrlot_list->DisplayRecs - 1;
	else
		$jc_mrlot_list->StopRec = $jc_mrlot_list->TotalRecs;
}
$jc_mrlot_list->RecCnt = $jc_mrlot_list->StartRec - 1;
if ($jc_mrlot_list->Recordset && !$jc_mrlot_list->Recordset->EOF) {
	$jc_mrlot_list->Recordset->moveFirst();
	$selectLimit = $jc_mrlot_list->UseSelectLimit;
	if (!$selectLimit && $jc_mrlot_list->StartRec > 1)
		$jc_mrlot_list->Recordset->move($jc_mrlot_list->StartRec - 1);
} elseif (!$jc_mrlot->AllowAddDeleteRow && $jc_mrlot_list->StopRec == 0) {
	$jc_mrlot_list->StopRec = $jc_mrlot->GridAddRowCount;
}

// Initialize aggregate
$jc_mrlot->RowType = ROWTYPE_AGGREGATEINIT;
$jc_mrlot->resetAttributes();
$jc_mrlot_list->renderRow();
while ($jc_mrlot_list->RecCnt < $jc_mrlot_list->StopRec) {
	$jc_mrlot_list->RecCnt++;
	if ($jc_mrlot_list->RecCnt >= $jc_mrlot_list->StartRec) {
		$jc_mrlot_list->RowCnt++;

		// Set up key count
		$jc_mrlot_list->KeyCount = $jc_mrlot_list->RowIndex;

		// Init row class and style
		$jc_mrlot->resetAttributes();
		$jc_mrlot->CssClass = "";
		if ($jc_mrlot->isGridAdd()) {
		} else {
			$jc_mrlot_list->loadRowValues($jc_mrlot_list->Recordset); // Load row values
		}
		$jc_mrlot->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$jc_mrlot->RowAttrs = array_merge($jc_mrlot->RowAttrs, array('data-rowindex'=>$jc_mrlot_list->RowCnt, 'id'=>'r' . $jc_mrlot_list->RowCnt . '_jc_mrlot', 'data-rowtype'=>$jc_mrlot->RowType));

		// Render row
		$jc_mrlot_list->renderRow();

		// Render list options
		$jc_mrlot_list->renderListOptions();
?>
	<tr<?php echo $jc_mrlot->rowAttributes() ?>>
<?php

// Render list options (body, left)
$jc_mrlot_list->ListOptions->render("body", "left", $jc_mrlot_list->RowCnt);
?>
	<?php if ($jc_mrlot->packing->Visible) { // packing ?>
		<td data-name="packing"<?php echo $jc_mrlot->packing->cellAttributes() ?>>
<span id="el<?php echo $jc_mrlot_list->RowCnt ?>_jc_mrlot_packing" class="jc_mrlot_packing">
<span<?php echo $jc_mrlot->packing->viewAttributes() ?>>
<?php echo $jc_mrlot->packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($jc_mrlot->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $jc_mrlot->lot_no->cellAttributes() ?>>
<span id="el<?php echo $jc_mrlot_list->RowCnt ?>_jc_mrlot_lot_no" class="jc_mrlot_lot_no">
<span<?php echo $jc_mrlot->lot_no->viewAttributes() ?>>
<?php echo $jc_mrlot->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($jc_mrlot->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $jc_mrlot->Balance->cellAttributes() ?>>
<span id="el<?php echo $jc_mrlot_list->RowCnt ?>_jc_mrlot_Balance" class="jc_mrlot_Balance">
<span<?php echo $jc_mrlot->Balance->viewAttributes() ?>>
<?php echo $jc_mrlot->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$jc_mrlot_list->ListOptions->render("body", "right", $jc_mrlot_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$jc_mrlot->isGridAdd())
		$jc_mrlot_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$jc_mrlot->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($jc_mrlot_list->Recordset)
	$jc_mrlot_list->Recordset->Close();
?>
<?php if (!$jc_mrlot->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$jc_mrlot->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($jc_mrlot_list->Pager)) $jc_mrlot_list->Pager = new PrevNextPager($jc_mrlot_list->StartRec, $jc_mrlot_list->DisplayRecs, $jc_mrlot_list->TotalRecs, $jc_mrlot_list->AutoHidePager) ?>
<?php if ($jc_mrlot_list->Pager->RecordCount > 0 && $jc_mrlot_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($jc_mrlot_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($jc_mrlot_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $jc_mrlot_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($jc_mrlot_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($jc_mrlot_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $jc_mrlot_list->pageUrl() ?>start=<?php echo $jc_mrlot_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($jc_mrlot_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $jc_mrlot_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($jc_mrlot_list->TotalRecs > 0 && (!$jc_mrlot_list->AutoHidePageSizeSelector || $jc_mrlot_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="jc_mrlot">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($jc_mrlot_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($jc_mrlot_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($jc_mrlot_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($jc_mrlot_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($jc_mrlot_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($jc_mrlot->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $jc_mrlot_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($jc_mrlot_list->TotalRecs == 0 && !$jc_mrlot->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $jc_mrlot_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$jc_mrlot_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$jc_mrlot->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$jc_mrlot_list->terminate();
?>