<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_bc_add = new job_card_bc_add();

// Run the page
$job_card_bc_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_bc_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fjob_card_bcadd = currentForm = new ew.Form("fjob_card_bcadd", "add");

// Validate form
fjob_card_bcadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($job_card_bc_add->no->Required) { ?>
			elm = this.getElements("x" + infix + "_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->no->caption(), $job_card_bc->no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card_bc->no->errorMessage()) ?>");
		<?php if ($job_card_bc_add->works->Required) { ?>
			elm = this.getElements("x" + infix + "_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->works->caption(), $job_card_bc->works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->issue_to->caption(), $job_card_bc->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->grp->caption(), $job_card_bc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->s_grp->caption(), $job_card_bc->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->po->caption(), $job_card_bc->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->design_size->Required) { ?>
			elm = this.getElements("x" + infix + "_design_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->design_size->caption(), $job_card_bc->design_size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->size_wl->Required) { ?>
			elm = this.getElements("x" + infix + "_size_wl");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->size_wl->caption(), $job_card_bc->size_wl->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->loom_no->Required) { ?>
			elm = this.getElements("x" + infix + "_loom_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->loom_no->caption(), $job_card_bc->loom_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->employee_1->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->employee_1->caption(), $job_card_bc->employee_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->employee_2->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->employee_2->caption(), $job_card_bc->employee_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->employee_3->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->employee_3->caption(), $job_card_bc->employee_3->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_employee_3");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card_bc->employee_3->errorMessage()) ?>");
		<?php if ($job_card_bc_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_barcode->caption(), $job_card_bc->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->r_date->Required) { ?>
			elm = this.getElements("x" + infix + "_r_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->r_date->caption(), $job_card_bc->r_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_r_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card_bc->r_date->errorMessage()) ?>");
		<?php if ($job_card_bc_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->lot_no->caption(), $job_card_bc->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->deduction->Required) { ?>
			elm = this.getElements("x" + infix + "_deduction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->deduction->caption(), $job_card_bc->deduction->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_deduction");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card_bc->deduction->errorMessage()) ?>");
		<?php if ($job_card_bc_add->ded_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_ded_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->ded_remarks->caption(), $job_card_bc->ded_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->operator->caption(), $job_card_bc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->datetime->caption(), $job_card_bc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_1->Required) { ?>
			elm = this.getElements("x" + infix + "__1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_1->caption(), $job_card_bc->_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_2->Required) { ?>
			elm = this.getElements("x" + infix + "__2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_2->caption(), $job_card_bc->_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_3->Required) { ?>
			elm = this.getElements("x" + infix + "__3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_3->caption(), $job_card_bc->_3->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_4->Required) { ?>
			elm = this.getElements("x" + infix + "__4");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_4->caption(), $job_card_bc->_4->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_5->Required) { ?>
			elm = this.getElements("x" + infix + "__5");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_5->caption(), $job_card_bc->_5->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_6->Required) { ?>
			elm = this.getElements("x" + infix + "__6");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_6->caption(), $job_card_bc->_6->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_7->Required) { ?>
			elm = this.getElements("x" + infix + "__7");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_7->caption(), $job_card_bc->_7->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->_8->Required) { ?>
			elm = this.getElements("x" + infix + "__8");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->_8->caption(), $job_card_bc->_8->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->other1->Required) { ?>
			elm = this.getElements("x" + infix + "_other1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->other1->caption(), $job_card_bc->other1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_bc_add->other2->Required) { ?>
			elm = this.getElements("x" + infix + "_other2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_bc->other2->caption(), $job_card_bc->other2->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjob_card_bcadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_bcadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_bcadd.lists["x_works"] = <?php echo $job_card_bc_add->works->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_works"].options = <?php echo JsonEncode($job_card_bc_add->works->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_issue_to"] = <?php echo $job_card_bc_add->issue_to->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_bc_add->issue_to->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_grp"] = <?php echo $job_card_bc_add->grp->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_grp"].options = <?php echo JsonEncode($job_card_bc_add->grp->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_s_grp"] = <?php echo $job_card_bc_add->s_grp->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_bc_add->s_grp->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_po"] = <?php echo $job_card_bc_add->po->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_po"].options = <?php echo JsonEncode($job_card_bc_add->po->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_design_size"] = <?php echo $job_card_bc_add->design_size->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_design_size"].options = <?php echo JsonEncode($job_card_bc_add->design_size->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_loom_no"] = <?php echo $job_card_bc_add->loom_no->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_loom_no"].options = <?php echo JsonEncode($job_card_bc_add->loom_no->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_employee_1"] = <?php echo $job_card_bc_add->employee_1->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_employee_1"].options = <?php echo JsonEncode($job_card_bc_add->employee_1->lookupOptions()) ?>;
fjob_card_bcadd.autoSuggests["x_employee_1"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjob_card_bcadd.lists["x_employee_2"] = <?php echo $job_card_bc_add->employee_2->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_employee_2"].options = <?php echo JsonEncode($job_card_bc_add->employee_2->lookupOptions()) ?>;
fjob_card_bcadd.autoSuggests["x_employee_2"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjob_card_bcadd.lists["x_employee_3"] = <?php echo $job_card_bc_add->employee_3->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_employee_3"].options = <?php echo JsonEncode($job_card_bc_add->employee_3->lookupOptions()) ?>;
fjob_card_bcadd.autoSuggests["x_employee_3"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjob_card_bcadd.lists["x__barcode[]"] = <?php echo $job_card_bc_add->_barcode->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x__barcode[]"].options = <?php echo JsonEncode($job_card_bc_add->_barcode->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_lot_no[]"] = <?php echo $job_card_bc_add->lot_no->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_lot_no[]"].options = <?php echo JsonEncode($job_card_bc_add->lot_no->lookupOptions()) ?>;
fjob_card_bcadd.lists["x_operator"] = <?php echo $job_card_bc_add->operator->Lookup->toClientList() ?>;
fjob_card_bcadd.lists["x_operator"].options = <?php echo JsonEncode($job_card_bc_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_bc_add->showPageHeader(); ?>
<?php
$job_card_bc_add->showMessage();
?>
<form name="fjob_card_bcadd" id="fjob_card_bcadd" class="<?php echo $job_card_bc_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_bc_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_bc_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_bc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_bc_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($job_card_bc->no->Visible) { // no ?>
	<div id="r_no" class="form-group row">
		<label id="elh_job_card_bc_no" for="x_no" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->no->caption() ?><?php echo ($job_card_bc->no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->no->cellAttributes() ?>>
<span id="el_job_card_bc_no">
<input type="text" data-table="job_card_bc" data-field="x_no" name="x_no" id="x_no" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->no->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->no->EditValue ?>"<?php echo $job_card_bc->no->editAttributes() ?>>
</span>
<?php echo $job_card_bc->no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->works->Visible) { // works ?>
	<div id="r_works" class="form-group row">
		<label id="elh_job_card_bc_works" for="x_works" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->works->caption() ?><?php echo ($job_card_bc->works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->works->cellAttributes() ?>>
<span id="el_job_card_bc_works">
<?php $job_card_bc->works->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_bc->works->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_works" data-value-separator="<?php echo $job_card_bc->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card_bc->works->editAttributes() ?>>
		<?php echo $job_card_bc->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card_bc->works->Lookup->getParamTag("p_x_works") ?>
</span>
<?php echo $job_card_bc->works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_job_card_bc_issue_to" for="x_issue_to" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->issue_to->caption() ?><?php echo ($job_card_bc->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->issue_to->cellAttributes() ?>>
<span id="el_job_card_bc_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_issue_to" data-value-separator="<?php echo $job_card_bc->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $job_card_bc->issue_to->editAttributes() ?>>
		<?php echo $job_card_bc->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $job_card_bc->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $job_card_bc->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_job_card_bc_grp" for="x_grp" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->grp->caption() ?><?php echo ($job_card_bc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->grp->cellAttributes() ?>>
<span id="el_job_card_bc_grp">
<?php $job_card_bc->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_bc->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_grp" data-value-separator="<?php echo $job_card_bc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $job_card_bc->grp->editAttributes() ?>>
		<?php echo $job_card_bc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $job_card_bc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $job_card_bc->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_job_card_bc_s_grp" for="x_s_grp" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->s_grp->caption() ?><?php echo ($job_card_bc->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->s_grp->cellAttributes() ?>>
<span id="el_job_card_bc_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_s_grp" data-value-separator="<?php echo $job_card_bc->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $job_card_bc->s_grp->editAttributes() ?>>
		<?php echo $job_card_bc->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $job_card_bc->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $job_card_bc->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_job_card_bc_po" for="x_po" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->po->caption() ?><?php echo ($job_card_bc->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->po->cellAttributes() ?>>
<span id="el_job_card_bc_po">
<?php $job_card_bc->po->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_bc->po->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_po" data-value-separator="<?php echo $job_card_bc->po->displayValueSeparatorAttribute() ?>" id="x_po" name="x_po"<?php echo $job_card_bc->po->editAttributes() ?>>
		<?php echo $job_card_bc->po->selectOptionListHtml("x_po") ?>
	</select>
</div>
<?php echo $job_card_bc->po->Lookup->getParamTag("p_x_po") ?>
</span>
<?php echo $job_card_bc->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->design_size->Visible) { // design_size ?>
	<div id="r_design_size" class="form-group row">
		<label id="elh_job_card_bc_design_size" for="x_design_size" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->design_size->caption() ?><?php echo ($job_card_bc->design_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->design_size->cellAttributes() ?>>
<span id="el_job_card_bc_design_size">
<?php $job_card_bc->design_size->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_bc->design_size->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_design_size" data-value-separator="<?php echo $job_card_bc->design_size->displayValueSeparatorAttribute() ?>" id="x_design_size" name="x_design_size"<?php echo $job_card_bc->design_size->editAttributes() ?>>
		<?php echo $job_card_bc->design_size->selectOptionListHtml("x_design_size") ?>
	</select>
</div>
<?php echo $job_card_bc->design_size->Lookup->getParamTag("p_x_design_size") ?>
</span>
<?php echo $job_card_bc->design_size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->size_wl->Visible) { // size_wl ?>
	<div id="r_size_wl" class="form-group row">
		<label id="elh_job_card_bc_size_wl" for="x_size_wl" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->size_wl->caption() ?><?php echo ($job_card_bc->size_wl->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->size_wl->cellAttributes() ?>>
<span id="el_job_card_bc_size_wl">
<input type="text" data-table="job_card_bc" data-field="x_size_wl" name="x_size_wl" id="x_size_wl" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->size_wl->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->size_wl->EditValue ?>"<?php echo $job_card_bc->size_wl->editAttributes() ?>>
</span>
<?php echo $job_card_bc->size_wl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->loom_no->Visible) { // loom_no ?>
	<div id="r_loom_no" class="form-group row">
		<label id="elh_job_card_bc_loom_no" for="x_loom_no" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->loom_no->caption() ?><?php echo ($job_card_bc->loom_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->loom_no->cellAttributes() ?>>
<span id="el_job_card_bc_loom_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_loom_no" data-value-separator="<?php echo $job_card_bc->loom_no->displayValueSeparatorAttribute() ?>" id="x_loom_no" name="x_loom_no"<?php echo $job_card_bc->loom_no->editAttributes() ?>>
		<?php echo $job_card_bc->loom_no->selectOptionListHtml("x_loom_no") ?>
	</select>
</div>
<?php echo $job_card_bc->loom_no->Lookup->getParamTag("p_x_loom_no") ?>
</span>
<?php echo $job_card_bc->loom_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->employee_1->Visible) { // employee_1 ?>
	<div id="r_employee_1" class="form-group row">
		<label id="elh_job_card_bc_employee_1" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->employee_1->caption() ?><?php echo ($job_card_bc->employee_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->employee_1->cellAttributes() ?>>
<span id="el_job_card_bc_employee_1">
<?php
$wrkonchange = "" . trim(@$job_card_bc->employee_1->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card_bc->employee_1->EditAttrs["onchange"] = "";
?>
<span id="as_x_employee_1" class="text-nowrap" style="z-index: 8880">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_employee_1" id="sv_x_employee_1" value="<?php echo RemoveHtml($job_card_bc->employee_1->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->employee_1->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card_bc->employee_1->getPlaceHolder()) ?>"<?php echo $job_card_bc->employee_1->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card_bc->employee_1->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_employee_1',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($job_card_bc->employee_1->ReadOnly || $job_card_bc->employee_1->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="job_card_bc" data-field="x_employee_1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $job_card_bc->employee_1->displayValueSeparatorAttribute() ?>" name="x_employee_1" id="x_employee_1" value="<?php echo HtmlEncode($job_card_bc->employee_1->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_card_bcadd.createAutoSuggest({"id":"x_employee_1","forceSelect":true});
</script>
<?php echo $job_card_bc->employee_1->Lookup->getParamTag("p_x_employee_1") ?>
</span>
<?php echo $job_card_bc->employee_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->employee_2->Visible) { // employee_2 ?>
	<div id="r_employee_2" class="form-group row">
		<label id="elh_job_card_bc_employee_2" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->employee_2->caption() ?><?php echo ($job_card_bc->employee_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->employee_2->cellAttributes() ?>>
<span id="el_job_card_bc_employee_2">
<?php
$wrkonchange = "" . trim(@$job_card_bc->employee_2->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card_bc->employee_2->EditAttrs["onchange"] = "";
?>
<span id="as_x_employee_2" class="text-nowrap" style="z-index: 8870">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_employee_2" id="sv_x_employee_2" value="<?php echo RemoveHtml($job_card_bc->employee_2->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->employee_2->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card_bc->employee_2->getPlaceHolder()) ?>"<?php echo $job_card_bc->employee_2->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card_bc->employee_2->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_employee_2',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($job_card_bc->employee_2->ReadOnly || $job_card_bc->employee_2->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="job_card_bc" data-field="x_employee_2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $job_card_bc->employee_2->displayValueSeparatorAttribute() ?>" name="x_employee_2" id="x_employee_2" value="<?php echo HtmlEncode($job_card_bc->employee_2->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_card_bcadd.createAutoSuggest({"id":"x_employee_2","forceSelect":true});
</script>
<?php echo $job_card_bc->employee_2->Lookup->getParamTag("p_x_employee_2") ?>
</span>
<?php echo $job_card_bc->employee_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->employee_3->Visible) { // employee_3 ?>
	<div id="r_employee_3" class="form-group row">
		<label id="elh_job_card_bc_employee_3" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->employee_3->caption() ?><?php echo ($job_card_bc->employee_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->employee_3->cellAttributes() ?>>
<span id="el_job_card_bc_employee_3">
<?php
$wrkonchange = "" . trim(@$job_card_bc->employee_3->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card_bc->employee_3->EditAttrs["onchange"] = "";
?>
<span id="as_x_employee_3" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_employee_3" id="sv_x_employee_3" value="<?php echo RemoveHtml($job_card_bc->employee_3->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->employee_3->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card_bc->employee_3->getPlaceHolder()) ?>"<?php echo $job_card_bc->employee_3->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card_bc->employee_3->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_employee_3',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($job_card_bc->employee_3->ReadOnly || $job_card_bc->employee_3->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="job_card_bc" data-field="x_employee_3" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $job_card_bc->employee_3->displayValueSeparatorAttribute() ?>" name="x_employee_3" id="x_employee_3" value="<?php echo HtmlEncode($job_card_bc->employee_3->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_card_bcadd.createAutoSuggest({"id":"x_employee_3","forceSelect":true});
</script>
<?php echo $job_card_bc->employee_3->Lookup->getParamTag("p_x_employee_3") ?>
</span>
<?php echo $job_card_bc->employee_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_job_card_bc__barcode" for="x__barcode" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_barcode->caption() ?><?php echo ($job_card_bc->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_barcode->cellAttributes() ?>>
<span id="el_job_card_bc__barcode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x__barcode" data-value-separator="<?php echo $job_card_bc->_barcode->displayValueSeparatorAttribute() ?>" id="x__barcode[]" name="x__barcode[]" size=10 multiple="multiple"<?php echo $job_card_bc->_barcode->editAttributes() ?>>
		<?php echo $job_card_bc->_barcode->selectOptionListHtml("x__barcode[]") ?>
	</select>
</div>
<?php echo $job_card_bc->_barcode->Lookup->getParamTag("p_x__barcode") ?>
</span>
<?php echo $job_card_bc->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->r_date->Visible) { // r_date ?>
	<div id="r_r_date" class="form-group row">
		<label id="elh_job_card_bc_r_date" for="x_r_date" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->r_date->caption() ?><?php echo ($job_card_bc->r_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->r_date->cellAttributes() ?>>
<span id="el_job_card_bc_r_date">
<input type="text" data-table="job_card_bc" data-field="x_r_date" name="x_r_date" id="x_r_date" placeholder="<?php echo HtmlEncode($job_card_bc->r_date->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->r_date->EditValue ?>"<?php echo $job_card_bc->r_date->editAttributes() ?>>
<?php if (!$job_card_bc->r_date->ReadOnly && !$job_card_bc->r_date->Disabled && !isset($job_card_bc->r_date->EditAttrs["readonly"]) && !isset($job_card_bc->r_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjob_card_bcadd", "x_r_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $job_card_bc->r_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_job_card_bc_lot_no" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->lot_no->caption() ?><?php echo ($job_card_bc->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->lot_no->cellAttributes() ?>>
<span id="el_job_card_bc_lot_no">
<div id="tp_x_lot_no" class="ew-template"><input type="checkbox" class="form-check-input" data-table="job_card_bc" data-field="x_lot_no" data-value-separator="<?php echo $job_card_bc->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no[]" id="x_lot_no[]" value="{value}"<?php echo $job_card_bc->lot_no->editAttributes() ?>></div>
<div id="dsl_x_lot_no" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $job_card_bc->lot_no->checkBoxListHtml(FALSE, "x_lot_no[]") ?>
</div></div>
<?php echo $job_card_bc->lot_no->Lookup->getParamTag("p_x_lot_no") ?>
</span>
<?php echo $job_card_bc->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label id="elh_job_card_bc_deduction" for="x_deduction" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->deduction->caption() ?><?php echo ($job_card_bc->deduction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->deduction->cellAttributes() ?>>
<span id="el_job_card_bc_deduction">
<input type="text" data-table="job_card_bc" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->deduction->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->deduction->EditValue ?>"<?php echo $job_card_bc->deduction->editAttributes() ?>>
</span>
<?php echo $job_card_bc->deduction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->ded_remarks->Visible) { // ded_remarks ?>
	<div id="r_ded_remarks" class="form-group row">
		<label id="elh_job_card_bc_ded_remarks" for="x_ded_remarks" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->ded_remarks->caption() ?><?php echo ($job_card_bc->ded_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->ded_remarks->cellAttributes() ?>>
<span id="el_job_card_bc_ded_remarks">
<input type="text" data-table="job_card_bc" data-field="x_ded_remarks" name="x_ded_remarks" id="x_ded_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card_bc->ded_remarks->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->ded_remarks->EditValue ?>"<?php echo $job_card_bc->ded_remarks->editAttributes() ?>>
</span>
<?php echo $job_card_bc->ded_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_1->Visible) { // 1 ?>
	<div id="r__1" class="form-group row">
		<label id="elh_job_card_bc__1" for="x__1" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_1->caption() ?><?php echo ($job_card_bc->_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_1->cellAttributes() ?>>
<span id="el_job_card_bc__1">
<input type="text" data-table="job_card_bc" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_1->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_1->EditValue ?>"<?php echo $job_card_bc->_1->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_2->Visible) { // 2 ?>
	<div id="r__2" class="form-group row">
		<label id="elh_job_card_bc__2" for="x__2" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_2->caption() ?><?php echo ($job_card_bc->_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_2->cellAttributes() ?>>
<span id="el_job_card_bc__2">
<input type="text" data-table="job_card_bc" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_2->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_2->EditValue ?>"<?php echo $job_card_bc->_2->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_3->Visible) { // 3 ?>
	<div id="r__3" class="form-group row">
		<label id="elh_job_card_bc__3" for="x__3" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_3->caption() ?><?php echo ($job_card_bc->_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_3->cellAttributes() ?>>
<span id="el_job_card_bc__3">
<input type="text" data-table="job_card_bc" data-field="x__3" name="x__3" id="x__3" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_3->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_3->EditValue ?>"<?php echo $job_card_bc->_3->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_4->Visible) { // 4 ?>
	<div id="r__4" class="form-group row">
		<label id="elh_job_card_bc__4" for="x__4" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_4->caption() ?><?php echo ($job_card_bc->_4->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_4->cellAttributes() ?>>
<span id="el_job_card_bc__4">
<input type="text" data-table="job_card_bc" data-field="x__4" name="x__4" id="x__4" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_4->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_4->EditValue ?>"<?php echo $job_card_bc->_4->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_5->Visible) { // 5 ?>
	<div id="r__5" class="form-group row">
		<label id="elh_job_card_bc__5" for="x__5" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_5->caption() ?><?php echo ($job_card_bc->_5->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_5->cellAttributes() ?>>
<span id="el_job_card_bc__5">
<input type="text" data-table="job_card_bc" data-field="x__5" name="x__5" id="x__5" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_5->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_5->EditValue ?>"<?php echo $job_card_bc->_5->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_5->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_6->Visible) { // 6 ?>
	<div id="r__6" class="form-group row">
		<label id="elh_job_card_bc__6" for="x__6" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_6->caption() ?><?php echo ($job_card_bc->_6->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_6->cellAttributes() ?>>
<span id="el_job_card_bc__6">
<input type="text" data-table="job_card_bc" data-field="x__6" name="x__6" id="x__6" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_6->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_6->EditValue ?>"<?php echo $job_card_bc->_6->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_6->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_7->Visible) { // 7 ?>
	<div id="r__7" class="form-group row">
		<label id="elh_job_card_bc__7" for="x__7" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_7->caption() ?><?php echo ($job_card_bc->_7->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_7->cellAttributes() ?>>
<span id="el_job_card_bc__7">
<input type="text" data-table="job_card_bc" data-field="x__7" name="x__7" id="x__7" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_7->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_7->EditValue ?>"<?php echo $job_card_bc->_7->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_7->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_8->Visible) { // 8 ?>
	<div id="r__8" class="form-group row">
		<label id="elh_job_card_bc__8" for="x__8" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->_8->caption() ?><?php echo ($job_card_bc->_8->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->_8->cellAttributes() ?>>
<span id="el_job_card_bc__8">
<input type="text" data-table="job_card_bc" data-field="x__8" name="x__8" id="x__8" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_8->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_8->EditValue ?>"<?php echo $job_card_bc->_8->editAttributes() ?>>
</span>
<?php echo $job_card_bc->_8->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->other1->Visible) { // other1 ?>
	<div id="r_other1" class="form-group row">
		<label id="elh_job_card_bc_other1" for="x_other1" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->other1->caption() ?><?php echo ($job_card_bc->other1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->other1->cellAttributes() ?>>
<span id="el_job_card_bc_other1">
<input type="text" data-table="job_card_bc" data-field="x_other1" name="x_other1" id="x_other1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->other1->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->other1->EditValue ?>"<?php echo $job_card_bc->other1->editAttributes() ?>>
</span>
<?php echo $job_card_bc->other1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->other2->Visible) { // other2 ?>
	<div id="r_other2" class="form-group row">
		<label id="elh_job_card_bc_other2" for="x_other2" class="<?php echo $job_card_bc_add->LeftColumnClass ?>"><?php echo $job_card_bc->other2->caption() ?><?php echo ($job_card_bc->other2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_bc_add->RightColumnClass ?>"><div<?php echo $job_card_bc->other2->cellAttributes() ?>>
<span id="el_job_card_bc_other2">
<input type="text" data-table="job_card_bc" data-field="x_other2" name="x_other2" id="x_other2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->other2->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->other2->EditValue ?>"<?php echo $job_card_bc->other2->editAttributes() ?>>
</span>
<?php echo $job_card_bc->other2->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$job_card_bc_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $job_card_bc_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $job_card_bc_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$job_card_bc_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var jloc = getCookie('location')
		if (jloc == 1)
		{
		$('#r_issue_to').show()
		}
		else
		{
		$('#r_issue_to').val(0)		
		$('#r_issue_to').hide()
		}
		var SGrp = $("#x_s_grp").val();
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
					if (data.jc_01_head == '--NA--') {
					$("#r__1").hide(); } else {
					$("#r__1").show();					
					$("#elh_job_card_bc__1").html(data.jc_01_head);}
					if (data.jc_02_head == '--NA--') {
					$("#r__2").hide(); } else {
					$("#r__2").show();					
					$("#elh_job_card_bc__2").html(data.jc_02_head);}
					if (data.jc_03_head == '--NA--') {
					$("#r__3").hide(); } else {
					$("#r__3").show();					
					$("#elh_job_card_bc__3").html(data.jc_03_head);}
					if (data.jc_04_head == '--NA--') {
					$("#r__4").hide(); } else {
					$("#r__4").show();					
					$("#elh_job_card_bc__4").html(data.jc_04_head);}
					if (data.jc_05_head == '--NA--') {
					$("#r__5").hide(); } else {
					$("#r__5").show();					
					$("#elh_job_card_bc__5").html(data.jc_05_head);}
					if (data.jc_06_head == '--NA--') {
					$("#r__6").hide(); } else {
					$("#r__6").show();					
					$("#elh_job_card_bc__6").html(data.jc_06_head);}
					if (data.jc_07_head == '--NA--') {
					$("#r__7").hide(); } else {
					$("#r__7").show();					
					$("#elh_job_card_bc__7").html(data.jc_07_head);}
					if (data.jc_08_head == '--NA--') {
					$("#r__8").hide(); } else {
					$("#r__8").show();					
					$("#elh_job_card_bc__8").html(data.jc_08_head);}
					if (data.jc_09_head == '--NA--') {
					$("#r_other1").hide(); } else {
					$("#r_other1").show();					
					$("#elh_job_card_bc_other1").html(data.jc_09_head);}
					if (data.jc_10_head == '--NA--') {
					$("#r_other2").hide(); } else {
					$("#r_other2").show();					
					$("#elh_job_card_bc_other2").html(data.jc_10_head);}					
					});
				}	
</script>
<?php include_once "footer.php" ?>
<?php
$job_card_bc_add->terminate();
?>