<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_bc_list = new job_card_bc_list();

// Run the page
$job_card_bc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_bc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card_bc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjob_card_bclist = currentForm = new ew.Form("fjob_card_bclist", "list");
fjob_card_bclist.formKeyCountName = '<?php echo $job_card_bc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjob_card_bclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_bclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_bclist.lists["x_works"] = <?php echo $job_card_bc_list->works->Lookup->toClientList() ?>;
fjob_card_bclist.lists["x_works"].options = <?php echo JsonEncode($job_card_bc_list->works->lookupOptions()) ?>;
fjob_card_bclist.lists["x_issue_to"] = <?php echo $job_card_bc_list->issue_to->Lookup->toClientList() ?>;
fjob_card_bclist.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_bc_list->issue_to->lookupOptions()) ?>;
fjob_card_bclist.lists["x_po"] = <?php echo $job_card_bc_list->po->Lookup->toClientList() ?>;
fjob_card_bclist.lists["x_po"].options = <?php echo JsonEncode($job_card_bc_list->po->lookupOptions()) ?>;
fjob_card_bclist.lists["x__barcode[]"] = <?php echo $job_card_bc_list->_barcode->Lookup->toClientList() ?>;
fjob_card_bclist.lists["x__barcode[]"].options = <?php echo JsonEncode($job_card_bc_list->_barcode->lookupOptions()) ?>;
fjob_card_bclist.lists["x_lot_no[]"] = <?php echo $job_card_bc_list->lot_no->Lookup->toClientList() ?>;
fjob_card_bclist.lists["x_lot_no[]"].options = <?php echo JsonEncode($job_card_bc_list->lot_no->lookupOptions()) ?>;

// Form object for search
var fjob_card_bclistsrch = currentSearchForm = new ew.Form("fjob_card_bclistsrch");

// Filters
fjob_card_bclistsrch.filterList = <?php echo $job_card_bc_list->getFilterList() ?>;

// Init search panel as collapsed
fjob_card_bclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card_bc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($job_card_bc_list->TotalRecs > 0 && $job_card_bc_list->ExportOptions->visible()) { ?>
<?php $job_card_bc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_bc_list->ImportOptions->visible()) { ?>
<?php $job_card_bc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_bc_list->SearchOptions->visible()) { ?>
<?php $job_card_bc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_bc_list->FilterOptions->visible()) { ?>
<?php $job_card_bc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$job_card_bc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$job_card_bc->isExport() && !$job_card_bc->CurrentAction) { ?>
<form name="fjob_card_bclistsrch" id="fjob_card_bclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($job_card_bc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjob_card_bclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="job_card_bc">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($job_card_bc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($job_card_bc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $job_card_bc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($job_card_bc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($job_card_bc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($job_card_bc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($job_card_bc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $job_card_bc_list->showPageHeader(); ?>
<?php
$job_card_bc_list->showMessage();
?>
<?php if ($job_card_bc_list->TotalRecs > 0 || $job_card_bc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($job_card_bc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> job_card_bc">
<?php if (!$job_card_bc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$job_card_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_bc_list->Pager)) $job_card_bc_list->Pager = new PrevNextPager($job_card_bc_list->StartRec, $job_card_bc_list->DisplayRecs, $job_card_bc_list->TotalRecs, $job_card_bc_list->AutoHidePager) ?>
<?php if ($job_card_bc_list->Pager->RecordCount > 0 && $job_card_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_bc_list->TotalRecs > 0 && (!$job_card_bc_list->AutoHidePageSizeSelector || $job_card_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_bc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($job_card_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjob_card_bclist" id="fjob_card_bclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_bc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_bc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_bc">
<div id="gmp_job_card_bc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($job_card_bc_list->TotalRecs > 0 || $job_card_bc->isGridEdit()) { ?>
<table id="tbl_job_card_bclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$job_card_bc_list->RowType = ROWTYPE_HEADER;

// Render list options
$job_card_bc_list->renderListOptions();

// Render list options (header, left)
$job_card_bc_list->ListOptions->render("header", "left");
?>
<?php if ($job_card_bc->id->Visible) { // id ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->id) == "") { ?>
		<th data-name="id" class="<?php echo $job_card_bc->id->headerCellClass() ?>"><div id="elh_job_card_bc_id" class="job_card_bc_id"><div class="ew-table-header-caption"><?php echo $job_card_bc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $job_card_bc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->id) ?>',1);"><div id="elh_job_card_bc_id" class="job_card_bc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->no->Visible) { // no ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->no) == "") { ?>
		<th data-name="no" class="<?php echo $job_card_bc->no->headerCellClass() ?>"><div id="elh_job_card_bc_no" class="job_card_bc_no"><div class="ew-table-header-caption"><?php echo $job_card_bc->no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no" class="<?php echo $job_card_bc->no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->no) ?>',1);"><div id="elh_job_card_bc_no" class="job_card_bc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->works->Visible) { // works ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->works) == "") { ?>
		<th data-name="works" class="<?php echo $job_card_bc->works->headerCellClass() ?>"><div id="elh_job_card_bc_works" class="job_card_bc_works"><div class="ew-table-header-caption"><?php echo $job_card_bc->works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="works" class="<?php echo $job_card_bc->works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->works) ?>',1);"><div id="elh_job_card_bc_works" class="job_card_bc_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->works->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->issue_to->Visible) { // issue_to ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $job_card_bc->issue_to->headerCellClass() ?>"><div id="elh_job_card_bc_issue_to" class="job_card_bc_issue_to"><div class="ew-table-header-caption"><?php echo $job_card_bc->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $job_card_bc->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->issue_to) ?>',1);"><div id="elh_job_card_bc_issue_to" class="job_card_bc_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->po->Visible) { // po ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->po) == "") { ?>
		<th data-name="po" class="<?php echo $job_card_bc->po->headerCellClass() ?>"><div id="elh_job_card_bc_po" class="job_card_bc_po"><div class="ew-table-header-caption"><?php echo $job_card_bc->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $job_card_bc->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->po) ?>',1);"><div id="elh_job_card_bc_po" class="job_card_bc_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->design_size_1->Visible) { // design_size_1 ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->design_size_1) == "") { ?>
		<th data-name="design_size_1" class="<?php echo $job_card_bc->design_size_1->headerCellClass() ?>"><div id="elh_job_card_bc_design_size_1" class="job_card_bc_design_size_1"><div class="ew-table-header-caption"><?php echo $job_card_bc->design_size_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_size_1" class="<?php echo $job_card_bc->design_size_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->design_size_1) ?>',1);"><div id="elh_job_card_bc_design_size_1" class="job_card_bc_design_size_1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->design_size_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->design_size_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->design_size_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->_barcode->Visible) { // barcode ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $job_card_bc->_barcode->headerCellClass() ?>"><div id="elh_job_card_bc__barcode" class="job_card_bc__barcode"><div class="ew-table-header-caption"><?php echo $job_card_bc->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $job_card_bc->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->_barcode) ?>',1);"><div id="elh_job_card_bc__barcode" class="job_card_bc__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->r_date->Visible) { // r_date ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->r_date) == "") { ?>
		<th data-name="r_date" class="<?php echo $job_card_bc->r_date->headerCellClass() ?>"><div id="elh_job_card_bc_r_date" class="job_card_bc_r_date"><div class="ew-table-header-caption"><?php echo $job_card_bc->r_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_date" class="<?php echo $job_card_bc->r_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->r_date) ?>',1);"><div id="elh_job_card_bc_r_date" class="job_card_bc_r_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->r_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->r_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->r_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->lot_no->Visible) { // lot_no ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $job_card_bc->lot_no->headerCellClass() ?>"><div id="elh_job_card_bc_lot_no" class="job_card_bc_lot_no"><div class="ew-table-header-caption"><?php echo $job_card_bc->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $job_card_bc->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->lot_no) ?>',1);"><div id="elh_job_card_bc_lot_no" class="job_card_bc_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->deduction->Visible) { // deduction ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->deduction) == "") { ?>
		<th data-name="deduction" class="<?php echo $job_card_bc->deduction->headerCellClass() ?>"><div id="elh_job_card_bc_deduction" class="job_card_bc_deduction"><div class="ew-table-header-caption"><?php echo $job_card_bc->deduction->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deduction" class="<?php echo $job_card_bc->deduction->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->deduction) ?>',1);"><div id="elh_job_card_bc_deduction" class="job_card_bc_deduction">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->deduction->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->deduction->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->deduction->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->ded_remarks->Visible) { // ded_remarks ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->ded_remarks) == "") { ?>
		<th data-name="ded_remarks" class="<?php echo $job_card_bc->ded_remarks->headerCellClass() ?>"><div id="elh_job_card_bc_ded_remarks" class="job_card_bc_ded_remarks"><div class="ew-table-header-caption"><?php echo $job_card_bc->ded_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_remarks" class="<?php echo $job_card_bc->ded_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->ded_remarks) ?>',1);"><div id="elh_job_card_bc_ded_remarks" class="job_card_bc_ded_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->ded_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->ded_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->ded_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_bc->datetime->Visible) { // datetime ?>
	<?php if ($job_card_bc->sortUrl($job_card_bc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $job_card_bc->datetime->headerCellClass() ?>"><div id="elh_job_card_bc_datetime" class="job_card_bc_datetime"><div class="ew-table-header-caption"><?php echo $job_card_bc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $job_card_bc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_bc->SortUrl($job_card_bc->datetime) ?>',1);"><div id="elh_job_card_bc_datetime" class="job_card_bc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_bc->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_bc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_bc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$job_card_bc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($job_card_bc->ExportAll && $job_card_bc->isExport()) {
	$job_card_bc_list->StopRec = $job_card_bc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($job_card_bc_list->TotalRecs > $job_card_bc_list->StartRec + $job_card_bc_list->DisplayRecs - 1)
		$job_card_bc_list->StopRec = $job_card_bc_list->StartRec + $job_card_bc_list->DisplayRecs - 1;
	else
		$job_card_bc_list->StopRec = $job_card_bc_list->TotalRecs;
}
$job_card_bc_list->RecCnt = $job_card_bc_list->StartRec - 1;
if ($job_card_bc_list->Recordset && !$job_card_bc_list->Recordset->EOF) {
	$job_card_bc_list->Recordset->moveFirst();
	$selectLimit = $job_card_bc_list->UseSelectLimit;
	if (!$selectLimit && $job_card_bc_list->StartRec > 1)
		$job_card_bc_list->Recordset->move($job_card_bc_list->StartRec - 1);
} elseif (!$job_card_bc->AllowAddDeleteRow && $job_card_bc_list->StopRec == 0) {
	$job_card_bc_list->StopRec = $job_card_bc->GridAddRowCount;
}

// Initialize aggregate
$job_card_bc->RowType = ROWTYPE_AGGREGATEINIT;
$job_card_bc->resetAttributes();
$job_card_bc_list->renderRow();
while ($job_card_bc_list->RecCnt < $job_card_bc_list->StopRec) {
	$job_card_bc_list->RecCnt++;
	if ($job_card_bc_list->RecCnt >= $job_card_bc_list->StartRec) {
		$job_card_bc_list->RowCnt++;

		// Set up key count
		$job_card_bc_list->KeyCount = $job_card_bc_list->RowIndex;

		// Init row class and style
		$job_card_bc->resetAttributes();
		$job_card_bc->CssClass = "";
		if ($job_card_bc->isGridAdd()) {
		} else {
			$job_card_bc_list->loadRowValues($job_card_bc_list->Recordset); // Load row values
		}
		$job_card_bc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$job_card_bc->RowAttrs = array_merge($job_card_bc->RowAttrs, array('data-rowindex'=>$job_card_bc_list->RowCnt, 'id'=>'r' . $job_card_bc_list->RowCnt . '_job_card_bc', 'data-rowtype'=>$job_card_bc->RowType));

		// Render row
		$job_card_bc_list->renderRow();

		// Render list options
		$job_card_bc_list->renderListOptions();
?>
	<tr<?php echo $job_card_bc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$job_card_bc_list->ListOptions->render("body", "left", $job_card_bc_list->RowCnt);
?>
	<?php if ($job_card_bc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $job_card_bc->id->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_id" class="job_card_bc_id">
<span<?php echo $job_card_bc->id->viewAttributes() ?>>
<?php echo $job_card_bc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->no->Visible) { // no ?>
		<td data-name="no"<?php echo $job_card_bc->no->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_no" class="job_card_bc_no">
<span<?php echo $job_card_bc->no->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_bc->no->getViewValue())) && $job_card_bc->no->linkAttributes() <> "") { ?>
<a<?php echo $job_card_bc->no->linkAttributes() ?>><?php echo $job_card_bc->no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_bc->no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->works->Visible) { // works ?>
		<td data-name="works"<?php echo $job_card_bc->works->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_works" class="job_card_bc_works">
<span<?php echo $job_card_bc->works->viewAttributes() ?>>
<?php echo $job_card_bc->works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $job_card_bc->issue_to->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_issue_to" class="job_card_bc_issue_to">
<span<?php echo $job_card_bc->issue_to->viewAttributes() ?>>
<?php echo $job_card_bc->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->po->Visible) { // po ?>
		<td data-name="po"<?php echo $job_card_bc->po->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_po" class="job_card_bc_po">
<span<?php echo $job_card_bc->po->viewAttributes() ?>>
<?php echo $job_card_bc->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->design_size_1->Visible) { // design_size_1 ?>
		<td data-name="design_size_1"<?php echo $job_card_bc->design_size_1->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_design_size_1" class="job_card_bc_design_size_1">
<span<?php echo $job_card_bc->design_size_1->viewAttributes() ?>>
<?php echo $job_card_bc->design_size_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $job_card_bc->_barcode->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc__barcode" class="job_card_bc__barcode">
<span<?php echo $job_card_bc->_barcode->viewAttributes() ?>>
<?php echo $job_card_bc->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->r_date->Visible) { // r_date ?>
		<td data-name="r_date"<?php echo $job_card_bc->r_date->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_r_date" class="job_card_bc_r_date">
<span<?php echo $job_card_bc->r_date->viewAttributes() ?>>
<?php echo $job_card_bc->r_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $job_card_bc->lot_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_lot_no" class="job_card_bc_lot_no">
<span<?php echo $job_card_bc->lot_no->viewAttributes() ?>>
<?php echo $job_card_bc->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->deduction->Visible) { // deduction ?>
		<td data-name="deduction"<?php echo $job_card_bc->deduction->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_deduction" class="job_card_bc_deduction">
<span<?php echo $job_card_bc->deduction->viewAttributes() ?>>
<?php echo $job_card_bc->deduction->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->ded_remarks->Visible) { // ded_remarks ?>
		<td data-name="ded_remarks"<?php echo $job_card_bc->ded_remarks->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_ded_remarks" class="job_card_bc_ded_remarks">
<span<?php echo $job_card_bc->ded_remarks->viewAttributes() ?>>
<?php echo $job_card_bc->ded_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_bc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $job_card_bc->datetime->cellAttributes() ?>>
<span id="el<?php echo $job_card_bc_list->RowCnt ?>_job_card_bc_datetime" class="job_card_bc_datetime">
<span<?php echo $job_card_bc->datetime->viewAttributes() ?>>
<?php echo $job_card_bc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$job_card_bc_list->ListOptions->render("body", "right", $job_card_bc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$job_card_bc->isGridAdd())
		$job_card_bc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$job_card_bc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($job_card_bc_list->Recordset)
	$job_card_bc_list->Recordset->Close();
?>
<?php if (!$job_card_bc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$job_card_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_bc_list->Pager)) $job_card_bc_list->Pager = new PrevNextPager($job_card_bc_list->StartRec, $job_card_bc_list->DisplayRecs, $job_card_bc_list->TotalRecs, $job_card_bc_list->AutoHidePager) ?>
<?php if ($job_card_bc_list->Pager->RecordCount > 0 && $job_card_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_bc_list->pageUrl() ?>start=<?php echo $job_card_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_bc_list->TotalRecs > 0 && (!$job_card_bc_list->AutoHidePageSizeSelector || $job_card_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_bc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($job_card_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_bc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($job_card_bc_list->TotalRecs == 0 && !$job_card_bc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $job_card_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$job_card_bc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card_bc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$job_card_bc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_job_card_bc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_bc_list->terminate();
?>