<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_bc_search = new job_card_bc_search();

// Run the page
$job_card_bc_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_bc_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($job_card_bc_search->IsModal) { ?>
var fjob_card_bcsearch = currentAdvancedSearchForm = new ew.Form("fjob_card_bcsearch", "search");
<?php } else { ?>
var fjob_card_bcsearch = currentForm = new ew.Form("fjob_card_bcsearch", "search");
<?php } ?>

// Form_CustomValidate event
fjob_card_bcsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_bcsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_bcsearch.lists["x_works"] = <?php echo $job_card_bc_search->works->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x_works"].options = <?php echo JsonEncode($job_card_bc_search->works->lookupOptions()) ?>;
fjob_card_bcsearch.lists["x_issue_to"] = <?php echo $job_card_bc_search->issue_to->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_bc_search->issue_to->lookupOptions()) ?>;
fjob_card_bcsearch.lists["x_grp"] = <?php echo $job_card_bc_search->grp->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x_grp"].options = <?php echo JsonEncode($job_card_bc_search->grp->lookupOptions()) ?>;
fjob_card_bcsearch.lists["x_po"] = <?php echo $job_card_bc_search->po->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x_po"].options = <?php echo JsonEncode($job_card_bc_search->po->lookupOptions()) ?>;
fjob_card_bcsearch.lists["x_loom_no"] = <?php echo $job_card_bc_search->loom_no->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x_loom_no"].options = <?php echo JsonEncode($job_card_bc_search->loom_no->lookupOptions()) ?>;
fjob_card_bcsearch.lists["x_employee_id[]"] = <?php echo $job_card_bc_search->employee_id->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($job_card_bc_search->employee_id->lookupOptions()) ?>;
fjob_card_bcsearch.lists["x__barcode[]"] = <?php echo $job_card_bc_search->_barcode->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x__barcode[]"].options = <?php echo JsonEncode($job_card_bc_search->_barcode->lookupOptions()) ?>;
fjob_card_bcsearch.lists["x_operator"] = <?php echo $job_card_bc_search->operator->Lookup->toClientList() ?>;
fjob_card_bcsearch.lists["x_operator"].options = <?php echo JsonEncode($job_card_bc_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fjob_card_bcsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_bc->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_bc->no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_bc->r_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_bc->deduction->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_bc->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_bc_search->showPageHeader(); ?>
<?php
$job_card_bc_search->showMessage();
?>
<form name="fjob_card_bcsearch" id="fjob_card_bcsearch" class="<?php echo $job_card_bc_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_bc_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_bc_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_bc">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_bc_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($job_card_bc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_id"><?php echo $job_card_bc->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->id->cellAttributes() ?>>
			<span id="el_job_card_bc_id">
<input type="text" data-table="job_card_bc" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($job_card_bc->id->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->id->EditValue ?>"<?php echo $job_card_bc->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->no->Visible) { // no ?>
	<div id="r_no" class="form-group row">
		<label for="x_no" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_no"><?php echo $job_card_bc->no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no" id="z_no" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->no->cellAttributes() ?>>
			<span id="el_job_card_bc_no">
<input type="text" data-table="job_card_bc" data-field="x_no" name="x_no" id="x_no" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->no->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->no->EditValue ?>"<?php echo $job_card_bc->no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->works->Visible) { // works ?>
	<div id="r_works" class="form-group row">
		<label for="x_works" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_works"><?php echo $job_card_bc->works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_works" id="z_works" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->works->cellAttributes() ?>>
			<span id="el_job_card_bc_works">
<?php $job_card_bc->works->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_bc->works->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_works" data-value-separator="<?php echo $job_card_bc->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card_bc->works->editAttributes() ?>>
		<?php echo $job_card_bc->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card_bc->works->Lookup->getParamTag("p_x_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_issue_to"><?php echo $job_card_bc->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->issue_to->cellAttributes() ?>>
			<span id="el_job_card_bc_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_issue_to" data-value-separator="<?php echo $job_card_bc->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $job_card_bc->issue_to->editAttributes() ?>>
		<?php echo $job_card_bc->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $job_card_bc->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_grp"><?php echo $job_card_bc->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->grp->cellAttributes() ?>>
			<span id="el_job_card_bc_grp">
<?php $job_card_bc->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_bc->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_grp" data-value-separator="<?php echo $job_card_bc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $job_card_bc->grp->editAttributes() ?>>
		<?php echo $job_card_bc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $job_card_bc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_po"><?php echo $job_card_bc->po->caption() ?></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($job_card_bc->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_job_card_bc_po">
<?php $job_card_bc->po->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_bc->po->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_po" data-value-separator="<?php echo $job_card_bc->po->displayValueSeparatorAttribute() ?>" id="x_po" name="x_po"<?php echo $job_card_bc->po->editAttributes() ?>>
		<?php echo $job_card_bc->po->selectOptionListHtml("x_po") ?>
	</select>
</div>
<?php echo $job_card_bc->po->Lookup->getParamTag("p_x_po") ?>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_job_card_bc_po" class="btw1_po d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_po" data-value-separator="<?php echo $job_card_bc->po->displayValueSeparatorAttribute() ?>" id="y_po" name="y_po"<?php echo $job_card_bc->po->editAttributes() ?>>
		<?php echo $job_card_bc->po->selectOptionListHtml("y_po") ?>
	</select>
</div>
<?php echo $job_card_bc->po->Lookup->getParamTag("p_y_po") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->design_size_1->Visible) { // design_size_1 ?>
	<div id="r_design_size_1" class="form-group row">
		<label for="x_design_size_1" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_design_size_1"><?php echo $job_card_bc->design_size_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_size_1" id="z_design_size_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->design_size_1->cellAttributes() ?>>
			<span id="el_job_card_bc_design_size_1">
<input type="text" data-table="job_card_bc" data-field="x_design_size_1" name="x_design_size_1" id="x_design_size_1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->design_size_1->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->design_size_1->EditValue ?>"<?php echo $job_card_bc->design_size_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->loom_no->Visible) { // loom_no ?>
	<div id="r_loom_no" class="form-group row">
		<label for="x_loom_no" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_loom_no"><?php echo $job_card_bc->loom_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_loom_no" id="z_loom_no" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->loom_no->cellAttributes() ?>>
			<span id="el_job_card_bc_loom_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_loom_no" data-value-separator="<?php echo $job_card_bc->loom_no->displayValueSeparatorAttribute() ?>" id="x_loom_no" name="x_loom_no"<?php echo $job_card_bc->loom_no->editAttributes() ?>>
		<?php echo $job_card_bc->loom_no->selectOptionListHtml("x_loom_no") ?>
	</select>
</div>
<?php echo $job_card_bc->loom_no->Lookup->getParamTag("p_x_loom_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_employee_id"><?php echo $job_card_bc->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->employee_id->cellAttributes() ?>>
			<span id="el_job_card_bc_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($job_card_bc->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($job_card_bc->employee_id->AdvancedSearch->ViewValue) : $job_card_bc->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card_bc->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($job_card_bc->employee_id->ReadOnly || $job_card_bc->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $job_card_bc->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="job_card_bc" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $job_card_bc->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $job_card_bc->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $job_card_bc->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__barcode"><?php echo $job_card_bc->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_barcode->cellAttributes() ?>>
			<span id="el_job_card_bc__barcode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x__barcode" data-value-separator="<?php echo $job_card_bc->_barcode->displayValueSeparatorAttribute() ?>" id="x__barcode[]" name="x__barcode[]" size=10 multiple="multiple"<?php echo $job_card_bc->_barcode->editAttributes() ?>>
		<?php echo $job_card_bc->_barcode->selectOptionListHtml("x__barcode[]") ?>
	</select>
</div>
<?php echo $job_card_bc->_barcode->Lookup->getParamTag("p_x__barcode") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->r_date->Visible) { // r_date ?>
	<div id="r_r_date" class="form-group row">
		<label for="x_r_date" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_r_date"><?php echo $job_card_bc->r_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_date" id="z_r_date" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->r_date->cellAttributes() ?>>
			<span id="el_job_card_bc_r_date">
<input type="text" data-table="job_card_bc" data-field="x_r_date" name="x_r_date" id="x_r_date" placeholder="<?php echo HtmlEncode($job_card_bc->r_date->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->r_date->EditValue ?>"<?php echo $job_card_bc->r_date->editAttributes() ?>>
<?php if (!$job_card_bc->r_date->ReadOnly && !$job_card_bc->r_date->Disabled && !isset($job_card_bc->r_date->EditAttrs["readonly"]) && !isset($job_card_bc->r_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjob_card_bcsearch", "x_r_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label for="x_deduction" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_deduction"><?php echo $job_card_bc->deduction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_deduction" id="z_deduction" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->deduction->cellAttributes() ?>>
			<span id="el_job_card_bc_deduction">
<input type="text" data-table="job_card_bc" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($job_card_bc->deduction->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->deduction->EditValue ?>"<?php echo $job_card_bc->deduction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->ded_remarks->Visible) { // ded_remarks ?>
	<div id="r_ded_remarks" class="form-group row">
		<label for="x_ded_remarks" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_ded_remarks"><?php echo $job_card_bc->ded_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ded_remarks" id="z_ded_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->ded_remarks->cellAttributes() ?>>
			<span id="el_job_card_bc_ded_remarks">
<input type="text" data-table="job_card_bc" data-field="x_ded_remarks" name="x_ded_remarks" id="x_ded_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card_bc->ded_remarks->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->ded_remarks->EditValue ?>"<?php echo $job_card_bc->ded_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_operator"><?php echo $job_card_bc->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->operator->cellAttributes() ?>>
			<span id="el_job_card_bc_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_bc" data-field="x_operator" data-value-separator="<?php echo $job_card_bc->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $job_card_bc->operator->editAttributes() ?>>
		<?php echo $job_card_bc->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $job_card_bc->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_datetime"><?php echo $job_card_bc->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($job_card_bc->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_job_card_bc_datetime">
<input type="text" data-table="job_card_bc" data-field="x_datetime" data-format="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($job_card_bc->datetime->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->datetime->EditValue ?>"<?php echo $job_card_bc->datetime->editAttributes() ?>>
<?php if (!$job_card_bc->datetime->ReadOnly && !$job_card_bc->datetime->Disabled && !isset($job_card_bc->datetime->EditAttrs["readonly"]) && !isset($job_card_bc->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjob_card_bcsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_job_card_bc_datetime" class="btw1_datetime d-none">
<input type="text" data-table="job_card_bc" data-field="x_datetime" data-format="7" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($job_card_bc->datetime->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->datetime->EditValue2 ?>"<?php echo $job_card_bc->datetime->editAttributes() ?>>
<?php if (!$job_card_bc->datetime->ReadOnly && !$job_card_bc->datetime->Disabled && !isset($job_card_bc->datetime->EditAttrs["readonly"]) && !isset($job_card_bc->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjob_card_bcsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_1->Visible) { // 1 ?>
	<div id="r__1" class="form-group row">
		<label for="x__1" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__1"><?php echo $job_card_bc->_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__1" id="z__1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_1->cellAttributes() ?>>
			<span id="el_job_card_bc__1">
<input type="text" data-table="job_card_bc" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_1->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_1->EditValue ?>"<?php echo $job_card_bc->_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_2->Visible) { // 2 ?>
	<div id="r__2" class="form-group row">
		<label for="x__2" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__2"><?php echo $job_card_bc->_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__2" id="z__2" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_2->cellAttributes() ?>>
			<span id="el_job_card_bc__2">
<input type="text" data-table="job_card_bc" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_2->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_2->EditValue ?>"<?php echo $job_card_bc->_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_3->Visible) { // 3 ?>
	<div id="r__3" class="form-group row">
		<label for="x__3" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__3"><?php echo $job_card_bc->_3->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__3" id="z__3" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_3->cellAttributes() ?>>
			<span id="el_job_card_bc__3">
<input type="text" data-table="job_card_bc" data-field="x__3" name="x__3" id="x__3" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_3->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_3->EditValue ?>"<?php echo $job_card_bc->_3->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_4->Visible) { // 4 ?>
	<div id="r__4" class="form-group row">
		<label for="x__4" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__4"><?php echo $job_card_bc->_4->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__4" id="z__4" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_4->cellAttributes() ?>>
			<span id="el_job_card_bc__4">
<input type="text" data-table="job_card_bc" data-field="x__4" name="x__4" id="x__4" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_4->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_4->EditValue ?>"<?php echo $job_card_bc->_4->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_5->Visible) { // 5 ?>
	<div id="r__5" class="form-group row">
		<label for="x__5" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__5"><?php echo $job_card_bc->_5->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__5" id="z__5" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_5->cellAttributes() ?>>
			<span id="el_job_card_bc__5">
<input type="text" data-table="job_card_bc" data-field="x__5" name="x__5" id="x__5" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_5->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_5->EditValue ?>"<?php echo $job_card_bc->_5->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_6->Visible) { // 6 ?>
	<div id="r__6" class="form-group row">
		<label for="x__6" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__6"><?php echo $job_card_bc->_6->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__6" id="z__6" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_6->cellAttributes() ?>>
			<span id="el_job_card_bc__6">
<input type="text" data-table="job_card_bc" data-field="x__6" name="x__6" id="x__6" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_6->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_6->EditValue ?>"<?php echo $job_card_bc->_6->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_7->Visible) { // 7 ?>
	<div id="r__7" class="form-group row">
		<label for="x__7" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__7"><?php echo $job_card_bc->_7->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__7" id="z__7" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_7->cellAttributes() ?>>
			<span id="el_job_card_bc__7">
<input type="text" data-table="job_card_bc" data-field="x__7" name="x__7" id="x__7" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_7->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_7->EditValue ?>"<?php echo $job_card_bc->_7->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->_8->Visible) { // 8 ?>
	<div id="r__8" class="form-group row">
		<label for="x__8" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc__8"><?php echo $job_card_bc->_8->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__8" id="z__8" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->_8->cellAttributes() ?>>
			<span id="el_job_card_bc__8">
<input type="text" data-table="job_card_bc" data-field="x__8" name="x__8" id="x__8" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->_8->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->_8->EditValue ?>"<?php echo $job_card_bc->_8->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->other1->Visible) { // other1 ?>
	<div id="r_other1" class="form-group row">
		<label for="x_other1" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_other1"><?php echo $job_card_bc->other1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other1" id="z_other1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->other1->cellAttributes() ?>>
			<span id="el_job_card_bc_other1">
<input type="text" data-table="job_card_bc" data-field="x_other1" name="x_other1" id="x_other1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->other1->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->other1->EditValue ?>"<?php echo $job_card_bc->other1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_bc->other2->Visible) { // other2 ?>
	<div id="r_other2" class="form-group row">
		<label for="x_other2" class="<?php echo $job_card_bc_search->LeftColumnClass ?>"><span id="elh_job_card_bc_other2"><?php echo $job_card_bc->other2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other2" id="z_other2" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_bc_search->RightColumnClass ?>"><div<?php echo $job_card_bc->other2->cellAttributes() ?>>
			<span id="el_job_card_bc_other2">
<input type="text" data-table="job_card_bc" data-field="x_other2" name="x_other2" id="x_other2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_bc->other2->getPlaceHolder()) ?>" value="<?php echo $job_card_bc->other2->EditValue ?>"<?php echo $job_card_bc->other2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$job_card_bc_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $job_card_bc_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$job_card_bc_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$job_card_bc_search->terminate();
?>