<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_description_list = new job_card_description_list();

// Run the page
$job_card_description_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_description_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card_description->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjob_card_descriptionlist = currentForm = new ew.Form("fjob_card_descriptionlist", "list");
fjob_card_descriptionlist.formKeyCountName = '<?php echo $job_card_description_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjob_card_descriptionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_descriptionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fjob_card_descriptionlistsrch = currentSearchForm = new ew.Form("fjob_card_descriptionlistsrch");

// Filters
fjob_card_descriptionlistsrch.filterList = <?php echo $job_card_description_list->getFilterList() ?>;

// Init search panel as collapsed
fjob_card_descriptionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card_description->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($job_card_description_list->TotalRecs > 0 && $job_card_description_list->ExportOptions->visible()) { ?>
<?php $job_card_description_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_description_list->ImportOptions->visible()) { ?>
<?php $job_card_description_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_description_list->SearchOptions->visible()) { ?>
<?php $job_card_description_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_description_list->FilterOptions->visible()) { ?>
<?php $job_card_description_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$job_card_description_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$job_card_description->isExport() && !$job_card_description->CurrentAction) { ?>
<form name="fjob_card_descriptionlistsrch" id="fjob_card_descriptionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($job_card_description_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjob_card_descriptionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="job_card_description">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($job_card_description_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($job_card_description_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $job_card_description_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($job_card_description_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($job_card_description_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($job_card_description_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($job_card_description_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $job_card_description_list->showPageHeader(); ?>
<?php
$job_card_description_list->showMessage();
?>
<?php if ($job_card_description_list->TotalRecs > 0 || $job_card_description->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($job_card_description_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> job_card_description">
<?php if (!$job_card_description->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$job_card_description->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_description_list->Pager)) $job_card_description_list->Pager = new PrevNextPager($job_card_description_list->StartRec, $job_card_description_list->DisplayRecs, $job_card_description_list->TotalRecs, $job_card_description_list->AutoHidePager) ?>
<?php if ($job_card_description_list->Pager->RecordCount > 0 && $job_card_description_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_description_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_description_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_description_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_description_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_description_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_description_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_description_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_description_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_description_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_description_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_description_list->TotalRecs > 0 && (!$job_card_description_list->AutoHidePageSizeSelector || $job_card_description_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_description">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_description_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_description_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_description_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_description_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_description_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_description->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_description_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjob_card_descriptionlist" id="fjob_card_descriptionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_description_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_description_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_description">
<div id="gmp_job_card_description" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($job_card_description_list->TotalRecs > 0 || $job_card_description->isGridEdit()) { ?>
<table id="tbl_job_card_descriptionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$job_card_description_list->RowType = ROWTYPE_HEADER;

// Render list options
$job_card_description_list->renderListOptions();

// Render list options (header, left)
$job_card_description_list->ListOptions->render("header", "left");
?>
<?php if ($job_card_description->id->Visible) { // id ?>
	<?php if ($job_card_description->sortUrl($job_card_description->id) == "") { ?>
		<th data-name="id" class="<?php echo $job_card_description->id->headerCellClass() ?>"><div id="elh_job_card_description_id" class="job_card_description_id"><div class="ew-table-header-caption"><?php echo $job_card_description->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $job_card_description->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->id) ?>',2);"><div id="elh_job_card_description_id" class="job_card_description_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->grp->Visible) { // grp ?>
	<?php if ($job_card_description->sortUrl($job_card_description->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $job_card_description->grp->headerCellClass() ?>"><div id="elh_job_card_description_grp" class="job_card_description_grp"><div class="ew-table-header-caption"><?php echo $job_card_description->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $job_card_description->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->grp) ?>',2);"><div id="elh_job_card_description_grp" class="job_card_description_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->s_grp->Visible) { // s_grp ?>
	<?php if ($job_card_description->sortUrl($job_card_description->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $job_card_description->s_grp->headerCellClass() ?>"><div id="elh_job_card_description_s_grp" class="job_card_description_s_grp"><div class="ew-table-header-caption"><?php echo $job_card_description->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $job_card_description->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->s_grp) ?>',2);"><div id="elh_job_card_description_s_grp" class="job_card_description_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->rid->Visible) { // rid ?>
	<?php if ($job_card_description->sortUrl($job_card_description->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $job_card_description->rid->headerCellClass() ?>"><div id="elh_job_card_description_rid" class="job_card_description_rid"><div class="ew-table-header-caption"><?php echo $job_card_description->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $job_card_description->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->rid) ?>',2);"><div id="elh_job_card_description_rid" class="job_card_description_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->packing_type->Visible) { // packing_type ?>
	<?php if ($job_card_description->sortUrl($job_card_description->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $job_card_description->packing_type->headerCellClass() ?>"><div id="elh_job_card_description_packing_type" class="job_card_description_packing_type"><div class="ew-table-header-caption"><?php echo $job_card_description->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $job_card_description->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->packing_type) ?>',2);"><div id="elh_job_card_description_packing_type" class="job_card_description_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->size_wl->Visible) { // size_wl ?>
	<?php if ($job_card_description->sortUrl($job_card_description->size_wl) == "") { ?>
		<th data-name="size_wl" class="<?php echo $job_card_description->size_wl->headerCellClass() ?>"><div id="elh_job_card_description_size_wl" class="job_card_description_size_wl"><div class="ew-table-header-caption"><?php echo $job_card_description->size_wl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_wl" class="<?php echo $job_card_description->size_wl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->size_wl) ?>',2);"><div id="elh_job_card_description_size_wl" class="job_card_description_size_wl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->size_wl->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->size_wl->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->size_wl->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_1->Visible) { // 1 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_1) == "") { ?>
		<th data-name="_1" class="<?php echo $job_card_description->_1->headerCellClass() ?>"><div id="elh_job_card_description__1" class="job_card_description__1"><div class="ew-table-header-caption"><?php echo $job_card_description->_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_1" class="<?php echo $job_card_description->_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_1) ?>',2);"><div id="elh_job_card_description__1" class="job_card_description__1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_2->Visible) { // 2 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_2) == "") { ?>
		<th data-name="_2" class="<?php echo $job_card_description->_2->headerCellClass() ?>"><div id="elh_job_card_description__2" class="job_card_description__2"><div class="ew-table-header-caption"><?php echo $job_card_description->_2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_2" class="<?php echo $job_card_description->_2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_2) ?>',2);"><div id="elh_job_card_description__2" class="job_card_description__2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_3->Visible) { // 3 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_3) == "") { ?>
		<th data-name="_3" class="<?php echo $job_card_description->_3->headerCellClass() ?>"><div id="elh_job_card_description__3" class="job_card_description__3"><div class="ew-table-header-caption"><?php echo $job_card_description->_3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_3" class="<?php echo $job_card_description->_3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_3) ?>',2);"><div id="elh_job_card_description__3" class="job_card_description__3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_3->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_3->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_4->Visible) { // 4 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_4) == "") { ?>
		<th data-name="_4" class="<?php echo $job_card_description->_4->headerCellClass() ?>"><div id="elh_job_card_description__4" class="job_card_description__4"><div class="ew-table-header-caption"><?php echo $job_card_description->_4->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_4" class="<?php echo $job_card_description->_4->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_4) ?>',2);"><div id="elh_job_card_description__4" class="job_card_description__4">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_4->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_4->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_4->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_5->Visible) { // 5 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_5) == "") { ?>
		<th data-name="_5" class="<?php echo $job_card_description->_5->headerCellClass() ?>"><div id="elh_job_card_description__5" class="job_card_description__5"><div class="ew-table-header-caption"><?php echo $job_card_description->_5->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_5" class="<?php echo $job_card_description->_5->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_5) ?>',2);"><div id="elh_job_card_description__5" class="job_card_description__5">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_5->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_5->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_5->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_6->Visible) { // 6 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_6) == "") { ?>
		<th data-name="_6" class="<?php echo $job_card_description->_6->headerCellClass() ?>"><div id="elh_job_card_description__6" class="job_card_description__6"><div class="ew-table-header-caption"><?php echo $job_card_description->_6->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_6" class="<?php echo $job_card_description->_6->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_6) ?>',2);"><div id="elh_job_card_description__6" class="job_card_description__6">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_6->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_6->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_6->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_7->Visible) { // 7 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_7) == "") { ?>
		<th data-name="_7" class="<?php echo $job_card_description->_7->headerCellClass() ?>"><div id="elh_job_card_description__7" class="job_card_description__7"><div class="ew-table-header-caption"><?php echo $job_card_description->_7->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_7" class="<?php echo $job_card_description->_7->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_7) ?>',2);"><div id="elh_job_card_description__7" class="job_card_description__7">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_7->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_7->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_7->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->_8->Visible) { // 8 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->_8) == "") { ?>
		<th data-name="_8" class="<?php echo $job_card_description->_8->headerCellClass() ?>"><div id="elh_job_card_description__8" class="job_card_description__8"><div class="ew-table-header-caption"><?php echo $job_card_description->_8->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_8" class="<?php echo $job_card_description->_8->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->_8) ?>',2);"><div id="elh_job_card_description__8" class="job_card_description__8">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->_8->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->_8->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->_8->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->other1->Visible) { // other1 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->other1) == "") { ?>
		<th data-name="other1" class="<?php echo $job_card_description->other1->headerCellClass() ?>"><div id="elh_job_card_description_other1" class="job_card_description_other1"><div class="ew-table-header-caption"><?php echo $job_card_description->other1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other1" class="<?php echo $job_card_description->other1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->other1) ?>',2);"><div id="elh_job_card_description_other1" class="job_card_description_other1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->other1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->other1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->other1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->other2->Visible) { // other2 ?>
	<?php if ($job_card_description->sortUrl($job_card_description->other2) == "") { ?>
		<th data-name="other2" class="<?php echo $job_card_description->other2->headerCellClass() ?>"><div id="elh_job_card_description_other2" class="job_card_description_other2"><div class="ew-table-header-caption"><?php echo $job_card_description->other2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other2" class="<?php echo $job_card_description->other2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->other2) ?>',2);"><div id="elh_job_card_description_other2" class="job_card_description_other2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->other2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->other2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->other2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->operator->Visible) { // operator ?>
	<?php if ($job_card_description->sortUrl($job_card_description->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $job_card_description->operator->headerCellClass() ?>"><div id="elh_job_card_description_operator" class="job_card_description_operator"><div class="ew-table-header-caption"><?php echo $job_card_description->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $job_card_description->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->operator) ?>',2);"><div id="elh_job_card_description_operator" class="job_card_description_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_description->datetime->Visible) { // datetime ?>
	<?php if ($job_card_description->sortUrl($job_card_description->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $job_card_description->datetime->headerCellClass() ?>"><div id="elh_job_card_description_datetime" class="job_card_description_datetime"><div class="ew-table-header-caption"><?php echo $job_card_description->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $job_card_description->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_description->SortUrl($job_card_description->datetime) ?>',2);"><div id="elh_job_card_description_datetime" class="job_card_description_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_description->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_description->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_description->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$job_card_description_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($job_card_description->ExportAll && $job_card_description->isExport()) {
	$job_card_description_list->StopRec = $job_card_description_list->TotalRecs;
} else {

	// Set the last record to display
	if ($job_card_description_list->TotalRecs > $job_card_description_list->StartRec + $job_card_description_list->DisplayRecs - 1)
		$job_card_description_list->StopRec = $job_card_description_list->StartRec + $job_card_description_list->DisplayRecs - 1;
	else
		$job_card_description_list->StopRec = $job_card_description_list->TotalRecs;
}
$job_card_description_list->RecCnt = $job_card_description_list->StartRec - 1;
if ($job_card_description_list->Recordset && !$job_card_description_list->Recordset->EOF) {
	$job_card_description_list->Recordset->moveFirst();
	$selectLimit = $job_card_description_list->UseSelectLimit;
	if (!$selectLimit && $job_card_description_list->StartRec > 1)
		$job_card_description_list->Recordset->move($job_card_description_list->StartRec - 1);
} elseif (!$job_card_description->AllowAddDeleteRow && $job_card_description_list->StopRec == 0) {
	$job_card_description_list->StopRec = $job_card_description->GridAddRowCount;
}

// Initialize aggregate
$job_card_description->RowType = ROWTYPE_AGGREGATEINIT;
$job_card_description->resetAttributes();
$job_card_description_list->renderRow();
while ($job_card_description_list->RecCnt < $job_card_description_list->StopRec) {
	$job_card_description_list->RecCnt++;
	if ($job_card_description_list->RecCnt >= $job_card_description_list->StartRec) {
		$job_card_description_list->RowCnt++;

		// Set up key count
		$job_card_description_list->KeyCount = $job_card_description_list->RowIndex;

		// Init row class and style
		$job_card_description->resetAttributes();
		$job_card_description->CssClass = "";
		if ($job_card_description->isGridAdd()) {
		} else {
			$job_card_description_list->loadRowValues($job_card_description_list->Recordset); // Load row values
		}
		$job_card_description->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$job_card_description->RowAttrs = array_merge($job_card_description->RowAttrs, array('data-rowindex'=>$job_card_description_list->RowCnt, 'id'=>'r' . $job_card_description_list->RowCnt . '_job_card_description', 'data-rowtype'=>$job_card_description->RowType));

		// Render row
		$job_card_description_list->renderRow();

		// Render list options
		$job_card_description_list->renderListOptions();
?>
	<tr<?php echo $job_card_description->rowAttributes() ?>>
<?php

// Render list options (body, left)
$job_card_description_list->ListOptions->render("body", "left", $job_card_description_list->RowCnt);
?>
	<?php if ($job_card_description->id->Visible) { // id ?>
		<td data-name="id"<?php echo $job_card_description->id->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_id" class="job_card_description_id">
<span<?php echo $job_card_description->id->viewAttributes() ?>>
<?php echo $job_card_description->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $job_card_description->grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_grp" class="job_card_description_grp">
<span<?php echo $job_card_description->grp->viewAttributes() ?>>
<?php echo $job_card_description->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $job_card_description->s_grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_s_grp" class="job_card_description_s_grp">
<span<?php echo $job_card_description->s_grp->viewAttributes() ?>>
<?php echo $job_card_description->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $job_card_description->rid->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_rid" class="job_card_description_rid">
<span<?php echo $job_card_description->rid->viewAttributes() ?>>
<?php echo $job_card_description->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $job_card_description->packing_type->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_packing_type" class="job_card_description_packing_type">
<span<?php echo $job_card_description->packing_type->viewAttributes() ?>>
<?php echo $job_card_description->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->size_wl->Visible) { // size_wl ?>
		<td data-name="size_wl"<?php echo $job_card_description->size_wl->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_size_wl" class="job_card_description_size_wl">
<span<?php echo $job_card_description->size_wl->viewAttributes() ?>>
<?php echo $job_card_description->size_wl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_1->Visible) { // 1 ?>
		<td data-name="_1"<?php echo $job_card_description->_1->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__1" class="job_card_description__1">
<span<?php echo $job_card_description->_1->viewAttributes() ?>>
<?php echo $job_card_description->_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_2->Visible) { // 2 ?>
		<td data-name="_2"<?php echo $job_card_description->_2->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__2" class="job_card_description__2">
<span<?php echo $job_card_description->_2->viewAttributes() ?>>
<?php echo $job_card_description->_2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_3->Visible) { // 3 ?>
		<td data-name="_3"<?php echo $job_card_description->_3->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__3" class="job_card_description__3">
<span<?php echo $job_card_description->_3->viewAttributes() ?>>
<?php echo $job_card_description->_3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_4->Visible) { // 4 ?>
		<td data-name="_4"<?php echo $job_card_description->_4->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__4" class="job_card_description__4">
<span<?php echo $job_card_description->_4->viewAttributes() ?>>
<?php echo $job_card_description->_4->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_5->Visible) { // 5 ?>
		<td data-name="_5"<?php echo $job_card_description->_5->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__5" class="job_card_description__5">
<span<?php echo $job_card_description->_5->viewAttributes() ?>>
<?php echo $job_card_description->_5->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_6->Visible) { // 6 ?>
		<td data-name="_6"<?php echo $job_card_description->_6->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__6" class="job_card_description__6">
<span<?php echo $job_card_description->_6->viewAttributes() ?>>
<?php echo $job_card_description->_6->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_7->Visible) { // 7 ?>
		<td data-name="_7"<?php echo $job_card_description->_7->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__7" class="job_card_description__7">
<span<?php echo $job_card_description->_7->viewAttributes() ?>>
<?php echo $job_card_description->_7->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->_8->Visible) { // 8 ?>
		<td data-name="_8"<?php echo $job_card_description->_8->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description__8" class="job_card_description__8">
<span<?php echo $job_card_description->_8->viewAttributes() ?>>
<?php echo $job_card_description->_8->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->other1->Visible) { // other1 ?>
		<td data-name="other1"<?php echo $job_card_description->other1->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_other1" class="job_card_description_other1">
<span<?php echo $job_card_description->other1->viewAttributes() ?>>
<?php echo $job_card_description->other1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->other2->Visible) { // other2 ?>
		<td data-name="other2"<?php echo $job_card_description->other2->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_other2" class="job_card_description_other2">
<span<?php echo $job_card_description->other2->viewAttributes() ?>>
<?php echo $job_card_description->other2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $job_card_description->operator->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_operator" class="job_card_description_operator">
<span<?php echo $job_card_description->operator->viewAttributes() ?>>
<?php echo $job_card_description->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_description->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $job_card_description->datetime->cellAttributes() ?>>
<span id="el<?php echo $job_card_description_list->RowCnt ?>_job_card_description_datetime" class="job_card_description_datetime">
<span<?php echo $job_card_description->datetime->viewAttributes() ?>>
<?php echo $job_card_description->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$job_card_description_list->ListOptions->render("body", "right", $job_card_description_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$job_card_description->isGridAdd())
		$job_card_description_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$job_card_description->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($job_card_description_list->Recordset)
	$job_card_description_list->Recordset->Close();
?>
<?php if (!$job_card_description->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$job_card_description->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_description_list->Pager)) $job_card_description_list->Pager = new PrevNextPager($job_card_description_list->StartRec, $job_card_description_list->DisplayRecs, $job_card_description_list->TotalRecs, $job_card_description_list->AutoHidePager) ?>
<?php if ($job_card_description_list->Pager->RecordCount > 0 && $job_card_description_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_description_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_description_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_description_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_description_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_description_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_description_list->pageUrl() ?>start=<?php echo $job_card_description_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_description_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_description_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_description_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_description_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_description_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_description_list->TotalRecs > 0 && (!$job_card_description_list->AutoHidePageSizeSelector || $job_card_description_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_description">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_description_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_description_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_description_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_description_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_description_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_description->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_description_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($job_card_description_list->TotalRecs == 0 && !$job_card_description->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $job_card_description_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$job_card_description_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card_description->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$job_card_description->isExport()) { ?>
<script>
ew.scrollableTable("gmp_job_card_description", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_description_list->terminate();
?>