<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_f_list = new job_card_f_list();

// Run the page
$job_card_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjob_card_flist = currentForm = new ew.Form("fjob_card_flist", "list");
fjob_card_flist.formKeyCountName = '<?php echo $job_card_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjob_card_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_flist.lists["x_grp"] = <?php echo $job_card_f_list->grp->Lookup->toClientList() ?>;
fjob_card_flist.lists["x_grp"].options = <?php echo JsonEncode($job_card_f_list->grp->options(FALSE, TRUE)) ?>;
fjob_card_flist.lists["x_employee_id"] = <?php echo $job_card_f_list->employee_id->Lookup->toClientList() ?>;
fjob_card_flist.lists["x_employee_id"].options = <?php echo JsonEncode($job_card_f_list->employee_id->lookupOptions()) ?>;
fjob_card_flist.lists["x_operator"] = <?php echo $job_card_f_list->operator->Lookup->toClientList() ?>;
fjob_card_flist.lists["x_operator"].options = <?php echo JsonEncode($job_card_f_list->operator->lookupOptions()) ?>;

// Form object for search
var fjob_card_flistsrch = currentSearchForm = new ew.Form("fjob_card_flistsrch");

// Validate function for search
fjob_card_flistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fjob_card_flistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_flistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_flistsrch.lists["x_employee_id"] = <?php echo $job_card_f_list->employee_id->Lookup->toClientList() ?>;
fjob_card_flistsrch.lists["x_employee_id"].options = <?php echo JsonEncode($job_card_f_list->employee_id->lookupOptions()) ?>;

// Filters
fjob_card_flistsrch.filterList = <?php echo $job_card_f_list->getFilterList() ?>;

// Init search panel as collapsed
fjob_card_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($job_card_f_list->TotalRecs > 0 && $job_card_f_list->ExportOptions->visible()) { ?>
<?php $job_card_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_f_list->ImportOptions->visible()) { ?>
<?php $job_card_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_f_list->SearchOptions->visible()) { ?>
<?php $job_card_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_f_list->FilterOptions->visible()) { ?>
<?php $job_card_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$job_card_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$job_card_f->isExport() && !$job_card_f->CurrentAction) { ?>
<form name="fjob_card_flistsrch" id="fjob_card_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($job_card_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjob_card_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="job_card_f">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$job_card_f_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$job_card_f->RowType = ROWTYPE_SEARCH;

// Render row
$job_card_f->resetAttributes();
$job_card_f_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($job_card_f->employee_id->Visible) { // employee_id ?>
	<div id="xsc_employee_id" class="ew-cell form-group">
		<label for="x_employee_id" class="ew-search-caption ew-label"><?php echo $job_card_f->employee_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_f" data-field="x_employee_id" data-value-separator="<?php echo $job_card_f->employee_id->displayValueSeparatorAttribute() ?>" id="x_employee_id" name="x_employee_id"<?php echo $job_card_f->employee_id->editAttributes() ?>>
		<?php echo $job_card_f->employee_id->selectOptionListHtml("x_employee_id") ?>
	</select>
</div>
<?php echo $job_card_f->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($job_card_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($job_card_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $job_card_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($job_card_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($job_card_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($job_card_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($job_card_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $job_card_f_list->showPageHeader(); ?>
<?php
$job_card_f_list->showMessage();
?>
<?php if ($job_card_f_list->TotalRecs > 0 || $job_card_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($job_card_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> job_card_f">
<?php if (!$job_card_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$job_card_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_f_list->Pager)) $job_card_f_list->Pager = new PrevNextPager($job_card_f_list->StartRec, $job_card_f_list->DisplayRecs, $job_card_f_list->TotalRecs, $job_card_f_list->AutoHidePager) ?>
<?php if ($job_card_f_list->Pager->RecordCount > 0 && $job_card_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_f_list->TotalRecs > 0 && (!$job_card_f_list->AutoHidePageSizeSelector || $job_card_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjob_card_flist" id="fjob_card_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_f">
<div id="gmp_job_card_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($job_card_f_list->TotalRecs > 0 || $job_card_f->isGridEdit()) { ?>
<table id="tbl_job_card_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$job_card_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$job_card_f_list->renderListOptions();

// Render list options (header, left)
$job_card_f_list->ListOptions->render("header", "left");
?>
<?php if ($job_card_f->id->Visible) { // id ?>
	<?php if ($job_card_f->sortUrl($job_card_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $job_card_f->id->headerCellClass() ?>"><div id="elh_job_card_f_id" class="job_card_f_id"><div class="ew-table-header-caption"><?php echo $job_card_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $job_card_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->id) ?>',2);"><div id="elh_job_card_f_id" class="job_card_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->grp->Visible) { // grp ?>
	<?php if ($job_card_f->sortUrl($job_card_f->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $job_card_f->grp->headerCellClass() ?>"><div id="elh_job_card_f_grp" class="job_card_f_grp"><div class="ew-table-header-caption"><?php echo $job_card_f->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $job_card_f->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->grp) ?>',2);"><div id="elh_job_card_f_grp" class="job_card_f_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->employee_id->Visible) { // employee_id ?>
	<?php if ($job_card_f->sortUrl($job_card_f->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $job_card_f->employee_id->headerCellClass() ?>"><div id="elh_job_card_f_employee_id" class="job_card_f_employee_id"><div class="ew-table-header-caption"><?php echo $job_card_f->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $job_card_f->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->employee_id) ?>',2);"><div id="elh_job_card_f_employee_id" class="job_card_f_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->lot_no->Visible) { // lot_no ?>
	<?php if ($job_card_f->sortUrl($job_card_f->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $job_card_f->lot_no->headerCellClass() ?>"><div id="elh_job_card_f_lot_no" class="job_card_f_lot_no"><div class="ew-table-header-caption"><?php echo $job_card_f->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $job_card_f->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->lot_no) ?>',2);"><div id="elh_job_card_f_lot_no" class="job_card_f_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_1->Visible) { // 1 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_1) == "") { ?>
		<th data-name="_1" class="<?php echo $job_card_f->_1->headerCellClass() ?>"><div id="elh_job_card_f__1" class="job_card_f__1"><div class="ew-table-header-caption"><?php echo $job_card_f->_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_1" class="<?php echo $job_card_f->_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_1) ?>',2);"><div id="elh_job_card_f__1" class="job_card_f__1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_2->Visible) { // 2 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_2) == "") { ?>
		<th data-name="_2" class="<?php echo $job_card_f->_2->headerCellClass() ?>"><div id="elh_job_card_f__2" class="job_card_f__2"><div class="ew-table-header-caption"><?php echo $job_card_f->_2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_2" class="<?php echo $job_card_f->_2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_2) ?>',2);"><div id="elh_job_card_f__2" class="job_card_f__2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_3->Visible) { // 3 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_3) == "") { ?>
		<th data-name="_3" class="<?php echo $job_card_f->_3->headerCellClass() ?>"><div id="elh_job_card_f__3" class="job_card_f__3"><div class="ew-table-header-caption"><?php echo $job_card_f->_3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_3" class="<?php echo $job_card_f->_3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_3) ?>',2);"><div id="elh_job_card_f__3" class="job_card_f__3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_3->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_3->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_4->Visible) { // 4 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_4) == "") { ?>
		<th data-name="_4" class="<?php echo $job_card_f->_4->headerCellClass() ?>"><div id="elh_job_card_f__4" class="job_card_f__4"><div class="ew-table-header-caption"><?php echo $job_card_f->_4->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_4" class="<?php echo $job_card_f->_4->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_4) ?>',2);"><div id="elh_job_card_f__4" class="job_card_f__4">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_4->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_4->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_4->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_5->Visible) { // 5 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_5) == "") { ?>
		<th data-name="_5" class="<?php echo $job_card_f->_5->headerCellClass() ?>"><div id="elh_job_card_f__5" class="job_card_f__5"><div class="ew-table-header-caption"><?php echo $job_card_f->_5->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_5" class="<?php echo $job_card_f->_5->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_5) ?>',2);"><div id="elh_job_card_f__5" class="job_card_f__5">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_5->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_5->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_5->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_6->Visible) { // 6 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_6) == "") { ?>
		<th data-name="_6" class="<?php echo $job_card_f->_6->headerCellClass() ?>"><div id="elh_job_card_f__6" class="job_card_f__6"><div class="ew-table-header-caption"><?php echo $job_card_f->_6->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_6" class="<?php echo $job_card_f->_6->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_6) ?>',2);"><div id="elh_job_card_f__6" class="job_card_f__6">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_6->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_6->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_6->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_7->Visible) { // 7 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_7) == "") { ?>
		<th data-name="_7" class="<?php echo $job_card_f->_7->headerCellClass() ?>"><div id="elh_job_card_f__7" class="job_card_f__7"><div class="ew-table-header-caption"><?php echo $job_card_f->_7->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_7" class="<?php echo $job_card_f->_7->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_7) ?>',2);"><div id="elh_job_card_f__7" class="job_card_f__7">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_7->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_7->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_7->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->_8->Visible) { // 8 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->_8) == "") { ?>
		<th data-name="_8" class="<?php echo $job_card_f->_8->headerCellClass() ?>"><div id="elh_job_card_f__8" class="job_card_f__8"><div class="ew-table-header-caption"><?php echo $job_card_f->_8->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_8" class="<?php echo $job_card_f->_8->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->_8) ?>',2);"><div id="elh_job_card_f__8" class="job_card_f__8">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->_8->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->_8->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->_8->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->other1->Visible) { // other1 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->other1) == "") { ?>
		<th data-name="other1" class="<?php echo $job_card_f->other1->headerCellClass() ?>"><div id="elh_job_card_f_other1" class="job_card_f_other1"><div class="ew-table-header-caption"><?php echo $job_card_f->other1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other1" class="<?php echo $job_card_f->other1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->other1) ?>',2);"><div id="elh_job_card_f_other1" class="job_card_f_other1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->other1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->other1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->other1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->other2->Visible) { // other2 ?>
	<?php if ($job_card_f->sortUrl($job_card_f->other2) == "") { ?>
		<th data-name="other2" class="<?php echo $job_card_f->other2->headerCellClass() ?>"><div id="elh_job_card_f_other2" class="job_card_f_other2"><div class="ew-table-header-caption"><?php echo $job_card_f->other2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other2" class="<?php echo $job_card_f->other2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->other2) ?>',2);"><div id="elh_job_card_f_other2" class="job_card_f_other2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->other2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->other2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->other2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->operator->Visible) { // operator ?>
	<?php if ($job_card_f->sortUrl($job_card_f->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $job_card_f->operator->headerCellClass() ?>"><div id="elh_job_card_f_operator" class="job_card_f_operator"><div class="ew-table-header-caption"><?php echo $job_card_f->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $job_card_f->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->operator) ?>',2);"><div id="elh_job_card_f_operator" class="job_card_f_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->updated->Visible) { // updated ?>
	<?php if ($job_card_f->sortUrl($job_card_f->updated) == "") { ?>
		<th data-name="updated" class="<?php echo $job_card_f->updated->headerCellClass() ?>"><div id="elh_job_card_f_updated" class="job_card_f_updated"><div class="ew-table-header-caption"><?php echo $job_card_f->updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="updated" class="<?php echo $job_card_f->updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->updated) ?>',2);"><div id="elh_job_card_f_updated" class="job_card_f_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->updated->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->datetime->Visible) { // datetime ?>
	<?php if ($job_card_f->sortUrl($job_card_f->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $job_card_f->datetime->headerCellClass() ?>"><div id="elh_job_card_f_datetime" class="job_card_f_datetime"><div class="ew-table-header-caption"><?php echo $job_card_f->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $job_card_f->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->datetime) ?>',2);"><div id="elh_job_card_f_datetime" class="job_card_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->jc_no->Visible) { // jc_no ?>
	<?php if ($job_card_f->sortUrl($job_card_f->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $job_card_f->jc_no->headerCellClass() ?>"><div id="elh_job_card_f_jc_no" class="job_card_f_jc_no"><div class="ew-table-header-caption"><?php echo $job_card_f->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $job_card_f->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->jc_no) ?>',2);"><div id="elh_job_card_f_jc_no" class="job_card_f_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->s_grp->Visible) { // s_grp ?>
	<?php if ($job_card_f->sortUrl($job_card_f->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $job_card_f->s_grp->headerCellClass() ?>"><div id="elh_job_card_f_s_grp" class="job_card_f_s_grp"><div class="ew-table-header-caption"><?php echo $job_card_f->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $job_card_f->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->s_grp) ?>',2);"><div id="elh_job_card_f_s_grp" class="job_card_f_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->item->Visible) { // item ?>
	<?php if ($job_card_f->sortUrl($job_card_f->item) == "") { ?>
		<th data-name="item" class="<?php echo $job_card_f->item->headerCellClass() ?>"><div id="elh_job_card_f_item" class="job_card_f_item"><div class="ew-table-header-caption"><?php echo $job_card_f->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $job_card_f->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->item) ?>',2);"><div id="elh_job_card_f_item" class="job_card_f_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->batch_no->Visible) { // batch_no ?>
	<?php if ($job_card_f->sortUrl($job_card_f->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $job_card_f->batch_no->headerCellClass() ?>"><div id="elh_job_card_f_batch_no" class="job_card_f_batch_no"><div class="ew-table-header-caption"><?php echo $job_card_f->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $job_card_f->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->batch_no) ?>',2);"><div id="elh_job_card_f_batch_no" class="job_card_f_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->poid->Visible) { // poid ?>
	<?php if ($job_card_f->sortUrl($job_card_f->poid) == "") { ?>
		<th data-name="poid" class="<?php echo $job_card_f->poid->headerCellClass() ?>"><div id="elh_job_card_f_poid" class="job_card_f_poid"><div class="ew-table-header-caption"><?php echo $job_card_f->poid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="poid" class="<?php echo $job_card_f->poid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->poid) ?>',2);"><div id="elh_job_card_f_poid" class="job_card_f_poid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->poid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->poid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->poid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->quantity->Visible) { // quantity ?>
	<?php if ($job_card_f->sortUrl($job_card_f->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $job_card_f->quantity->headerCellClass() ?>"><div id="elh_job_card_f_quantity" class="job_card_f_quantity"><div class="ew-table-header-caption"><?php echo $job_card_f->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $job_card_f->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->quantity) ?>',2);"><div id="elh_job_card_f_quantity" class="job_card_f_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_f->pro_unit->Visible) { // pro_unit ?>
	<?php if ($job_card_f->sortUrl($job_card_f->pro_unit) == "") { ?>
		<th data-name="pro_unit" class="<?php echo $job_card_f->pro_unit->headerCellClass() ?>"><div id="elh_job_card_f_pro_unit" class="job_card_f_pro_unit"><div class="ew-table-header-caption"><?php echo $job_card_f->pro_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pro_unit" class="<?php echo $job_card_f->pro_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_f->SortUrl($job_card_f->pro_unit) ?>',2);"><div id="elh_job_card_f_pro_unit" class="job_card_f_pro_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_f->pro_unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_f->pro_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_f->pro_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$job_card_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($job_card_f->ExportAll && $job_card_f->isExport()) {
	$job_card_f_list->StopRec = $job_card_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($job_card_f_list->TotalRecs > $job_card_f_list->StartRec + $job_card_f_list->DisplayRecs - 1)
		$job_card_f_list->StopRec = $job_card_f_list->StartRec + $job_card_f_list->DisplayRecs - 1;
	else
		$job_card_f_list->StopRec = $job_card_f_list->TotalRecs;
}
$job_card_f_list->RecCnt = $job_card_f_list->StartRec - 1;
if ($job_card_f_list->Recordset && !$job_card_f_list->Recordset->EOF) {
	$job_card_f_list->Recordset->moveFirst();
	$selectLimit = $job_card_f_list->UseSelectLimit;
	if (!$selectLimit && $job_card_f_list->StartRec > 1)
		$job_card_f_list->Recordset->move($job_card_f_list->StartRec - 1);
} elseif (!$job_card_f->AllowAddDeleteRow && $job_card_f_list->StopRec == 0) {
	$job_card_f_list->StopRec = $job_card_f->GridAddRowCount;
}

// Initialize aggregate
$job_card_f->RowType = ROWTYPE_AGGREGATEINIT;
$job_card_f->resetAttributes();
$job_card_f_list->renderRow();
while ($job_card_f_list->RecCnt < $job_card_f_list->StopRec) {
	$job_card_f_list->RecCnt++;
	if ($job_card_f_list->RecCnt >= $job_card_f_list->StartRec) {
		$job_card_f_list->RowCnt++;

		// Set up key count
		$job_card_f_list->KeyCount = $job_card_f_list->RowIndex;

		// Init row class and style
		$job_card_f->resetAttributes();
		$job_card_f->CssClass = "";
		if ($job_card_f->isGridAdd()) {
		} else {
			$job_card_f_list->loadRowValues($job_card_f_list->Recordset); // Load row values
		}
		$job_card_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$job_card_f->RowAttrs = array_merge($job_card_f->RowAttrs, array('data-rowindex'=>$job_card_f_list->RowCnt, 'id'=>'r' . $job_card_f_list->RowCnt . '_job_card_f', 'data-rowtype'=>$job_card_f->RowType));

		// Render row
		$job_card_f_list->renderRow();

		// Render list options
		$job_card_f_list->renderListOptions();
?>
	<tr<?php echo $job_card_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$job_card_f_list->ListOptions->render("body", "left", $job_card_f_list->RowCnt);
?>
	<?php if ($job_card_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $job_card_f->id->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_id" class="job_card_f_id">
<span<?php echo $job_card_f->id->viewAttributes() ?>>
<?php echo $job_card_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $job_card_f->grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_grp" class="job_card_f_grp">
<span<?php echo $job_card_f->grp->viewAttributes() ?>>
<?php echo $job_card_f->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $job_card_f->employee_id->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_employee_id" class="job_card_f_employee_id">
<span<?php echo $job_card_f->employee_id->viewAttributes() ?>>
<?php echo $job_card_f->employee_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $job_card_f->lot_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_lot_no" class="job_card_f_lot_no">
<span<?php echo $job_card_f->lot_no->viewAttributes() ?>>
<?php echo $job_card_f->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_1->Visible) { // 1 ?>
		<td data-name="_1"<?php echo $job_card_f->_1->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__1" class="job_card_f__1">
<span<?php echo $job_card_f->_1->viewAttributes() ?>>
<?php echo $job_card_f->_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_2->Visible) { // 2 ?>
		<td data-name="_2"<?php echo $job_card_f->_2->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__2" class="job_card_f__2">
<span<?php echo $job_card_f->_2->viewAttributes() ?>>
<?php echo $job_card_f->_2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_3->Visible) { // 3 ?>
		<td data-name="_3"<?php echo $job_card_f->_3->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__3" class="job_card_f__3">
<span<?php echo $job_card_f->_3->viewAttributes() ?>>
<?php echo $job_card_f->_3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_4->Visible) { // 4 ?>
		<td data-name="_4"<?php echo $job_card_f->_4->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__4" class="job_card_f__4">
<span<?php echo $job_card_f->_4->viewAttributes() ?>>
<?php echo $job_card_f->_4->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_5->Visible) { // 5 ?>
		<td data-name="_5"<?php echo $job_card_f->_5->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__5" class="job_card_f__5">
<span<?php echo $job_card_f->_5->viewAttributes() ?>>
<?php echo $job_card_f->_5->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_6->Visible) { // 6 ?>
		<td data-name="_6"<?php echo $job_card_f->_6->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__6" class="job_card_f__6">
<span<?php echo $job_card_f->_6->viewAttributes() ?>>
<?php echo $job_card_f->_6->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_7->Visible) { // 7 ?>
		<td data-name="_7"<?php echo $job_card_f->_7->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__7" class="job_card_f__7">
<span<?php echo $job_card_f->_7->viewAttributes() ?>>
<?php echo $job_card_f->_7->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->_8->Visible) { // 8 ?>
		<td data-name="_8"<?php echo $job_card_f->_8->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f__8" class="job_card_f__8">
<span<?php echo $job_card_f->_8->viewAttributes() ?>>
<?php echo $job_card_f->_8->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->other1->Visible) { // other1 ?>
		<td data-name="other1"<?php echo $job_card_f->other1->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_other1" class="job_card_f_other1">
<span<?php echo $job_card_f->other1->viewAttributes() ?>>
<?php echo $job_card_f->other1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->other2->Visible) { // other2 ?>
		<td data-name="other2"<?php echo $job_card_f->other2->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_other2" class="job_card_f_other2">
<span<?php echo $job_card_f->other2->viewAttributes() ?>>
<?php echo $job_card_f->other2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $job_card_f->operator->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_operator" class="job_card_f_operator">
<span<?php echo $job_card_f->operator->viewAttributes() ?>>
<?php echo $job_card_f->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->updated->Visible) { // updated ?>
		<td data-name="updated"<?php echo $job_card_f->updated->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_updated" class="job_card_f_updated">
<span<?php echo $job_card_f->updated->viewAttributes() ?>>
<?php echo $job_card_f->updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $job_card_f->datetime->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_datetime" class="job_card_f_datetime">
<span<?php echo $job_card_f->datetime->viewAttributes() ?>>
<?php echo $job_card_f->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $job_card_f->jc_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_jc_no" class="job_card_f_jc_no">
<span<?php echo $job_card_f->jc_no->viewAttributes() ?>>
<?php echo $job_card_f->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $job_card_f->s_grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_s_grp" class="job_card_f_s_grp">
<span<?php echo $job_card_f->s_grp->viewAttributes() ?>>
<?php echo $job_card_f->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->item->Visible) { // item ?>
		<td data-name="item"<?php echo $job_card_f->item->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_item" class="job_card_f_item">
<span<?php echo $job_card_f->item->viewAttributes() ?>>
<?php echo $job_card_f->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $job_card_f->batch_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_batch_no" class="job_card_f_batch_no">
<span<?php echo $job_card_f->batch_no->viewAttributes() ?>>
<?php echo $job_card_f->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->poid->Visible) { // poid ?>
		<td data-name="poid"<?php echo $job_card_f->poid->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_poid" class="job_card_f_poid">
<span<?php echo $job_card_f->poid->viewAttributes() ?>>
<?php echo $job_card_f->poid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $job_card_f->quantity->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_quantity" class="job_card_f_quantity">
<span<?php echo $job_card_f->quantity->viewAttributes() ?>>
<?php echo $job_card_f->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_f->pro_unit->Visible) { // pro_unit ?>
		<td data-name="pro_unit"<?php echo $job_card_f->pro_unit->cellAttributes() ?>>
<span id="el<?php echo $job_card_f_list->RowCnt ?>_job_card_f_pro_unit" class="job_card_f_pro_unit">
<span<?php echo $job_card_f->pro_unit->viewAttributes() ?>>
<?php echo $job_card_f->pro_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$job_card_f_list->ListOptions->render("body", "right", $job_card_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$job_card_f->isGridAdd())
		$job_card_f_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$job_card_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($job_card_f_list->Recordset)
	$job_card_f_list->Recordset->Close();
?>
<?php if (!$job_card_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$job_card_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_f_list->Pager)) $job_card_f_list->Pager = new PrevNextPager($job_card_f_list->StartRec, $job_card_f_list->DisplayRecs, $job_card_f_list->TotalRecs, $job_card_f_list->AutoHidePager) ?>
<?php if ($job_card_f_list->Pager->RecordCount > 0 && $job_card_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_f_list->pageUrl() ?>start=<?php echo $job_card_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_f_list->TotalRecs > 0 && (!$job_card_f_list->AutoHidePageSizeSelector || $job_card_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($job_card_f_list->TotalRecs == 0 && !$job_card_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $job_card_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$job_card_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#elh_job_card_f__1").html("<?php echo PageDesc(1,'d_01_head')['d_01_head'] ?>");
$("#elh_job_card_f__2").html("<?php echo PageDesc(1,'d_02_head')['d_02_head'] ?>");
$("#elh_job_card_f__3").html("<?php echo PageDesc(1,'d_03_head')['d_03_head'] ?>");
$("#elh_job_card_f__4").html("<?php echo PageDesc(1,'d_04_head')['d_04_head'] ?>");
$("#elh_job_card_f__5").html("<?php echo PageDesc(1,'d_05_head')['d_05_head'] ?>");
$("#elh_job_card_f__6").html("<?php echo PageDesc(1,'d_06_head')['d_06_head'] ?>");
$("#elh_job_card_f__7").html("<?php echo PageDesc(1,'d_07_head')['d_07_head'] ?>");
$("#elh_job_card_f__8").html("<?php echo PageDesc(1,'d_08_head')['d_08_head'] ?>");
</script>
<?php if (!$job_card_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_job_card_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_f_list->terminate();
?>