<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_fp_list = new job_card_fp_list();

// Run the page
$job_card_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjob_card_fplist = currentForm = new ew.Form("fjob_card_fplist", "list");
fjob_card_fplist.formKeyCountName = '<?php echo $job_card_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjob_card_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_fplist.lists["x_grp"] = <?php echo $job_card_fp_list->grp->Lookup->toClientList() ?>;
fjob_card_fplist.lists["x_grp"].options = <?php echo JsonEncode($job_card_fp_list->grp->options(FALSE, TRUE)) ?>;
fjob_card_fplist.lists["x_works"] = <?php echo $job_card_fp_list->works->Lookup->toClientList() ?>;
fjob_card_fplist.lists["x_works"].options = <?php echo JsonEncode($job_card_fp_list->works->lookupOptions()) ?>;
fjob_card_fplist.lists["x_s_grp"] = <?php echo $job_card_fp_list->s_grp->Lookup->toClientList() ?>;
fjob_card_fplist.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_fp_list->s_grp->lookupOptions()) ?>;
fjob_card_fplist.lists["x_employee_id[]"] = <?php echo $job_card_fp_list->employee_id->Lookup->toClientList() ?>;
fjob_card_fplist.lists["x_employee_id[]"].options = <?php echo JsonEncode($job_card_fp_list->employee_id->lookupOptions()) ?>;
fjob_card_fplist.lists["x_operator"] = <?php echo $job_card_fp_list->operator->Lookup->toClientList() ?>;
fjob_card_fplist.lists["x_operator"].options = <?php echo JsonEncode($job_card_fp_list->operator->lookupOptions()) ?>;

// Form object for search
var fjob_card_fplistsrch = currentSearchForm = new ew.Form("fjob_card_fplistsrch");

// Validate function for search
fjob_card_fplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fjob_card_fplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_fplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_fplistsrch.lists["x_works"] = <?php echo $job_card_fp_list->works->Lookup->toClientList() ?>;
fjob_card_fplistsrch.lists["x_works"].options = <?php echo JsonEncode($job_card_fp_list->works->lookupOptions()) ?>;
fjob_card_fplistsrch.lists["x_s_grp"] = <?php echo $job_card_fp_list->s_grp->Lookup->toClientList() ?>;
fjob_card_fplistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_fp_list->s_grp->lookupOptions()) ?>;

// Filters
fjob_card_fplistsrch.filterList = <?php echo $job_card_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fjob_card_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($job_card_fp_list->TotalRecs > 0 && $job_card_fp_list->ExportOptions->visible()) { ?>
<?php $job_card_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_fp_list->ImportOptions->visible()) { ?>
<?php $job_card_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_fp_list->SearchOptions->visible()) { ?>
<?php $job_card_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_fp_list->FilterOptions->visible()) { ?>
<?php $job_card_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$job_card_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$job_card_fp->isExport() && !$job_card_fp->CurrentAction) { ?>
<form name="fjob_card_fplistsrch" id="fjob_card_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($job_card_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjob_card_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="job_card_fp">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$job_card_fp_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$job_card_fp->RowType = ROWTYPE_SEARCH;

// Render row
$job_card_fp->resetAttributes();
$job_card_fp_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($job_card_fp->works->Visible) { // works ?>
	<div id="xsc_works" class="ew-cell form-group">
		<label for="x_works" class="ew-search-caption ew-label"><?php echo $job_card_fp->works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_works" id="z_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_fp" data-field="x_works" data-value-separator="<?php echo $job_card_fp->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card_fp->works->editAttributes() ?>>
		<?php echo $job_card_fp->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card_fp->works->Lookup->getParamTag("p_x_works") ?>
</span>
	</div>
<?php } ?>
<?php if ($job_card_fp->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $job_card_fp->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_fp" data-field="x_s_grp" data-value-separator="<?php echo $job_card_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $job_card_fp->s_grp->editAttributes() ?>>
		<?php echo $job_card_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $job_card_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($job_card_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($job_card_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $job_card_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($job_card_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($job_card_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($job_card_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($job_card_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $job_card_fp_list->showPageHeader(); ?>
<?php
$job_card_fp_list->showMessage();
?>
<?php if ($job_card_fp_list->TotalRecs > 0 || $job_card_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($job_card_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> job_card_fp">
<?php if (!$job_card_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$job_card_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_fp_list->Pager)) $job_card_fp_list->Pager = new PrevNextPager($job_card_fp_list->StartRec, $job_card_fp_list->DisplayRecs, $job_card_fp_list->TotalRecs, $job_card_fp_list->AutoHidePager) ?>
<?php if ($job_card_fp_list->Pager->RecordCount > 0 && $job_card_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_fp_list->TotalRecs > 0 && (!$job_card_fp_list->AutoHidePageSizeSelector || $job_card_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjob_card_fplist" id="fjob_card_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_fp">
<div id="gmp_job_card_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($job_card_fp_list->TotalRecs > 0 || $job_card_fp->isGridEdit()) { ?>
<table id="tbl_job_card_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$job_card_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$job_card_fp_list->renderListOptions();

// Render list options (header, left)
$job_card_fp_list->ListOptions->render("header", "left");
?>
<?php if ($job_card_fp->id->Visible) { // id ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $job_card_fp->id->headerCellClass() ?>"><div id="elh_job_card_fp_id" class="job_card_fp_id"><div class="ew-table-header-caption"><?php echo $job_card_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $job_card_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->id) ?>',2);"><div id="elh_job_card_fp_id" class="job_card_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->grp->Visible) { // grp ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $job_card_fp->grp->headerCellClass() ?>"><div id="elh_job_card_fp_grp" class="job_card_fp_grp"><div class="ew-table-header-caption"><?php echo $job_card_fp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $job_card_fp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->grp) ?>',2);"><div id="elh_job_card_fp_grp" class="job_card_fp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->jc_no->Visible) { // jc_no ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $job_card_fp->jc_no->headerCellClass() ?>"><div id="elh_job_card_fp_jc_no" class="job_card_fp_jc_no"><div class="ew-table-header-caption"><?php echo $job_card_fp->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $job_card_fp->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->jc_no) ?>',2);"><div id="elh_job_card_fp_jc_no" class="job_card_fp_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->works->Visible) { // works ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->works) == "") { ?>
		<th data-name="works" class="<?php echo $job_card_fp->works->headerCellClass() ?>"><div id="elh_job_card_fp_works" class="job_card_fp_works"><div class="ew-table-header-caption"><?php echo $job_card_fp->works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="works" class="<?php echo $job_card_fp->works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->works) ?>',2);"><div id="elh_job_card_fp_works" class="job_card_fp_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->works->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->s_grp->Visible) { // s_grp ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $job_card_fp->s_grp->headerCellClass() ?>"><div id="elh_job_card_fp_s_grp" class="job_card_fp_s_grp"><div class="ew-table-header-caption"><?php echo $job_card_fp->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $job_card_fp->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->s_grp) ?>',2);"><div id="elh_job_card_fp_s_grp" class="job_card_fp_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->po->Visible) { // po ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->po) == "") { ?>
		<th data-name="po" class="<?php echo $job_card_fp->po->headerCellClass() ?>"><div id="elh_job_card_fp_po" class="job_card_fp_po"><div class="ew-table-header-caption"><?php echo $job_card_fp->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $job_card_fp->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->po) ?>',2);"><div id="elh_job_card_fp_po" class="job_card_fp_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->quantity->Visible) { // quantity ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $job_card_fp->quantity->headerCellClass() ?>"><div id="elh_job_card_fp_quantity" class="job_card_fp_quantity"><div class="ew-table-header-caption"><?php echo $job_card_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $job_card_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->quantity) ?>',2);"><div id="elh_job_card_fp_quantity" class="job_card_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->pro_unit->Visible) { // pro_unit ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->pro_unit) == "") { ?>
		<th data-name="pro_unit" class="<?php echo $job_card_fp->pro_unit->headerCellClass() ?>"><div id="elh_job_card_fp_pro_unit" class="job_card_fp_pro_unit"><div class="ew-table-header-caption"><?php echo $job_card_fp->pro_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pro_unit" class="<?php echo $job_card_fp->pro_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->pro_unit) ?>',2);"><div id="elh_job_card_fp_pro_unit" class="job_card_fp_pro_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->pro_unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->pro_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->pro_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->employee_id->Visible) { // employee_id ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $job_card_fp->employee_id->headerCellClass() ?>"><div id="elh_job_card_fp_employee_id" class="job_card_fp_employee_id"><div class="ew-table-header-caption"><?php echo $job_card_fp->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $job_card_fp->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->employee_id) ?>',2);"><div id="elh_job_card_fp_employee_id" class="job_card_fp_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_1->Visible) { // 1 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_1) == "") { ?>
		<th data-name="_1" class="<?php echo $job_card_fp->_1->headerCellClass() ?>"><div id="elh_job_card_fp__1" class="job_card_fp__1"><div class="ew-table-header-caption"><?php echo $job_card_fp->_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_1" class="<?php echo $job_card_fp->_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_1) ?>',2);"><div id="elh_job_card_fp__1" class="job_card_fp__1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_2->Visible) { // 2 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_2) == "") { ?>
		<th data-name="_2" class="<?php echo $job_card_fp->_2->headerCellClass() ?>"><div id="elh_job_card_fp__2" class="job_card_fp__2"><div class="ew-table-header-caption"><?php echo $job_card_fp->_2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_2" class="<?php echo $job_card_fp->_2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_2) ?>',2);"><div id="elh_job_card_fp__2" class="job_card_fp__2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_3->Visible) { // 3 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_3) == "") { ?>
		<th data-name="_3" class="<?php echo $job_card_fp->_3->headerCellClass() ?>"><div id="elh_job_card_fp__3" class="job_card_fp__3"><div class="ew-table-header-caption"><?php echo $job_card_fp->_3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_3" class="<?php echo $job_card_fp->_3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_3) ?>',2);"><div id="elh_job_card_fp__3" class="job_card_fp__3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_3->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_3->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_4->Visible) { // 4 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_4) == "") { ?>
		<th data-name="_4" class="<?php echo $job_card_fp->_4->headerCellClass() ?>"><div id="elh_job_card_fp__4" class="job_card_fp__4"><div class="ew-table-header-caption"><?php echo $job_card_fp->_4->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_4" class="<?php echo $job_card_fp->_4->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_4) ?>',2);"><div id="elh_job_card_fp__4" class="job_card_fp__4">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_4->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_4->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_4->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_5->Visible) { // 5 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_5) == "") { ?>
		<th data-name="_5" class="<?php echo $job_card_fp->_5->headerCellClass() ?>"><div id="elh_job_card_fp__5" class="job_card_fp__5"><div class="ew-table-header-caption"><?php echo $job_card_fp->_5->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_5" class="<?php echo $job_card_fp->_5->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_5) ?>',2);"><div id="elh_job_card_fp__5" class="job_card_fp__5">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_5->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_5->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_5->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_6->Visible) { // 6 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_6) == "") { ?>
		<th data-name="_6" class="<?php echo $job_card_fp->_6->headerCellClass() ?>"><div id="elh_job_card_fp__6" class="job_card_fp__6"><div class="ew-table-header-caption"><?php echo $job_card_fp->_6->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_6" class="<?php echo $job_card_fp->_6->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_6) ?>',2);"><div id="elh_job_card_fp__6" class="job_card_fp__6">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_6->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_6->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_6->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_7->Visible) { // 7 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_7) == "") { ?>
		<th data-name="_7" class="<?php echo $job_card_fp->_7->headerCellClass() ?>"><div id="elh_job_card_fp__7" class="job_card_fp__7"><div class="ew-table-header-caption"><?php echo $job_card_fp->_7->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_7" class="<?php echo $job_card_fp->_7->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_7) ?>',2);"><div id="elh_job_card_fp__7" class="job_card_fp__7">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_7->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_7->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_7->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->_8->Visible) { // 8 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->_8) == "") { ?>
		<th data-name="_8" class="<?php echo $job_card_fp->_8->headerCellClass() ?>"><div id="elh_job_card_fp__8" class="job_card_fp__8"><div class="ew-table-header-caption"><?php echo $job_card_fp->_8->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_8" class="<?php echo $job_card_fp->_8->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->_8) ?>',2);"><div id="elh_job_card_fp__8" class="job_card_fp__8">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->_8->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->_8->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->_8->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->other1->Visible) { // other1 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->other1) == "") { ?>
		<th data-name="other1" class="<?php echo $job_card_fp->other1->headerCellClass() ?>"><div id="elh_job_card_fp_other1" class="job_card_fp_other1"><div class="ew-table-header-caption"><?php echo $job_card_fp->other1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other1" class="<?php echo $job_card_fp->other1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->other1) ?>',2);"><div id="elh_job_card_fp_other1" class="job_card_fp_other1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->other1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->other1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->other1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->other2->Visible) { // other2 ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->other2) == "") { ?>
		<th data-name="other2" class="<?php echo $job_card_fp->other2->headerCellClass() ?>"><div id="elh_job_card_fp_other2" class="job_card_fp_other2"><div class="ew-table-header-caption"><?php echo $job_card_fp->other2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other2" class="<?php echo $job_card_fp->other2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->other2) ?>',2);"><div id="elh_job_card_fp_other2" class="job_card_fp_other2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->other2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->other2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->other2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->operator->Visible) { // operator ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $job_card_fp->operator->headerCellClass() ?>"><div id="elh_job_card_fp_operator" class="job_card_fp_operator"><div class="ew-table-header-caption"><?php echo $job_card_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $job_card_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->operator) ?>',2);"><div id="elh_job_card_fp_operator" class="job_card_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->datetime->Visible) { // datetime ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $job_card_fp->datetime->headerCellClass() ?>"><div id="elh_job_card_fp_datetime" class="job_card_fp_datetime"><div class="ew-table-header-caption"><?php echo $job_card_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $job_card_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->datetime) ?>',2);"><div id="elh_job_card_fp_datetime" class="job_card_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->product_code->Visible) { // product_code ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $job_card_fp->product_code->headerCellClass() ?>"><div id="elh_job_card_fp_product_code" class="job_card_fp_product_code"><div class="ew-table-header-caption"><?php echo $job_card_fp->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $job_card_fp->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->product_code) ?>',2);"><div id="elh_job_card_fp_product_code" class="job_card_fp_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->in_id->Visible) { // in_id ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->in_id) == "") { ?>
		<th data-name="in_id" class="<?php echo $job_card_fp->in_id->headerCellClass() ?>"><div id="elh_job_card_fp_in_id" class="job_card_fp_in_id"><div class="ew-table-header-caption"><?php echo $job_card_fp->in_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="in_id" class="<?php echo $job_card_fp->in_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->in_id) ?>',2);"><div id="elh_job_card_fp_in_id" class="job_card_fp_in_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->in_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->in_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->in_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_fp->balance_quantity->Visible) { // balance_quantity ?>
	<?php if ($job_card_fp->sortUrl($job_card_fp->balance_quantity) == "") { ?>
		<th data-name="balance_quantity" class="<?php echo $job_card_fp->balance_quantity->headerCellClass() ?>"><div id="elh_job_card_fp_balance_quantity" class="job_card_fp_balance_quantity"><div class="ew-table-header-caption"><?php echo $job_card_fp->balance_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance_quantity" class="<?php echo $job_card_fp->balance_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_fp->SortUrl($job_card_fp->balance_quantity) ?>',2);"><div id="elh_job_card_fp_balance_quantity" class="job_card_fp_balance_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_fp->balance_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_fp->balance_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_fp->balance_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$job_card_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($job_card_fp->ExportAll && $job_card_fp->isExport()) {
	$job_card_fp_list->StopRec = $job_card_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($job_card_fp_list->TotalRecs > $job_card_fp_list->StartRec + $job_card_fp_list->DisplayRecs - 1)
		$job_card_fp_list->StopRec = $job_card_fp_list->StartRec + $job_card_fp_list->DisplayRecs - 1;
	else
		$job_card_fp_list->StopRec = $job_card_fp_list->TotalRecs;
}
$job_card_fp_list->RecCnt = $job_card_fp_list->StartRec - 1;
if ($job_card_fp_list->Recordset && !$job_card_fp_list->Recordset->EOF) {
	$job_card_fp_list->Recordset->moveFirst();
	$selectLimit = $job_card_fp_list->UseSelectLimit;
	if (!$selectLimit && $job_card_fp_list->StartRec > 1)
		$job_card_fp_list->Recordset->move($job_card_fp_list->StartRec - 1);
} elseif (!$job_card_fp->AllowAddDeleteRow && $job_card_fp_list->StopRec == 0) {
	$job_card_fp_list->StopRec = $job_card_fp->GridAddRowCount;
}

// Initialize aggregate
$job_card_fp->RowType = ROWTYPE_AGGREGATEINIT;
$job_card_fp->resetAttributes();
$job_card_fp_list->renderRow();
while ($job_card_fp_list->RecCnt < $job_card_fp_list->StopRec) {
	$job_card_fp_list->RecCnt++;
	if ($job_card_fp_list->RecCnt >= $job_card_fp_list->StartRec) {
		$job_card_fp_list->RowCnt++;

		// Set up key count
		$job_card_fp_list->KeyCount = $job_card_fp_list->RowIndex;

		// Init row class and style
		$job_card_fp->resetAttributes();
		$job_card_fp->CssClass = "";
		if ($job_card_fp->isGridAdd()) {
		} else {
			$job_card_fp_list->loadRowValues($job_card_fp_list->Recordset); // Load row values
		}
		$job_card_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$job_card_fp->RowAttrs = array_merge($job_card_fp->RowAttrs, array('data-rowindex'=>$job_card_fp_list->RowCnt, 'id'=>'r' . $job_card_fp_list->RowCnt . '_job_card_fp', 'data-rowtype'=>$job_card_fp->RowType));

		// Render row
		$job_card_fp_list->renderRow();

		// Render list options
		$job_card_fp_list->renderListOptions();
?>
	<tr<?php echo $job_card_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$job_card_fp_list->ListOptions->render("body", "left", $job_card_fp_list->RowCnt);
?>
	<?php if ($job_card_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $job_card_fp->id->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_id" class="job_card_fp_id">
<span<?php echo $job_card_fp->id->viewAttributes() ?>>
<?php echo $job_card_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $job_card_fp->grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_grp" class="job_card_fp_grp">
<span<?php echo $job_card_fp->grp->viewAttributes() ?>>
<?php echo $job_card_fp->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $job_card_fp->jc_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_jc_no" class="job_card_fp_jc_no">
<span<?php echo $job_card_fp->jc_no->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_fp->jc_no->getViewValue())) && $job_card_fp->jc_no->linkAttributes() <> "") { ?>
<a<?php echo $job_card_fp->jc_no->linkAttributes() ?>><?php echo $job_card_fp->jc_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_fp->jc_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->works->Visible) { // works ?>
		<td data-name="works"<?php echo $job_card_fp->works->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_works" class="job_card_fp_works">
<span<?php echo $job_card_fp->works->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_fp->works->getViewValue())) && $job_card_fp->works->linkAttributes() <> "") { ?>
<a<?php echo $job_card_fp->works->linkAttributes() ?>><?php echo $job_card_fp->works->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_fp->works->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $job_card_fp->s_grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_s_grp" class="job_card_fp_s_grp">
<span<?php echo $job_card_fp->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_fp->s_grp->getViewValue())) && $job_card_fp->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $job_card_fp->s_grp->linkAttributes() ?>><?php echo $job_card_fp->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_fp->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->po->Visible) { // po ?>
		<td data-name="po"<?php echo $job_card_fp->po->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_po" class="job_card_fp_po">
<span<?php echo $job_card_fp->po->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_fp->po->getViewValue())) && $job_card_fp->po->linkAttributes() <> "") { ?>
<a<?php echo $job_card_fp->po->linkAttributes() ?>><?php echo $job_card_fp->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_fp->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $job_card_fp->quantity->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_quantity" class="job_card_fp_quantity">
<span<?php echo $job_card_fp->quantity->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_fp->quantity->getViewValue())) && $job_card_fp->quantity->linkAttributes() <> "") { ?>
<a<?php echo $job_card_fp->quantity->linkAttributes() ?>><?php echo $job_card_fp->quantity->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_fp->quantity->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->pro_unit->Visible) { // pro_unit ?>
		<td data-name="pro_unit"<?php echo $job_card_fp->pro_unit->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_pro_unit" class="job_card_fp_pro_unit">
<span<?php echo $job_card_fp->pro_unit->viewAttributes() ?>>
<?php echo $job_card_fp->pro_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $job_card_fp->employee_id->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_employee_id" class="job_card_fp_employee_id">
<span<?php echo $job_card_fp->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_fp->employee_id->getViewValue())) && $job_card_fp->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $job_card_fp->employee_id->linkAttributes() ?>><?php echo $job_card_fp->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_fp->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_1->Visible) { // 1 ?>
		<td data-name="_1"<?php echo $job_card_fp->_1->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__1" class="job_card_fp__1">
<span<?php echo $job_card_fp->_1->viewAttributes() ?>>
<?php echo $job_card_fp->_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_2->Visible) { // 2 ?>
		<td data-name="_2"<?php echo $job_card_fp->_2->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__2" class="job_card_fp__2">
<span<?php echo $job_card_fp->_2->viewAttributes() ?>>
<?php echo $job_card_fp->_2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_3->Visible) { // 3 ?>
		<td data-name="_3"<?php echo $job_card_fp->_3->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__3" class="job_card_fp__3">
<span<?php echo $job_card_fp->_3->viewAttributes() ?>>
<?php echo $job_card_fp->_3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_4->Visible) { // 4 ?>
		<td data-name="_4"<?php echo $job_card_fp->_4->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__4" class="job_card_fp__4">
<span<?php echo $job_card_fp->_4->viewAttributes() ?>>
<?php echo $job_card_fp->_4->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_5->Visible) { // 5 ?>
		<td data-name="_5"<?php echo $job_card_fp->_5->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__5" class="job_card_fp__5">
<span<?php echo $job_card_fp->_5->viewAttributes() ?>>
<?php echo $job_card_fp->_5->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_6->Visible) { // 6 ?>
		<td data-name="_6"<?php echo $job_card_fp->_6->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__6" class="job_card_fp__6">
<span<?php echo $job_card_fp->_6->viewAttributes() ?>>
<?php echo $job_card_fp->_6->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_7->Visible) { // 7 ?>
		<td data-name="_7"<?php echo $job_card_fp->_7->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__7" class="job_card_fp__7">
<span<?php echo $job_card_fp->_7->viewAttributes() ?>>
<?php echo $job_card_fp->_7->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->_8->Visible) { // 8 ?>
		<td data-name="_8"<?php echo $job_card_fp->_8->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp__8" class="job_card_fp__8">
<span<?php echo $job_card_fp->_8->viewAttributes() ?>>
<?php echo $job_card_fp->_8->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->other1->Visible) { // other1 ?>
		<td data-name="other1"<?php echo $job_card_fp->other1->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_other1" class="job_card_fp_other1">
<span<?php echo $job_card_fp->other1->viewAttributes() ?>>
<?php echo $job_card_fp->other1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->other2->Visible) { // other2 ?>
		<td data-name="other2"<?php echo $job_card_fp->other2->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_other2" class="job_card_fp_other2">
<span<?php echo $job_card_fp->other2->viewAttributes() ?>>
<?php echo $job_card_fp->other2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $job_card_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_operator" class="job_card_fp_operator">
<span<?php echo $job_card_fp->operator->viewAttributes() ?>>
<?php echo $job_card_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $job_card_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_datetime" class="job_card_fp_datetime">
<span<?php echo $job_card_fp->datetime->viewAttributes() ?>>
<?php echo $job_card_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $job_card_fp->product_code->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_product_code" class="job_card_fp_product_code">
<span<?php echo $job_card_fp->product_code->viewAttributes() ?>>
<?php echo $job_card_fp->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->in_id->Visible) { // in_id ?>
		<td data-name="in_id"<?php echo $job_card_fp->in_id->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_in_id" class="job_card_fp_in_id">
<span<?php echo $job_card_fp->in_id->viewAttributes() ?>>
<?php echo $job_card_fp->in_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_fp->balance_quantity->Visible) { // balance_quantity ?>
		<td data-name="balance_quantity"<?php echo $job_card_fp->balance_quantity->cellAttributes() ?>>
<span id="el<?php echo $job_card_fp_list->RowCnt ?>_job_card_fp_balance_quantity" class="job_card_fp_balance_quantity">
<span<?php echo $job_card_fp->balance_quantity->viewAttributes() ?>>
<?php echo $job_card_fp->balance_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$job_card_fp_list->ListOptions->render("body", "right", $job_card_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$job_card_fp->isGridAdd())
		$job_card_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$job_card_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($job_card_fp_list->Recordset)
	$job_card_fp_list->Recordset->Close();
?>
<?php if (!$job_card_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$job_card_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_fp_list->Pager)) $job_card_fp_list->Pager = new PrevNextPager($job_card_fp_list->StartRec, $job_card_fp_list->DisplayRecs, $job_card_fp_list->TotalRecs, $job_card_fp_list->AutoHidePager) ?>
<?php if ($job_card_fp_list->Pager->RecordCount > 0 && $job_card_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_fp_list->pageUrl() ?>start=<?php echo $job_card_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_fp_list->TotalRecs > 0 && (!$job_card_fp_list->AutoHidePageSizeSelector || $job_card_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($job_card_fp_list->TotalRecs == 0 && !$job_card_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $job_card_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$job_card_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#elh_job_card_fp__1").html("<?php echo PageDesc(2,'d_01_head')['d_01_head'] ?>");
$("#elh_job_card_fp__2").html("<?php echo PageDesc(2,'d_02_head')['d_02_head'] ?>");
$("#elh_job_card_fp__3").html("<?php echo PageDesc(2,'d_03_head')['d_03_head'] ?>");
$("#elh_job_card_fp__4").html("<?php echo PageDesc(2,'d_04_head')['d_04_head'] ?>");
$("#elh_job_card_fp__5").html("<?php echo PageDesc(2,'d_05_head')['d_05_head'] ?>");
$("#elh_job_card_fp__6").html("<?php echo PageDesc(2,'d_06_head')['d_06_head'] ?>");
$("#elh_job_card_fp__7").html("<?php echo PageDesc(2,'d_07_head')['d_07_head'] ?>");
$("#elh_job_card_fp__8").html("<?php echo PageDesc(2,'d_08_head')['d_08_head'] ?>");
</script>
<?php if (!$job_card_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_job_card_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_fp_list->terminate();
?>