<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_fp_search = new job_card_fp_search();

// Run the page
$job_card_fp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_fp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($job_card_fp_search->IsModal) { ?>
var fjob_card_fpsearch = currentAdvancedSearchForm = new ew.Form("fjob_card_fpsearch", "search");
<?php } else { ?>
var fjob_card_fpsearch = currentForm = new ew.Form("fjob_card_fpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fjob_card_fpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_fpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_fpsearch.lists["x_grp"] = <?php echo $job_card_fp_search->grp->Lookup->toClientList() ?>;
fjob_card_fpsearch.lists["x_grp"].options = <?php echo JsonEncode($job_card_fp_search->grp->options(FALSE, TRUE)) ?>;
fjob_card_fpsearch.lists["x_s_grp"] = <?php echo $job_card_fp_search->s_grp->Lookup->toClientList() ?>;
fjob_card_fpsearch.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_fp_search->s_grp->lookupOptions()) ?>;
fjob_card_fpsearch.lists["x_item"] = <?php echo $job_card_fp_search->item->Lookup->toClientList() ?>;
fjob_card_fpsearch.lists["x_item"].options = <?php echo JsonEncode($job_card_fp_search->item->lookupOptions()) ?>;
fjob_card_fpsearch.lists["x_employee_id[]"] = <?php echo $job_card_fp_search->employee_id->Lookup->toClientList() ?>;
fjob_card_fpsearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($job_card_fp_search->employee_id->lookupOptions()) ?>;
fjob_card_fpsearch.lists["x_operator"] = <?php echo $job_card_fp_search->operator->Lookup->toClientList() ?>;
fjob_card_fpsearch.lists["x_operator"].options = <?php echo JsonEncode($job_card_fp_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fjob_card_fpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_fp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_fp->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_fp->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pro_unit");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_fp->pro_unit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_fp->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_fp->balance_quantity->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_fp_search->showPageHeader(); ?>
<?php
$job_card_fp_search->showMessage();
?>
<form name="fjob_card_fpsearch" id="fjob_card_fpsearch" class="<?php echo $job_card_fp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_fp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_fp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_fp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_fp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($job_card_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_id"><?php echo $job_card_fp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->id->cellAttributes() ?>>
			<span id="el_job_card_fp_id">
<input type="text" data-table="job_card_fp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($job_card_fp->id->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->id->EditValue ?>"<?php echo $job_card_fp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_grp"><?php echo $job_card_fp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->grp->cellAttributes() ?>>
			<span id="el_job_card_fp_grp">
<?php $job_card_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_fp" data-field="x_grp" data-value-separator="<?php echo $job_card_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $job_card_fp->grp->editAttributes() ?>>
		<?php echo $job_card_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_jc_no"><?php echo $job_card_fp->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->jc_no->cellAttributes() ?>>
			<span id="el_job_card_fp_jc_no">
<input type="text" data-table="job_card_fp" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($job_card_fp->jc_no->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->jc_no->EditValue ?>"<?php echo $job_card_fp->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_s_grp"><?php echo $job_card_fp->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->s_grp->cellAttributes() ?>>
			<span id="el_job_card_fp_s_grp">
<?php $job_card_fp->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_fp->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_fp" data-field="x_s_grp" data-value-separator="<?php echo $job_card_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $job_card_fp->s_grp->editAttributes() ?>>
		<?php echo $job_card_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $job_card_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label for="x_poid" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_poid"><?php echo $job_card_fp->poid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_poid" id="z_poid" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->poid->cellAttributes() ?>>
			<span id="el_job_card_fp_poid">
<input type="text" data-table="job_card_fp" data-field="x_poid" name="x_poid" id="x_poid" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card_fp->poid->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->poid->EditValue ?>"<?php echo $job_card_fp->poid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_item"><?php echo $job_card_fp->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->item->cellAttributes() ?>>
			<span id="el_job_card_fp_item">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_fp" data-field="x_item" data-value-separator="<?php echo $job_card_fp->item->displayValueSeparatorAttribute() ?>" id="x_item" name="x_item"<?php echo $job_card_fp->item->editAttributes() ?>>
		<?php echo $job_card_fp->item->selectOptionListHtml("x_item") ?>
	</select>
</div>
<?php echo $job_card_fp->item->Lookup->getParamTag("p_x_item") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_batch_no"><?php echo $job_card_fp->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->batch_no->cellAttributes() ?>>
			<span id="el_job_card_fp_batch_no">
<input type="text" data-table="job_card_fp" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" maxlength="89" placeholder="<?php echo HtmlEncode($job_card_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->batch_no->EditValue ?>"<?php echo $job_card_fp->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_quantity"><?php echo $job_card_fp->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->quantity->cellAttributes() ?>>
			<span id="el_job_card_fp_quantity">
<input type="text" data-table="job_card_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->quantity->EditValue ?>"<?php echo $job_card_fp->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->pro_unit->Visible) { // pro_unit ?>
	<div id="r_pro_unit" class="form-group row">
		<label for="x_pro_unit" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_pro_unit"><?php echo $job_card_fp->pro_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pro_unit" id="z_pro_unit" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->pro_unit->cellAttributes() ?>>
			<span id="el_job_card_fp_pro_unit">
<input type="text" data-table="job_card_fp" data-field="x_pro_unit" name="x_pro_unit" id="x_pro_unit" size="30" placeholder="<?php echo HtmlEncode($job_card_fp->pro_unit->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->pro_unit->EditValue ?>"<?php echo $job_card_fp->pro_unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_employee_id"><?php echo $job_card_fp->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->employee_id->cellAttributes() ?>>
			<span id="el_job_card_fp_employee_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_fp" data-field="x_employee_id" data-value-separator="<?php echo $job_card_fp->employee_id->displayValueSeparatorAttribute() ?>" id="x_employee_id[]" name="x_employee_id[]" multiple="multiple"<?php echo $job_card_fp->employee_id->editAttributes() ?>>
		<?php echo $job_card_fp->employee_id->selectOptionListHtml("x_employee_id[]") ?>
	</select>
</div>
<?php echo $job_card_fp->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_1->Visible) { // 1 ?>
	<div id="r__1" class="form-group row">
		<label for="x__1" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__1"><?php echo $job_card_fp->_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__1" id="z__1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_1->cellAttributes() ?>>
			<span id="el_job_card_fp__1">
<input type="text" data-table="job_card_fp" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_1->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_1->EditValue ?>"<?php echo $job_card_fp->_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_2->Visible) { // 2 ?>
	<div id="r__2" class="form-group row">
		<label for="x__2" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__2"><?php echo $job_card_fp->_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__2" id="z__2" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_2->cellAttributes() ?>>
			<span id="el_job_card_fp__2">
<input type="text" data-table="job_card_fp" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_2->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_2->EditValue ?>"<?php echo $job_card_fp->_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_3->Visible) { // 3 ?>
	<div id="r__3" class="form-group row">
		<label for="x__3" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__3"><?php echo $job_card_fp->_3->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__3" id="z__3" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_3->cellAttributes() ?>>
			<span id="el_job_card_fp__3">
<input type="text" data-table="job_card_fp" data-field="x__3" name="x__3" id="x__3" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_3->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_3->EditValue ?>"<?php echo $job_card_fp->_3->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_4->Visible) { // 4 ?>
	<div id="r__4" class="form-group row">
		<label for="x__4" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__4"><?php echo $job_card_fp->_4->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__4" id="z__4" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_4->cellAttributes() ?>>
			<span id="el_job_card_fp__4">
<input type="text" data-table="job_card_fp" data-field="x__4" name="x__4" id="x__4" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_4->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_4->EditValue ?>"<?php echo $job_card_fp->_4->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_5->Visible) { // 5 ?>
	<div id="r__5" class="form-group row">
		<label for="x__5" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__5"><?php echo $job_card_fp->_5->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__5" id="z__5" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_5->cellAttributes() ?>>
			<span id="el_job_card_fp__5">
<input type="text" data-table="job_card_fp" data-field="x__5" name="x__5" id="x__5" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_5->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_5->EditValue ?>"<?php echo $job_card_fp->_5->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_6->Visible) { // 6 ?>
	<div id="r__6" class="form-group row">
		<label for="x__6" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__6"><?php echo $job_card_fp->_6->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__6" id="z__6" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_6->cellAttributes() ?>>
			<span id="el_job_card_fp__6">
<input type="text" data-table="job_card_fp" data-field="x__6" name="x__6" id="x__6" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_6->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_6->EditValue ?>"<?php echo $job_card_fp->_6->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_7->Visible) { // 7 ?>
	<div id="r__7" class="form-group row">
		<label for="x__7" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__7"><?php echo $job_card_fp->_7->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__7" id="z__7" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_7->cellAttributes() ?>>
			<span id="el_job_card_fp__7">
<input type="text" data-table="job_card_fp" data-field="x__7" name="x__7" id="x__7" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_7->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_7->EditValue ?>"<?php echo $job_card_fp->_7->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->_8->Visible) { // 8 ?>
	<div id="r__8" class="form-group row">
		<label for="x__8" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp__8"><?php echo $job_card_fp->_8->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__8" id="z__8" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->_8->cellAttributes() ?>>
			<span id="el_job_card_fp__8">
<input type="text" data-table="job_card_fp" data-field="x__8" name="x__8" id="x__8" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->_8->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->_8->EditValue ?>"<?php echo $job_card_fp->_8->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->other1->Visible) { // other1 ?>
	<div id="r_other1" class="form-group row">
		<label for="x_other1" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_other1"><?php echo $job_card_fp->other1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other1" id="z_other1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->other1->cellAttributes() ?>>
			<span id="el_job_card_fp_other1">
<input type="text" data-table="job_card_fp" data-field="x_other1" name="x_other1" id="x_other1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->other1->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->other1->EditValue ?>"<?php echo $job_card_fp->other1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->other2->Visible) { // other2 ?>
	<div id="r_other2" class="form-group row">
		<label for="x_other2" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_other2"><?php echo $job_card_fp->other2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other2" id="z_other2" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->other2->cellAttributes() ?>>
			<span id="el_job_card_fp_other2">
<input type="text" data-table="job_card_fp" data-field="x_other2" name="x_other2" id="x_other2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_fp->other2->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->other2->EditValue ?>"<?php echo $job_card_fp->other2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_operator"><?php echo $job_card_fp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->operator->cellAttributes() ?>>
			<span id="el_job_card_fp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_fp" data-field="x_operator" data-value-separator="<?php echo $job_card_fp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $job_card_fp->operator->editAttributes() ?>>
		<?php echo $job_card_fp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $job_card_fp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_datetime"><?php echo $job_card_fp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->datetime->cellAttributes() ?>>
			<span id="el_job_card_fp_datetime">
<input type="text" data-table="job_card_fp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($job_card_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->datetime->EditValue ?>"<?php echo $job_card_fp->datetime->editAttributes() ?>>
<?php if (!$job_card_fp->datetime->ReadOnly && !$job_card_fp->datetime->Disabled && !isset($job_card_fp->datetime->EditAttrs["readonly"]) && !isset($job_card_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjob_card_fpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_product_code"><?php echo $job_card_fp->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->product_code->cellAttributes() ?>>
			<span id="el_job_card_fp_product_code">
<input type="text" data-table="job_card_fp" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card_fp->product_code->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->product_code->EditValue ?>"<?php echo $job_card_fp->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->in_id->Visible) { // in_id ?>
	<div id="r_in_id" class="form-group row">
		<label for="x_in_id" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_in_id"><?php echo $job_card_fp->in_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_in_id" id="z_in_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->in_id->cellAttributes() ?>>
			<span id="el_job_card_fp_in_id">
<input type="text" data-table="job_card_fp" data-field="x_in_id" name="x_in_id" id="x_in_id" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card_fp->in_id->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->in_id->EditValue ?>"<?php echo $job_card_fp->in_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_fp->balance_quantity->Visible) { // balance_quantity ?>
	<div id="r_balance_quantity" class="form-group row">
		<label for="x_balance_quantity" class="<?php echo $job_card_fp_search->LeftColumnClass ?>"><span id="elh_job_card_fp_balance_quantity"><?php echo $job_card_fp->balance_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance_quantity" id="z_balance_quantity" value="="></span>
		</label>
		<div class="<?php echo $job_card_fp_search->RightColumnClass ?>"><div<?php echo $job_card_fp->balance_quantity->cellAttributes() ?>>
			<span id="el_job_card_fp_balance_quantity">
<input type="text" data-table="job_card_fp" data-field="x_balance_quantity" name="x_balance_quantity" id="x_balance_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card_fp->balance_quantity->getPlaceHolder()) ?>" value="<?php echo $job_card_fp->balance_quantity->EditValue ?>"<?php echo $job_card_fp->balance_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$job_card_fp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $job_card_fp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$job_card_fp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$job_card_fp_search->terminate();
?>