<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_hs_add = new job_card_hs_add();

// Run the page
$job_card_hs_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_hs_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fjob_card_hsadd = currentForm = new ew.Form("fjob_card_hsadd", "add");

// Validate form
fjob_card_hsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($job_card_hs_add->works->Required) { ?>
			elm = this.getElements("x" + infix + "_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->works->caption(), $job_card_hs->works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->jc_no_fp->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no_fp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->jc_no_fp->caption(), $job_card_hs->jc_no_fp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->item->caption(), $job_card_hs->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->batch_no->caption(), $job_card_hs->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->po->caption(), $job_card_hs->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->employee_id->caption(), $job_card_hs->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->avl_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_avl_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->avl_qty->caption(), $job_card_hs->avl_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avl_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card_hs->avl_qty->errorMessage()) ?>");
		<?php if ($job_card_hs_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->quantity->caption(), $job_card_hs->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card_hs->quantity->errorMessage()) ?>");
		<?php if ($job_card_hs_add->_1->Required) { ?>
			elm = this.getElements("x" + infix + "__1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->_1->caption(), $job_card_hs->_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->_2->Required) { ?>
			elm = this.getElements("x" + infix + "__2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->_2->caption(), $job_card_hs->_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->operator->caption(), $job_card_hs->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_hs_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card_hs->datetime->caption(), $job_card_hs->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjob_card_hsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_hsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_hsadd.lists["x_works"] = <?php echo $job_card_hs_add->works->Lookup->toClientList() ?>;
fjob_card_hsadd.lists["x_works"].options = <?php echo JsonEncode($job_card_hs_add->works->lookupOptions()) ?>;
fjob_card_hsadd.lists["x_jc_no_fp"] = <?php echo $job_card_hs_add->jc_no_fp->Lookup->toClientList() ?>;
fjob_card_hsadd.lists["x_jc_no_fp"].options = <?php echo JsonEncode($job_card_hs_add->jc_no_fp->lookupOptions()) ?>;
fjob_card_hsadd.lists["x_batch_no"] = <?php echo $job_card_hs_add->batch_no->Lookup->toClientList() ?>;
fjob_card_hsadd.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_hs_add->batch_no->lookupOptions()) ?>;
fjob_card_hsadd.lists["x_employee_id"] = <?php echo $job_card_hs_add->employee_id->Lookup->toClientList() ?>;
fjob_card_hsadd.lists["x_employee_id"].options = <?php echo JsonEncode($job_card_hs_add->employee_id->lookupOptions()) ?>;
fjob_card_hsadd.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_hs_add->showPageHeader(); ?>
<?php
$job_card_hs_add->showMessage();
?>
<form name="fjob_card_hsadd" id="fjob_card_hsadd" class="<?php echo $job_card_hs_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_hs_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_hs_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_hs">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_hs_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($job_card_hs->works->Visible) { // works ?>
	<div id="r_works" class="form-group row">
		<label id="elh_job_card_hs_works" for="x_works" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->works->caption() ?><?php echo ($job_card_hs->works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->works->cellAttributes() ?>>
<span id="el_job_card_hs_works">
<?php $job_card_hs->works->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_hs->works->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_hs" data-field="x_works" data-value-separator="<?php echo $job_card_hs->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card_hs->works->editAttributes() ?>>
		<?php echo $job_card_hs->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card_hs->works->Lookup->getParamTag("p_x_works") ?>
</span>
<?php echo $job_card_hs->works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->jc_no_fp->Visible) { // jc_no_fp ?>
	<div id="r_jc_no_fp" class="form-group row">
		<label id="elh_job_card_hs_jc_no_fp" for="x_jc_no_fp" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->jc_no_fp->caption() ?><?php echo ($job_card_hs->jc_no_fp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->jc_no_fp->cellAttributes() ?>>
<span id="el_job_card_hs_jc_no_fp">
<?php $job_card_hs->jc_no_fp->EditAttrs["onchange"] = "ew.autoFill(this);" . @$job_card_hs->jc_no_fp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_hs" data-field="x_jc_no_fp" data-value-separator="<?php echo $job_card_hs->jc_no_fp->displayValueSeparatorAttribute() ?>" id="x_jc_no_fp" name="x_jc_no_fp"<?php echo $job_card_hs->jc_no_fp->editAttributes() ?>>
		<?php echo $job_card_hs->jc_no_fp->selectOptionListHtml("x_jc_no_fp") ?>
	</select>
</div>
<?php echo $job_card_hs->jc_no_fp->Lookup->getParamTag("p_x_jc_no_fp") ?>
</span>
<?php echo $job_card_hs->jc_no_fp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_job_card_hs_item" for="x_item" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->item->caption() ?><?php echo ($job_card_hs->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->item->cellAttributes() ?>>
<span id="el_job_card_hs_item">
<input type="text" data-table="job_card_hs" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_hs->item->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->item->EditValue ?>"<?php echo $job_card_hs->item->editAttributes() ?>>
</span>
<?php echo $job_card_hs->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_job_card_hs_batch_no" for="x_batch_no" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->batch_no->caption() ?><?php echo ($job_card_hs->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->batch_no->cellAttributes() ?>>
<span id="el_job_card_hs_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_hs" data-field="x_batch_no" data-value-separator="<?php echo $job_card_hs->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $job_card_hs->batch_no->editAttributes() ?>>
		<?php echo $job_card_hs->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $job_card_hs->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php echo $job_card_hs->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_job_card_hs_po" for="x_po" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->po->caption() ?><?php echo ($job_card_hs->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->po->cellAttributes() ?>>
<span id="el_job_card_hs_po">
<input type="text" data-table="job_card_hs" data-field="x_po" name="x_po" id="x_po" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card_hs->po->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->po->EditValue ?>"<?php echo $job_card_hs->po->editAttributes() ?>>
</span>
<?php echo $job_card_hs->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_job_card_hs_employee_id" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->employee_id->caption() ?><?php echo ($job_card_hs->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->employee_id->cellAttributes() ?>>
<span id="el_job_card_hs_employee_id">
<?php
$wrkonchange = "" . trim(@$job_card_hs->employee_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card_hs->employee_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_employee_id" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?php echo RemoveHtml($job_card_hs->employee_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->employee_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card_hs->employee_id->getPlaceHolder()) ?>"<?php echo $job_card_hs->employee_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card_hs->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id',m:0,n:3,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($job_card_hs->employee_id->ReadOnly || $job_card_hs->employee_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "production_employee_hs") && !$job_card_hs->employee_id->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $job_card_hs->employee_id->caption() ?>" data-title="<?php echo $job_card_hs->employee_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_employee_id',url:'production_employee_hsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="job_card_hs" data-field="x_employee_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $job_card_hs->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?php echo HtmlEncode($job_card_hs->employee_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_card_hsadd.createAutoSuggest({"id":"x_employee_id","forceSelect":true});
</script>
<?php echo $job_card_hs->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
<?php echo $job_card_hs->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->avl_qty->Visible) { // avl_qty ?>
	<div id="r_avl_qty" class="form-group row">
		<label id="elh_job_card_hs_avl_qty" for="x_avl_qty" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->avl_qty->caption() ?><?php echo ($job_card_hs->avl_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->avl_qty->cellAttributes() ?>>
<span id="el_job_card_hs_avl_qty">
<input type="text" data-table="job_card_hs" data-field="x_avl_qty" name="x_avl_qty" id="x_avl_qty" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->avl_qty->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->avl_qty->EditValue ?>"<?php echo $job_card_hs->avl_qty->editAttributes() ?>>
</span>
<?php echo $job_card_hs->avl_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_job_card_hs_quantity" for="x_quantity" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->quantity->caption() ?><?php echo ($job_card_hs->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->quantity->cellAttributes() ?>>
<span id="el_job_card_hs_quantity">
<input type="text" data-table="job_card_hs" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->quantity->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->quantity->EditValue ?>"<?php echo $job_card_hs->quantity->editAttributes() ?>>
</span>
<?php echo $job_card_hs->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->_1->Visible) { // 1 ?>
	<div id="r__1" class="form-group row">
		<label id="elh_job_card_hs__1" for="x__1" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->_1->caption() ?><?php echo ($job_card_hs->_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->_1->cellAttributes() ?>>
<span id="el_job_card_hs__1">
<input type="text" data-table="job_card_hs" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_hs->_1->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->_1->EditValue ?>"<?php echo $job_card_hs->_1->editAttributes() ?>>
</span>
<?php echo $job_card_hs->_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->_2->Visible) { // 2 ?>
	<div id="r__2" class="form-group row">
		<label id="elh_job_card_hs__2" for="x__2" class="<?php echo $job_card_hs_add->LeftColumnClass ?>"><?php echo $job_card_hs->_2->caption() ?><?php echo ($job_card_hs->_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_hs_add->RightColumnClass ?>"><div<?php echo $job_card_hs->_2->cellAttributes() ?>>
<span id="el_job_card_hs__2">
<input type="text" data-table="job_card_hs" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_hs->_2->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->_2->EditValue ?>"<?php echo $job_card_hs->_2->editAttributes() ?>>
</span>
<?php echo $job_card_hs->_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$job_card_hs_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $job_card_hs_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $job_card_hs_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$job_card_hs_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$job_card_hs_add->terminate();
?>